/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.util.Logger;

public class QuantumCalculation {
    boolean doDebug = false;
    protected static final float bohr_per_angstrom = 1.8897161f;
    protected float[][] xyzBohr;
    protected float[] X;
    protected float[] Y;
    protected float[] Z;
    protected float[] X2;
    protected float[] Y2;
    protected float[] Z2;
    protected Point3f[] atomCoordBohr;
    protected Point3f[] atomCoordAngstroms;
    protected BitSet atomSet;
    protected float[][][] voxelData;
    protected float[] originBohr = new float[3];
    protected float[] stepBohr = new float[3];
    protected int[] countsXYZ;
    protected int atomIndex;
    protected int xMin;
    protected int xMax;
    protected int yMin;
    protected int yMax;
    protected int zMin;
    protected int zMax;

    protected void setVolume(VolumeData volumeData, BitSet bitSet) {
        this.voxelData = volumeData.voxelData;
        this.countsXYZ = volumeData.voxelCounts;
        this.atomSet = bitSet;
        if (this.atomSet == null) {
            this.atomSet = new BitSet();
        }
        this.setupCoordinates(volumeData.origin, volumeData.volumetricVectorLengths);
    }

    protected void setMinMax() {
        this.xMin = 0;
        this.yMin = 0;
        this.zMin = 0;
        this.xMax = this.countsXYZ[0];
        this.yMax = this.countsXYZ[1];
        this.zMax = this.countsXYZ[2];
    }

    protected void initialize(int n) {
        this.xyzBohr = new float[n][3];
        this.X = new float[n];
        this.Y = new float[n];
        this.Z = new float[n];
        this.X2 = new float[n];
        this.Y2 = new float[n];
        this.Z2 = new float[n];
    }

    protected void setupCoordinates(float[] fArray, float[] fArray2) {
        int n = 3;
        while (--n >= 0) {
            this.originBohr[n] = fArray[n] * 1.8897161f;
            this.stepBohr[n] = fArray2[n] * 1.8897161f;
        }
        n = 3;
        while (--n >= 0) {
            this.xyzBohr[0][n] = this.originBohr[n];
            int n2 = this.countsXYZ[n];
            float f = this.stepBohr[n];
            int n3 = 0;
            while (++n3 < n2) {
                this.xyzBohr[n3][n] = this.xyzBohr[n3 - 1][n] + f;
            }
        }
        this.atomCoordBohr = new Point3f[this.atomCoordAngstroms.length];
        for (n = 0; n < this.atomCoordAngstroms.length; ++n) {
            if (!this.atomSet.get(n)) continue;
            this.atomCoordBohr[n] = new Point3f(this.atomCoordAngstroms[n]);
            this.atomCoordBohr[n].scale(1.8897161f);
        }
        if (this.doDebug) {
            Logger.debug((String)("QuantumCalculation:\n origin(Bohr)= " + this.originBohr[0] + " " + this.originBohr[1] + " " + this.originBohr[2] + "\n steps(Bohr)= " + this.stepBohr[0] + " " + this.stepBohr[1] + " " + this.stepBohr[2] + "\n counts= " + this.countsXYZ[0] + " " + this.countsXYZ[1] + " " + this.countsXYZ[2]));
        }
    }
}

