/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileSystemView;
import org.jmol.api.JmolViewer;
import org.openscience.jmol.app.HistoryFile;
import org.openscience.jmol.app.webexport.LogPanel;
import org.openscience.jmol.app.webexport.Molecules;
import org.openscience.jmol.app.webexport.Orbitals;
import org.openscience.jmol.app.webexport.PopInJmol;
import org.openscience.jmol.app.webexport.ScriptButtons;
import org.openscience.jmol.app.webexport.WebPanel;

public class WebExport
extends JPanel
implements WindowListener {
    private static boolean showMoleculesAndOrbitals = false;
    private static final int STAND_ALONE = 0;
    private static final int IN_JMOL = 1;
    private static int runStatus = 1;
    private static HistoryFile historyFile;
    private static WebPanel[] webPanels;
    private static WebExport webExport;
    private static JFrame webFrame;
    private static String windowName;
    static String remoteAppletPath;
    static String localAppletPath;
    static Properties prop;
    static String pageAuthorName;

    private WebExport(JmolViewer jmolViewer, HistoryFile historyFile) {
        super(new BorderLayout());
        WebExport.historyFile = historyFile;
        remoteAppletPath = WebExport.historyFile.getProperty("webMakerAppletPath", "..");
        localAppletPath = WebExport.historyFile.getProperty("webMakerLocalAppletPath", "..");
        pageAuthorName = WebExport.historyFile.getProperty("webMakerPageAuthorName", "Jmol Web Export");
        JTabbedPane jTabbedPane = new JTabbedPane();
        JFileChooser jFileChooser = new JFileChooser();
        webPanels = new WebPanel[2];
        if (runStatus != 0) {
            JPanel jPanel = new JPanel();
            URL uRL = WebExport.getResource(this, "WebExportIntro.html");
            if (uRL == null) {
                System.err.println("Couldn't find file: WebExportIntro.html");
            }
            JEditorPane jEditorPane = new JEditorPane();
            if (uRL != null) {
                try {
                    jEditorPane.setPage(uRL);
                }
                catch (IOException iOException) {
                    System.err.println("Attempted to read a bad URL: " + uRL);
                }
            }
            jEditorPane.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jEditorPane);
            jScrollPane.setMaximumSize(new Dimension(450, 350));
            jScrollPane.setPreferredSize(new Dimension(400, 300));
            jPanel.setLayout(new BorderLayout());
            jPanel.add(jScrollPane);
            jPanel.setMaximumSize(new Dimension(450, 350));
            jPanel.setPreferredSize(new Dimension(400, 300));
            jTabbedPane.add("Introduction", jPanel);
            WebExport.webPanels[0] = new PopInJmol(jmolViewer, jFileChooser, webPanels, 0);
            WebExport.webPanels[1] = new ScriptButtons(jmolViewer, jFileChooser, webPanels, 1);
            int n = Integer.parseInt(WebExport.historyFile.getProperty("webMakerInfoWidth", "300"));
            int n2 = Integer.parseInt(WebExport.historyFile.getProperty("webMakerInfoHeight", "350"));
            jTabbedPane.addTab("Pop-In Jmol", webPanels[0].getPanel(n, n2));
            jTabbedPane.addTab("ScriptButton Jmol", webPanels[1].getPanel(n, n2));
        }
        boolean bl = showMoleculesAndOrbitals = runStatus == 0 || JmolViewer.checkOption(jmolViewer, "webMakerAllTabs");
        if (showMoleculesAndOrbitals) {
            jTabbedPane.addTab("Orbitals", new Orbitals().getPanel());
            jTabbedPane.addTab("Molecules", new Molecules().getPanel());
        }
        jTabbedPane.addTab("Log", LogPanel.getPanel());
        this.add(jTabbedPane);
        this.add((Component)LogPanel.getMiniPanel(), "South");
    }

    static String TimeStamp_WebLink() {
        String string = "      <small>Page skeleton and <a href=\"http://www.java.com\">JavaScript</a>";
        Date date = new Date();
        String string2 = DateFormat.getDateInstance().format(date);
        string = string + " generated by export to web function of (<a href=\"http://jmol.sourceforge.net\">Jmol " + JmolViewer.getJmolVersion() + "</a>) on " + string2 + ". </small><br />";
        return string;
    }

    public static WebExport createAndShowGUI(JmolViewer jmolViewer, HistoryFile historyFile, String string) {
        if (jmolViewer == null) {
            runStatus = 0;
        }
        if (webFrame != null) {
            webFrame.setVisible(true);
            webFrame.toFront();
            return webExport;
        }
        webFrame = new JFrame("Jmol Web Page Maker");
        windowName = string;
        historyFile.repositionWindow(windowName, webFrame, 700, 400);
        if (runStatus == 0) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            webFrame.setDefaultCloseOperation(3);
        } else {
            webFrame.setDefaultCloseOperation(2);
        }
        webExport = new WebExport(jmolViewer, historyFile);
        webExport.setOpaque(true);
        webFrame.setContentPane(webExport);
        webFrame.addWindowListener(webExport);
        webFrame.pack();
        webFrame.setVisible(true);
        if (runStatus == 0) {
            // empty if block
        }
        return webExport;
    }

    public static void saveHistory() {
        historyFile.addWindowInfo(windowName, webFrame, null);
        prop.setProperty("webMakerAppletPath", remoteAppletPath);
        prop.setProperty("webMakerLocalAppletPath", localAppletPath);
        prop.setProperty("webMakerPageAuthorName", pageAuthorName);
        historyFile.addProperties(prop);
    }

    static String getAppletPath(boolean bl) {
        return bl ? remoteAppletPath : localAppletPath;
    }

    static void setAppletPath(String string, boolean bl) {
        if (string == null) {
            string = "..";
        }
        if (bl) {
            remoteAppletPath = string;
            prop.setProperty("webMakerAppletPath", remoteAppletPath);
            historyFile.addProperties(prop);
        } else {
            localAppletPath = string;
            prop.setProperty("webMakerLocalAppletPath", localAppletPath);
            historyFile.addProperties(prop);
        }
    }

    static String getPageAuthorName() {
        return pageAuthorName;
    }

    static void setWebPageAuthor(String string) {
        if (string == null) {
            string = "Jmol Web Export";
        }
        pageAuthorName = string;
        prop.setProperty("webMakerPageAuthorName", pageAuthorName);
        historyFile.addProperties(prop);
    }

    static JFrame getFrame() {
        return webFrame;
    }

    static URL getResource(Object object, String string) {
        URL uRL = null;
        try {
            uRL = object.getClass().getResource("html/" + string);
            if (uRL == null) {
                System.err.println("Couldn't find file: " + string);
            }
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception.getMessage() + " in getResource " + string);
        }
        return uRL;
    }

    static String getResourceString(Object object, String string) throws IOException {
        Object object2;
        URL uRL = WebExport.getResource(object, string);
        if (uRL == null) {
            throw new FileNotFoundException("Error loading resource " + string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            object2 = new BufferedReader(new InputStreamReader((InputStream)uRL.getContent()));
            while ((string2 = ((BufferedReader)object2).readLine()) != null) {
                stringBuffer.append(string2).append("\n");
            }
            ((BufferedReader)object2).close();
        }
        catch (Exception exception) {
            LogPanel.log(exception.getMessage());
        }
        object2 = stringBuffer.toString();
        return object2;
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    public void windowStateChanged(WindowEvent windowEvent) {
    }

    public static void cleanUp() {
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        File file = fileSystemView.getHomeDirectory();
        String string = file.getPath();
        String string2 = string + "/.jmol_WPM";
        File file2 = new File(string2);
        if (file2.exists()) {
            File[] fileArray = null;
            fileArray = file2.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i].delete();
            }
        }
        WebExport.saveHistory();
        System.gc();
    }

    static {
        prop = new Properties();
    }
}

