/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.openscience.jmol.app.ConsoleTextPane;
import org.openscience.jmol.app.EnterListener;
import org.openscience.jmol.app.HelpDialog;

public final class ScriptWindow
extends JDialog
implements ActionListener,
EnterListener {
    ConsoleTextPane console;
    private JButton closeButton;
    private JButton runButton;
    private JButton haltButton;
    private JButton clearButton;
    private JButton historyButton;
    private JButton stateButton;
    private JButton helpButton;
    private JButton undoButton;
    private JButton redoButton;
    JmolViewer viewer;
    boolean isError = false;
    ExecuteCommandThread execThread;
    static int MAXUNDO = 50;
    String[] undoStack = new String[MAXUNDO];
    int undoPointer = 0;
    boolean undoSaved = false;

    public ScriptWindow(JmolViewer jmolViewer, JFrame jFrame) {
        super(jFrame, GT._("Jmol Script Console"), false);
        this.viewer = jmolViewer;
        this.layoutWindow(this.getContentPane());
        this.setSize(645, 400);
        this.setLocationRelativeTo(jFrame);
    }

    void layoutWindow(Container container) {
        this.console = new ConsoleTextPane(this);
        this.console.setPrompt();
        JScrollPane jScrollPane = new JScrollPane(this.console);
        JPanel jPanel = new JPanel();
        this.runButton = new JButton(GT._("Run"));
        this.runButton.addActionListener(this);
        jPanel.add(this.runButton);
        this.haltButton = new JButton(GT._("Halt"));
        this.haltButton.addActionListener(this);
        jPanel.add(this.haltButton);
        this.haltButton.setEnabled(false);
        this.clearButton = new JButton(GT._("Clear"));
        this.clearButton.addActionListener(this);
        jPanel.add(this.clearButton);
        this.historyButton = new JButton(GT._("History"));
        this.historyButton.addActionListener(this);
        jPanel.add(this.historyButton);
        this.stateButton = new JButton(GT._("State"));
        this.stateButton.addActionListener(this);
        jPanel.add(this.stateButton);
        this.helpButton = new JButton(GT._("Help"));
        this.helpButton.addActionListener(this);
        jPanel.add(this.helpButton);
        this.closeButton = new JButton(GT._("Close"));
        this.closeButton.addActionListener(this);
        jPanel.add(this.closeButton);
        this.undoButton = new JButton(GT._("Undo"));
        this.undoButton.addActionListener(this);
        this.undoButton.setEnabled(false);
        jPanel.add(this.undoButton);
        this.redoButton = new JButton(GT._("Redo"));
        this.redoButton.addActionListener(this);
        this.redoButton.setEnabled(false);
        jPanel.add(this.redoButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jPanel2);
        jScrollPane.setMinimumSize(new Dimension(300, 300));
        jScrollPane.setPreferredSize(new Dimension(5000, 5000));
        jPanel2.setMinimumSize(new Dimension(60, 60));
        jPanel2.setMaximumSize(new Dimension(1000, 60));
        jPanel2.setPreferredSize(new Dimension(60, 60));
        jSplitPane.setDividerSize(0);
        jSplitPane.setResizeWeight(0.95);
        container.add(jSplitPane);
    }

    public void sendConsoleEcho(String string) {
        if (string != null && !this.isError) {
            this.console.outputEcho(string);
        }
        this.setError(false);
    }

    void setError(boolean bl) {
        this.isError = bl;
    }

    void sendConsoleMessage(String string) {
        if (string == null) {
            this.console.clearContent();
            this.console.outputStatus("");
        } else if (string.indexOf("ERROR:") >= 0) {
            this.console.outputError(string);
            this.setError(true);
            this.runButton.setEnabled(true);
            this.haltButton.setEnabled(false);
        } else if (!this.isError) {
            this.console.outputStatus(string);
        }
    }

    void notifyScriptStart() {
        this.runButton.setEnabled(true);
        this.haltButton.setEnabled(true);
    }

    void notifyScriptTermination() {
        this.runButton.setEnabled(true);
        this.haltButton.setEnabled(false);
    }

    public void enterPressed() {
        this.runButton.doClick(100);
    }

    void executeCommandAsThread() {
        String string = this.console.getCommandString().trim();
        if (string.equalsIgnoreCase("undo")) {
            this.undoRedo(false);
            this.console.appendNewline();
            this.console.setPrompt();
            return;
        }
        if (string.equalsIgnoreCase("redo")) {
            this.undoRedo(true);
            this.console.appendNewline();
            this.console.setPrompt();
            return;
        }
        if (string.equalsIgnoreCase("exitJmol")) {
            System.exit(0);
        }
        if (string.length() > 0) {
            this.execThread = new ExecuteCommandThread(string);
            this.execThread.start();
        }
    }

    void undoClear() {
        for (int i = 0; i < MAXUNDO; ++i) {
            this.undoStack[i] = null;
        }
        this.undoPointer = 0;
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
    }

    void undoSetEnabled() {
        this.undoButton.setEnabled(this.undoPointer > 0 && this.undoStack[this.undoPointer - 1] != null);
        this.redoButton.setEnabled(this.undoPointer + 1 < MAXUNDO && this.undoStack[this.undoPointer + 1] != null);
    }

    void undoRedo(boolean bl) {
        if (!this.viewer.getBooleanProperty("undo")) {
            return;
        }
        if (!this.undoSaved) {
            this.undoSave();
        }
        String string = this.undoStack[this.undoPointer];
        int n = this.undoPointer + (bl ? 1 : -1);
        if (n == MAXUNDO) {
            --n;
        }
        if (n < 0) {
            n = 0;
        }
        if ((string = this.undoStack[n]) != null) {
            string = string + "#----";
            this.setError(false);
            this.viewer.evalStringQuiet(string);
            this.undoPointer = n;
        }
        this.undoSetEnabled();
    }

    void undoSave() {
        int n;
        if (!this.viewer.getBooleanProperty("undo")) {
            return;
        }
        ++this.undoPointer;
        if (this.undoPointer == MAXUNDO) {
            for (n = 1; n < MAXUNDO; ++n) {
                this.undoStack[n - 1] = this.undoStack[n];
            }
            --this.undoPointer;
        }
        for (n = this.undoPointer; n < MAXUNDO; ++n) {
            this.undoStack[n] = null;
        }
        Logger.startTimer();
        this.undoStack[this.undoPointer] = (String)this.viewer.getProperty("readable", "stateInfo", null);
        if (Logger.checkTimer(null) > 1000L) {
            this.viewer.setBooleanProperty("undo", false);
            Logger.info("command processing slow; undo disabled");
            this.undoClear();
        } else {
            this.undoSetEnabled();
        }
        this.undoSaved = true;
    }

    void executeCommand(String string) {
        boolean bl;
        this.console.appendNewline();
        this.console.setPrompt();
        if (string.length() == 0) {
            this.console.grabFocus();
            return;
        }
        if (string.charAt(0) != '!' && !this.isError) {
            this.undoSave();
        }
        this.setError(false);
        this.undoSaved = false;
        String string2 = null;
        boolean bl2 = bl = string.indexOf("WAITTEST ") == 0;
        if (bl) {
            this.runButton.setEnabled(false);
            this.haltButton.setEnabled(true);
            Vector vector = (Vector)this.viewer.scriptWaitStatus(string.substring(5), "+fileLoaded,+scriptStarted,+scriptStatus,+scriptEcho,+scriptTerminated");
            this.runButton.setEnabled(true);
            this.haltButton.setEnabled(false);
            for (int i = 0; i < vector.size(); ++i) {
                Vector vector2 = (Vector)vector.get(i);
                for (int j = 0; j < vector2.size(); ++j) {
                    Vector vector3 = (Vector)vector2.get(j);
                    Logger.info("msg#=" + vector3.get(0) + " " + vector3.get(1) + " intInfo=" + vector3.get(2) + " stringInfo=" + vector3.get(3));
                }
            }
            this.console.appendNewline();
        } else {
            boolean bl3 = this.viewer.isScriptExecuting();
            string2 = "";
            if (this.viewer.checkHalt(string)) {
                String string3 = string2 = bl3 ? "script execution halted with " + string : "no script was executing";
            }
            if (string2.length() > 0) {
                this.console.outputError(string2);
            } else {
                this.runButton.setEnabled(true);
                this.haltButton.setEnabled(true);
                this.viewer.script(string);
            }
        }
        this.console.grabFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton) {
            this.hide();
        } else if (object == this.runButton) {
            this.executeCommandAsThread();
        } else if (object == this.clearButton) {
            this.console.clearContent();
        } else if (object == this.historyButton) {
            this.console.clearContent(this.viewer.getSetHistory(Integer.MAX_VALUE));
        } else if (object == this.stateButton) {
            this.console.clearContent(this.viewer.getStateInfo());
        } else if (object == this.haltButton) {
            this.viewer.haltScriptExecution();
        } else if (object == this.undoButton) {
            this.undoRedo(false);
        } else if (object == this.redoButton) {
            this.undoRedo(true);
        } else if (object == this.helpButton) {
            URL uRL = this.getClass().getClassLoader().getResource("org/openscience/jmol/Data/guide/ch04.html");
            HelpDialog helpDialog = new HelpDialog(null, uRL);
            helpDialog.show();
        }
        this.console.grabFocus();
    }

    class ExecuteCommandThread
    extends Thread {
        String strCommand;

        ExecuteCommandThread(String string) {
            this.strCommand = string;
            this.setName("ScriptWindowExecuteCommandThread");
        }

        public void run() {
            try {
                while (ScriptWindow.this.console.checking) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                        break;
                    }
                }
                ScriptWindow.this.executeCommand(this.strCommand);
            }
            catch (Exception exception) {
                Logger.error("execution command interrupted!", exception);
            }
        }
    }
}

