/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;

public class MeasurementTable
extends JDialog {
    JmolViewer viewer;
    private JTable measurementTable;
    private MeasurementTableModel measurementTableModel;
    int selectedMeasurementRow = -1;
    JButton deleteButton;
    JButton deleteAllButton;
    final Class stringClass = "".getClass();

    public MeasurementTable(JmolViewer jmolViewer, JFrame jFrame) {
        super(jFrame, GT._("Measurements..."), false);
        this.viewer = jmolViewer;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.constructMeasurementTable(), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.constructMeasurementButtonPanel(), "West");
        jPanel2.add((Component)this.constructDismissButtonPanel(), "East");
        jPanel.add((Component)jPanel2, "South");
        this.addWindowListener(new MeasurementListWindowListener());
        this.getContentPane().add(jPanel);
        this.pack();
        this.centerDialog();
    }

    JComponent constructMeasurementTable() {
        this.measurementTableModel = new MeasurementTableModel();
        this.measurementTable = new JTable(this.measurementTableModel);
        this.measurementTable.setPreferredScrollableViewportSize(new Dimension(300, 100));
        this.measurementTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        int n = 5;
        while (--n > 0) {
            this.measurementTable.getColumnModel().getColumn(n).setPreferredWidth(15);
        }
        this.measurementTable.setSelectionMode(0);
        this.measurementTable.setRowSelectionAllowed(true);
        this.measurementTable.setColumnSelectionAllowed(false);
        ListSelectionModel listSelectionModel = this.measurementTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    MeasurementTable.this.selectedMeasurementRow = -1;
                    MeasurementTable.this.deleteButton.setEnabled(false);
                } else {
                    MeasurementTable.this.selectedMeasurementRow = listSelectionModel.getMinSelectionIndex();
                    MeasurementTable.this.deleteButton.setEnabled(true);
                }
            }
        });
        return new JScrollPane(this.measurementTable);
    }

    JComponent constructMeasurementButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.deleteButton = new JButton(GT._("Delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MeasurementTable.this.viewer.script("measures delete " + (MeasurementTable.this.selectedMeasurementRow + 1));
                MeasurementTable.this.updateMeasurementTableData();
            }
        });
        this.deleteButton.setEnabled(false);
        this.deleteAllButton = new JButton(GT._("DeleteAll"));
        this.deleteAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MeasurementTable.this.viewer.script("measures delete");
                MeasurementTable.this.updateMeasurementTableData();
            }
        });
        this.deleteAllButton.setEnabled(false);
        jPanel.add(this.deleteAllButton);
        jPanel.add(this.deleteButton);
        return jPanel;
    }

    JComponent constructDismissButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(GT._("Dismiss"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MeasurementTable.this.close();
            }
        });
        jPanel.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    protected void centerDialog() {
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        dimension.height /= 2;
        dimension.width /= 2;
        dimension2.height /= 2;
        dimension2.width /= 2;
        int n = dimension.height - dimension2.height;
        int n2 = dimension.width - dimension2.width;
        this.setLocation(n2, n);
    }

    public void close() {
        this.setVisible(false);
    }

    public void activate() {
        this.updateMeasurementTableData();
        this.show();
    }

    void updateMeasurementTableData() {
        this.deleteAllButton.setEnabled(this.viewer.getMeasurementCount() > 0);
        this.measurementTableModel.fireTableDataChanged();
    }

    public void updateTables() {
        this.updateMeasurementTableData();
    }

    class MeasurementTableModel
    extends AbstractTableModel {
        final String[] measurementHeaders = new String[]{GT._("Value"), "a", "b", "c", "d"};

        MeasurementTableModel() {
        }

        public String getColumnName(int n) {
            return this.measurementHeaders[n];
        }

        public int getRowCount() {
            return MeasurementTable.this.viewer.getMeasurementCount();
        }

        public int getColumnCount() {
            return 5;
        }

        public Class getColumnClass(int n) {
            return MeasurementTable.this.stringClass;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                MeasurementTable.this.deleteAllButton.setEnabled(true);
                return MeasurementTable.this.viewer.getMeasurementStringValue(n);
            }
            int[] nArray = MeasurementTable.this.viewer.getMeasurementCountPlusIndices(n);
            if (n2 > nArray[0]) {
                return null;
            }
            int n3 = nArray[n2];
            return MeasurementTable.this.viewer.getAtomInfo(n3 >= 0 ? n3 : -n * 10 - n2);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    class MeasurementListWindowListener
    extends WindowAdapter {
        MeasurementListWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            MeasurementTable.this.close();
        }
    }
}

