/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.popup.JmolPopup;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.AboutDialog;
import org.openscience.jmol.app.AtomSetChooser;
import org.openscience.jmol.app.ConsoleTextArea;
import org.openscience.jmol.app.DisplayPanel;
import org.openscience.jmol.app.FileChooser;
import org.openscience.jmol.app.FileDropper;
import org.openscience.jmol.app.FilePreview;
import org.openscience.jmol.app.FileTyper;
import org.openscience.jmol.app.GuiMap;
import org.openscience.jmol.app.HelpDialog;
import org.openscience.jmol.app.HistoryFile;
import org.openscience.jmol.app.ImageCreator;
import org.openscience.jmol.app.ImageSelection;
import org.openscience.jmol.app.ImageTyper;
import org.openscience.jmol.app.JmolResourceHandler;
import org.openscience.jmol.app.MeasurementTable;
import org.openscience.jmol.app.PovrayDialog;
import org.openscience.jmol.app.PreferencesDialog;
import org.openscience.jmol.app.RecentFilesDialog;
import org.openscience.jmol.app.ScriptWindow;
import org.openscience.jmol.app.Splash;
import org.openscience.jmol.app.StatusBar;
import org.openscience.jmol.app.WhatsNewDialog;
import org.openscience.jmol.app.webexport.WebExport;

public class Jmol
extends JPanel {
    public JmolViewer viewer;
    DisplayPanel display;
    StatusBar status;
    private PreferencesDialog preferencesDialog;
    MeasurementTable measurementTable;
    RecentFilesDialog recentFiles;
    public ScriptWindow scriptWindow;
    public AtomSetChooser atomSetChooser;
    private ExecuteScriptAction executeScriptAction;
    protected JFrame frame;
    protected static File currentDir;
    FileChooser openChooser;
    FilePreview openPreview;
    private JFileChooser saveChooser;
    private FileTyper fileTyper;
    JFileChooser exportChooser;
    JFileChooser writeChooser;
    JmolPopup jmolpopup;
    String language;
    static String menuStructure;
    static String menuFile;
    private GuiMap guimap = new GuiMap();
    private static int numWindows;
    private static Dimension screenSize;
    int startupWidth;
    int startupHeight;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final String JMOL_WINDOW_NAME = "Jmol";
    private static final String CONSOLE_WINDOW_NAME = "Console";
    private static final String SCRIPT_WINDOW_NAME = "ScriptWindow";
    private static final String FILE_OPEN_WINDOW_NAME = "FileOpen";
    private static final String WEB_MAKER_WINDOW_NAME = "JmolWebPageMaker";
    static Point border;
    static Boolean haveBorder;
    File currentFile;
    static AbstractButton buttonRotate;
    static ButtonGroup toolbarButtonGroup;
    static File UserPropsFile;
    static HistoryFile historyFile;
    Splash splash;
    static JFrame consoleframe;
    static Boolean isSilent;
    static Boolean haveConsole;
    static Boolean haveDisplay;
    private Hashtable commands;
    private Hashtable menuItems;
    private JMenuBar menubar;
    private JToolBar toolbar;
    private static final String newwinAction = "newwin";
    private static final String openAction = "open";
    private static final String openurlAction = "openurl";
    private static final String newAction = "new";
    private static final String exportActionProperty = "export";
    private static final String closeAction = "close";
    private static final String exitAction = "exit";
    private static final String aboutAction = "about";
    private static final String whatsnewAction = "whatsnew";
    private static final String uguideAction = "uguide";
    private static final String printActionProperty = "print";
    private static final String recentFilesAction = "recentFiles";
    private static final String povrayActionProperty = "povray";
    private static final String writeActionProperty = "write";
    private static final String scriptAction = "script";
    private static final String toWebActionProperty = "toweb";
    private static final String atomsetchooserAction = "atomsetchooser";
    private static final String copyImageActionProperty = "copyImage";
    private static final String copyScriptActionProperty = "copyScript";
    private static final String pasteClipboardActionProperty = "pasteClipboard";
    private ExportAction exportAction = new ExportAction();
    private PovrayAction povrayAction = new PovrayAction();
    private ToWebAction toWebAction = new ToWebAction();
    private WriteAction writeAction = new WriteAction();
    private PrintAction printAction = new PrintAction();
    private CopyImageAction copyImageAction = new CopyImageAction();
    private CopyScriptAction copyScriptAction = new CopyScriptAction();
    private PasteClipboardAction pasteClipboardAction = new PasteClipboardAction();
    private ViewMeasurementTableAction viewMeasurementTableAction = new ViewMeasurementTableAction();
    private Action[] defaultActions = new Action[]{new NewAction(), new NewwinAction(), new OpenAction(), new OpenUrlAction(), this.printAction, this.exportAction, new CloseAction(), new ExitAction(), this.copyImageAction, this.copyScriptAction, this.pasteClipboardAction, new AboutAction(), new WhatsNewAction(), new UguideAction(), new ConsoleAction(), new RecentFilesAction(), this.povrayAction, this.writeAction, this.toWebAction, new ScriptWindowAction(), new AtomSetChooserAction(), this.viewMeasurementTableAction};
    WebExport webExport;
    public static final String chemFileProperty = "chemFile";
    static /* synthetic */ Class class$java$net$URI;

    public static HistoryFile getHistoryFile() {
        return historyFile;
    }

    Jmol(Splash splash, JFrame jFrame, Jmol jmol, int n, int n2, String string) {
        this(splash, jFrame, jmol, n, n2, string, null);
    }

    Jmol(Splash splash, JFrame jFrame, Jmol jmol, int n, int n2, String string, Point point) {
        super(true);
        Object object;
        SmarterJmolAdapter smarterJmolAdapter;
        this.frame = jFrame;
        this.startupWidth = n;
        this.startupHeight = n2;
        ++numWindows;
        try {
            this.say("history file is " + Jmol.historyFile.file.getAbsolutePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        jFrame.setTitle(JMOL_WINDOW_NAME);
        jFrame.setBackground(Color.lightGray);
        jFrame.getContentPane().setLayout(new BorderLayout());
        this.splash = splash;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.language = GT.getLanguage();
        this.status = (StatusBar)this.createStatusBar();
        this.say(GT._("Initializing 3D display..."));
        this.display = new DisplayPanel(this.status, this.guimap, haveDisplay, n, n2);
        String string2 = System.getProperty("model");
        if (string2 == null || string2.length() == 0) {
            string2 = "smarter";
        }
        if (string2.equals("smarter")) {
            Jmol.report("using Smarter Model Adapter");
            smarterJmolAdapter = new SmarterJmolAdapter();
        } else if (string2.equals("cdk")) {
            Jmol.report("the CDK Model Adapter is currently no longer supported. Check out http://bioclipse.net/. -- using Smarter");
            smarterJmolAdapter = new SmarterJmolAdapter();
        } else {
            Jmol.report("unrecognized model adapter:" + string2 + " -- using Smarter");
            smarterJmolAdapter = new SmarterJmolAdapter();
        }
        this.viewer = JmolViewer.allocateViewer(this.display, smarterJmolAdapter);
        this.viewer.setAppletContext("", null, null, string);
        if (this.display != null) {
            this.display.setViewer(this.viewer);
        }
        this.say(GT._("Initializing Preferences..."));
        this.preferencesDialog = new PreferencesDialog(jFrame, this.guimap, this.viewer);
        this.say(GT._("Initializing Recent Files..."));
        this.recentFiles = new RecentFilesDialog(jFrame);
        if (haveDisplay.booleanValue()) {
            this.say(GT._("Initializing Script Window..."));
            this.scriptWindow = new ScriptWindow(this.viewer, jFrame);
            this.say(GT._("Initializing AtomSetChooser Window..."));
            this.atomSetChooser = new AtomSetChooser(this.viewer, jFrame);
        }
        MyStatusListener myStatusListener = new MyStatusListener();
        this.viewer.setJmolStatusListener(myStatusListener);
        this.say(GT._("Initializing Measurements..."));
        this.measurementTable = new MeasurementTable(this.viewer, jFrame);
        if (haveDisplay.booleanValue()) {
            Object object2;
            this.say(GT._("Building Command Hooks..."));
            this.commands = new Hashtable();
            if (this.display != null) {
                object = this.getActions();
                for (int i = 0; i < ((Action[])object).length; ++i) {
                    object2 = object[i];
                    this.commands.put(object2.getValue("Name"), object2);
                }
            }
            this.menuItems = new Hashtable();
            this.say(GT._("Building Menubar..."));
            this.executeScriptAction = new ExecuteScriptAction();
            this.menubar = this.createMenubar();
            this.add("North", this.menubar);
            object = new JPanel();
            ((Container)object).setLayout(new BorderLayout());
            ((Container)object).add("North", this.createToolbar());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add("Center", this.display);
            ((Container)object).add("Center", jPanel);
            this.add("Center", (Component)object);
            this.add("South", this.status);
            this.say(GT._("Starting display..."));
            this.display.start();
            this.say(GT._("Setting up File Choosers..."));
            this.openChooser = new FileChooser();
            this.openChooser.setCurrentDirectory(currentDir);
            object2 = System.getProperty("openFilePreview", "true");
            if (Boolean.valueOf((String)object2).booleanValue()) {
                this.openPreview = new FilePreview(this.openChooser, smarterJmolAdapter);
            }
            this.saveChooser = new JFileChooser();
            this.fileTyper = new FileTyper();
            this.saveChooser.addPropertyChangeListener(this.fileTyper);
            this.saveChooser.setAccessory(this.fileTyper);
            this.saveChooser.setCurrentDirectory(currentDir);
            this.exportChooser = new JFileChooser();
            this.exportChooser.setCurrentDirectory(currentDir);
            this.writeChooser = new JFileChooser();
            this.writeChooser.setCurrentDirectory(currentDir);
            this.pcs.addPropertyChangeListener(chemFileProperty, this.exportAction);
            this.pcs.addPropertyChangeListener(chemFileProperty, this.povrayAction);
            this.pcs.addPropertyChangeListener(chemFileProperty, this.writeAction);
            this.pcs.addPropertyChangeListener(chemFileProperty, this.toWebAction);
            this.pcs.addPropertyChangeListener(chemFileProperty, this.printAction);
            this.pcs.addPropertyChangeListener(chemFileProperty, this.viewMeasurementTableAction);
            this.pcs.addPropertyChangeListener(chemFileProperty, this.atomSetChooser);
            if (menuFile != null) {
                menuStructure = this.viewer.getFileAsString(menuFile);
            }
            this.jmolpopup = JmolPopup.newJmolPopup(this.viewer, true, menuStructure);
        }
        if (point != null) {
            jFrame.setLocation(point);
        } else if (jmol != null) {
            object = jmol.frame.getLocationOnScreen();
            int n3 = Jmol.screenSize.width - 50;
            int n4 = Jmol.screenSize.height - 50;
            ((Point)object).x += 40;
            ((Point)object).y += 40;
            if (((Point)object).x > n3 || ((Point)object).y > n4) {
                ((Point)object).setLocation(0, 0);
            }
            jFrame.setLocation((Point)object);
        }
        jFrame.getContentPane().add("Center", this);
        jFrame.addWindowListener(new AppCloser());
        jFrame.pack();
        jFrame.setSize(n, n2);
        object = JmolResourceHandler.getIconX("icon");
        Image image = ((ImageIcon)object).getImage();
        jFrame.setIconImage(image);
        if (this.scriptWindow != null) {
            historyFile.repositionWindow(SCRIPT_WINDOW_NAME, this.scriptWindow, 200, 100);
        }
        this.say(GT._("Setting up Drag-and-Drop..."));
        FileDropper fileDropper = new FileDropper();
        final JFrame jFrame2 = jFrame;
        fileDropper.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jFrame2.setCursor(Cursor.getPredefinedCursor(3));
                if (propertyChangeEvent.getPropertyName().equals("filename")) {
                    String string = propertyChangeEvent.getNewValue().toString();
                    Jmol.this.viewer.openFile(string);
                } else if (propertyChangeEvent.getPropertyName().equals("inline")) {
                    String string = propertyChangeEvent.getNewValue().toString();
                    Jmol.this.viewer.openStringInline(string);
                }
                jFrame2.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.setDropTarget(new DropTarget(this, fileDropper));
        this.setEnabled(true);
        this.say(GT._("Launching main frame..."));
    }

    static void report(String string) {
        if (isSilent.booleanValue()) {
            return;
        }
        Logger.info(string);
    }

    public static Jmol getJmol(JFrame jFrame, int n, int n2, String string) {
        Accessible accessible;
        Splash splash = null;
        if (haveDisplay.booleanValue()) {
            accessible = JmolResourceHandler.getIconX("splash");
            Jmol.report("splash_image=" + accessible);
            splash = new Splash(jFrame, (ImageIcon)accessible);
            splash.setCursor(new Cursor(3));
            splash.showStatus(GT._("Creating main window..."));
            splash.showStatus(GT._("Initializing Swing..."));
        }
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (splash != null) {
            splash.showStatus(GT._("Initializing Jmol..."));
        }
        currentDir = Jmol.getUserDirectory();
        accessible = new Jmol(splash, jFrame, null, n, n2, string);
        if (haveDisplay.booleanValue()) {
            jFrame.show();
        }
        return accessible;
    }

    static void setupUIManager() {
        UIManager.put("FileChooser.acceptAllFileFilterText", GT._("All Files"));
        UIManager.put("FileChooser.cancelButtonText", GT._("Cancel"));
        UIManager.put("FileChooser.cancelButtonToolTipText", GT._("Abort file chooser dialog"));
        UIManager.put("FileChooser.detailsViewButtonAccessibleName", GT._("Details"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", GT._("Details"));
        UIManager.put("FileChooser.directoryDescriptionText", GT._("Directory"));
        UIManager.put("FileChooser.directoryOpenButtonText", GT._("Open"));
        UIManager.put("FileChooser.directoryOpenButtonToolTipText", GT._("Open selected directory"));
        UIManager.put("FileChooser.fileAttrHeaderText", GT._("Attributes"));
        UIManager.put("FileChooser.fileDateHeaderText", GT._("Modified"));
        UIManager.put("FileChooser.fileDescriptionText", GT._("Generic File"));
        UIManager.put("FileChooser.fileNameHeaderText", GT._("Name"));
        UIManager.put("FileChooser.fileNameLabelText", GT._("File Name:"));
        UIManager.put("FileChooser.fileSizeHeaderText", GT._("Size"));
        UIManager.put("FileChooser.filesOfTypeLabelText", GT._("Files of Type:"));
        UIManager.put("FileChooser.fileTypeHeaderText", GT._("Type"));
        UIManager.put("FileChooser.helpButtonText", GT._("Help"));
        UIManager.put("FileChooser.helpButtonToolTipText", GT._("FileChooser help"));
        UIManager.put("FileChooser.homeFolderAccessibleName", GT._("Home"));
        UIManager.put("FileChooser.homeFolderToolTipText", GT._("Home"));
        UIManager.put("FileChooser.listViewButtonAccessibleName", GT._("List"));
        UIManager.put("FileChooser.listViewButtonToolTipText", GT._("List"));
        UIManager.put("FileChooser.lookInLabelText", GT._("Look In:"));
        UIManager.put("FileChooser.newFolderErrorText", GT._("Error creating new folder"));
        UIManager.put("FileChooser.newFolderAccessibleName", GT._("New Folder"));
        UIManager.put("FileChooser.newFolderToolTipText", GT._("Create New Folder"));
        UIManager.put("FileChooser.openButtonText", GT._("Open"));
        UIManager.put("FileChooser.openButtonToolTipText", GT._("Open selected file"));
        UIManager.put("FileChooser.openDialogTitleText", GT._("Open"));
        UIManager.put("FileChooser.saveButtonText", GT._("Save"));
        UIManager.put("FileChooser.saveButtonToolTipText", GT._("Save selected file"));
        UIManager.put("FileChooser.saveDialogTitleText", GT._("Save"));
        UIManager.put("FileChooser.saveInLabelText", GT._("Save In:"));
        UIManager.put("FileChooser.updateButtonText", GT._("Update"));
        UIManager.put("FileChooser.updateButtonToolTipText", GT._("Update directory listing"));
        UIManager.put("FileChooser.upFolderAccessibleName", GT._("Up"));
        UIManager.put("FileChooser.upFolderToolTipText", GT._("Up One Level"));
        UIManager.put("OptionPane.cancelButtonText", GT._("Cancel"));
        UIManager.put("OptionPane.noButtonText", GT._("No"));
        UIManager.put("OptionPane.okButtonText", GT._("OK"));
        UIManager.put("OptionPane.yesButtonText", GT._("Yes"));
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        Dimension dimension;
        Object object;
        Object object2;
        Jmol.setupUIManager();
        Jmol jmol = null;
        String string = null;
        String string2 = null;
        Options options = new Options();
        options.addOption("h", "help", false, GT._("give this help page"));
        options.addOption("n", "nodisplay", false, GT._("no display (and also exit when done)"));
        options.addOption("c", "check", false, GT._("check script syntax only"));
        options.addOption("i", "silent", false, GT._("silent startup operation"));
        options.addOption("l", "list", false, GT._("list commands during script execution"));
        options.addOption("o", "noconsole", false, GT._("no console -- all output to sysout"));
        options.addOption("t", "threaded", false, GT._("independent commmand thread"));
        options.addOption("x", exitAction, false, GT._("exit after script (implicit with -n)"));
        OptionBuilder.withLongOpt(scriptAction);
        OptionBuilder.withDescription("script file to execute");
        OptionBuilder.withValueSeparator('=');
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("s"));
        OptionBuilder.withLongOpt("menu");
        OptionBuilder.withDescription("menu file to use");
        OptionBuilder.withValueSeparator('=');
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("m"));
        OptionBuilder.withArgName(GT._("property=value"));
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription(GT._("supported options are given below"));
        options.addOption(OptionBuilder.create("D"));
        OptionBuilder.withLongOpt("geometry");
        OptionBuilder.withDescription(GT._("window width x height, e.g. {0}", "-g500x500"));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("g"));
        OptionBuilder.withLongOpt("quality");
        OptionBuilder.withDescription(GT._("JPG image quality (1-100; default 75) or PNG image compression (0-9; default 2, maximum compression 9)"));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("q"));
        OptionBuilder.withLongOpt(writeActionProperty);
        OptionBuilder.withDescription(GT._("{0} or {1}:filename", new Object[]{"CLIP", "JPG|JPG64|PNG|PPM"}));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create("w"));
        int n = 0;
        int n2 = 0;
        CommandLine commandLine = null;
        try {
            object2 = new PosixParser();
            commandLine = object2.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            System.err.println("Unexpected exception: " + parseException.toString());
        }
        if (commandLine.hasOption("h")) {
            object2 = new HelpFormatter();
            ((HelpFormatter)object2).printHelp(JMOL_WINDOW_NAME, options);
            System.out.println();
            System.out.println(GT._("For example:"));
            System.out.println();
            System.out.println("Jmol -ions myscript.spt -w JPEG:myfile.jpg > output.txt");
            System.out.println();
            System.out.println(GT._("The -D options are as follows (defaults in parathesis):"));
            System.out.println();
            System.out.println("  cdk.debugging=[true|false] (false)");
            System.out.println("  cdk.debug.stdout=[true|false] (false)");
            System.out.println("  display.speed=[fps|ms] (ms)");
            System.out.println("  JmolConsole=[true|false] (true)");
            System.out.println("  jmol.logger.debug=[true|false] (false)");
            System.out.println("  jmol.logger.error=[true|false] (true)");
            System.out.println("  jmol.logger.fatal=[true|false] (true)");
            System.out.println("  jmol.logger.info=[true|false] (true)");
            System.out.println("  jmol.logger.logLevel=[true|false] (false)");
            System.out.println("  jmol.logger.warn=[true|false] (true)");
            System.out.println("  plugin.dir (unset)");
            System.out.println("  user.language=[CA|CS|DE|EN|ES|FR|NL|PT|TR] (EN)");
            System.exit(0);
        }
        if ((stringArray = commandLine.getArgs()).length > 0) {
            string = stringArray[0];
        }
        object2 = "";
        if (commandLine.hasOption("i")) {
            object2 = (String)object2 + "-i";
            isSilent = Boolean.TRUE;
        }
        if (commandLine.hasOption("t")) {
            object2 = (String)object2 + "-t";
        }
        if (commandLine.hasOption("l")) {
            object2 = (String)object2 + "-l";
        }
        if (commandLine.hasOption("o")) {
            object2 = (String)object2 + "-o";
            haveConsole = Boolean.FALSE;
        }
        if (commandLine.hasOption("n")) {
            object2 = (String)object2 + "-n-x";
            haveDisplay = Boolean.FALSE;
        }
        if (commandLine.hasOption("c")) {
            object2 = (String)object2 + "-c";
        }
        if (commandLine.hasOption("s")) {
            object2 = (String)object2 + "-s";
            string2 = commandLine.getOptionValue("s");
        }
        if (commandLine.hasOption("m")) {
            menuFile = commandLine.getOptionValue("m");
        }
        if (commandLine.hasOption("x")) {
            object2 = (String)object2 + "-x";
        }
        String string3 = null;
        if (commandLine.hasOption("w")) {
            string3 = commandLine.getOptionValue("w");
        }
        try {
            Object object3;
            object = System.getProperty("java.version");
            if (((String)object).compareTo("1.1.2") < 0) {
                System.out.println("!!!WARNING: Swing components require a 1.1.2 or higher version VM!!!");
            }
            if ((dimension = historyFile.getWindowSize(JMOL_WINDOW_NAME)) != null && haveDisplay.booleanValue()) {
                n = dimension.width;
                n2 = dimension.height;
            }
            border = (serializable = historyFile.getWindowBorder(JMOL_WINDOW_NAME)) == null ? new Point(12, 116) : new Point(((Point)serializable).x, ((Point)serializable).y);
            int n3 = -1;
            int n4 = -1;
            int n5 = 75;
            if (commandLine.hasOption("g")) {
                object3 = commandLine.getOptionValue("g");
                int n6 = ((String)object3).indexOf(120);
                if (n6 > 0) {
                    n3 = Jmol.parseInt(((String)object3).substring(0, n6));
                    n4 = Jmol.parseInt(((String)object3).substring(n6 + 1));
                }
                if (haveDisplay.booleanValue()) {
                    n = n3 + Jmol.border.x;
                    n2 = n4 + Jmol.border.y;
                }
            }
            if (commandLine.hasOption("q")) {
                n5 = Jmol.parseInt(commandLine.getOptionValue("q"));
            }
            if (string3 != null) {
                object2 = (String)object2 + "-w\u0001" + string3 + "\t" + n3 + "\t" + n4 + "\t" + n5 + "\u0001";
            }
            if (n <= 0 || n2 <= 0) {
                n = 500 + Jmol.border.x;
                n2 = 500 + Jmol.border.y;
            }
            object3 = new JFrame();
            Point point = historyFile.getWindowPosition(JMOL_WINDOW_NAME);
            if (point != null) {
                ((Window)object3).setLocation(point);
            }
            jmol = Jmol.getJmol((JFrame)object3, n, n2, (String)object2);
            if (string != null) {
                jmol.viewer.openFile(string);
                jmol.viewer.getOpenFileError();
            }
            if (string2 != null) {
                Jmol.report("Executing script: " + string2);
                if (haveDisplay.booleanValue()) {
                    jmol.splash.showStatus(GT._("Executing script..."));
                }
                jmol.viewer.evalFile(string2);
            }
        }
        catch (Throwable throwable) {
            System.out.println("uncaught exception: " + throwable);
            throwable.printStackTrace();
        }
        if (haveConsole.booleanValue()) {
            object = jmol.frame.getLocation();
            dimension = jmol.frame.getSize();
            consoleframe = new JFrame(GT._("Jmol Java Console"));
            consoleframe.setIconImage(jmol.frame.getIconImage());
            try {
                serializable = new ConsoleTextArea();
                ((JTextArea)serializable).setFont(Font.decode("monospaced"));
                consoleframe.getContentPane().add((Component)new JScrollPane((Component)serializable), "Center");
                if (Boolean.getBoolean("clearConsoleButton")) {
                    JButton jButton = new JButton(GT._("Clear"));
                    jButton.addActionListener(new ActionListener((ConsoleTextArea)serializable){
                        private final /* synthetic */ ConsoleTextArea val$consoleTextArea;
                        {
                            this.val$consoleTextArea = consoleTextArea;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            this.val$consoleTextArea.setText("");
                        }
                    });
                    consoleframe.getContentPane().add((Component)jButton, "South");
                }
            }
            catch (IOException iOException) {
                JTextArea jTextArea = new JTextArea();
                jTextArea.setFont(Font.decode("monospaced"));
                consoleframe.getContentPane().add((Component)new JScrollPane(jTextArea), "Center");
                jTextArea.append(GT._("Could not create ConsoleTextArea: ") + iOException);
            }
            serializable = historyFile.getWindowSize(CONSOLE_WINDOW_NAME);
            Point point = historyFile.getWindowPosition(CONSOLE_WINDOW_NAME);
            if (serializable != null && point != null) {
                consoleframe.setBounds(point.x, point.y, ((Dimension)serializable).width, ((Dimension)serializable).height);
            } else {
                consoleframe.setBounds(((Point)object).x, ((Point)object).y + dimension.height, dimension.width, 200);
            }
            Boolean bl = historyFile.getWindowVisibility(CONSOLE_WINDOW_NAME);
            if (bl != null && bl.equals(Boolean.TRUE)) {
                consoleframe.show();
            }
        }
    }

    static int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MIN_VALUE;
        }
    }

    private void say(String string) {
        if (haveDisplay.booleanValue()) {
            if (this.splash == null) {
                Jmol.report(string);
            } else {
                this.splash.showStatus(string);
            }
        }
    }

    public Action[] getActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.addAll(Arrays.asList(this.defaultActions));
        arrayList.addAll(Arrays.asList(this.display.getActions()));
        arrayList.addAll(Arrays.asList(this.preferencesDialog.getActions()));
        return arrayList.toArray(new Action[0]);
    }

    void doClose() {
        if (historyFile != null && this.display != null) {
            Jmol.border.x = this.getFrame().getWidth() - this.display.dimSize.width;
            Jmol.border.y = this.getFrame().getHeight() - this.display.dimSize.height;
            historyFile.addWindowInfo(JMOL_WINDOW_NAME, this.frame, border);
        }
        this.dispose(this.frame);
    }

    private void dispose(JFrame jFrame) {
        if (historyFile != null && this.scriptWindow != null) {
            historyFile.addWindowInfo(SCRIPT_WINDOW_NAME, this.scriptWindow, null);
        }
        if (historyFile != null && this.webExport != null) {
            WebExport.saveHistory();
            WebExport.cleanUp();
        }
        if (numWindows <= 1) {
            Jmol.report(GT._("Closing Jmol..."));
            System.exit(0);
        } else {
            --numWindows;
            this.viewer.setModeMouse(-1);
            jFrame.dispose();
            if (this.scriptWindow != null) {
                this.scriptWindow.dispose();
            }
        }
    }

    protected void setupNewFrame(String string) {
        JFrame jFrame = new JFrame();
        JFrame jFrame2 = this.frame;
        Jmol jmol = new Jmol(null, jFrame, this, this.startupWidth, this.startupHeight, "", string == null ? null : jFrame2.getLocationOnScreen());
        jFrame.show();
        if (string != null) {
            this.dispose(jFrame2);
            jmol.viewer.script(string);
        }
    }

    protected Frame getFrame() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Frame)) continue;
            return (Frame)container;
        }
        return null;
    }

    protected JMenuItem createMenuItem(String string) {
        JMenuItem jMenuItem = string.endsWith("Check") ? this.guimap.newJCheckBoxMenuItem(string, false) : this.guimap.newJMenuItem(string);
        ImageIcon imageIcon = JmolResourceHandler.getIconX(string + "Image");
        if (imageIcon != null) {
            jMenuItem.setHorizontalTextPosition(4);
            jMenuItem.setIcon(imageIcon);
        }
        if (string.endsWith("Script")) {
            jMenuItem.setActionCommand(JmolResourceHandler.getStringX(string));
            jMenuItem.addActionListener(this.executeScriptAction);
        } else {
            jMenuItem.setActionCommand(string);
            Action action = this.getAction(string);
            if (action != null) {
                jMenuItem.addActionListener(action);
                action.addPropertyChangeListener(new ActionChangedListener(jMenuItem));
                jMenuItem.setEnabled(action.isEnabled());
            } else {
                jMenuItem.setEnabled(false);
            }
        }
        this.menuItems.put(string, jMenuItem);
        return jMenuItem;
    }

    protected JMenuItem getMenuItem(String string) {
        return (JMenuItem)this.menuItems.get(string);
    }

    protected Action getAction(String string) {
        return (Action)this.commands.get(string);
    }

    private Component createToolbar() {
        this.toolbar = new JToolBar();
        String[] stringArray = this.tokenize(JmolResourceHandler.getStringX("toolbar"));
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                this.toolbar.addSeparator();
                continue;
            }
            this.toolbar.add(this.createTool(stringArray[i]));
        }
        this.toolbar.add(Box.createHorizontalGlue());
        return this.toolbar;
    }

    protected Component createTool(String string) {
        return this.createToolbarButton(string);
    }

    protected AbstractButton createToolbarButton(String string) {
        String string2;
        boolean bl;
        ImageIcon imageIcon = JmolResourceHandler.getIconX(string + "Image");
        AbstractButton abstractButton = new JButton(imageIcon);
        String string3 = JmolResourceHandler.getStringX(string + "Toggle");
        if (string3 != null && (bl = Boolean.valueOf(string3).booleanValue())) {
            abstractButton = new JToggleButton(imageIcon);
            if (string.equals("rotate")) {
                buttonRotate = abstractButton;
            }
            toolbarButtonGroup.add(abstractButton);
            string2 = JmolResourceHandler.getStringX(string + "ToggleSelected");
            if (string2 != null) {
                boolean bl2 = Boolean.valueOf(string2);
                abstractButton.setSelected(bl2);
            }
        }
        abstractButton.setRequestFocusEnabled(false);
        abstractButton.setMargin(new Insets(1, 1, 1, 1));
        Action action = null;
        string2 = null;
        if (string.endsWith("Script")) {
            string2 = JmolResourceHandler.getStringX(string);
            action = this.executeScriptAction;
        } else {
            string2 = string;
            action = this.getAction(string);
        }
        if (action != null) {
            abstractButton.setActionCommand(string2);
            abstractButton.addActionListener(action);
            action.addPropertyChangeListener(new ActionChangedListener(abstractButton));
            abstractButton.setEnabled(action.isEnabled());
        } else {
            abstractButton.setEnabled(false);
        }
        String string4 = this.guimap.getLabel(string + "Tip");
        if (string4 != null) {
            abstractButton.setToolTipText(string4);
        }
        return abstractButton;
    }

    public static void setRotateButton() {
        if (buttonRotate != null) {
            buttonRotate.setSelected(true);
        }
    }

    protected String[] tokenize(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    protected Component createStatusBar() {
        return new StatusBar();
    }

    protected JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.addNormalMenuBar(jMenuBar);
        this.addMacrosMenuBar(jMenuBar);
        jMenuBar.add(Box.createHorizontalGlue());
        this.addHelpMenuBar(jMenuBar);
        return jMenuBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMacrosMenuBar(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu(GT._("Macros"));
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jmol" + System.getProperty("file.separator") + "macros");
        Jmol.report("User macros dir: " + file);
        Jmol.report("       exists: " + file.exists());
        Jmol.report("  isDirectory: " + file.isDirectory());
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getName();
                if (!string.endsWith(".macro")) continue;
                if (Logger.debugging) {
                    Logger.debug("Possible macro found: " + string);
                }
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(fileArray[i]);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    String string2 = properties.getProperty("Title");
                    String string3 = properties.getProperty("Script");
                    JMenuItem jMenuItem = new JMenuItem(string2);
                    jMenuItem.setActionCommand(string3);
                    jMenuItem.addActionListener(this.executeScriptAction);
                    jMenu.add(jMenuItem);
                    continue;
                }
                catch (IOException iOException) {
                    System.err.println("Could not load macro file: ");
                    System.err.println(iOException);
                    continue;
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                        fileInputStream = null;
                    }
                }
            }
        }
        jMenuBar.add(jMenu);
    }

    protected void addNormalMenuBar(JMenuBar jMenuBar) {
        String[] stringArray = this.tokenize(JmolResourceHandler.getStringX("menubar"));
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                jMenuBar.add(Box.createHorizontalGlue());
                continue;
            }
            JMenu jMenu = this.createMenu(stringArray[i]);
            if (jMenu == null) continue;
            jMenuBar.add(jMenu);
        }
    }

    protected void addHelpMenuBar(JMenuBar jMenuBar) {
        String string = "help";
        JMenu jMenu = this.createMenu(string);
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
    }

    protected JMenu createMenu(String string) {
        String[] stringArray = this.tokenize(JmolResourceHandler.getStringX(string));
        JMenu jMenu = this.guimap.newJMenu(string);
        ImageIcon imageIcon = JmolResourceHandler.getIconX(string + "Image");
        if (imageIcon != null) {
            jMenu.setHorizontalTextPosition(4);
            jMenu.setIcon(imageIcon);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JMenuItem jMenuItem;
            String string2 = stringArray[i];
            if (string2.equals("-")) {
                jMenu.addSeparator();
                continue;
            }
            if (string2.endsWith("Menu")) {
                jMenuItem = "recentFilesMenu".equals(string2) ? this.createMenu(string2) : this.createMenu(string2);
                jMenu.add(jMenuItem);
                continue;
            }
            jMenuItem = this.createMenuItem(string2);
            jMenu.add(jMenuItem);
        }
        jMenu.addMenuListener(this.display.getMenuListener());
        return jMenu;
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this.display);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                Logger.error("Error while printing", printerException);
            }
        }
    }

    public static File getUserDirectory() {
        if (System.getProperty("user.dir") == null) {
            return null;
        }
        return new File(System.getProperty("user.dir"));
    }

    static {
        numWindows = 0;
        screenSize = null;
        haveBorder = Boolean.FALSE;
        buttonRotate = null;
        toolbarButtonGroup = new ButtonGroup();
        if (System.getProperty("javawebstart.version") != null) {
            System.setSecurityManager(null);
        }
        if (System.getProperty("user.home") == null) {
            System.err.println(GT._("Error starting Jmol: the property 'user.home' is not defined."));
            System.exit(1);
        }
        File file = new File(new File(System.getProperty("user.home")), ".jmol");
        file.mkdirs();
        UserPropsFile = new File(file, "properties");
        historyFile = new HistoryFile(new File(file, "history"), "Jmol's persistent values");
        isSilent = Boolean.FALSE;
        haveConsole = Boolean.TRUE;
        haveDisplay = Boolean.TRUE;
    }

    class ExecuteScriptAction
    extends AbstractAction {
        public ExecuteScriptAction() {
            super("executeScriptAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Jmol.this.viewer.evalStringQuiet(actionEvent.getActionCommand());
        }
    }

    class MyStatusListener
    implements JmolStatusListener {
        MyStatusListener() {
        }

        public boolean notifyEnabled(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: {
                    return true;
                }
            }
            return false;
        }

        public void notifyCallback(int n, Object[] objectArray) {
            String string = objectArray == null || objectArray[1] == null ? null : objectArray[1].toString();
            switch (n) {
                case 4: {
                    this.notifyFileLoaded(string, (String)objectArray[2], (String)objectArray[3], (String)objectArray[4]);
                    break;
                }
                case 0: {
                    int[] nArray = (int[])objectArray[1];
                    this.notifyFrameChanged(nArray[0], nArray[1], nArray[2]);
                    break;
                }
                case 1: {
                    this.sendConsoleEcho(string);
                    break;
                }
                case 5: {
                    if (objectArray.length == 3) {
                        this.notifyAtomPicked(string);
                    } else if (((String)objectArray[3]).indexOf("Completed") >= 0) {
                        this.sendConsoleEcho(string.substring(string.lastIndexOf(",") + 2, string.length() - 1));
                    }
                    Jmol.this.measurementTable.updateTables();
                    break;
                }
                case 6: {
                    this.sendConsoleMessage(objectArray == null ? null : string);
                    break;
                }
                case 8: {
                    this.notifyAtomPicked(string);
                    break;
                }
                case 10: {
                    if (Jmol.this.scriptWindow == null) {
                        return;
                    }
                    int n2 = (Integer)objectArray[3];
                    if (n2 > 0) {
                        Jmol.this.scriptWindow.notifyScriptTermination();
                        break;
                    }
                    if (n2 < 0) {
                        if (n2 != -2) break;
                        Jmol.this.scriptWindow.notifyScriptStart();
                        break;
                    }
                    Jmol.this.scriptWindow.sendConsoleMessage(string);
                    break;
                }
            }
        }

        public String eval(String string) {
            if (string.startsWith("_GET_MENU")) {
                return Jmol.this.jmolpopup == null ? "" : Jmol.this.jmolpopup.getMenu("Jmol version " + Viewer.getJmolVersion() + "|" + string);
            }
            this.sendConsoleMessage("javascript: " + string);
            return "# 'eval' is implemented only for the applet.";
        }

        public void createImage(String string, Object object, int n) {
            ImageCreator imageCreator = new ImageCreator(Jmol.this.viewer, Jmol.this.status);
            imageCreator.createImage(string, object, n);
        }

        public void setCallbackFunction(String string, String string2) {
            if (string.equalsIgnoreCase("menu")) {
                menuStructure = string2;
                menuFile = null;
                Jmol.this.setupNewFrame(Jmol.this.viewer.getStateInfo());
                return;
            }
            if (string.equalsIgnoreCase("language")) {
                new GT(string2);
                Jmol.this.language = GT.getLanguage();
                Jmol.setupUIManager();
                Jmol.this.setupNewFrame(Jmol.this.viewer.getStateInfo());
            }
        }

        private void notifyAtomPicked(String string) {
            if (Jmol.this.scriptWindow != null) {
                Jmol.this.scriptWindow.sendConsoleMessage(string);
                Jmol.this.scriptWindow.sendConsoleMessage("\n");
            }
        }

        private void notifyFileLoaded(String string, String string2, String string3, String string4) {
            if (string4 != null) {
                return;
            }
            if (Jmol.this.display == null) {
                return;
            }
            String string5 = Jmol.JMOL_WINDOW_NAME;
            if (string == null) {
                if (string2 != null && Jmol.this.scriptWindow != null) {
                    Jmol.this.scriptWindow.undoClear();
                }
            } else {
                if (string3 != null && string2 != null) {
                    string5 = string2 + " - " + string3;
                } else if (string2 != null) {
                    string5 = string2;
                } else if (string3 != null) {
                    string5 = string3;
                }
                Jmol.this.recentFiles.notifyFileOpen(string);
            }
            Jmol.this.frame.setTitle(string5);
            Jmol.this.pcs.firePropertyChange(Jmol.chemFileProperty, null, null);
        }

        private void notifyFrameChanged(int n, int n2, int n3) {
            boolean bl;
            boolean bl2 = bl = n <= -2;
            if (Jmol.this.display != null) {
                Jmol.this.display.status.setStatus(1, n2 + "." + n3);
            }
            if (Jmol.this.jmolpopup == null || bl) {
                return;
            }
            Jmol.this.jmolpopup.updateComputedMenus();
        }

        private void sendConsoleEcho(String string) {
            if (Jmol.this.scriptWindow != null) {
                Jmol.this.scriptWindow.sendConsoleEcho(string);
            }
        }

        private void sendConsoleMessage(String string) {
            if (Jmol.this.scriptWindow != null) {
                Jmol.this.scriptWindow.sendConsoleMessage(string);
            }
        }

        public void handlePopupMenu(int n, int n2) {
            if (!Jmol.this.language.equals(GT.getLanguage())) {
                Jmol.this.jmolpopup = JmolPopup.newJmolPopup(Jmol.this.viewer, true, menuStructure);
                Jmol.this.language = GT.getLanguage();
            }
            Jmol.this.jmolpopup.show(n, n2);
        }

        public void showUrl(String string) {
            try {
                Class<?> clazz = Class.forName("java.awt.Desktop");
                Method method = clazz.getMethod("getDesktop", new Class[0]);
                Object object = method.invoke(null, (Object[])new Class[0]);
                Method method2 = clazz.getMethod("browse", class$java$net$URI == null ? (class$java$net$URI = Jmol.class$("java.net.URI")) : class$java$net$URI);
                Object[] objectArray = new Object[]{new URI(string)};
                method2.invoke(object, objectArray);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                if (Jmol.this.scriptWindow != null) {
                    Jmol.this.scriptWindow.sendConsoleMessage("Java 6 Desktop.browse() capability unavailable. Could not open " + string);
                }
                Logger.error("Java 6 Desktop.browse() capability unavailable. Could not open " + string);
            }
        }

        public void showConsole(boolean bl) {
            if (Jmol.this.scriptWindow == null) {
                return;
            }
            if (bl) {
                Jmol.this.scriptWindow.show();
            } else {
                Jmol.this.scriptWindow.hide();
            }
        }

        public float[][] functionXY(String string, int n, int n2) {
            n = Math.abs(n);
            n2 = Math.abs(n2);
            float[][] fArray = new float[n][n2];
            boolean bl = string.indexOf("2") >= 0;
            int n3 = n;
            while (--n3 >= 0) {
                int n4 = n2;
                while (--n4 >= 0) {
                    fArray[n3][n4] = bl ? (float)(n3 + n4 - n) / 2.0f : (float)Math.sqrt(Math.abs(n3 * n3 + n4 * n4)) / 2.0f;
                }
            }
            return fArray;
        }

        public Hashtable getRegistryInfo() {
            return null;
        }
    }

    private abstract class MoleculeDependentAction
    extends AbstractAction
    implements PropertyChangeListener {
        public MoleculeDependentAction(String string) {
            super(string);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }

    class ViewMeasurementTableAction
    extends MoleculeDependentAction {
        public ViewMeasurementTableAction() {
            super("viewMeasurementTable");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Jmol.this.viewer.script("set picking measure distance;set pickingstyle measure");
            Jmol.this.measurementTable.activate();
        }
    }

    class ToWebAction
    extends MoleculeDependentAction {
        public ToWebAction() {
            super(Jmol.toWebActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((ToWebAction)ToWebAction.this).Jmol.this.webExport = WebExport.createAndShowGUI(((ToWebAction)ToWebAction.this).Jmol.this.viewer, historyFile, Jmol.WEB_MAKER_WINDOW_NAME);
                }
            });
        }
    }

    class WriteAction
    extends MoleculeDependentAction {
        public WriteAction() {
            super(Jmol.writeActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            int n = Jmol.this.writeChooser.showSaveDialog(Jmol.this);
            if (n == 0 && (file = Jmol.this.writeChooser.getSelectedFile()) != null) {
                ImageCreator imageCreator = new ImageCreator(Jmol.this.viewer, Jmol.this.status);
                imageCreator.createImage(file.getAbsolutePath(), Jmol.this.viewer.getStateInfo(), Integer.MIN_VALUE);
            }
        }
    }

    class PovrayAction
    extends MoleculeDependentAction {
        public PovrayAction() {
            super(Jmol.povrayActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Jmol.this.currentFile != null) {
                Jmol.this.currentFile.getName().substring(0, Jmol.this.currentFile.getName().lastIndexOf("."));
            }
            new PovrayDialog(Jmol.this.frame, Jmol.this.viewer);
        }
    }

    class AtomSetChooserAction
    extends AbstractAction {
        public AtomSetChooserAction() {
            super(Jmol.atomsetchooserAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Jmol.this.atomSetChooser.show();
        }
    }

    class ScriptWindowAction
    extends AbstractAction {
        public ScriptWindowAction() {
            super(Jmol.scriptAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Jmol.this.scriptWindow != null) {
                Jmol.this.scriptWindow.show();
            }
        }
    }

    class RecentFilesAction
    extends AbstractAction {
        public RecentFilesAction() {
            super(Jmol.recentFilesAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Jmol.this.recentFiles.show();
            String string = Jmol.this.recentFiles.getFile();
            if (string != null) {
                Jmol.this.viewer.openFile(string);
                Jmol.this.viewer.getOpenFileError();
            }
        }
    }

    class ExportAction
    extends MoleculeDependentAction {
        ExportAction() {
            super(Jmol.exportActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            ImageTyper imageTyper = new ImageTyper(Jmol.this.exportChooser);
            Jmol.this.exportChooser.setAccessory(imageTyper);
            String string = Jmol.this.viewer.getModelSetFileName();
            String string2 = Jmol.this.viewer.getModelSetPathName();
            File file = null;
            if (string != null && string2 != null) {
                n = string.lastIndexOf(46);
                if (n != -1) {
                    string = string.substring(0, n) + "." + imageTyper.getExtension();
                }
                file = new File(string2, string);
                Jmol.this.exportChooser.setSelectedFile(file);
            }
            if ((n = Jmol.this.exportChooser.showSaveDialog(Jmol.this)) == 0) {
                imageTyper.memorizeDefaultType();
                file = Jmol.this.exportChooser.getSelectedFile();
                if (file != null) {
                    ImageCreator imageCreator = new ImageCreator(Jmol.this.viewer, Jmol.this.status);
                    int n2 = imageTyper.getQuality();
                    String string3 = imageTyper.getType();
                    if (string3.equals("PDF")) {
                        Document document = new Document();
                        try {
                            PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(file));
                            document.open();
                            int n3 = Jmol.this.display.getWidth();
                            int n4 = Jmol.this.display.getHeight();
                            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
                            PdfTemplate pdfTemplate = pdfContentByte.createTemplate(n3, n4);
                            Graphics2D graphics2D = pdfTemplate.createGraphics(n3, n4);
                            graphics2D.setStroke(new BasicStroke(0.1f));
                            pdfTemplate.setWidth(n3);
                            pdfTemplate.setHeight(n4);
                            Jmol.this.display.print(graphics2D);
                            graphics2D.dispose();
                            pdfContentByte.addTemplate(pdfTemplate, 72.0f, 720 - n4);
                        }
                        catch (DocumentException documentException) {
                            System.err.println(documentException.getMessage());
                        }
                        catch (IOException iOException) {
                            System.err.println(iOException.getMessage());
                        }
                        document.close();
                        return;
                    }
                    imageCreator.createImage(file.getAbsolutePath(), string3, n2);
                }
            }
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super(Jmol.exitAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Jmol.this.doClose();
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            super(Jmol.newAction);
        }

        NewAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Jmol.this.revalidate();
        }
    }

    class OpenUrlAction
    extends NewAction {
        String title;
        String prompt;

        OpenUrlAction() {
            super(Jmol.openurlAction);
            this.title = GT._("Open URL");
            this.prompt = GT._("Enter URL of molecular model");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(Jmol.this.frame, this.prompt, this.title, -1);
            if (string != null) {
                if (string.indexOf("://") == -1) {
                    string = "http://" + string;
                }
                Jmol.this.viewer.openFile(string);
                Jmol.this.viewer.getOpenFileError();
            }
        }
    }

    class OpenAction
    extends NewAction {
        OpenAction() {
            super(Jmol.openAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Jmol.this.openChooser.setDialogSize(historyFile.getWindowSize(Jmol.FILE_OPEN_WINDOW_NAME));
            Jmol.this.openChooser.setDialogLocation(historyFile.getWindowPosition(Jmol.FILE_OPEN_WINDOW_NAME));
            int n = Jmol.this.openChooser.showOpenDialog(Jmol.this);
            if (n == 0) {
                File file = Jmol.this.openChooser.getSelectedFile();
                if (Jmol.this.openPreview != null && Jmol.this.openPreview.isAppendSelected()) {
                    Jmol.this.viewer.scriptWait("load append " + Escape.escape(file.getAbsolutePath()));
                } else {
                    Jmol.this.viewer.openFile(file.getAbsolutePath());
                }
                return;
            }
            historyFile.addWindowInfo(Jmol.FILE_OPEN_WINDOW_NAME, Jmol.this.openChooser.getDialog(), null);
        }
    }

    class PrintAction
    extends MoleculeDependentAction {
        public PrintAction() {
            super(Jmol.printActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Jmol.this.print();
        }
    }

    class CopyScriptAction
    extends AbstractAction {
        public CopyScriptAction() {
            super(Jmol.copyScriptActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImageCreator imageCreator = new ImageCreator(Jmol.this.viewer, Jmol.this.status);
            imageCreator.clipImage((String)Jmol.this.viewer.getProperty("string", "stateInfo", null));
        }
    }

    class CopyImageAction
    extends AbstractAction {
        public CopyImageAction() {
            super(Jmol.copyImageActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImageCreator imageCreator = new ImageCreator(Jmol.this.viewer, Jmol.this.status);
            imageCreator.clipImage(null);
        }
    }

    class PasteClipboardAction
    extends AbstractAction {
        public PasteClipboardAction() {
            super(Jmol.pasteClipboardActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ImageSelection.getClipboardText();
            if (string != null && string.length() > 0) {
                Jmol.this.viewer.loadInline(string, false);
            }
        }
    }

    class UguideAction
    extends AbstractAction {
        public UguideAction() {
            super(Jmol.uguideAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HelpDialog helpDialog = new HelpDialog(Jmol.this.frame);
            helpDialog.show();
        }
    }

    class NewwinAction
    extends AbstractAction {
        NewwinAction() {
            super(Jmol.newwinAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFrame jFrame = new JFrame();
            new Jmol(null, jFrame, Jmol.this, Jmol.this.startupWidth, Jmol.this.startupHeight, "");
            jFrame.show();
        }
    }

    class WhatsNewAction
    extends AbstractAction {
        public WhatsNewAction() {
            super(Jmol.whatsnewAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WhatsNewDialog whatsNewDialog = new WhatsNewDialog(Jmol.this.frame);
            whatsNewDialog.show();
        }
    }

    class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super(Jmol.aboutAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AboutDialog aboutDialog = new AboutDialog(Jmol.this.frame);
            aboutDialog.show();
        }
    }

    static class ConsoleAction
    extends AbstractAction {
        public ConsoleAction() {
            super("console");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (consoleframe != null) {
                consoleframe.show();
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            super(Jmol.closeAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Jmol.this.frame.hide();
            Jmol.this.doClose();
        }
    }

    private static class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        ActionChangedListener(AbstractButton abstractButton) {
            this.button = abstractButton;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                if (this.button.getText() != null) {
                    this.button.setText(string2);
                }
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.button.setEnabled(bl);
            }
        }
    }

    protected final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Jmol.this.doClose();
        }
    }
}

