/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import Acme.JPM.Encoders.PpmEncoder;
import java.awt.Image;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.util.Base64;
import org.jmol.util.JpegEncoder;
import org.jmol.util.Logger;
import org.openscience.jmol.app.ImageSelection;
import org.openscience.jmol.app.PngEncoder;
import org.openscience.jmol.app.StatusBar;

public class ImageCreator {
    JmolViewer viewer;
    StatusBar status;

    public ImageCreator(JmolViewer jmolViewer, StatusBar statusBar) {
        this.viewer = jmolViewer;
        this.status = statusBar;
    }

    void clipImage(String string) {
        if (string == null) {
            Image image = this.viewer.getScreenImage();
            ImageSelection.setClipboard(image);
            this.viewer.releaseScreenImage();
            return;
        }
        ImageSelection.setClipboard(string);
    }

    public void createImage(String string, Object object, int n) {
        block15: {
            boolean bl;
            boolean bl2 = object instanceof byte[];
            String string2 = bl2 ? null : (String)object;
            boolean bl3 = bl = n == Integer.MIN_VALUE;
            if (string == null) {
                this.clipImage(string2);
                return;
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                if (bl2) {
                    fileOutputStream.write((byte[])object);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                } else if (bl) {
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream), 8192);
                    bufferedWriter.write(string2);
                    bufferedWriter.close();
                    fileOutputStream = null;
                } else {
                    Image image = this.viewer.getScreenImage();
                    if (string2.equalsIgnoreCase("JPEG") || string2.equalsIgnoreCase("JPG")) {
                        JpegEncoder jpegEncoder = new JpegEncoder(image, n, fileOutputStream);
                        jpegEncoder.Compress();
                    } else if (string2.equalsIgnoreCase("PPM")) {
                        PpmEncoder ppmEncoder = new PpmEncoder(image, (OutputStream)fileOutputStream);
                        ppmEncoder.encode();
                    } else if (string2.equalsIgnoreCase("PNG")) {
                        PngEncoder pngEncoder = new PngEncoder(image, false, 0, n);
                        byte[] byArray = pngEncoder.pngEncode();
                        fileOutputStream.write(byArray);
                    } else if (string2.equalsIgnoreCase("JPG64")) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        JpegEncoder jpegEncoder = new JpegEncoder(image, n, byteArrayOutputStream);
                        jpegEncoder.Compress();
                        byteArrayOutputStream.flush();
                        byteArrayOutputStream.close();
                        StringBuffer stringBuffer = Base64.getBase64(byteArrayOutputStream.toByteArray());
                        fileOutputStream.write(Base64.toBytes(stringBuffer));
                    }
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    this.viewer.releaseScreenImage();
                }
            }
            catch (IOException iOException) {
                this.viewer.releaseScreenImage();
                if (iOException == null) break block15;
                if (this.status != null) {
                    this.status.setStatus(1, GT._("IO Exception:"));
                    this.status.setStatus(2, iOException.toString());
                }
                Logger.error("IO Exception", iOException);
            }
        }
    }
}

