/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class HistoryFile {
    private Properties properties = new Properties();
    File file;
    String header;

    public HistoryFile(File file, String string) {
        this.file = file;
        this.header = string;
        this.load();
    }

    public void addProperties(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            bl |= this.addProperty(string, string2);
        }
        this.save();
    }

    public Properties getProperties() {
        return new Properties(this.properties);
    }

    public String getProperty(String string, String string2) {
        return this.properties.getProperty(string, string2);
    }

    private boolean addProperty(String string, String string2) {
        boolean bl = false;
        Object object = this.properties.setProperty(string, string2);
        if (!string2.equals(object)) {
            bl = true;
        }
        return bl;
    }

    public Point getWindowPosition(String string) {
        Point point = null;
        if (string != null) {
            try {
                String string2 = this.getProperty("Jmol.window." + string + ".x", null);
                String string3 = this.getProperty("Jmol.window." + string + ".y", null);
                if (string2 != null && string3 != null) {
                    int n = Integer.parseInt(string2);
                    int n2 = Integer.parseInt(string3);
                    point = new Point(n, n2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return point;
    }

    public Point getWindowBorder(String string) {
        Point point = null;
        try {
            String string2 = this.getProperty("Jmol.windowBorder." + string + ".x", null);
            String string3 = this.getProperty("Jmol.windowBorder." + string + ".y", null);
            if (string2 != null && string3 != null) {
                int n = Integer.parseInt(string2);
                int n2 = Integer.parseInt(string3);
                point = new Point(n, n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return point;
    }

    public Dimension getWindowSize(String string) {
        Dimension dimension = null;
        if (string != null) {
            try {
                String string2 = this.getProperty("Jmol.window." + string + ".w", null);
                String string3 = this.getProperty("Jmol.window." + string + ".h", null);
                if (string2 != null && string3 != null) {
                    int n = Integer.parseInt(string2);
                    int n2 = Integer.parseInt(string3);
                    dimension = new Dimension(n, n2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dimension;
    }

    public Boolean getWindowVisibility(String string) {
        Boolean bl = null;
        if (string != null) {
            try {
                String string2 = this.getProperty("Jmol.window." + string + ".visible", null);
                if (string2 != null) {
                    bl = Boolean.valueOf(string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    private boolean addWindowPosition(String string, Point point) {
        boolean bl = false;
        if (string != null && point != null) {
            bl |= this.addProperty("Jmol.window." + string + ".x", "" + point.x);
            bl |= this.addProperty("Jmol.window." + string + ".y", "" + point.y);
        }
        return bl;
    }

    private boolean addWindowBorder(String string, Point point) {
        boolean bl = false;
        if (string != null && point != null) {
            bl |= this.addProperty("Jmol.windowBorder." + string + ".x", "" + point.x);
            bl |= this.addProperty("Jmol.windowBorder." + string + ".y", "" + point.y);
        }
        return bl;
    }

    private boolean addWindowSize(String string, Dimension dimension) {
        boolean bl = false;
        if (string != null && dimension != null) {
            bl |= this.addProperty("Jmol.window." + string + ".w", "" + dimension.width);
            bl |= this.addProperty("Jmol.window." + string + ".h", "" + dimension.height);
        }
        return bl;
    }

    private boolean addWindowVisibility(String string, boolean bl) {
        boolean bl2 = false;
        if (string != null) {
            bl2 |= this.addProperty("Jmol.window." + string + ".visible", "" + bl);
        }
        return bl2;
    }

    public void addWindowInfo(String string, Component component, Point point) {
        if (component != null) {
            boolean bl = false;
            bl |= this.addWindowPosition(string, component.getLocation());
            bl |= this.addWindowSize(string, component.getSize());
            bl |= this.addWindowBorder(string, point);
            if (bl |= this.addWindowVisibility(string, component.isVisible())) {
                this.save();
            }
        }
    }

    public void repositionWindow(String string, Component component, int n, int n2) {
        if (component != null) {
            Point point = this.getWindowPosition(string);
            Dimension dimension = this.getWindowSize(string);
            Boolean bl = this.getWindowVisibility(string);
            if (point != null) {
                component.setLocation(point);
            }
            if (dimension != null) {
                if (dimension.width < n) {
                    dimension.width = n;
                }
                if (dimension.height < n2) {
                    dimension.height = n2;
                }
                component.setSize(dimension);
            }
            if (bl != null && bl.equals(Boolean.TRUE)) {
                component.show();
            }
        }
    }

    public void repositionWindow(String string, Component component) {
        this.repositionWindow(string, component, 10, 10);
    }

    private void load() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            this.properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            this.properties.store(fileOutputStream, this.header);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Error saving history: " + iOException);
        }
    }
}

