/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.openscience.jmol.app.JmolResourceHandler;

class GuiMap {
    Hashtable map = new Hashtable();
    Hashtable labels = null;

    GuiMap() {
    }

    private Hashtable setupLabels() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("file", GT._("&File"));
        hashtable.put("newwin", GT._("New"));
        hashtable.put("open", GT._("&Open"));
        hashtable.put("openTip", GT._("Open a file."));
        hashtable.put("openurl", GT._("Open &URL"));
        hashtable.put("script", GT._("Scrip&t..."));
        hashtable.put("atomsetchooser", GT._("AtomSetChooser..."));
        hashtable.put("saveas", GT._("&Save As..."));
        hashtable.put("exportMenu", GT._("&Export"));
        hashtable.put("export", GT._("Export &Image..."));
        hashtable.put("exportTip", GT._("Save current view as an image."));
        hashtable.put("toweb", GT._("Export to &Web Page..."));
        hashtable.put("towebTip", GT._("Export one or more views to a web page."));
        hashtable.put("povray", GT._("Render in POV-&Ray..."));
        hashtable.put("povrayTip", GT._("Render in pov-ray."));
        hashtable.put("write", GT._("Write &State..."));
        hashtable.put("writeTip", GT._("Save current view as a Jmol state script."));
        hashtable.put("print", GT._("&Print..."));
        hashtable.put("printTip", GT._("Print view."));
        hashtable.put("close", GT._("Close"));
        hashtable.put("exit", GT._("E&xit"));
        hashtable.put("recentFiles", GT._("Recent Files..."));
        hashtable.put("edit", GT._("&Edit"));
        hashtable.put("selectall", GT._("Select All"));
        hashtable.put("deselectall", GT._("Deselect All"));
        hashtable.put("copyImage", GT._("Copy Image"));
        hashtable.put("copyScript", GT._("Copy Script"));
        hashtable.put("prefs", GT._("&Preferences..."));
        hashtable.put("pasteClipboard", GT._("&Paste"));
        hashtable.put("editSelectAllScript", GT._("Select All"));
        hashtable.put("selectMenu", GT._("Select"));
        hashtable.put("selectAllScript", GT._("All"));
        hashtable.put("selectNoneScript", GT._("None"));
        hashtable.put("selectHydrogenScript", GT._("Hydrogen"));
        hashtable.put("selectCarbonScript", GT._("Carbon"));
        hashtable.put("selectNitrogenScript", GT._("Nitrogen"));
        hashtable.put("selectOxygenScript", GT._("Oxygen"));
        hashtable.put("selectPhosphorusScript", GT._("Phosphorus"));
        hashtable.put("selectSulphurScript", GT._("Sulphur"));
        hashtable.put("selectAminoScript", GT._("Amino"));
        hashtable.put("selectNucleicScript", GT._("Nucleic"));
        hashtable.put("selectWaterScript", GT._("Water"));
        hashtable.put("selectHeteroScript", GT._("Hetero"));
        hashtable.put("display", GT._("&Display"));
        hashtable.put("atomMenu", GT._("Atom"));
        hashtable.put("atomNoneScript", GT._("None"));
        hashtable.put("atom15Script", GT._("{0}% vanderWaals", "15"));
        hashtable.put("atom20Script", GT._("{0}% vanderWaals", "20"));
        hashtable.put("atom25Script", GT._("{0}% vanderWaals", "25"));
        hashtable.put("atom100Script", GT._("{0}% vanderWaals", "100"));
        hashtable.put("bondMenu", GT._("Bond"));
        hashtable.put("bondNoneScript", GT._("None"));
        hashtable.put("bondWireframeScript", GT._("Wireframe"));
        hashtable.put("bond100Script", GT._("{0} \u00c5", "0.10"));
        hashtable.put("bond150Script", GT._("{0} \u00c5", "0.15"));
        hashtable.put("bond200Script", GT._("{0} \u00c5", "0.20"));
        hashtable.put("labelMenu", GT._("Label"));
        hashtable.put("labelNoneScript", GT._("None"));
        hashtable.put("labelSymbolScript", GT._("Symbol"));
        hashtable.put("labelNameScript", GT._("Name"));
        hashtable.put("labelNumberScript", GT._("Number"));
        hashtable.put("labelCenteredScript", GT._("Centered"));
        hashtable.put("labelUpperRightScript", GT._("Upper right"));
        hashtable.put("vectorMenu", GT._("Vector"));
        hashtable.put("vectorOffScript", GT._("None"));
        hashtable.put("vectorOnScript", GT._("On"));
        hashtable.put("vector3Script", GT._("{0} pixels", "3"));
        hashtable.put("vector005Script", GT._("{0} \u00c5", "0.05"));
        hashtable.put("vector01Script", GT._("{0} \u00c5", "0.1"));
        hashtable.put("vectorScale02Script", GT._("Scale {0}", "0.2"));
        hashtable.put("vectorScale05Script", GT._("Scale {0}", "0.5"));
        hashtable.put("vectorScale1Script", GT._("Scale {0}", "1"));
        hashtable.put("vectorScale2Script", GT._("Scale {0}", "2"));
        hashtable.put("vectorScale5Script", GT._("Scale {0}", "5"));
        hashtable.put("zoomMenu", GT._("Zoom"));
        hashtable.put("zoom100Script", GT._("{0}%", "100"));
        hashtable.put("zoom150Script", GT._("{0}%", "150"));
        hashtable.put("zoom200Script", GT._("{0}%", "200"));
        hashtable.put("zoom400Script", GT._("{0}%", "400"));
        hashtable.put("zoom800Script", GT._("{0}%", "800"));
        hashtable.put("perspectiveCheck", GT._("Perspective Depth"));
        hashtable.put("axesCheck", GT._("Axes"));
        hashtable.put("boundboxCheck", GT._("Bounding Box"));
        hashtable.put("hydrogensCheck", GT._("&Hydrogens"));
        hashtable.put("vectorsCheck", GT._("&Vectors"));
        hashtable.put("measurementsCheck", GT._("&Measurements"));
        hashtable.put("view", GT._("&View"));
        hashtable.put("front", GT._("Front"));
        hashtable.put("top", GT._("Top"));
        hashtable.put("bottom", GT._("Bottom"));
        hashtable.put("right", GT._("Right"));
        hashtable.put("left", GT._("Left"));
        hashtable.put("transform", GT._("Transform..."));
        hashtable.put("definecenter", GT._("Define Center"));
        hashtable.put("tools", GT._("&Tools"));
        hashtable.put("viewMeasurementTable", GT._("Measurements..."));
        hashtable.put("viewMeasurementTableTip", GT._("Click atoms to measure distances"));
        hashtable.put("distanceUnitsMenu", GT._("Distance Units"));
        hashtable.put("distanceNanometersScript", GT._("Nanometers 1E-9"));
        hashtable.put("distanceAngstromsScript", GT._("Angstroms 1E-10"));
        hashtable.put("distancePicometersScript", GT._("Picometers 1E-12"));
        hashtable.put("animateMenu", GT._("Animate..."));
        hashtable.put("vibrateMenu", GT._("Vibrate..."));
        hashtable.put("graph", GT._("&Graph..."));
        hashtable.put("chemicalShifts", GT._("Calculate chemical &shifts..."));
        hashtable.put("crystprop", GT._("&Crystal Properties"));
        hashtable.put("animateOnceScript", GT._("Once"));
        hashtable.put("animateLoopScript", GT._("Loop"));
        hashtable.put("animatePalindromeScript", GT._("Palindrome"));
        hashtable.put("animateStopScript", GT._("Stop animation"));
        String string = GT._("Rewind to first frame");
        hashtable.put("animateRewindScript", string);
        hashtable.put("animateRewindScriptTip", string);
        string = GT._("Go to next frame");
        hashtable.put("animateNextScript", string);
        hashtable.put("animateNextScriptTip", string);
        string = GT._("Go to previous frame");
        hashtable.put("animatePrevScript", string);
        hashtable.put("animatePrevScriptTip", string);
        string = GT._("Go to last frame");
        hashtable.put("animateLastScript", string);
        hashtable.put("animateLastScriptTip", string);
        hashtable.put("vibrateStartScript", GT._("Start vibration"));
        hashtable.put("vibrateStopScript", GT._("Stop vibration"));
        hashtable.put("vibrateRewindScript", GT._("First frequency"));
        hashtable.put("vibrateNextScript", GT._("Next frequency"));
        hashtable.put("vibratePrevScript", GT._("Previous frequency"));
        hashtable.put("help", GT._("&Help"));
        hashtable.put("about", GT._("About Jmol"));
        hashtable.put("uguide", GT._("User Guide"));
        hashtable.put("whatsnew", GT._("What's New"));
        hashtable.put("console", GT._("Jmol Java &Console"));
        hashtable.put("Prefs.showHydrogens", GT._("Hydrogens"));
        hashtable.put("Prefs.showMeasurements", GT._("Measurements"));
        hashtable.put("Prefs.perspectiveDepth", GT._("Perspective Depth"));
        hashtable.put("Prefs.showAxes", GT._("Axes"));
        hashtable.put("Prefs.showBoundingBox", GT._("Bounding Box"));
        hashtable.put("Prefs.axesOrientationRasmol", GT._("RasMol/Chime compatible axes orientation/rotations"));
        hashtable.put("Prefs.openFilePreview", GT._("File Preview (needs restarting Jmol)"));
        hashtable.put("Prefs.clearConsoleButton", GT._("Clear console button (needs restarting Jmol)"));
        hashtable.put("Prefs.isLabelAtomColor", GT._("Use Atom Color"));
        hashtable.put("Prefs.isBondAtomColor", GT._("Use Atom Color"));
        hashtable.put("rotateTip", GT._("Rotate molecule."));
        hashtable.put("pickTip", GT._("Select a set of atoms using SHIFT-LEFT-  DRAG."));
        hashtable.put("homeTip", GT._("Return molecule to home position."));
        return hashtable;
    }

    String getLabel(String string) {
        String string2;
        if (this.labels == null) {
            this.labels = this.setupLabels();
        }
        if ((string2 = (String)this.labels.get(string)) == null) {
            Logger.warn("Missing i18n menu resource, trying old scheme for: " + string);
            JmolResourceHandler.getStringX(string + "Label");
        }
        return string2;
    }

    JMenu newJMenu(String string) {
        String string2 = this.getLabel(string);
        return new KeyJMenu(string, this.getLabelWithoutMnemonic(string2), this.getMnemonic(string2));
    }

    JMenuItem newJMenuItem(String string) {
        String string2 = this.getLabel(string);
        return new KeyJMenuItem(string, this.getLabelWithoutMnemonic(string2), this.getMnemonic(string2));
    }

    JCheckBoxMenuItem newJCheckBoxMenuItem(String string, boolean bl) {
        String string2 = this.getLabel(string);
        return new KeyJCheckBoxMenuItem(string, this.getLabelWithoutMnemonic(string2), this.getMnemonic(string2), bl);
    }

    JRadioButtonMenuItem newJRadioButtonMenuItem(String string) {
        String string2 = this.getLabel(string);
        return new KeyJRadioButtonMenuItem(string, this.getLabelWithoutMnemonic(string2), this.getMnemonic(string2));
    }

    JCheckBox newJCheckBox(String string, boolean bl) {
        String string2 = this.getLabel(string);
        return new KeyJCheckBox(string, this.getLabelWithoutMnemonic(string2), this.getMnemonic(string2), bl);
    }

    Object get(String string) {
        return this.map.get(string);
    }

    String getKey(Object object) {
        return ((GetKey)object).getKey();
    }

    public String getLabelWithoutMnemonic(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(38);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + (n < string.length() - 1 ? string.substring(n + 1) : "");
    }

    public char getMnemonic(String string) {
        if (string == null) {
            return ' ';
        }
        int n = string.indexOf(38);
        if (n == -1 || n == string.length() - 1) {
            return ' ';
        }
        return string.charAt(n + 1);
    }

    void setSelected(String string, boolean bl) {
        ((AbstractButton)this.get(string)).setSelected(bl);
    }

    boolean isSelected(String string) {
        return ((AbstractButton)this.get(string)).isSelected();
    }

    class KeyJCheckBox
    extends JCheckBox
    implements GetKey {
        String key;

        KeyJCheckBox(String string, String string2, char c, boolean bl) {
            super(string2, bl);
            if (c != ' ') {
                this.setMnemonic(c);
            }
            this.key = string;
            GuiMap.this.map.put(string, this);
        }

        public String getKey() {
            return this.key;
        }
    }

    class KeyJRadioButtonMenuItem
    extends JRadioButtonMenuItem
    implements GetKey {
        String key;

        KeyJRadioButtonMenuItem(String string, String string2, char c) {
            super(string2);
            if (c != ' ') {
                this.setMnemonic(c);
            }
            this.key = string;
            GuiMap.this.map.put(string, this);
        }

        public String getKey() {
            return this.key;
        }
    }

    class KeyJCheckBoxMenuItem
    extends JCheckBoxMenuItem
    implements GetKey {
        String key;

        KeyJCheckBoxMenuItem(String string, String string2, char c, boolean bl) {
            super(string2, bl);
            if (c != ' ') {
                this.setMnemonic(c);
            }
            this.key = string;
            GuiMap.this.map.put(string, this);
        }

        public String getKey() {
            return this.key;
        }
    }

    class KeyJMenuItem
    extends JMenuItem
    implements GetKey {
        String key;

        KeyJMenuItem(String string, String string2, char c) {
            super(string2);
            if (c != ' ') {
                this.setMnemonic(c);
            }
            this.key = string;
            GuiMap.this.map.put(string, this);
        }

        public String getKey() {
            return this.key;
        }
    }

    class KeyJMenu
    extends JMenu
    implements GetKey {
        String key;

        KeyJMenu(String string, String string2, char c) {
            super(string2);
            if (c != ' ') {
                this.setMnemonic(c);
            }
            this.key = string;
            GuiMap.this.map.put(string, this);
        }

        public String getKey() {
            return this.key;
        }
    }

    static interface GetKey {
        public String getKey();
    }
}

