/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.openscience.jmol.app.JmolResourceHandler;

public class FileTyper
extends JPanel
implements PropertyChangeListener,
ItemListener {
    private JCheckBox useFileExtensionCheckBox;
    private JLabel fileTypeLabel;
    private JComboBox fileTypeComboBox;
    private boolean useFileExtension = true;
    private String[] choices = new String[]{JmolResourceHandler.getStringX("FileTyper.XYZ"), JmolResourceHandler.getStringX("FileTyper.PDB"), JmolResourceHandler.getStringX("FileTyper.CML")};
    private int defaultTypeIndex = 0;
    private String fileType = this.choices[this.defaultTypeIndex];

    public FileTyper() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.useFileExtensionCheckBox = new JCheckBox(JmolResourceHandler.getStringX("FileTyper.useFileExtensionCheckBox"), this.useFileExtension);
        this.useFileExtensionCheckBox.addItemListener(this);
        String string = JmolResourceHandler.getStringX("FileTyper.useFileExtensionMnemonic");
        if (string != null && string.length() > 0) {
            this.useFileExtensionCheckBox.setMnemonic(string.charAt(0));
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.useFileExtensionCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.fileTypeLabel = new JLabel(JmolResourceHandler.getStringX("FileTyper.fileTypeLabel"));
        this.fileTypeLabel.setForeground(Color.black);
        jPanel.add((Component)this.fileTypeLabel, gridBagConstraints);
        this.fileTypeComboBox = new JComboBox<String>(this.choices);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.fileTypeComboBox, gridBagConstraints);
        this.fileTypeComboBox.setSelectedIndex(this.defaultTypeIndex);
        this.fileTypeComboBox.addItemListener(this);
        this.add((Component)jPanel, "Center");
        this.setUseFileExtension(this.useFileExtension);
    }

    public String getType() {
        return this.fileType;
    }

    private void setUseFileExtension(boolean bl) {
        this.useFileExtension = bl;
        this.fileTypeLabel.setEnabled(!this.useFileExtension);
        this.fileTypeComboBox.setEnabled(!this.useFileExtension);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.useFileExtensionCheckBox) {
            if (itemEvent.getStateChange() == 2) {
                this.setUseFileExtension(false);
            } else {
                this.setUseFileExtension(true);
            }
        } else if (itemEvent.getSource() == this.fileTypeComboBox) {
            this.fileType = (String)this.fileTypeComboBox.getSelectedItem();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.useFileExtension && string.equals("SelectedFileChangedProperty")) {
            File file = (File)propertyChangeEvent.getNewValue();
            String string2 = file.toString().toLowerCase();
            if (string2.endsWith("xyz")) {
                this.fileTypeComboBox.setSelectedIndex(0);
            } else if (string2.endsWith("pdb")) {
                this.fileTypeComboBox.setSelectedIndex(1);
            } else if (string2.endsWith("cml")) {
                this.fileTypeComboBox.setSelectedIndex(2);
            } else {
                this.fileTypeComboBox.setSelectedIndex(0);
            }
        }
    }
}

