/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import org.jmol.api.JmolViewer;
import org.openscience.jmol.app.ConsoleDocument;
import org.openscience.jmol.app.EnterListener;
import org.openscience.jmol.app.ScriptWindow;

class ConsoleTextPane
extends JTextPane {
    ConsoleDocument consoleDoc = (ConsoleDocument)this.getDocument();
    EnterListener enterListener;
    JmolViewer viewer;
    boolean checking = false;

    ConsoleTextPane(ScriptWindow scriptWindow) {
        super(new ConsoleDocument());
        this.consoleDoc.setConsoleTextPane(this);
        this.enterListener = scriptWindow;
        this.viewer = scriptWindow.viewer;
    }

    public String getCommandString() {
        String string = this.consoleDoc.getCommandString();
        return string;
    }

    public void setPrompt() {
        this.consoleDoc.setPrompt();
    }

    public void appendNewline() {
        this.consoleDoc.appendNewline();
    }

    public void outputError(String string) {
        this.consoleDoc.outputError(string);
    }

    public void outputErrorForeground(String string) {
        this.consoleDoc.outputErrorForeground(string);
    }

    public void outputEcho(String string) {
        this.consoleDoc.outputEcho(string);
    }

    public void outputStatus(String string) {
        this.consoleDoc.outputStatus(string);
    }

    public void enterPressed() {
        if (this.enterListener != null) {
            this.enterListener.enterPressed();
        }
    }

    public void clearContent() {
        this.clearContent(null);
    }

    public void clearContent(String string) {
        this.consoleDoc.clearContent();
        if (string != null) {
            this.consoleDoc.outputEcho(string);
        }
        this.setPrompt();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getID();
        if (n == 38 && n2 == 401 && !keyEvent.isControlDown()) {
            this.recallCommand(true);
        } else if (n == 40 && n2 == 401 && !keyEvent.isControlDown()) {
            this.recallCommand(false);
        } else if ((n == 40 || n == 38) && n2 == 401 && keyEvent.isControlDown()) {
            super.processKeyEvent(new KeyEvent((Component)keyEvent.getSource(), n2, keyEvent.getWhen(), 0, n, keyEvent.getKeyChar(), keyEvent.getKeyLocation()));
        } else {
            super.processKeyEvent(keyEvent);
            if (n2 == 402 && keyEvent.getModifiers() < 2 && (n > 40 && n < 400 || n == 8)) {
                this.checkCommand();
            }
        }
    }

    void recallCommand(boolean bl) {
        String string = this.viewer.getSetHistory(bl ? -1 : 1);
        if (string == null) {
            return;
        }
        try {
            if (string.endsWith("#??")) {
                string = string.substring(0, string.indexOf("#??"));
                this.consoleDoc.replaceCommand(string, true);
            } else {
                this.consoleDoc.replaceCommand(string, false);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    synchronized void checkCommand() {
        String string = this.consoleDoc.getCommandString();
        if (string.length() == 0 || string.charAt(0) == '!' || this.viewer.isScriptExecuting()) {
            return;
        }
        this.checking = true;
        this.consoleDoc.colorCommand(this.viewer.scriptCheck(string) == null ? this.consoleDoc.attUserInput : this.consoleDoc.attError);
        this.checking = false;
    }
}

