/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolSelectionListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.api.MinimizerInterface;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomIndexIterator;
import org.jmol.modelset.BoxInfo;
import org.jmol.modelset.MeasurementPending;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Base64;
import org.jmol.util.BitSetUtil;
import org.jmol.util.CommandHistory;
import org.jmol.util.Escape;
import org.jmol.util.JpegEncoder;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TempArray;
import org.jmol.util.TextFormat;
import org.jmol.viewer.ColorManager;
import org.jmol.viewer.Compiler;
import org.jmol.viewer.DataManager;
import org.jmol.viewer.Eval;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.FrameRenderer;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.ModelManager;
import org.jmol.viewer.MouseManager;
import org.jmol.viewer.MouseManager10;
import org.jmol.viewer.MouseWrapper11;
import org.jmol.viewer.MouseWrapper14;
import org.jmol.viewer.PickingManager;
import org.jmol.viewer.PropertyManager;
import org.jmol.viewer.RepaintManager;
import org.jmol.viewer.ScriptManager;
import org.jmol.viewer.SelectionManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.StatusManager;
import org.jmol.viewer.Token;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.TransformManager10;
import org.jmol.viewer.TransformManager11;

public class Viewer
extends JmolViewer
implements AtomDataServer {
    private Component display;
    private Graphics3D g3d;
    private JmolAdapter modelAdapter;
    private CommandHistory commandHistory = new CommandHistory();
    private ColorManager colorManager;
    private Compiler compiler;
    private MinimizerInterface minimizer;
    private Eval eval;
    private DataManager dataManager;
    private FileManager fileManager;
    private ModelManager modelManager;
    private ModelSet modelSet;
    public MouseManager mouseManager;
    private PickingManager pickingManager;
    private RepaintManager repaintManager;
    private ScriptManager scriptManager;
    private SelectionManager selectionManager;
    private StateManager stateManager;
    private StateManager.GlobalSettings global;
    private StatusManager statusManager;
    private TempArray tempManager;
    private TransformManager transformManager;
    private String strJavaVendor;
    private String strJavaVersion;
    private String strOSName;
    private String htmlName = "";
    private String fullName = "";
    private String syncId = "";
    private String appletDocumentBase = "";
    private String appletCodeBase = "";
    private boolean jvm11orGreater = false;
    private boolean jvm12orGreater = false;
    private boolean jvm14orGreater = false;
    private Hashtable evalVariables;
    private boolean isSilent = false;
    private boolean isApplet = false;
    private boolean autoExit = false;
    private String writeInfo;
    private boolean haveDisplay = true;
    private boolean mustRender = true;
    private boolean checkScriptOnly = false;
    private boolean listCommands = false;
    private boolean fileOpenCheck = true;
    private boolean useCommandThread = false;
    private boolean isSignedApplet = false;
    private boolean noneSelected;
    static final String STATE_VERSION_STAMP = "# Jmol state version ";
    public static Object testData;
    public static Object testData2;
    boolean wasInMotion = false;
    int motionEventNumber;
    private boolean refreshing = true;
    private boolean axesAreTainted = false;
    final Dimension dimScreen = new Dimension();
    private boolean antialiasDisplay;
    String interruptScript = "";
    int scriptIndex;
    boolean isScriptQueued = true;
    boolean checking;
    int hoverAtomIndex = -1;
    String hoverText;
    int n;
    public static final int CURSOR_DEFAULT = 0;
    public static final int CURSOR_HAND = 1;
    public static final int CURSOR_CROSSHAIR = 2;
    public static final int CURSOR_MOVE = 3;
    public static final int CURSOR_WAIT = 4;
    private int currentCursor = 0;
    boolean frankOn = true;
    boolean isTainted = true;
    private float imageFontScaling = 1.0f;
    private boolean syncingScripts = false;
    private boolean syncingMouse = false;

    protected void finalize() throws Throwable {
        Logger.debug("viewer finalize " + this);
        super.finalize();
    }

    Compiler getCompiler() {
        return this.compiler;
    }

    public void setMinimizer(MinimizerInterface minimizerInterface) {
        this.minimizer = minimizerInterface;
        if (minimizerInterface != null) {
            minimizerInterface.setProperty("viewer", this);
        }
    }

    public MinimizerInterface getMinimizer() {
        if (this.minimizer != null) {
            this.minimizer.setProperty("viewer", this);
        }
        return this.minimizer;
    }

    StateManager.GlobalSettings getGlobalSettings() {
        return this.global;
    }

    Hashtable getEvalVariables() {
        return this.evalVariables;
    }

    public Viewer(Component component, JmolAdapter jmolAdapter) {
        if (Logger.debugging) {
            Logger.debug("Viewer constructor " + this);
        }
        this.display = component;
        this.modelAdapter = jmolAdapter;
        this.strJavaVendor = System.getProperty("java.vendor");
        this.strOSName = System.getProperty("os.name");
        this.strJavaVersion = System.getProperty("java.version");
        this.jvm11orGreater = this.strJavaVersion.compareTo("1.1") >= 0 && (!this.strJavaVendor.startsWith("Netscape") || this.strJavaVersion.compareTo("1.1.5") > 0 || !"Mac OS".equals(this.strOSName));
        this.jvm12orGreater = this.strJavaVersion.compareTo("1.2") >= 0;
        this.jvm14orGreater = this.strJavaVersion.compareTo("1.4") >= 0;
        this.stateManager = new StateManager(this);
        this.g3d = new Graphics3D(component);
        this.colorManager = new ColorManager(this, this.g3d);
        this.statusManager = new StatusManager(this);
        this.scriptManager = new ScriptManager(this);
        this.transformManager = new TransformManager11(this);
        this.selectionManager = new SelectionManager(this);
        this.pickingManager = new PickingManager(this);
        this.mouseManager = this.jvm14orGreater ? MouseWrapper14.alloc(component, this) : (this.jvm11orGreater ? MouseWrapper11.alloc(component, this) : new MouseManager10(component, this));
        this.modelManager = new ModelManager(this);
        this.tempManager = new TempArray();
        this.dataManager = new DataManager();
        this.repaintManager = new RepaintManager(this);
        this.initialize();
        this.fileManager = new FileManager(this, jmolAdapter);
        this.compiler = new Compiler(this);
        this.evalVariables = new Hashtable();
        this.eval = new Eval(this);
    }

    public static JmolViewer allocateViewer(Component component, JmolAdapter jmolAdapter) {
        return new Viewer(component, jmolAdapter);
    }

    public boolean isApplet() {
        return this.htmlName.length() > 0;
    }

    public void setAppletContext(String string, URL uRL, URL uRL2, String string2) {
        string = string == null ? "" : string;
        this.fullName = string;
        this.appletDocumentBase = uRL == null ? "" : uRL.toString();
        this.appletCodeBase = uRL2 == null ? "" : uRL2.toString();
        int n = string.lastIndexOf("[");
        this.htmlName = n < 0 ? string : string.substring(0, n);
        this.syncId = n < 0 ? "" : string.substring(n + 1, string.length() - 1);
        this.isApplet = uRL != null;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        String string4 = (String)this.getParameter("_memory");
        String string5 = null;
        if (this.isApplet && (n = string3.indexOf("-appletProxy ")) >= 0) {
            string5 = string3.substring(n + 13);
            string3 = string3.substring(0, n);
        }
        boolean bl = this.useCommandThread = string3.indexOf("-t") >= 0;
        if (this.useCommandThread) {
            this.scriptManager.startCommandWatcher(true);
        }
        this.isSignedApplet = this.isApplet && string3.indexOf("-signed") >= 0;
        this.setBooleanProperty("_applet", this.isApplet);
        this.setBooleanProperty("_signedApplet", this.isSignedApplet);
        this.setBooleanProperty("_useCommandThread", this.useCommandThread);
        if (!this.isApplet) {
            if (string3.indexOf("-i") >= 0) {
                Logger.setLogLevel(3);
                this.isSilent = true;
            }
            if (string3.indexOf("-c") >= 0) {
                this.checkScriptOnly = true;
                this.fileOpenCheck = true;
            }
            if (string3.indexOf("-C") >= 0) {
                this.checkScriptOnly = true;
                this.fileOpenCheck = false;
            }
            if (string3.indexOf("-l") >= 0) {
                this.listCommands = true;
            }
            if (string3.indexOf("-x") >= 0) {
                this.autoExit = true;
            }
            if (this.display == null || string3.indexOf("-n") >= 0) {
                this.haveDisplay = false;
                this.display = null;
            }
            this.writeInfo = null;
            if (string3.indexOf("-w") >= 0) {
                n = string3.indexOf("\u0001");
                int n2 = string3.lastIndexOf("\u0001");
                this.writeInfo = string3.substring(n + 1, n2);
            }
            boolean bl2 = this.mustRender = this.haveDisplay || this.writeInfo != null;
        }
        if (!this.isSilent) {
            Logger.info("(C) 2007 Jmol Development\nJmol Version " + Viewer.getJmolVersion() + "\njava.vendor:" + this.strJavaVendor + "\njava.version:" + this.strJavaVersion + "\nos.name:" + this.strOSName + "\nmemory:" + string4 + "\nuseCommandThread: " + this.useCommandThread + (!this.isApplet ? "" : "\nappletId:" + this.htmlName + (this.isSignedApplet ? " (signed)" : "")));
        }
        if (this.isApplet) {
            this.fileManager.setAppletContext(uRL, uRL2, string5);
        }
        this.zap(false, false);
        this.global.setParameterValue("language", GT.getLanguage());
    }

    public static String getJmolVersion() {
        return JmolConstants.version + "  " + JmolConstants.date;
    }

    public String getExportDriverList() {
        return (String)this.global.getParameter("exportDrivers");
    }

    private static int getJmolVersionInt() {
        String string = JmolConstants.version;
        int n = -1;
        try {
            int n2 = string.indexOf(".");
            if (n2 < 0) {
                n = 100000 * Integer.parseInt(string);
                return n;
            }
            n = 100000 * Integer.parseInt(string.substring(0, n2));
            if ((n2 = (string = string.substring(n2 + 1)).indexOf(".")) < 0) {
                return n += 1000 * Integer.parseInt(string);
            }
            n += 1000 * Integer.parseInt(string.substring(0, n2));
            if ((n2 = (string = string.substring(n2 + 1)).indexOf("_")) >= 0) {
                string = string.substring(0, n2);
            }
            if ((n2 = string.indexOf(" ")) >= 0) {
                string = string.substring(0, n2);
            }
            n += Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    String getHtmlName() {
        return this.htmlName;
    }

    boolean mustRenderFlag() {
        return this.mustRender && this.refreshing;
    }

    static int getLogLevel() {
        for (int i = 0; i < 7; ++i) {
            if (!Logger.isActiveLevel(i)) continue;
            return 7 - i;
        }
        return 0;
    }

    public Component getAwtComponent() {
        return this.display;
    }

    public boolean handleOldJvm10Event(Event event) {
        return this.mouseManager.handleOldJvm10Event(event);
    }

    void reset() {
        this.modelSet.calcBoundBoxDimensions(null);
        this.axesAreTainted = true;
        this.transformManager.homePosition();
        if (this.modelSet.setCrystallographicDefaults()) {
            this.stateManager.setCrystallographicDefaults();
        } else {
            this.setAxesModeMolecular(false);
        }
        this.refresh(1, "Viewer:homePosition()");
    }

    public void homePosition() {
        this.evalString("reset");
    }

    Hashtable getAppletInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("htmlName", this.htmlName);
        hashtable.put("syncId", this.syncId);
        hashtable.put("fullName", this.fullName);
        if (this.isApplet) {
            hashtable.put("documentBase", this.appletDocumentBase);
            hashtable.put("codeBase", this.appletCodeBase);
            hashtable.put("registry", this.statusManager.getRegistryInfo());
        }
        hashtable.put("version", JmolConstants.version);
        hashtable.put("date", JmolConstants.date);
        hashtable.put("javaVendor", this.strJavaVendor);
        hashtable.put("javaVersion", this.strJavaVersion);
        hashtable.put("operatingSystem", this.strOSName);
        return hashtable;
    }

    void initialize() {
        this.global = this.stateManager.getGlobalSettings(this.global);
        this.setIntProperty("_version", Viewer.getJmolVersionInt(), true);
        this.setBooleanProperty("_applet", this.isApplet);
        this.setBooleanProperty("_signedApplet", this.isSignedApplet);
        this.setBooleanProperty("_useCommandThread", this.useCommandThread);
        this.colorManager.resetElementColors();
        this.setObjectColor("background", "black");
        this.setObjectColor("axis1", "red");
        this.setObjectColor("axis2", "green");
        this.setObjectColor("axis3", "blue");
        this.setZShade(this.global.zShade);
        Viewer.setAmbientPercent(this.global.ambientPercent);
        Viewer.setDiffusePercent(this.global.diffusePercent);
        Viewer.setSpecular(this.global.specular);
        Viewer.setSpecularPercent(this.global.specularPercent);
        Viewer.setSpecularExponent(this.global.specularExponent);
        Viewer.setSpecularPower(this.global.specularPower);
        this.repaintManager.setAnimationFps(this.global.animationFps);
        this.statusManager.setAllowStatusReporting(this.global.statusReporting);
        this.setTransformManagerDefaults();
    }

    String listSavedStates() {
        return this.stateManager.listSavedStates();
    }

    void saveOrientation(String string) {
        this.stateManager.saveOrientation(string);
    }

    boolean restoreOrientation(String string, float f) {
        return this.stateManager.restoreOrientation(string, f, true);
    }

    public void restoreRotation(String string, float f) {
        this.stateManager.restoreOrientation(string, f, false);
    }

    void saveModelOrientation() {
        this.modelSet.saveModelOrientation(this.repaintManager.currentModelIndex, this.stateManager.getOrientation());
    }

    void restoreModelOrientation(int n) {
        StateManager.Orientation orientation = this.modelSet.getModelOrientation(n);
        if (orientation != null) {
            orientation.restore(-1.0f, true);
        }
    }

    void restoreModelRotation(int n) {
        StateManager.Orientation orientation = this.modelSet.getModelOrientation(n);
        if (orientation != null) {
            orientation.restore(-1.0f, false);
        }
    }

    void saveBonds(String string) {
        this.stateManager.saveBonds(string);
    }

    boolean restoreBonds(String string) {
        this.clearMinimization();
        return this.stateManager.restoreBonds(string);
    }

    void saveState(String string) {
        this.stateManager.saveState(string);
    }

    public String getSavedState(String string) {
        return this.stateManager.getSavedState(string);
    }

    void saveStructure(String string) {
        this.stateManager.saveStructure(string);
    }

    String getSavedStructure(String string) {
        return this.stateManager.getSavedStructure(string);
    }

    public void saveCoordinates(String string, BitSet bitSet) {
        this.stateManager.saveCoordinates(string, bitSet);
    }

    String getSavedCoordinates(String string) {
        return this.stateManager.getSavedCoordinates(string);
    }

    void saveSelection(String string) {
        this.stateManager.saveSelection(string, this.selectionManager.bsSelection);
        this.stateManager.restoreSelection(string);
    }

    boolean restoreSelection(String string) {
        return this.stateManager.restoreSelection(string);
    }

    public Matrix4f getMatrixtransform() {
        return this.transformManager.getMatrixtransform();
    }

    public float getRotationRadius() {
        return this.transformManager.getRotationRadius();
    }

    void setRotationRadius(float f, boolean bl) {
        if (bl) {
            f = this.transformManager.setRotationRadius(f, false);
        }
        if (!this.modelSet.setRotationRadius(this.repaintManager.currentModelIndex, f)) {
            this.global.setParameterValue("rotationRadius", f);
        }
    }

    public Point3f getRotationCenter() {
        return this.transformManager.getRotationCenter();
    }

    void setCenterAt(String string, Point3f point3f) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.setCenterAt(string, point3f);
        this.refresh(0, "Viewer:setCenter(" + string + ")");
    }

    void setCenterBitSet(BitSet bitSet, boolean bl) {
        Point3f point3f;
        Point3f point3f2 = point3f = bitSet != null && BitSetUtil.cardinalityOf(bitSet) > 0 ? this.getAtomSetCenter(bitSet) : null;
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.setNewRotationCenter(point3f, bl);
        this.refresh(0, "Viewer:setCenterBitSet()");
    }

    void setNewRotationCenter(Point3f point3f) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.setNewRotationCenter(point3f, true);
        this.refresh(0, "Viewer:setCenterBitSet()");
    }

    Point3f getNavigationCenter() {
        return this.transformManager.getNavigationCenter();
    }

    public boolean getNavigationCentered() {
        return this.transformManager.isNavigationCentered();
    }

    float getNavigationDepthPercent() {
        return this.transformManager.getNavigationDepthPercent();
    }

    void navigate(int n, int n2) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(n, n2);
        if (!this.transformManager.vibrationOn) {
            this.refresh(1, "Viewer:navigate()");
        }
    }

    public Point3f getNavigationOffset() {
        return this.transformManager.getNavigationOffset();
    }

    float getNavigationOffsetPercent(char c) {
        return this.transformManager.getNavigationOffsetPercent(c);
    }

    public boolean getNavigating() {
        return this.transformManager.getNavigating();
    }

    boolean isInPosition(Point3f point3f, float f) {
        return this.transformManager.isInPosition(point3f, f);
    }

    void move(Vector3f vector3f, float f, Vector3f vector3f2, float f2, float f3, int n) {
        this.transformManager.move(vector3f, f, vector3f2, f2, f3, n);
    }

    void moveTo(float f, Point3f point3f, Point3f point3f2, float f2, float f3, float f4, float f5, float f6, Point3f point3f3, float f7, float f8, float f9) {
        this.transformManager.moveTo(f, point3f, point3f2, f2, f3, f4, f5, f6, point3f3, f7, f8, f9);
    }

    void moveTo(float f, Matrix3f matrix3f, Point3f point3f, float f2, float f3, float f4, float f5, Point3f point3f2, float f6, float f7, float f8) {
        this.transformManager.moveTo(f, matrix3f, point3f, f2, f3, f4, f5, point3f2, f6, f7, f8);
    }

    String getMoveToText(float f) {
        return this.transformManager.getMoveToText(f, false);
    }

    void navigate(float f, Point3f[] point3fArray, float[] fArray, int n, int n2) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(f, point3fArray, fArray, n, n2);
        this.refresh(1, "navigate");
    }

    void navigate(float f, Point3f point3f) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(f, point3f);
        this.refresh(1, "navigate");
    }

    void navigate(float f, Point3f[][] point3fArray) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(f, point3fArray);
        this.refresh(1, "navigate");
    }

    void navigate(float f, Vector3f vector3f, float f2) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(f, vector3f, f2);
        this.refresh(1, "navigate");
    }

    void navTranslate(float f, Point3f point3f) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navTranslate(f, point3f);
        this.refresh(1, "navigate");
    }

    void navTranslatePercent(float f, float f2, float f3) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navTranslatePercent(f, f2, f3);
        this.refresh(1, "navigate");
    }

    void zoomBy(int n) {
        this.transformManager.zoomBy(n);
        this.refresh(2, this.syncingMouse ? "Mouse: zoomBy " + n : "");
    }

    void zoomByFactor(float f) {
        this.transformManager.zoomByFactor(f);
        this.refresh(2, this.syncingMouse ? "Mouse: zoomByFactor " + f : "");
    }

    void rotateXYBy(int n, int n2) {
        this.transformManager.rotateXYBy(n, n2, null);
        this.refresh(2, this.syncingMouse ? "Mouse: rotateXYBy " + n + " " + n2 : "");
    }

    void rotateZBy(int n) {
        this.transformManager.rotateZBy(n);
        this.refresh(2, this.syncingMouse ? "Mouse: rotateZBy " + n : "");
    }

    void rotateMolecule(int n, int n2) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.setRotateMolecule(true);
        this.transformManager.rotateXYBy(n, n2, this.selectionManager.bsSelection);
        this.transformManager.setRotateMolecule(false);
        this.refreshMeasures();
        this.refresh(2, this.syncingMouse ? "Mouse: rotateMolecule " + n + " " + n2 : "");
    }

    void translateXYBy(int n, int n2) {
        this.transformManager.translateXYBy(n, n2);
        this.refresh(2, this.syncingMouse ? "Mouse: translateXYBy " + n + " " + n2 : "");
    }

    public void rotateFront() {
        this.transformManager.rotateFront();
        this.refresh(1, "Viewer:rotateFront()");
    }

    public void rotateX(float f) {
        this.transformManager.rotateX(f);
        this.refresh(1, "Viewer:rotateX()");
    }

    public void rotateY(float f) {
        this.transformManager.rotateY(f);
        this.refresh(1, "Viewer:rotateY()");
    }

    public void rotateZ(float f) {
        this.transformManager.rotateZ(f);
        this.refresh(1, "Viewer:rotateZ()");
    }

    public void rotateX(int n) {
        this.rotateX((float)n * ((float)Math.PI / 180));
    }

    public void rotateY(int n) {
        this.rotateY((float)n * ((float)Math.PI / 180));
    }

    void translateToXPercent(float f) {
        this.transformManager.translateToXPercent(f);
        this.refresh(1, "Viewer:translateToXPercent()");
    }

    void translateToYPercent(float f) {
        this.transformManager.translateToYPercent(f);
        this.refresh(1, "Viewer:translateToYPercent()");
    }

    void translateToZPercent(float f) {
        this.transformManager.translateToZPercent(f);
        this.refresh(1, "Viewer:translateToZPercent()");
    }

    float getTranslationXPercent() {
        return this.transformManager.getTranslationXPercent();
    }

    float getTranslationYPercent() {
        return this.transformManager.getTranslationYPercent();
    }

    float getTranslationZPercent() {
        return this.transformManager.getTranslationZPercent();
    }

    String getTranslationScript() {
        return this.transformManager.getTranslationScript();
    }

    public int getZoomPercent() {
        return (int)this.getZoomSetting();
    }

    float getZoomSetting() {
        return this.transformManager.getZoomSetting();
    }

    public float getZoomPercentFloat() {
        return this.transformManager.getZoomPercentFloat();
    }

    float getMaxZoomPercent() {
        return 200000.0f;
    }

    private void setZoomEnabled(boolean bl) {
        this.transformManager.setZoomEnabled(bl);
        this.refresh(1, "Viewer:setZoomEnabled()");
    }

    void slabReset() {
        this.transformManager.slabReset();
    }

    boolean getZoomEnabled() {
        return this.transformManager.zoomEnabled;
    }

    public boolean getSlabEnabled() {
        return this.transformManager.slabEnabled;
    }

    void slabByPixels(int n) {
        this.transformManager.slabByPercentagePoints(n);
        this.refresh(0, "Viewer:slabByPixels()");
    }

    void depthByPixels(int n) {
        this.transformManager.depthByPercentagePoints(n);
        this.refresh(0, "Viewer:depthByPixels()");
    }

    void slabDepthByPixels(int n) {
        this.transformManager.slabDepthByPercentagePoints(n);
        this.refresh(0, "Viewer:slabDepthByPixels()");
    }

    void slabToPercent(int n) {
        this.transformManager.slabToPercent(n);
        this.refresh(0, "Viewer:slabToPercent()");
    }

    void slabInternal(Point4f point4f, boolean bl) {
        this.transformManager.slabInternal(point4f, bl);
    }

    void depthToPercent(int n) {
        this.transformManager.depthToPercent(n);
        this.refresh(0, "Viewer:depthToPercent()");
    }

    private void setSlabEnabled(boolean bl) {
        this.transformManager.setSlabEnabled(bl);
        this.refresh(0, "Viewer:setSlabEnabled()");
    }

    void setSlabDepthInternal(boolean bl) {
        this.transformManager.setSlabDepthInternal(bl);
    }

    public Matrix4f getUnscaledTransformMatrix() {
        return this.transformManager.getUnscaledTransformMatrix();
    }

    void finalizeTransformParameters() {
        this.transformManager.finalizeTransformParameters();
        this.g3d.setSlabAndDepthValues(this.transformManager.slabValue, this.transformManager.depthValue, this.global.zShade);
    }

    public void rotatePoint(Point3f point3f, Point3f point3f2) {
        this.transformManager.rotatePoint(point3f, point3f2);
    }

    public Point3i transformPoint(Point3f point3f) {
        return this.transformManager.transformPoint(point3f);
    }

    public Point3i transformPoint(Point3f point3f, Vector3f vector3f) {
        return this.transformManager.transformPoint(point3f, vector3f);
    }

    public void transformPoint(Point3f point3f, Point3i point3i) {
        this.transformManager.transformPoint(point3f, point3i);
    }

    public void transformPointNoClip(Point3f point3f, Point3f point3f2) {
        this.transformManager.transformPointNoClip(point3f, point3f2);
    }

    public void transformPoint(Point3f point3f, Point3f point3f2) {
        this.transformManager.transformPoint(point3f, point3f2);
    }

    public void transformPoints(Point3f[] point3fArray, Point3i[] point3iArray) {
        this.transformManager.transformPoints(point3fArray.length, point3fArray, point3iArray);
    }

    public void transformVector(Vector3f vector3f, Vector3f vector3f2) {
        this.transformManager.transformVector(vector3f, vector3f2);
    }

    public void unTransformPoint(Point3f point3f, Point3f point3f2) {
        this.transformManager.unTransformPoint(point3f, point3f2);
    }

    public float getScalePixelsPerAngstrom() {
        return this.transformManager.scalePixelsPerAngstrom;
    }

    public short scaleToScreen(int n, int n2) {
        return this.transformManager.scaleToScreen(n, n2);
    }

    public float scaleToPerspective(int n, float f) {
        return this.transformManager.scaleToPerspective(n, f);
    }

    private void setScaleAngstromsPerInch(float f) {
        this.transformManager.setScaleAngstromsPerInch(f);
    }

    void setSpin(String string, int n) {
        if (!Parser.isOneOf(string, "x;y;z;fps")) {
            return;
        }
        switch ("x;y;z;fps".indexOf(string)) {
            case 0: {
                this.transformManager.setSpinX(n);
                break;
            }
            case 2: {
                this.transformManager.setSpinY(n);
                break;
            }
            case 4: {
                this.transformManager.setSpinZ(n);
                break;
            }
            default: {
                this.transformManager.setSpinFps(n);
            }
        }
        this.global.setParameterValue("spin" + string, n);
    }

    String getSpinState() {
        return this.transformManager.getSpinState(false);
    }

    float getSpinX() {
        return this.transformManager.spinX;
    }

    float getSpinY() {
        return this.transformManager.spinY;
    }

    float getSpinZ() {
        return this.transformManager.spinZ;
    }

    float getSpinFps() {
        return this.transformManager.spinFps;
    }

    void setSpinOn(boolean bl) {
        this.transformManager.setSpinOn(bl);
    }

    boolean getSpinOn() {
        return this.transformManager.getSpinOn();
    }

    String getOrientationText(int n) {
        return this.transformManager.getOrientationText(n);
    }

    Hashtable getOrientationInfo() {
        return this.transformManager.getOrientationInfo();
    }

    Matrix3f getMatrixRotate() {
        return this.transformManager.getMatrixRotate();
    }

    void getAxisAngle(AxisAngle4f axisAngle4f) {
        this.transformManager.getAxisAngle(axisAngle4f);
    }

    String getTransformText() {
        return this.transformManager.getTransformText();
    }

    void getRotation(Matrix3f matrix3f) {
        this.transformManager.getRotation(matrix3f);
    }

    private void setDefaultColors(String string) {
        this.colorManager.setDefaultColors(string);
        this.global.setParameterValue("colorRasmol", string.equals("rasmol"));
    }

    private void setDefaultTranslucent(float f) {
        this.global.defaultTranslucent = f;
    }

    float getDefaultTranslucent() {
        return this.global.defaultTranslucent;
    }

    public int getColixArgb(short s) {
        return this.g3d.getColixArgb(s);
    }

    void setRubberbandArgb(int n) {
        this.colorManager.setRubberbandArgb(n);
    }

    public short getColixRubberband() {
        return this.colorManager.colixRubberband;
    }

    void setElementArgb(int n, int n2) {
        this.global.setParameterValue("=color " + JmolConstants.elementNameFromNumber(n), Escape.escapeColor(n2));
        this.colorManager.setElementArgb(n, n2);
    }

    public float getVectorScale() {
        return this.global.vectorScale;
    }

    public void setVectorScale(float f) {
        this.global.setParameterValue("vectorScale", f);
        this.global.vectorScale = f;
        this.refresh(0, "set vectorScale");
    }

    public float getDefaultDrawArrowScale() {
        return this.global.defaultDrawArrowScale;
    }

    public void setDefaultDrawArrowScale(float f) {
        this.global.setParameterValue("defaultDrawArrowScale", f);
        this.global.defaultDrawArrowScale = f;
        this.refresh(0, "set defaultDrawArrowScale");
    }

    float getVibrationScale() {
        return this.global.vibrationScale;
    }

    float getVibrationPeriod() {
        return this.global.vibrationPeriod;
    }

    public void setVibrationScale(float f) {
        this.transformManager.setVibrationScale(f);
        this.global.vibrationScale = f;
        this.global.setParameterValue("vibrationScale", f);
    }

    void setVibrationOff() {
        this.transformManager.setVibrationPeriod(0.0f);
    }

    public void setVibrationPeriod(float f) {
        this.transformManager.setVibrationPeriod(f);
        this.global.vibrationPeriod = f = Math.abs(f);
        this.global.setParameterValue("vibrationPeriod", f);
    }

    void setObjectColor(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        this.setObjectArgb(string, Graphics3D.getArgbFromString(string2));
    }

    void setObjectArgb(String string, int n) {
        int n2 = StateManager.getObjectIdFromName(string);
        if (n2 < 0) {
            return;
        }
        this.global.objColors[n2] = n;
        switch (n2) {
            case 0: {
                this.g3d.setBackgroundArgb(n);
                this.colorManager.setColixBackgroundContrast(n);
            }
        }
        this.global.setParameterValue(string + "Color", Escape.escapeColor(n));
    }

    int getObjectArgb(int n) {
        return this.global.objColors[n];
    }

    public short getObjectColix(int n) {
        int n2 = this.getObjectArgb(n);
        if (n2 == 0) {
            return this.getColixBackgroundContrast();
        }
        return Graphics3D.getColix(n2);
    }

    public String getObjectState(String string) {
        int n = StateManager.getObjectIdFromName(string.equalsIgnoreCase("axes") ? "axis" : string);
        if (n < 0) {
            return "";
        }
        int n2 = this.getObjectMad(n);
        StringBuffer stringBuffer = new StringBuffer("\n");
        Shape.appendCmd(stringBuffer, string + (n2 == 0 ? " off" : (n2 == 1 ? " on" : (n2 == -1 ? " dotted" : (n2 < 20 ? " " + n2 : " " + (float)n2 / 2000.0f)))));
        return stringBuffer.toString();
    }

    public void setColorBackground(String string) {
        this.setObjectColor("background", string);
    }

    public int getBackgroundArgb() {
        return this.getObjectArgb(0);
    }

    void setObjectMad(int n, String string, int n2) {
        int n3 = StateManager.getObjectIdFromName(string.equalsIgnoreCase("axes") ? "axis" : string);
        if (n3 < 0) {
            return;
        }
        if (n2 == -2 || n2 == -4) {
            int n4 = n2 + 3;
            n2 = this.getObjectMad(n3);
            if (n2 == 0) {
                n2 = n4;
            }
        }
        this.global.setParameterValue("show" + string, n2 != 0);
        boolean bl = this.global.objStateOn[n3] = n2 != 0;
        if (n2 == 0) {
            return;
        }
        this.global.objMad[n3] = n2;
        this.setShapeSize(n, n2);
    }

    public int getObjectMad(int n) {
        return this.global.objStateOn[n] ? this.global.objMad[n] : 0;
    }

    public void setPropertyColorScheme(String string, boolean bl) {
        this.global.propertyColorScheme = string;
        this.colorManager.setColorScheme(string, bl);
    }

    public String getPropertyColorScheme() {
        return this.global.propertyColorScheme;
    }

    public short getColixBackgroundContrast() {
        return this.colorManager.colixBackgroundContrast;
    }

    String getSpecularState() {
        return this.global.getSpecularState();
    }

    private static void setSpecular(boolean bl) {
        ColorManager.setSpecular(bl);
    }

    boolean getSpecular() {
        return ColorManager.getSpecular();
    }

    private static void setSpecularPower(int n) {
        ColorManager.setSpecularPower(Math.abs(n));
    }

    private static void setSpecularExponent(int n) {
        ColorManager.setSpecularPower(-Math.abs(n));
    }

    private static void setAmbientPercent(int n) {
        ColorManager.setAmbientPercent(n);
    }

    static int getAmbientPercent() {
        return ColorManager.getAmbientPercent();
    }

    private static void setDiffusePercent(int n) {
        ColorManager.setDiffusePercent(n);
    }

    static int getDiffusePercent() {
        return ColorManager.getDiffusePercent();
    }

    private static void setSpecularPercent(int n) {
        ColorManager.setSpecularPercent(n);
    }

    static int getSpecularPercent() {
        return ColorManager.getSpecularPercent();
    }

    private void setZShade(boolean bl) {
        this.global.zShade = bl;
    }

    boolean getZShade() {
        return this.global.zShade;
    }

    public short getColixAtomPalette(Atom atom, byte by) {
        return this.colorManager.getColixAtomPalette(atom, by);
    }

    public int[] getColorSchemeArray(String string) {
        return this.colorManager.getColorSchemeArray(string);
    }

    public String getColorSchemeList(String string, boolean bl) {
        return this.colorManager.getColorSchemeList(string, bl);
    }

    public static void setUserScale(int[] nArray) {
        ColorManager.setUserScale(nArray);
    }

    public short getColixForPropertyValue(float f) {
        return this.colorManager.getColixForPropertyValue(f);
    }

    Point3f getColorPointForPropertyValue(float f) {
        short s = this.colorManager.getColixForPropertyValue(f);
        Point3f point3f = new Point3f();
        return Graphics3D.colorPointFromInt(this.g3d.getColixArgb(s), point3f);
    }

    void select(BitSet bitSet, boolean bl) {
        this.selectionManager.select(bitSet, bl);
        this.modelSet.setShapeSize(1, Integer.MAX_VALUE, null);
    }

    void selectBonds(BitSet bitSet) {
        this.modelSet.setShapeSize(1, Integer.MAX_VALUE, bitSet);
    }

    void hide(BitSet bitSet, boolean bl) {
        this.selectionManager.hide(bitSet, bl);
    }

    void display(BitSet bitSet, BitSet bitSet2, boolean bl) {
        this.selectionManager.display(bitSet, bitSet2, bl);
    }

    BitSet getHiddenSet() {
        return this.selectionManager.getHiddenSet();
    }

    public boolean isSelected(int n) {
        return this.selectionManager.isSelected(n);
    }

    boolean isInSelectionSubset(int n) {
        return this.selectionManager.isInSelectionSubset(n);
    }

    void reportSelection(String string) {
        if (this.modelSet.getSelectionHaloEnabled()) {
            this.setTainted(true);
        }
        if (this.isScriptQueued) {
            this.scriptStatus(string);
        }
    }

    public Point3f getAtomSetCenter(BitSet bitSet) {
        return this.modelSet.getAtomSetCenter(bitSet);
    }

    public void selectAll() {
        this.selectionManager.selectAll(false);
        this.refresh(0, "Viewer:selectAll()");
    }

    void setNoneSelected(boolean bl) {
        this.noneSelected = bl;
    }

    Boolean getNoneSelected() {
        return this.noneSelected ? Boolean.TRUE : Boolean.FALSE;
    }

    public void clearSelection() {
        this.selectionManager.clearSelection(false);
        this.global.setParameterValue("hideNotSelected", false);
        this.refresh(0, "Viewer:clearSelection()");
    }

    public void setSelectionSet(BitSet bitSet) {
        this.selectionManager.setSelectionSet(bitSet);
        this.refresh(0, "Viewer:setSelectionSet()");
    }

    void setSelectionSubset(BitSet bitSet) {
        this.selectionManager.setSelectionSubset(bitSet);
    }

    public BitSet getSelectionSubset() {
        return this.selectionManager.bsSubset;
    }

    private void setHideNotSelected(boolean bl) {
        this.selectionManager.setHideNotSelected(bl);
    }

    void invertSelection() {
        this.selectionManager.invertSelection();
    }

    public BitSet getSelectionSet() {
        return this.selectionManager.bsSelection;
    }

    public int getSelectionCount() {
        return this.selectionManager.getSelectionCount();
    }

    void setFormalCharges(int n) {
        this.modelSet.setFormalCharges(this.selectionManager.bsSelection, n);
    }

    public void addSelectionListener(JmolSelectionListener jmolSelectionListener) {
        this.selectionManager.addListener(jmolSelectionListener);
    }

    public void removeSelectionListener(JmolSelectionListener jmolSelectionListener) {
        this.selectionManager.addListener(jmolSelectionListener);
    }

    BitSet getAtomBitSet(Object object) {
        return Eval.getAtomBitSet(this.eval, this, object);
    }

    Vector getAtomBitSetVector(Object object) {
        return Eval.getAtomBitSetVector(this.eval, this, object);
    }

    public void setModeMouse(int n) {
        this.mouseManager.setModeMouse(n);
        if (n == -1) {
            this.clearScriptQueue();
            this.haltScriptExecution();
            this.transformManager.setSpinOn(false);
            this.transformManager.setVibrationPeriod(0.0f);
            this.scriptManager.startCommandWatcher(false);
            this.scriptManager.interruptQueueThreads();
            this.g3d.destroy();
        }
    }

    Rectangle getRubberBandSelection() {
        return this.mouseManager.getRubberBand();
    }

    public int getCursorX() {
        return this.mouseManager.xCurrent;
    }

    public int getCursorY() {
        return this.mouseManager.yCurrent;
    }

    private void setAppletProxy(String string) {
        this.fileManager.setAppletProxy(string);
    }

    private void setDefaultDirectory(String string) {
        this.global.defaultDirectory = string == null ? "" : string.replace('\\', '/');
    }

    String getDefaultDirectory() {
        return this.global.defaultDirectory;
    }

    Object getBufferedReaderOrErrorMessageFromName(String string, String[] stringArray, boolean bl) {
        return this.fileManager.getBufferedReaderOrErrorMessageFromName(string, stringArray, bl);
    }

    Object getBufferedReaderForString(String string) {
        return this.fileManager.getBufferedReaderForString(string);
    }

    void addLoadScript(String string) {
        this.fileManager.addLoadScript(string);
    }

    public void openFile(String string) {
        string = string.replace('\\', '/');
        String string2 = this.fileManager.getFileTypeName(string);
        this.checkHalt("exit");
        this.evalString((string2 == null ? "script " : "load ") + Escape.escape(string));
    }

    void openFile(String string, Hashtable hashtable, String string2, boolean bl) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("string")) {
            this.openStringInline(this.fileManager.getInlineData(-1), hashtable, bl);
            return;
        }
        if (string.equalsIgnoreCase("string[]")) {
            return;
        }
        if (!bl) {
            this.zap(false, false);
        }
        Logger.startTimer();
        this.fileManager.openFile(string, hashtable, string2, bl);
        Logger.checkTimer("openFile(" + string + ")");
        this.setStatusFileLoaded(1, string, "", this.getModelSetName(), null);
    }

    public void openFiles(String string, String[] stringArray) {
        this.openFiles(string, stringArray, null, false);
    }

    void openFiles(String string, String[] stringArray, String string2, boolean bl) {
        if (!bl) {
            this.zap(false, false);
        }
        long l = System.currentTimeMillis();
        this.fileManager.openFiles(string, stringArray, string2, bl);
        long l2 = System.currentTimeMillis() - l;
        for (int i = 0; i < stringArray.length; ++i) {
            this.setStatusFileLoaded(1, stringArray[i], "", this.getModelSetName(), null);
        }
        Logger.info("openFiles(" + stringArray.length + ") " + l2 + " ms");
    }

    public void openStringInline(String string) {
        this.openStringInline(string, null, false);
    }

    private boolean openStringInline(String string, Hashtable hashtable, boolean bl) {
        if (!bl) {
            this.clear();
        }
        this.fileManager.openStringInline(string, hashtable, bl);
        String string2 = this.getOpenFileError(bl);
        if (string2 == null) {
            this.setStatusFileLoaded(1, "string", "", this.getModelSetName(), null);
        }
        return string2 == null;
    }

    private void openStringsInline(String[] stringArray, Hashtable hashtable, boolean bl) {
        if (!bl) {
            this.clear();
        }
        this.fileManager.openStringsInline(stringArray, hashtable, bl);
        String string = this.getOpenFileError(bl);
        if (string == null) {
            this.setStatusFileLoaded(1, "string[]", "", this.getModelSetName(), null);
        }
    }

    public char getInlineChar() {
        return this.global.inlineNewlineChar;
    }

    public void loadInline(String string) {
        this.loadInline(string, this.global.inlineNewlineChar);
    }

    public void loadInline(String string, boolean bl) {
        this.loadInline(string, '\u0000', bl);
    }

    public void loadInline(String string, char c) {
        this.loadInline(string, c, false);
    }

    boolean loadInline(String string, char c, boolean bl) {
        String string2;
        int n;
        if (string == null) {
            return false;
        }
        int[] nArray = this.global.getDefaultLatticeArray();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("params", nArray);
        if (this.global.applySymmetryToBonds) {
            hashtable.put("applySymmetryToBonds", Boolean.TRUE);
        }
        Logger.debug(string);
        if (c != '\u0000' && c != '\n') {
            int n2 = string.length();
            for (n = 0; n < n2 && string.charAt(n) == ' '; ++n) {
            }
            if (n < n2 && string.charAt(n) == c) {
                string = string.substring(n + 1);
            }
            string = TextFormat.simpleReplace(string, "" + c, "\n");
        }
        if ((string2 = this.getDataSeparator()) != null && string2 != "" && (n = string.indexOf(string2)) >= 0) {
            int n3 = 2;
            while ((n = string.indexOf(string2, n + 1)) >= 0) {
                ++n3;
            }
            String[] stringArray = new String[n3];
            int n4 = 0;
            int n5 = 0;
            for (n = 0; n < n3; ++n) {
                n4 = string.indexOf(string2, n5);
                if (n4 < 0) {
                    n4 = string.length();
                }
                stringArray[n] = string.substring(n5, n4);
                n5 = n4 + string2.length();
            }
            this.openStringsInline(stringArray, hashtable, bl);
            return true;
        }
        return this.openStringInline(string, hashtable, bl);
    }

    String getDataSeparator() {
        return (String)this.global.getParameter("dataseparator");
    }

    public void loadInline(String[] stringArray) {
        this.loadInline(stringArray, false);
    }

    public void loadInline(String[] stringArray, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int[] nArray = this.global.getDefaultLatticeArray();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("params", nArray);
        if (this.global.applySymmetryToBonds) {
            hashtable.put("applySymmetryToBonds", Boolean.TRUE);
        }
        this.openStringsInline(stringArray, hashtable, bl);
    }

    public boolean getApplySymmetryToBonds() {
        return this.global.applySymmetryToBonds;
    }

    void setApplySymmetryToBonds(boolean bl) {
        this.global.applySymmetryToBonds = bl;
    }

    void loadData(int n, String string, String string2) {
        this.modelSet.loadData(n, string, string2);
    }

    public void openDOM(Object object) {
        this.clear();
        long l = System.currentTimeMillis();
        this.fileManager.openDOM(object);
        long l2 = System.currentTimeMillis() - l;
        Logger.info("openDOM " + l2 + " ms");
        this.setStatusFileLoaded(1, "JSNode", "", this.getModelSetName(), this.getOpenFileError());
    }

    public void openReader(String string, String string2, Reader reader) {
        this.clear();
        this.fileManager.openReader(string, string2, reader);
        this.getOpenFileError();
        System.gc();
    }

    public String getOpenFileError() {
        return this.getOpenFileError(false);
    }

    String getOpenFileError(boolean bl) {
        String string = this.getFullPathName();
        String string2 = this.getFileName();
        Object object = this.fileManager.waitForClientFileOrErrorMessage();
        if (object instanceof String || object == null) {
            String string3 = (String)object;
            this.setStatusFileNotLoaded(string, string3);
            if (string3 != null && !bl) {
                this.zap(string3);
            }
            return string3;
        }
        if (bl) {
            this.modelSet = this.modelManager.merge(this.modelAdapter, object);
            if (this.eval != null) {
                this.eval.clearDefinitionsAndLoadPredefined();
            }
            this.selectAll();
            this.setTainted(true);
        } else {
            this.openClientFile(string, string2, object);
        }
        object = null;
        System.gc();
        return null;
    }

    public void openClientFile(String string, String string2, Object object) {
        this.setStatusFileLoaded(2, string, string2, null, null);
        this.pushHoldRepaint();
        this.modelSet = this.modelManager.setClientFile(string, string2, this.modelAdapter, object);
        this.initializeModel();
        this.popHoldRepaint();
        this.setStatusFileLoaded(3, string, string2, this.getModelSetName(), null);
    }

    public Object getCurrentFileAsBytes() {
        String string = this.getFullPathName();
        if (string == "string" || string == "string[]" || string == "JSNode") {
            return this.getCurrentFileAsString();
        }
        String string2 = this.modelManager.getModelSetPathName();
        if (string2 == null) {
            return "";
        }
        return this.fileManager.getFileAsBytes(string2);
    }

    public String getCurrentFileAsString() {
        String string = this.getFullPathName();
        if (string == "string") {
            return this.fileManager.getInlineData(-1);
        }
        if (string == "string[]") {
            int n = this.getDisplayModelIndex();
            if (n < 0) {
                return "";
            }
            return this.fileManager.getInlineData(n);
        }
        if (string == "JSNode") {
            return "<DOM NODE>";
        }
        String string2 = this.modelManager.getModelSetPathName();
        if (string2 == null) {
            return null;
        }
        return this.fileManager.getFileAsString(string2);
    }

    public String getFileAsString(String string) {
        return string == null ? this.getCurrentFileAsString() : this.fileManager.getFileAsString(string);
    }

    public String getFullPathName() {
        return this.fileManager.getFullPathName();
    }

    public String getFileName() {
        return this.fileManager.getFileName();
    }

    String[] getFileInfo() {
        return this.fileManager.getFileInfo();
    }

    void setFileInfo(String[] stringArray) {
        this.fileManager.setFileInfo(stringArray);
    }

    public void calculateStraightness() {
        this.modelSet.calculateStraightness();
    }

    public Point3f[] calculateSurface(BitSet bitSet, float f) {
        if (bitSet == null) {
            bitSet = this.selectionManager.bsSelection;
        }
        this.addStateScript("calculate surfaceDistance " + (f == Float.MAX_VALUE ? "FROM" : "WITHIN"), null, bitSet, null, "", false, true);
        return this.modelSet.calculateSurface(bitSet, f);
    }

    public AtomIndexIterator getWithinModelIterator(Atom atom, float f) {
        return this.modelSet.getWithinModelIterator(atom, f);
    }

    public AtomIndexIterator getWithinAtomSetIterator(int n, float f, BitSet bitSet, boolean bl, boolean bl2) {
        return this.modelSet.getWithinAtomSetIterator(n, f, bitSet, bl, bl2);
    }

    public void fillAtomData(AtomData atomData, int n) {
        atomData.programInfo = "Jmol Version " + Viewer.getJmolVersion();
        atomData.fileName = this.getFileName();
        this.modelSet.fillAtomData(atomData, n);
    }

    void addStateScript(String string, boolean bl, boolean bl2) {
        this.addStateScript(string, null, null, null, null, bl, bl2);
    }

    void addStateScript(String string, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, String string2, boolean bl, boolean bl2) {
        this.modelSet.addStateScript(string, bitSet, bitSet2, bitSet3, string2, bl, bl2);
    }

    public boolean getEchoStateActive() {
        return this.modelSet.getEchoStateActive();
    }

    void setEchoStateActive(boolean bl) {
        this.modelSet.setEchoStateActive(bl);
    }

    public void zap(boolean bl, boolean bl2) {
        this.clear();
        this.modelSet = this.modelManager.zap();
        this.initializeModel();
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long l = runtime.totalMemory();
        long l2 = runtime.freeMemory();
        long l3 = 0L;
        try {
            l3 = runtime.maxMemory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.debug("ZAP memory inuse, total, free, max: " + (l - l2) + " " + l + " " + l2 + " " + l3);
        if (bl) {
            this.setStatusFileLoaded(0, null, bl2 ? "resetUndo" : null, null, null);
        }
    }

    private void zap(String string) {
        this.zap(true, false);
        this.echoMessage(string);
    }

    void echoMessage(String string) {
        int n = 29;
        this.loadShape(n);
        this.setShapeProperty(n, "font", this.getFont3D("SansSerif", "Plain", 9.0f));
        this.setShapeProperty(n, "target", "error");
        this.setShapeProperty(n, "text", string);
    }

    private void clear() {
        if (this.modelSet == null) {
            return;
        }
        this.clearMinimization();
        this.fileManager.clear();
        this.repaintManager.clear();
        this.transformManager.clear();
        this.pickingManager.clear();
        this.selectionManager.clear();
        this.clearAllMeasurements();
        this.modelSet = this.modelManager.clear();
        this.mouseManager.clear();
        this.statusManager.clear();
        this.stateManager.clear();
        this.global.clear();
        this.tempManager.clear();
        this.colorManager.clear();
        this.evalVariables.clear();
        this.refresh(0, "Viewer:clear()");
        this.dataManager.clear();
        System.gc();
    }

    private void clearMinimization() {
        if (this.minimizer == null) {
            return;
        }
        this.minimizer.setProperty("clear", null);
        this.minimizer = null;
    }

    public void notifyMinimizationStatus() {
        String string = this.statusManager.getCallbackScript("minimizationcallback");
        if (string != null) {
            this.evalStringQuiet(string, true, false);
        } else {
            this.statusManager.notifyMinimizationStatus();
        }
    }

    public String getMinimizationInfo() {
        return this.minimizer == null ? "" : (String)this.minimizer.getProperty("log", 0);
    }

    public boolean useMinimizationThread() {
        return !this.autoExit;
    }

    private void initializeModel() {
        this.reset();
        this.selectAll();
        this.noneSelected = false;
        this.transformManager.setCenter();
        if (this.eval != null) {
            this.eval.clearDefinitionsAndLoadPredefined();
        }
        this.repaintManager.initializePointers(1);
        this.setCurrentModelIndex(0);
        this.setBackgroundModelIndex(-1);
        this.setFrankOn(this.getShowFrank());
        this.mouseManager.startHoverWatcher(true);
        this.setTainted(true);
        this.finalizeTransformParameters();
    }

    public String getModelSetName() {
        if (this.modelSet == null) {
            return null;
        }
        return this.modelSet.getModelSetName();
    }

    public String getModelSetFileName() {
        return this.modelManager.getModelSetFileName();
    }

    public String getUnitCellInfoText() {
        return this.modelSet.getUnitCellInfoText();
    }

    public String getSpaceGroupInfoText(String string) {
        return this.modelSet.getSpaceGroupInfoText(string);
    }

    void getPolymerPointsAndVectors(BitSet bitSet, Vector vector) {
        this.modelSet.getPolymerPointsAndVectors(bitSet, vector);
    }

    public String getModelSetProperty(String string) {
        return this.modelSet.getModelSetProperty(string);
    }

    public Object getModelSetAuxiliaryInfo(String string) {
        return this.modelSet.getModelSetAuxiliaryInfo(string);
    }

    public String getModelSetPathName() {
        return this.modelManager.getModelSetPathName();
    }

    public String getModelSetTypeName() {
        return this.modelSet.getModelSetTypeName();
    }

    public boolean haveFrame() {
        return this.haveModelSet();
    }

    boolean haveModelSet() {
        return this.modelSet != null;
    }

    int getSurfaceDistanceMax() {
        return this.modelSet.getSurfaceDistanceMax();
    }

    void calculateStructures(BitSet bitSet) {
        this.modelSet.calculateStructures(bitSet);
    }

    void clearBfactorRange() {
        this.modelSet.clearBfactorRange();
    }

    public String getHybridizationAndAxes(int n, Vector3f vector3f, Vector3f vector3f2, String string, boolean bl) {
        return this.modelSet.getHybridizationAndAxes(n, vector3f, vector3f2, string, bl);
    }

    public BitSet getModelAtomBitSet(int n, boolean bl) {
        return this.modelSet.getModelAtomBitSet(n, bl);
    }

    public BitSet getModelBitSet(BitSet bitSet) {
        return this.modelSet.getModelBitSet(bitSet);
    }

    Object getClientFile() {
        return null;
    }

    public String getClientAtomStringProperty(Object object, String string) {
        if (this.modelAdapter == null || string == null || string.length() == 0) {
            return null;
        }
        return this.modelAdapter.getClientAtomStringProperty(object, string);
    }

    JmolAdapter getExportJmolAdapter() {
        return null;
    }

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    public String getBoundBoxCommand(boolean bl) {
        return this.modelSet.getBoundBoxCommand(bl);
    }

    void setBoundBox(Point3f point3f, Point3f point3f2, boolean bl) {
        this.modelSet.setBoundBox(point3f, point3f2, bl);
    }

    public Point3f getBoundBoxCenter() {
        return this.modelSet.getBoundBoxCenter(this.repaintManager.currentModelIndex);
    }

    Point3f getAverageAtomPoint() {
        return this.modelSet.getAverageAtomPoint();
    }

    void calcBoundBoxDimensions(BitSet bitSet) {
        this.modelSet.calcBoundBoxDimensions(bitSet);
        this.axesAreTainted = true;
        this.refresh(0, "set calcBoundBoxDimensions");
    }

    BoxInfo getBoxInfo(BitSet bitSet) {
        return this.modelSet.getBoxInfo(bitSet);
    }

    float calcRotationRadius(Point3f point3f) {
        return this.modelSet.calcRotationRadius(this.repaintManager.currentModelIndex, point3f);
    }

    public float calcRotationRadius(BitSet bitSet) {
        return this.modelSet.calcRotationRadius(bitSet);
    }

    public Vector3f getBoundBoxCornerVector() {
        return this.modelSet.getBoundBoxCornerVector();
    }

    Hashtable getBoundBoxInfo() {
        return this.modelSet.getBoundBoxInfo();
    }

    public BitSet getBoundBoxModels() {
        return this.modelSet.getBoundBoxModels();
    }

    public int getBoundBoxCenterX() {
        return this.dimScreen.width / 2;
    }

    public int getBoundBoxCenterY() {
        return this.dimScreen.height / 2;
    }

    public int getModelCount() {
        return this.modelSet.getModelCount();
    }

    String getModelInfoAsString() {
        return this.modelSet.getModelInfoAsString();
    }

    String getSymmetryInfoAsString() {
        return this.modelSet.getSymmetryInfoAsString();
    }

    public Properties getModelSetProperties() {
        return this.modelSet.getModelSetProperties();
    }

    public Hashtable getModelSetAuxiliaryInfo() {
        return this.modelSet.getModelSetAuxiliaryInfo();
    }

    public int getModelNumber(int n) {
        if (n < 0) {
            return n;
        }
        return this.modelSet.getModelNumber(n);
    }

    public int getModelFileNumber(int n) {
        if (n < 0) {
            return 0;
        }
        return this.modelSet.getModelFileNumber(n);
    }

    public String getModelNumberDotted(int n) {
        return n < 0 ? "0" : (this.modelSet == null ? null : this.modelSet.getModelNumberDotted(n));
    }

    public String getModelName(int n) {
        return this.modelSet == null ? null : this.modelSet.getModelName(n);
    }

    public Properties getModelProperties(int n) {
        return this.modelSet.getModelProperties(n);
    }

    public String getModelProperty(int n, String string) {
        return this.modelSet.getModelProperty(n, string);
    }

    public String getModelFileInfo() {
        return this.modelSet.getModelFileInfo(this.getVisibleFramesBitSet());
    }

    String getModelFileInfoAll() {
        return this.modelSet.getModelFileInfo(null);
    }

    public Hashtable getModelAuxiliaryInfo(int n) {
        return this.modelSet.getModelAuxiliaryInfo(n);
    }

    public Object getModelAuxiliaryInfo(int n, String string) {
        return this.modelSet.getModelAuxiliaryInfo(n, string);
    }

    int getModelNumberIndex(int n, boolean bl, boolean bl2) {
        return this.modelSet.getModelNumberIndex(n, bl, bl2);
    }

    boolean modelSetHasVibrationVectors() {
        return this.modelSet.modelSetHasVibrationVectors();
    }

    public boolean modelHasVibrationVectors(int n) {
        return this.modelSetHasVibrationVectors() && this.modelSet.modelHasVibrationVectors(n);
    }

    public int getChainCount() {
        return this.modelSet.getChainCount(true);
    }

    public int getChainCountInModel(int n) {
        return this.modelSet.getChainCountInModel(n, false);
    }

    public int getChainCountInModel(int n, boolean bl) {
        return this.modelSet.getChainCountInModel(n, bl);
    }

    public int getGroupCount() {
        return this.modelSet.getGroupCount();
    }

    public int getGroupCountInModel(int n) {
        return this.modelSet.getGroupCountInModel(n);
    }

    public int getPolymerCount() {
        return this.modelSet.getBioPolymerCount();
    }

    public int getPolymerCountInModel(int n) {
        return this.modelSet.getBioPolymerCountInModel(n);
    }

    public int getAtomCount() {
        return this.modelSet.getAtomCount();
    }

    public int getAtomCountInModel(int n) {
        return this.modelSet.getAtomCountInModel(n);
    }

    public int getBondCount() {
        return this.modelSet.getBondCount();
    }

    public int getBondCountInModel(int n) {
        return this.modelSet.getBondCountInModel(n);
    }

    BitSet getBondsForSelectedAtoms(BitSet bitSet) {
        return this.modelSet.getBondsForSelectedAtoms(bitSet);
    }

    boolean frankClicked(int n, int n2) {
        return this.frankOn && this.modelSet.frankClicked(n, n2);
    }

    int findNearestAtomIndex(int n, int n2) {
        return this.modelSet == null ? -1 : this.modelSet.findNearestAtomIndex(n, n2);
    }

    BitSet findAtomsInRectangle(Rectangle rectangle) {
        return this.modelSet.findAtomsInRectangle(rectangle);
    }

    void selectRectangle(Rectangle rectangle, int n) {
        BitSet bitSet = this.findAtomsInRectangle(rectangle);
        if (BitSetUtil.firstSetBit(bitSet) < 0) {
            return;
        }
        this.pickingManager.atomsPicked(bitSet, n);
    }

    void toCartesian(Point3f point3f) {
        int n = this.repaintManager.currentModelIndex;
        if (n < 0) {
            return;
        }
        this.modelSet.toCartesian(n, point3f);
    }

    void toUnitCell(Point3f point3f, Point3f point3f2) {
        int n = this.repaintManager.currentModelIndex;
        if (n < 0) {
            return;
        }
        this.modelSet.toUnitCell(n, point3f, point3f2);
    }

    void toFractional(Point3f point3f) {
        int n = this.repaintManager.currentModelIndex;
        if (n < 0) {
            return;
        }
        this.modelSet.toFractional(n, point3f);
    }

    public void setCenterSelected() {
        this.setCenterBitSet(this.selectionManager.bsSelection, true);
    }

    public void setBondTolerance(float f) {
        this.global.setParameterValue("bondTolerance", f);
        this.global.bondTolerance = f;
    }

    public float getBondTolerance() {
        return this.global.bondTolerance;
    }

    public void setMinBondDistance(float f) {
        this.global.setParameterValue("minBondDistance", f);
        this.global.minBondDistance = f;
    }

    public float getMinBondDistance() {
        return this.global.minBondDistance;
    }

    int[] getAtomIndices(BitSet bitSet) {
        return this.modelSet.getAtomIndices(bitSet);
    }

    public BitSet getAtomBits(int n, Object object) {
        return this.modelSet.getAtomBits(n, object);
    }

    BitSet getSequenceBits(String string, BitSet bitSet) {
        return this.modelSet.getSequenceBits(string, bitSet);
    }

    BitSet getAtomsWithin(float f, Point3f point3f) {
        return this.modelSet.getAtomsWithin(f, point3f);
    }

    BitSet getAtomsWithin(float f, Point4f point4f) {
        return this.modelSet.getAtomsWithin(f, point4f);
    }

    BitSet getAtomsWithin(float f, BitSet bitSet, boolean bl) {
        return this.modelSet.getAtomsWithin(f, bitSet, bl);
    }

    BitSet getAtomsConnected(float f, float f2, int n, BitSet bitSet) {
        return this.modelSet.getAtomsConnected(f, f2, n, bitSet);
    }

    BitSet getBranchBitSet(int n, int n2) {
        return this.modelSet.getBranchBitSet(n, n2);
    }

    int getAtomIndexFromAtomNumber(int n) {
        return this.modelSet.getAtomIndexFromAtomNumber(n);
    }

    public BitSet getElementsPresentBitSet(int n) {
        return this.modelSet.getElementsPresentBitSet(n);
    }

    public Hashtable getHeteroList(int n) {
        return this.modelSet.getHeteroList(n);
    }

    BitSet getVisibleSet() {
        return this.modelSet.getVisibleSet();
    }

    BitSet getClickableSet() {
        return this.modelSet.getClickableSet();
    }

    void calcSelectedGroupsCount() {
        this.modelSet.calcSelectedGroupsCount(this.selectionManager.bsSelection);
    }

    void calcSelectedMonomersCount() {
        this.modelSet.calcSelectedMonomersCount(this.selectionManager.bsSelection);
    }

    void calcSelectedMoleculesCount() {
        this.modelSet.calcSelectedMoleculesCount(this.selectionManager.bsSelection);
    }

    String getFileHeader() {
        return this.modelSet.getFileHeader(this.repaintManager.currentModelIndex);
    }

    String getPDBHeader() {
        return this.modelSet.getPDBHeader(this.repaintManager.currentModelIndex);
    }

    public Hashtable getModelInfo() {
        return this.modelSet.getModelInfo();
    }

    public Hashtable getAuxiliaryInfo() {
        return this.modelSet.getAuxiliaryInfo();
    }

    public Hashtable getShapeInfo() {
        return this.modelSet.getShapeInfo();
    }

    int getShapeIdFromObjectName(String string) {
        return this.modelSet.getShapeIdFromObjectName(string);
    }

    Vector getAllAtomInfo(Object object) {
        return this.modelSet.getAllAtomInfo(this.getAtomBitSet(object));
    }

    Vector getAllBondInfo(Object object) {
        return this.modelSet.getAllBondInfo(this.getAtomBitSet(object));
    }

    Vector getMoleculeInfo(Object object) {
        return this.modelSet.getMoleculeInfo(this.getAtomBitSet(object));
    }

    public String getChimeInfo(int n) {
        return this.modelSet.getChimeInfo(n, this.selectionManager.bsSelection);
    }

    public Hashtable getAllChainInfo(Object object) {
        return this.modelSet.getAllChainInfo(this.getAtomBitSet(object));
    }

    public Hashtable getAllPolymerInfo(Object object) {
        return this.modelSet.getAllPolymerInfo(this.getAtomBitSet(object));
    }

    public String getStateInfo() {
        return this.getStateInfo(null);
    }

    public String getStateInfo(String string) {
        StringBuffer stringBuffer;
        boolean bl = string == null || string.equalsIgnoreCase("all");
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = stringBuffer = bl ? new StringBuffer("function _setState();\n") : null;
        if (bl) {
            stringBuffer2.append(STATE_VERSION_STAMP + Viewer.getJmolVersion() + ";\n");
        }
        if (this.isApplet && bl) {
            StateManager.appendCmd(stringBuffer2, "# fullName = " + Escape.escape(this.fullName));
            StateManager.appendCmd(stringBuffer2, "# documentBase = " + Escape.escape(this.appletDocumentBase));
            StateManager.appendCmd(stringBuffer2, "# codeBase = " + Escape.escape(this.appletCodeBase));
            stringBuffer2.append("\n");
        }
        if (bl || string.equalsIgnoreCase("windowState")) {
            stringBuffer2.append(this.global.getWindowState(stringBuffer));
        }
        if (bl) {
            stringBuffer2.append(this.eval.getState());
        }
        if (bl || string.equalsIgnoreCase("fileState")) {
            stringBuffer2.append(this.fileManager.getState(stringBuffer));
        }
        if (bl || string.equalsIgnoreCase("definedState")) {
            stringBuffer2.append(this.modelSet.getDefinedState(stringBuffer, true));
        }
        if (bl || string.equalsIgnoreCase("variableState")) {
            stringBuffer2.append(this.global.getState(stringBuffer));
        }
        if (bl || string.equalsIgnoreCase("dataState")) {
            this.dataManager.getDataState(stringBuffer2, stringBuffer, this.modelSet.atoms, this.getAtomCount(), this.modelSet.getAtomicPropertyState(-1, null));
        }
        if (bl || string.equalsIgnoreCase("modelState")) {
            stringBuffer2.append(this.modelSet.getState(stringBuffer, true));
        }
        if (bl || string.equalsIgnoreCase("colorState")) {
            stringBuffer2.append(ColorManager.getState(stringBuffer));
        }
        if (bl || string.equalsIgnoreCase("frameState")) {
            stringBuffer2.append(this.repaintManager.getState(stringBuffer));
        }
        if (bl || string.equalsIgnoreCase("perspectiveState")) {
            stringBuffer2.append(this.transformManager.getState(stringBuffer));
        }
        if (bl || string.equalsIgnoreCase("selectionState")) {
            stringBuffer2.append(this.selectionManager.getState(stringBuffer));
        }
        if (stringBuffer != null) {
            StateManager.appendCmd(stringBuffer, "set refreshing true");
            StateManager.appendCmd(stringBuffer, "set antialiasDisplay " + this.global.antialiasDisplay);
            StateManager.appendCmd(stringBuffer, "set antialiasTranslucent " + this.global.antialiasTranslucent);
            StateManager.appendCmd(stringBuffer, "set antialiasImages " + this.global.antialiasImages);
            if (this.getSpinOn()) {
                StateManager.appendCmd(stringBuffer, "spin on");
            }
            stringBuffer.append("end function;\n\n_setState;\n");
        }
        if (bl) {
            stringBuffer2.append(stringBuffer);
        }
        return stringBuffer2.toString();
    }

    public String getStructureState() {
        return this.modelSet.getState(null, false);
    }

    String getProteinStructureState() {
        return this.modelSet.getProteinStructureState(this.selectionManager.bsSelection, false);
    }

    public String getCoordinateState(BitSet bitSet) {
        return this.modelSet.getAtomicPropertyState(0, bitSet);
    }

    void setCurrentColorRange(String string) {
        float[] fArray = this.getDataFloat(string);
        BitSet bitSet = fArray == null ? null : (BitSet)this.dataManager.getData(string)[2];
        this.setCurrentColorRange(fArray, bitSet);
    }

    void setCurrentColorRange(float[] fArray, BitSet bitSet) {
        this.colorManager.setCurrentColorRange(fArray, bitSet, this.global.propertyColorScheme);
    }

    public void setCurrentColorRange(float f, float f2) {
        this.colorManager.setCurrentColorRange(f, f2);
    }

    public float[] getCurrentColorRange() {
        return this.colorManager.getCurrentColorRange();
    }

    public void setData(String string, Object[] objectArray, int n, int n2, int n3) {
        this.dataManager.setData(string, objectArray, n, n2, n3);
    }

    Object[] getData(String string) {
        return this.dataManager.getData(string);
    }

    float[] getDataFloat(String string) {
        return this.dataManager.getDataFloat(string);
    }

    float[][] getDataFloat2D(String string) {
        return this.dataManager.getDataFloat2D(string);
    }

    public float getDataFloat(String string, int n) {
        return this.dataManager.getDataFloat(string, n);
    }

    public String getAltLocListInModel(int n) {
        return this.modelSet.getAltLocListInModel(n);
    }

    public BitSet setConformation() {
        return this.modelSet.setConformation(-1, this.selectionManager.bsSelection);
    }

    public BitSet setConformation(int n) {
        return this.modelSet.setConformation(this.repaintManager.currentModelIndex, n);
    }

    int autoHbond(BitSet bitSet) {
        return this.autoHbond(this.selectionManager.bsSelection, this.selectionManager.bsSelection, bitSet);
    }

    int autoHbond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        return this.modelSet.autoHbond(bitSet, bitSet2, bitSet3);
    }

    public boolean hasCalculatedHBonds(BitSet bitSet) {
        return this.modelSet.hasCalculatedHBonds(bitSet);
    }

    public boolean havePartialCharges() {
        return this.modelSet.getPartialCharges() != null;
    }

    public UnitCell getCurrentUnitCell() {
        return this.modelSet.getUnitCell(this.getDisplayModelIndex());
    }

    Point3f getCurrentUnitCellOffset() {
        return this.modelSet.getUnitCellOffset(this.getDisplayModelIndex());
    }

    void setCurrentUnitCellOffset(int n) {
        int n2 = this.repaintManager.currentModelIndex;
        if (this.modelSet.setUnitCellOffset(n2, n)) {
            this.global.setParameterValue("=frame " + this.getModelNumberDotted(n2) + "; set unitcell ", n);
        }
    }

    void setCurrentUnitCellOffset(Point3f point3f) {
        int n = this.repaintManager.currentModelIndex;
        if (this.modelSet.setUnitCellOffset(n, point3f)) {
            this.global.setParameterValue("=frame " + this.getModelNumberDotted(n) + "; set unitcell ", Escape.escape(point3f));
        }
    }

    public String getDefaultMeasurementLabel(int n) {
        switch (n) {
            case 2: {
                return this.global.defaultDistanceLabel;
            }
            case 3: {
                return this.global.defaultAngleLabel;
            }
        }
        return this.global.defaultTorsionLabel;
    }

    private void setDefaultMeasurementLabel(int n, String string) {
        switch (n) {
            case 2: {
                this.global.defaultDistanceLabel = string;
            }
            case 3: {
                this.global.defaultAngleLabel = string;
            }
            case 4: {
                this.global.defaultTorsionLabel = string;
            }
        }
    }

    public int getMeasurementCount() {
        int n = this.getShapePropertyAsInt(5, "count");
        return n <= 0 ? 0 : n;
    }

    public String getMeasurementStringValue(int n) {
        String string = "" + this.getShapeProperty(5, "stringValue", n);
        return string;
    }

    Vector getMeasurementInfo() {
        return (Vector)this.getShapeProperty(5, "info");
    }

    public String getMeasurementInfoAsString() {
        return (String)this.getShapeProperty(5, "infostring");
    }

    public int[] getMeasurementCountPlusIndices(int n) {
        int[] nArray = (int[])this.getShapeProperty(5, "countPlusIndices", n);
        return nArray;
    }

    void setPendingMeasurement(MeasurementPending measurementPending) {
        this.setShapeProperty(5, "pending", measurementPending);
    }

    void clearAllMeasurements() {
        this.setShapeProperty(5, "clear", null);
        this.refresh(0, "Viewer:clearAllMeasurements()");
    }

    public void clearMeasurements() {
        this.evalString("measures delete");
    }

    private void setJustifyMeasurements(boolean bl) {
        this.global.justifyMeasurements = bl;
    }

    public boolean getJustifyMeasurements() {
        return this.global.justifyMeasurements;
    }

    void setMeasurementFormats(String string) {
        this.setShapeProperty(5, "setFormats", string);
    }

    void defineMeasurement(Vector vector, float[] fArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string) {
        this.setShapeProperty(5, "setConnected", bl3 ? Boolean.TRUE : Boolean.FALSE);
        this.setShapeProperty(5, "setRange", fArray);
        this.setShapeProperty(5, "setFormat", string);
        this.setShapeProperty(5, (bl ? "deleteVector" : (bl4 ? "showVector" : (bl5 ? "hideVector" : "defineVector"))) + (bl2 ? "_All" : ""), vector);
    }

    public void deleteMeasurement(int n) {
        this.setShapeProperty(5, "delete", new Integer(n));
    }

    void deleteMeasurement(int[] nArray) {
        this.setShapeProperty(5, "delete", nArray);
    }

    public void showMeasurement(int[] nArray, boolean bl) {
        this.setShapeProperty(5, bl ? "show" : "hide", nArray);
        this.refresh(0, "Viewer:showMeasurements()");
    }

    void hideMeasurements(boolean bl) {
        this.setShapeProperty(5, "hideAll", bl);
        this.refresh(0, "hideMeasurements()");
    }

    void toggleMeasurement(int[] nArray, String string) {
        this.setShapeProperty(5, string == null ? "toggle" : "toggleOn", nArray);
        if (string != null) {
            this.setShapeProperty(5, "setFormats", string);
        }
    }

    void repaint() {
        if (this.display == null) {
            return;
        }
        this.display.repaint();
    }

    void setAnimationDirection(int n) {
        this.repaintManager.setAnimationDirection(n);
    }

    void reverseAnimation() {
        this.repaintManager.reverseAnimation();
    }

    int getAnimationDirection() {
        return this.repaintManager.animationDirection;
    }

    Hashtable getAnimationInfo() {
        return this.repaintManager.getAnimationInfo();
    }

    public void setAnimationFps(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 50) {
            n = 50;
        }
        this.global.setParameterValue("animationFps", n);
        this.repaintManager.setAnimationFps(n);
    }

    public int getAnimationFps() {
        return this.repaintManager.animationFps;
    }

    void setAnimationReplayMode(int n, float f, float f2) {
        this.repaintManager.setAnimationReplayMode(n, f, f2);
    }

    int getAnimationReplayMode() {
        return this.repaintManager.animationReplayMode;
    }

    void setAnimationOn(boolean bl) {
        boolean bl2 = this.repaintManager.animationOn;
        if (bl == bl2) {
            return;
        }
        this.repaintManager.setAnimationOn(bl);
    }

    void resumeAnimation() {
        if (this.repaintManager.animationOn) {
            Logger.debug("animation is ON in resumeAnimation");
            return;
        }
        this.repaintManager.resumeAnimation();
        this.refresh(0, "Viewer:resumeAnimation()");
    }

    void pauseAnimation() {
        if (!this.repaintManager.animationOn || this.repaintManager.animationPaused) {
            return;
        }
        this.repaintManager.pauseAnimation();
        this.refresh(0, "Viewer:pauseAnimation()");
    }

    void setAnimationRange(int n, int n2) {
        this.repaintManager.setAnimationRange(n, n2);
    }

    public BitSet getVisibleFramesBitSet() {
        BitSet bitSet = BitSetUtil.copy(this.repaintManager.getVisibleFramesBitSet());
        this.modelSet.selectDisplayedTrajectories(bitSet);
        return bitSet;
    }

    boolean isAnimationOn() {
        return this.repaintManager.animationOn;
    }

    void setAnimationNext() {
        if (this.repaintManager.setAnimationNext()) {
            this.refresh(0, "Viewer:setAnimationNext()");
        }
    }

    void setAnimationPrevious() {
        if (this.repaintManager.setAnimationPrevious()) {
            this.refresh(0, "Viewer:setAnimationPrevious()");
        }
    }

    void setAnimationLast() {
        this.repaintManager.setAnimationLast();
        this.refresh(0, "Viewer:setAnimationLast()");
    }

    void rewindAnimation() {
        this.repaintManager.rewindAnimation();
        this.refresh(0, "Viewer:rewindAnimation()");
    }

    void setCurrentModelIndex(int n) {
        this.repaintManager.setCurrentModelIndex(n);
    }

    void setTrajectory(int n) {
        this.modelSet.setTrajectory(n);
    }

    public void setTrajectory(BitSet bitSet) {
        this.modelSet.setTrajectory(bitSet);
    }

    boolean isTrajectory(int n) {
        return this.modelSet.isTrajectory(n);
    }

    public BitSet getBitSetTrajectories() {
        return this.modelSet.getBitSetTrajectories();
    }

    String getTrajectoryInfo() {
        return this.modelSet.getTrajectoryInfo();
    }

    public void setCurrentModelIndex(int n, boolean bl) {
        this.repaintManager.setCurrentModelIndex(n, bl);
    }

    public int getCurrentModelIndex() {
        return this.repaintManager.currentModelIndex;
    }

    public int getDisplayModelIndex() {
        int n = this.repaintManager.currentModelIndex;
        int n2 = this.getBackgroundModelIndex();
        return n2 >= 0 ? -2 - n : n;
    }

    boolean haveFileSet() {
        return this.getModelCount() > 1 && this.getModelNumber(0) > 1000000;
    }

    void setBackgroundModelIndex(int n) {
        this.repaintManager.setBackgroundModelIndex(n);
        this.global.setParameterValue("backgroundModel", this.modelSet.getModelNumberDotted(n));
    }

    public int getBackgroundModelIndex() {
        return this.repaintManager.backgroundModelIndex;
    }

    public FrameRenderer getFrameRenderer() {
        return this.repaintManager.frameRenderer;
    }

    void setFrameVariables(int n, int n2) {
        this.global.setParameterValue("_firstFrame", this.getModelNumberDotted(n));
        this.global.setParameterValue("_lastFrame", this.getModelNumberDotted(n2));
    }

    public int getMotionEventNumber() {
        return this.motionEventNumber;
    }

    void setInMotion(boolean bl) {
        if (this.wasInMotion ^ bl) {
            this.repaintManager.setInMotion(bl);
            if (bl) {
                ++this.motionEventNumber;
            } else {
                this.repaintManager.refresh();
            }
            this.wasInMotion = bl;
        }
    }

    public boolean getInMotion() {
        return this.repaintManager.inMotion;
    }

    public void pushHoldRepaint() {
        this.repaintManager.pushHoldRepaint();
    }

    public void popHoldRepaint() {
        this.repaintManager.popHoldRepaint();
    }

    void setRefreshing(boolean bl) {
        this.refreshing = bl;
    }

    boolean getRefreshing() {
        return this.refreshing;
    }

    public void refresh(int n, String string) {
        if (n >= 0) {
            this.repaintManager.refresh();
        } else if (n < 0) {
            n = -n;
        }
        if (n != 0) {
            this.statusManager.setStatusViewerRefreshed(n, string, this.syncingMouse, !this.syncingScripts);
        }
    }

    void requestRepaintAndWait() {
        if (!this.haveDisplay) {
            return;
        }
        this.repaintManager.requestRepaintAndWait();
        this.statusManager.setStatusViewerRefreshed(1, "move/navigate/refresh", this.syncingMouse, !this.syncingScripts);
    }

    public void repaintView() {
        this.repaintManager.repaintDone();
    }

    public boolean areAxesTainted() {
        boolean bl = this.axesAreTainted;
        this.axesAreTainted = false;
        return bl;
    }

    public void setScreenDimension(Dimension dimension) {
        int n = dimension.height;
        int n2 = dimension.width;
        if (this.getStereoMode() == 1) {
            n2 = (n2 + 1) / 2;
        }
        if (this.dimScreen.width == n2 && this.dimScreen.height == n) {
            return;
        }
        this.resizeImage(n2, n, false, false, true);
    }

    private void resizeImage(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        if (n > 0) {
            if (bl && !bl3) {
                this.setImageFontScaling(n, n2);
            }
            this.dimScreen.width = n;
            this.dimScreen.height = n2;
        }
        this.antialiasDisplay = false;
        if (bl3) {
            this.imageFontScaling = 1.0f;
            this.antialiasDisplay = this.global.antialiasDisplay;
        } else if (bl && !bl2) {
            this.antialiasDisplay = this.global.antialiasImages;
        }
        if (this.antialiasDisplay) {
            this.imageFontScaling *= 2.0f;
        }
        if (n > 0 && !bl) {
            this.global.setParameterValue("_width", n);
            this.global.setParameterValue("_height", n2);
            this.setStatusResized(n, n2);
        }
        if (n <= 0) {
            n = this.dimScreen.width;
            n2 = this.dimScreen.height;
        }
        this.transformManager.setScreenParameters(n, n2, bl || bl3 ? this.global.zoomLarge : false, this.antialiasDisplay, false, false);
        this.g3d.setWindowParameters(n, n2, this.antialiasDisplay);
    }

    public int getScreenWidth() {
        return this.dimScreen.width;
    }

    public int getScreenHeight() {
        return this.dimScreen.height;
    }

    public int getScreenDim() {
        return this.global.zoomLarge == this.dimScreen.height > this.dimScreen.width ? this.dimScreen.height : this.dimScreen.width;
    }

    public String generateOutput(String string, String string2, int n, int n2) {
        this.saveState("_Export");
        int n3 = this.dimScreen.width;
        int n4 = this.dimScreen.height;
        this.resizeImage(n, n2, true, true, false);
        this.setModelVisibility();
        String string3 = this.repaintManager.generateOutput(string, this.g3d, this.modelSet, string2);
        this.resizeImage(n3, n4, true, true, true);
        return string3;
    }

    public void renderScreenImage(Graphics graphics, Dimension dimension, Rectangle rectangle) {
        if (this.isTainted || this.getSlabEnabled()) {
            this.setModelVisibility();
        }
        this.isTainted = false;
        if (dimension != null) {
            this.setScreenDimension(dimension);
        }
        int n = this.getStereoMode();
        switch (n) {
            case 1: {
                this.render1(graphics, this.getImage(true), this.dimScreen.width, 0);
            }
            case 0: {
                this.render1(graphics, this.getImage(false), 0, 0);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.render1(graphics, this.getStereoImage(n), 0, 0);
            }
        }
        this.repaintView();
    }

    private Image getImage(boolean bl) {
        this.g3d.beginRendering(this.transformManager.getStereoRotationMatrix(bl));
        this.render();
        this.g3d.endRendering();
        return this.g3d.getScreenImage();
    }

    private void render() {
        boolean bl = this.antialiasDisplay && this.global.antialiasTranslucent;
        this.repaintManager.render(this.g3d, this.modelSet);
        if (this.g3d.setPass2(bl)) {
            this.transformManager.setAntialias(bl);
            this.repaintManager.render(this.g3d, this.modelSet);
        }
    }

    private Image getStereoImage(int n) {
        this.g3d.beginRendering(this.transformManager.getStereoRotationMatrix(true));
        this.render();
        this.g3d.endRendering();
        this.g3d.snapshotAnaglyphChannelBytes();
        this.g3d.beginRendering(this.transformManager.getStereoRotationMatrix(false));
        this.render();
        this.g3d.endRendering();
        switch (n) {
            case 2: {
                this.g3d.applyCyanAnaglyph();
                break;
            }
            case 5: {
                this.g3d.applyCustomAnaglyph(this.transformManager.stereoColors);
                break;
            }
            case 3: {
                this.g3d.applyBlueAnaglyph();
                break;
            }
            default: {
                this.g3d.applyGreenAnaglyph();
            }
        }
        return this.g3d.getScreenImage();
    }

    private void render1(Graphics graphics, Image image, int n, int n2) {
        if (graphics != null) {
            try {
                graphics.drawImage(image, n, n2, null);
            }
            catch (NullPointerException nullPointerException) {
                Logger.error("Sun!! ... fix graphics your bugs!");
            }
        }
        this.g3d.releaseScreenImage();
    }

    public Image getScreenImage() {
        boolean bl = false;
        int n = this.getStereoMode();
        switch (n) {
            case 1: {
                bl = true;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.getStereoImage(n);
            }
        }
        return this.getImage(bl);
    }

    public String getJpegBase64(int n) {
        Image image = this.getScreenImage();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JpegEncoder jpegEncoder = new JpegEncoder(image, n, byteArrayOutputStream);
        jpegEncoder.Compress();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.releaseScreenImage();
        return Base64.getBase64(byArray).toString();
    }

    public void releaseScreenImage() {
        this.g3d.releaseScreenImage();
    }

    private void setAllowEmbeddedScripts(boolean bl) {
        this.global.allowEmbeddedScripts = bl;
    }

    boolean getAllowEmbeddedScripts() {
        return this.global.allowEmbeddedScripts;
    }

    public String evalFile(String string) {
        int n = string.indexOf(" -noqueue");
        if (n >= 0) {
            return (String)this.evalStringWaitStatus("String", string.substring(0, n), "", true, false, false);
        }
        return this.scriptManager.addScript(string, true, false);
    }

    public String script(String string) {
        return this.evalString(string);
    }

    String getInterruptScript() {
        String string = this.interruptScript;
        this.interruptScript = "";
        if (Logger.debugging && string != "") {
            Logger.debug("interrupt: " + string);
        }
        return string;
    }

    public String evalString(String string) {
        return this.evalStringQuiet(string, false, true);
    }

    public String evalStringQuiet(String string) {
        return this.evalStringQuiet(string, true, true);
    }

    private String evalStringQuiet(String string, boolean bl, boolean bl2) {
        boolean bl3;
        if (bl2 && this.syncingScripts && string.indexOf("#NOSYNC;") < 0) {
            this.syncScript(string + " #NOSYNC;", null);
        }
        boolean bl4 = bl3 = string.length() > 0 && string.charAt(0) == '!';
        if (bl3) {
            string = string.substring(1);
        }
        if (this.checkResume(string)) {
            return "script processing resumed";
        }
        if (this.checkHalt(string)) {
            return "script execution halted";
        }
        if (this.isScriptExecuting() && (bl3 || this.eval.isExecutionPaused())) {
            this.interruptScript = string;
            if (string.indexOf("moveto ") == 0) {
                this.scriptManager.flushQueue("moveto ");
            }
            return "!" + string;
        }
        this.interruptScript = "";
        return this.scriptManager.addScript(string, false, bl && !this.getMessageStyleChime());
    }

    private void setScriptQueue(boolean bl) {
        this.scriptManager.setQueue(bl);
    }

    boolean usingScriptQueue() {
        return this.scriptManager.useQueue;
    }

    public void clearScriptQueue() {
        this.scriptManager.clearQueue();
    }

    public boolean checkResume(String string) {
        if (string.equalsIgnoreCase("resume")) {
            this.resumeScriptExecution();
            return true;
        }
        return false;
    }

    public boolean checkHalt(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("pause")) {
            this.pauseScriptExecution();
            return true;
        }
        if (string2.startsWith("exit")) {
            this.haltScriptExecution();
            this.clearScriptQueue();
            if (this.checkScriptOnly) {
                Logger.info("exit -- stops script checking");
            }
            this.checkScriptOnly = false;
            return string2.equals("exit");
        }
        if (string2.startsWith("quit")) {
            this.haltScriptExecution();
            if (this.checkScriptOnly) {
                Logger.info("quit -- stops script checking");
            }
            this.checkScriptOnly = false;
            return string2.equals("quit");
        }
        return false;
    }

    public String scriptWait(String string) {
        this.scriptManager.waitForQueue();
        boolean bl = GT.getDoTranslate();
        GT.setDoTranslate(false);
        String string2 = (String)this.evalStringWaitStatus("JSON", string, "+scriptStarted,+scriptStatus,+scriptEcho,+scriptTerminated", false, false, false);
        GT.setDoTranslate(bl);
        return string2;
    }

    public Object scriptWaitStatus(String string, String string2) {
        this.scriptManager.waitForQueue();
        boolean bl = GT.getDoTranslate();
        GT.setDoTranslate(false);
        Object object = this.evalStringWaitStatus("object", string, string2, false, false, false);
        GT.setDoTranslate(bl);
        return object;
    }

    public Object evalStringWaitStatus(String string, String string2, String string3) {
        this.scriptManager.waitForQueue();
        return this.evalStringWaitStatus(string, string2, string3, false, false, false);
    }

    synchronized Object evalStringWaitStatus(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        if (this.checkResume(string2)) {
            return "script processing resumed";
        }
        if (this.checkHalt(string2)) {
            return "script execution halted";
        }
        if (string2 == null) {
            return null;
        }
        String string4 = this.statusManager.statusList;
        this.getProperty("String", "jmolStatus", string3);
        if (this.checkScriptOnly) {
            Logger.info("--checking script:\n" + this.eval.getScript() + "\n----\n");
        }
        boolean bl5 = bl4 = string2.indexOf(")") == 0;
        if (bl4) {
            string2 = string2.substring(1);
        }
        bl4 = bl4 || !bl3;
        boolean bl6 = bl ? this.eval.loadScriptFile(string2, bl2) : this.eval.loadScriptString(string2, bl2);
        String string5 = this.eval.getErrorMessage();
        if (bl6) {
            this.isScriptQueued = bl3;
            this.statusManager.setStatusScriptStarted(++this.scriptIndex, string2);
            this.eval.runEval(this.checkScriptOnly, !this.checkScriptOnly || this.fileOpenCheck, bl4, this.listCommands);
            this.statusManager.setScriptStatus("Jmol script terminated", this.eval.getErrorMessage(), 1 + this.eval.getExecutionWalltime());
            if (bl && this.writeInfo != null) {
                this.createImage(this.writeInfo);
            }
        } else {
            this.scriptStatus(string5);
        }
        if (this.checkScriptOnly) {
            if (string5 == null) {
                Logger.info("--script check ok");
            } else {
                Logger.error("--script check error\n" + string5);
            }
        }
        if (bl && this.autoExit) {
            System.out.flush();
            System.exit(0);
        } else if (this.checkScriptOnly) {
            Logger.info("(use 'exit' to stop checking)");
        }
        this.isScriptQueued = true;
        if (string.equalsIgnoreCase("String")) {
            return this.eval.getErrorMessage();
        }
        Object object = this.getProperty(string, "jmolStatus", string3);
        this.getProperty("object", "jmolStatus", string4);
        return object;
    }

    public String scriptCheck(String string) {
        if (string == null || this.checking) {
            return null;
        }
        this.checking = true;
        if (string.indexOf(")") == 0) {
            string = string.substring(1);
        }
        Object object = this.eval.checkScriptSilent(string);
        this.checking = false;
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public boolean isScriptExecuting() {
        return this.eval.isScriptExecuting();
    }

    public void haltScriptExecution() {
        this.eval.haltExecution();
    }

    public void resumeScriptExecution() {
        this.eval.resumePausedExecution();
    }

    public void pauseScriptExecution() {
        this.refresh(0, "pauseScriptExecution");
        this.eval.pauseExecution();
    }

    private void setDefaultLoadScript(String string) {
        this.global.defaultLoadScript = string;
    }

    String getDefaultLoadScript() {
        return this.global.defaultLoadScript;
    }

    private void setLanguage(String string) {
        this.statusManager.setCallbackFunction("language", string);
        this.global.setParameterValue("language", GT.getLanguage());
    }

    private void setLoadFormat(String string) {
        this.global.loadFormat = string;
    }

    String getLoadFormat() {
        return this.global.loadFormat;
    }

    public String getStandardLabelFormat() {
        return this.stateManager.getStandardLabelFormat();
    }

    public int getRibbonAspectRatio() {
        return this.global.ribbonAspectRatio;
    }

    private void setRibbonAspectRatio(int n) {
        this.global.ribbonAspectRatio = n;
    }

    public float getSheetSmoothing() {
        return this.global.sheetSmoothing;
    }

    private void setSheetSmoothing(float f) {
        this.global.sheetSmoothing = f;
    }

    public boolean getSsbondsBackbone() {
        return this.global.ssbondsBackbone;
    }

    private void setHbondsBackbone(boolean bl) {
        this.global.hbondsBackbone = bl;
    }

    public boolean getHbondsBackbone() {
        return this.global.hbondsBackbone;
    }

    private void setHbondsSolid(boolean bl) {
        this.global.hbondsSolid = bl;
    }

    public boolean getHbondsSolid() {
        return this.global.hbondsSolid;
    }

    public void setMarBond(short s) {
        this.global.bondRadiusMilliAngstroms = s;
        this.global.setParameterValue("bondRadiusMilliAngstroms", s);
        this.setShapeSize(1, s * 2, BitSetUtil.setAll(this.getAtomCount()));
    }

    public void hoverOn(int n) {
        if (this.eval != null && this.isScriptExecuting() || n == this.hoverAtomIndex || this.global.hoverDelayMs == 0) {
            return;
        }
        if (!this.isInSelectionSubset(n)) {
            return;
        }
        this.loadShape(30);
        this.setShapeProperty(30, "text", null);
        this.setShapeProperty(30, "target", new Integer(n));
        this.hoverText = null;
        this.hoverAtomIndex = n;
    }

    int getHoverDelay() {
        return this.global.hoverDelayMs;
    }

    private void setHoverDelay(int n) {
        this.global.hoverDelayMs = n;
    }

    public void hoverOn(int n, int n2, String string) {
        if (this.eval != null && this.isScriptExecuting()) {
            return;
        }
        this.loadShape(30);
        this.setShapeProperty(30, "xy", new Point3i(n, n2, 0));
        this.setShapeProperty(30, "target", null);
        this.setShapeProperty(30, "text", string);
        this.hoverAtomIndex = -1;
        this.hoverText = string;
    }

    void hoverOff() {
        if (this.hoverAtomIndex >= 0) {
            this.setShapeProperty(30, "target", null);
            this.hoverAtomIndex = -1;
        }
        if (this.hoverText != null) {
            this.setShapeProperty(30, "text", null);
            this.hoverText = null;
        }
    }

    private void setAtomHoverLabel(String string) {
        this.setShapeProperty(30, "atomLabel", string);
    }

    void setLabel(String string) {
        if (string != null) {
            this.loadShape(4);
            this.setShapeSize(4, 0);
        }
        this.setShapeProperty(4, "label", string);
    }

    void togglePickingLabel(BitSet bitSet) {
        if (bitSet == null) {
            bitSet = this.selectionManager.bsSelection;
        }
        this.loadShape(4);
        this.setShapeSize(4, 0, null);
        this.modelSet.setShapeProperty(4, "toggleLabel", null, bitSet);
        this.refresh(0, "Viewer:togglePickingLabel()");
    }

    BitSet getBitSetSelection() {
        return this.selectionManager.bsSelection;
    }

    public void loadShape(int n) {
        this.modelSet.loadShape(n);
    }

    void setShapeSize(int n, int n2) {
        this.setShapeSize(n, n2, this.selectionManager.bsSelection);
    }

    public void setShapeSize(int n, int n2, BitSet bitSet) {
        this.modelSet.setShapeSize(n, n2, bitSet);
        this.refresh(0, "Viewer:setShapeSize(" + n + "," + n2 + ")");
    }

    public void setShapeProperty(int n, String string, Object object) {
        if (n < 0) {
            return;
        }
        this.modelSet.setShapeProperty(n, string, object, this.selectionManager.bsSelection);
        this.refresh(0, "Viewer:setShapeProperty()");
    }

    void setShapeProperty(int n, String string, Object object, BitSet bitSet) {
        if (n < 0) {
            return;
        }
        this.modelSet.setShapeProperty(n, string, object, bitSet);
        this.refresh(0, "Viewer:setShapeProperty()");
    }

    void setShapePropertyArgb(int n, String string, int n2) {
        this.setShapeProperty(n, string, n2 == 0 ? null : new Integer(n2 | 0xFF000000));
    }

    public Object getShapeProperty(int n, String string) {
        return this.modelSet.getShapeProperty(n, string, Integer.MIN_VALUE);
    }

    Object getShapeProperty(int n, String string, int n2) {
        return this.modelSet.getShapeProperty(n, string, n2);
    }

    int getShapePropertyAsInt(int n, String string) {
        Object object = this.getShapeProperty(n, string);
        return object == null || !(object instanceof Integer) ? Integer.MIN_VALUE : (Integer)object;
    }

    short getColix(Object object) {
        return Graphics3D.getColix(object);
    }

    private void setRasmolHydrogenSetting(boolean bl) {
        this.global.rasmolHydrogenSetting = bl;
    }

    boolean getRasmolHydrogenSetting() {
        return this.global.rasmolHydrogenSetting;
    }

    private void setRasmolHeteroSetting(boolean bl) {
        this.global.rasmolHeteroSetting = bl;
    }

    boolean getRasmolHeteroSetting() {
        return this.global.rasmolHeteroSetting;
    }

    boolean getDebugScript() {
        return this.global.debugScript;
    }

    public void setDebugScript(boolean bl) {
        this.global.debugScript = bl;
        this.global.setParameterValue("debugScript", bl);
    }

    void atomPicked(int n, Point3f point3f, int n2) {
        this.pickingManager.atomPicked(n, point3f, n2);
    }

    void clearClickCount() {
        this.mouseManager.clearClickCount();
        this.setTainted(true);
    }

    public void setCursor(int n) {
        int n2;
        if (this.currentCursor == n || this.display == null) {
            return;
        }
        this.currentCursor = n;
        switch (this.currentCursor) {
            case 1: {
                n2 = 12;
                break;
            }
            case 3: {
                n2 = 13;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            default: {
                this.display.setCursor(Cursor.getDefaultCursor());
                return;
            }
        }
        this.display.setCursor(Cursor.getPredefinedCursor(n2));
    }

    private void setPickingMode(String string) {
        int n = JmolConstants.getPickingMode(string);
        if (n < 0) {
            n = 1;
        }
        this.pickingManager.setPickingMode(n);
        this.global.setParameterValue("picking", JmolConstants.getPickingModeName(this.pickingManager.getPickingMode()));
    }

    public int getPickingMode() {
        return this.pickingManager.getPickingMode();
    }

    private void setDrawPicking(boolean bl) {
        this.global.drawPicking = bl;
    }

    public boolean getDrawPicking() {
        return this.global.drawPicking;
    }

    private void setPickingStyle(String string) {
        int n = JmolConstants.getPickingStyle(string);
        if (n < 0) {
            n = 0;
        }
        this.pickingManager.setPickingStyle(n);
        this.global.setParameterValue("pickingStyle", JmolConstants.getPickingStyleName(this.pickingManager.getPickingStyle()));
    }

    int getPickingStyle() {
        return this.pickingManager.getPickingStyle();
    }

    void setDrawHover(boolean bl) {
        this.pickingManager.setDrawHover(bl);
    }

    public boolean getDrawHover() {
        return this.pickingManager.getDrawHover();
    }

    public String getAtomInfo(int n) {
        return n >= 0 ? this.modelSet.getAtomInfo(n, null) : (String)this.modelSet.getShapeProperty(5, "pointInfo", -n);
    }

    public String getAtomInfoXYZ(int n, boolean bl) {
        return this.modelSet.getAtomInfoXYZ(n, bl);
    }

    public Hashtable getMessageQueue() {
        return this.statusManager.messageQueue;
    }

    private void setCallbackFunction(String string, String string2) {
        if (string2.equalsIgnoreCase("none")) {
            string2 = null;
        }
        this.statusManager.setCallbackFunction(string, string2);
    }

    private void setPickLabel(String string) {
        this.global.pickLabel = string;
    }

    public void setStatusAtomPicked(int n, String string) {
        if (string == null) {
            string = this.global.pickLabel;
            string = string.length() == 0 ? this.getAtomInfoXYZ(n, this.getMessageStyleChime()) : this.modelSet.getAtomInfo(n, string);
        }
        String string2 = this.statusManager.getCallbackScript("pickcallback");
        this.global.setParameterValue("_atompicked", n);
        this.global.setParameterValue("_pickinfo", string);
        if (string2 != null) {
            this.evalStringQuiet(string2, true, false);
        } else {
            this.statusManager.setStatusAtomPicked(n, string);
        }
    }

    public void setStatusAtomHovered(int n, String string) {
        String string2 = this.statusManager.getCallbackScript("hovercallback");
        this.global.setParameterValue("_atomhovered", n);
        if (string2 != null) {
            this.evalStringQuiet(string2, true, false);
        } else {
            this.statusManager.setStatusAtomHovered(n, string);
        }
    }

    public void setStatusMeasurePicked(int n, String string) {
        this.statusManager.setStatusMeasurePicked(n, string);
    }

    public void setStatusMeasuring(String string, int n, String string2) {
        this.statusManager.setStatusMeasuring(string, n, string2);
    }

    public void setStatusResized(int n, int n2) {
        String string = this.statusManager.getCallbackScript("resizecallback");
        if (string != null) {
            this.evalStringQuiet(string, true, false);
        } else {
            this.statusManager.setStatusResized(n, n2);
        }
    }

    void setStatusScriptStarted(int n, String string) {
        this.statusManager.setStatusScriptStarted(n, string);
    }

    Vector getStatusChanged(String string) {
        return this.statusManager.getStatusChanged(string);
    }

    void popupMenu(int n, int n2) {
        if (this.global.disablePopupMenu) {
            return;
        }
        this.setFrankOn(true);
        this.statusManager.popupMenu(n, n2);
    }

    public void setJmolStatusListener(JmolStatusListener jmolStatusListener) {
        this.statusManager.setJmolStatusListener(jmolStatusListener);
    }

    void setStatusFrameChanged(int n) {
        String string;
        int n2;
        this.transformManager.setVibrationPeriod(Float.NaN);
        int n3 = this.repaintManager.currentModelIndex;
        int n4 = this.repaintManager.firstModelIndex;
        int n5 = this.repaintManager.lastModelIndex;
        if (n4 == n5) {
            n3 = n4;
        }
        int n6 = n2 = this.getModelFileNumber(n3);
        int n7 = n2 % 1000000;
        int n8 = this.getModelFileNumber(n4);
        int n9 = this.getModelFileNumber(n5);
        if (n6 == 0) {
            string = this.getModelNumberDotted(n4);
            if (n4 != n5) {
                string = string + " - " + this.getModelNumberDotted(n5);
            }
            if (n8 / 1000000 == n9 / 1000000) {
                n6 = n8;
            }
        } else {
            string = this.getModelNumberDotted(n3);
        }
        if (n6 != 0) {
            n6 = n6 < 1000000 ? 1 : n6 / 1000000;
        }
        this.global.setParameterValue("_currentFileNumber", n6);
        this.global.setParameterValue("_currentModelNumberInFile", n7);
        this.global.setParameterValue("_frameID", n2);
        this.global.setParameterValue("_modelNumber", string);
        this.global.setParameterValue("_modelName", n3 < 0 ? "" : this.getModelName(n3));
        this.global.setParameterValue("_modelTitle", n3 < 0 ? "" : this.getModelTitle(n3));
        this.global.setParameterValue("_modelFile", n3 < 0 ? "" : this.getModelFileName(n3));
        string = this.statusManager.getCallbackScript("animframecallback");
        if (string != null) {
            this.evalStringQuiet(string, true, false);
        } else {
            this.statusManager.setStatusFrameChanged(n, n6, n7, this.repaintManager.animationDirection < 0 ? -n8 : n8, this.repaintManager.currentDirection < 0 ? -n9 : n9);
        }
    }

    private String getModelTitle(int n) {
        return this.modelSet == null ? null : this.modelSet.getModelTitle(n);
    }

    private String getModelFileName(int n) {
        return this.modelSet == null ? null : this.modelSet.getModelFileName(n);
    }

    private void setStatusFileLoaded(int n, String string, String string2, String string3, String string4) {
        String string5 = this.statusManager.getCallbackScript("loadstructcallback");
        if (string5 != null) {
            this.evalStringQuiet(string5, true, false);
        } else {
            this.statusManager.setStatusFileLoaded(string, string2, string3, string4, n);
        }
    }

    private void setStatusFileNotLoaded(String string, String string2) {
        this.setStatusFileLoaded(-1, string, null, null, string2);
    }

    public void scriptEcho(String string) {
        this.statusManager.setScriptEcho(string, this.isScriptQueued);
        if (this.listCommands && string != null && string.indexOf("$[") == 0) {
            Logger.info(string);
        }
    }

    private void scriptError(String string) {
        Logger.error(string);
        this.scriptEcho(string);
    }

    void scriptStatus(String string) {
        this.statusManager.setScriptStatus(string, "", 0);
    }

    private void setScriptDelay(int n) {
        this.global.scriptDelay = n;
    }

    int getScriptDelay() {
        return this.global.scriptDelay;
    }

    public void showUrl(String string) {
        if (string == null) {
            return;
        }
        if (string.indexOf(":") < 0) {
            String string2 = this.fileManager.getAppletDocumentBase();
            if (string2 == "") {
                string2 = this.fileManager.getFullPathName();
            }
            if (string2.indexOf("/") >= 0) {
                string2 = string2.substring(0, string2.lastIndexOf("/") + 1);
            } else if (string2.indexOf("\\") >= 0) {
                string2 = string2.substring(0, string2.lastIndexOf("\\") + 1);
            }
            string = string2 + string;
        }
        Logger.info("showUrl:" + string);
        this.statusManager.showUrl(string);
    }

    void showConsole(boolean bl) {
        this.statusManager.showConsole(bl);
    }

    void clearConsole() {
        this.statusManager.clearConsole();
    }

    Object getParameterEscaped(String string) {
        return this.global.getParameterEscaped(string, 0);
    }

    public Object getParameter(String string) {
        return this.global.getParameter(string);
    }

    void unsetProperty(String string) {
        this.global.setUserVariable(string, null);
    }

    public boolean getBooleanProperty(String string) {
        return this.getBooleanProperty(string, true);
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        if (this.global.htPropertyFlags.containsKey(string = string.toLowerCase())) {
            return (Boolean)this.global.htPropertyFlags.get(string);
        }
        if (string.equalsIgnoreCase("haveBFactors")) {
            return this.modelSet.getBFactors() != null;
        }
        if (string.equalsIgnoreCase("colorRasmol")) {
            return this.colorManager.getDefaultColorRasmol();
        }
        if (string.equalsIgnoreCase("frank")) {
            return this.getShowFrank();
        }
        if (string.equalsIgnoreCase("showSelections")) {
            return this.getSelectionHaloEnabled();
        }
        if (this.global.htUserVariables.containsKey(string)) {
            Token token = (Token)this.global.getUserParameterValue(string);
            if (token.tok == 0x100011) {
                return true;
            }
            if (token.tok == 0x100010) {
                return false;
            }
        }
        if (bl) {
            Logger.error("viewer.getBooleanProperty(" + string + ") - unrecognized");
        }
        return false;
    }

    public void setStringProperty(String string, String string2) {
        if (string.charAt(0) == '_') {
            this.global.setParameterValue(string, string2);
            return;
        }
        boolean bl = false;
        if (string.equalsIgnoreCase("pickLabel")) {
            this.setPickLabel(string2);
        } else if (string.equalsIgnoreCase("quaternionFrame")) {
            this.setQuaternionFrame(string2);
        } else {
            if (string.equalsIgnoreCase("defaultVDW")) {
                this.setDefaultVdw(string2);
                return;
            }
            if (string.equalsIgnoreCase("language")) {
                this.setLanguage(string2);
                return;
            }
            if (string.equalsIgnoreCase("loadFormat")) {
                this.setLoadFormat(string2);
            } else {
                if (string.equalsIgnoreCase("backgroundColor")) {
                    this.setObjectColor("background", string2);
                    return;
                }
                if (string.equalsIgnoreCase("axesColor")) {
                    this.setObjectColor("axis1", string2);
                    this.setObjectColor("axis2", string2);
                    this.setObjectColor("axis3", string2);
                    return;
                }
                if (string.equalsIgnoreCase("axis1Color")) {
                    this.setObjectColor("axis1", string2);
                    return;
                }
                if (string.equalsIgnoreCase("axis2Color")) {
                    this.setObjectColor("axis2", string2);
                    return;
                }
                if (string.equalsIgnoreCase("axis3Color")) {
                    this.setObjectColor("axis3", string2);
                    return;
                }
                if (string.equalsIgnoreCase("boundBoxColor")) {
                    this.setObjectColor("boundbox", string2);
                    return;
                }
                if (string.equalsIgnoreCase("unitCellColor")) {
                    this.setObjectColor("unitcell", string2);
                    return;
                }
                if (string.equalsIgnoreCase("propertyColorScheme")) {
                    this.setPropertyColorScheme(string2, false);
                    return;
                }
                if (string.equalsIgnoreCase("propertyColorSchemeOverload")) {
                    this.setPropertyColorScheme(string2, true);
                    return;
                }
                if (string.equalsIgnoreCase("hoverLabel")) {
                    this.setAtomHoverLabel(string2);
                } else if (string.equalsIgnoreCase("defaultDistanceLabel")) {
                    this.setDefaultMeasurementLabel(2, string2);
                } else if (string.equalsIgnoreCase("defaultAngleLabel")) {
                    this.setDefaultMeasurementLabel(3, string2);
                } else if (string.equalsIgnoreCase("defaultTorsionLabel")) {
                    this.setDefaultMeasurementLabel(4, string2);
                } else if (string.equalsIgnoreCase("defaultLoadScript")) {
                    this.setDefaultLoadScript(string2);
                } else if (string.equalsIgnoreCase("appletProxy")) {
                    this.setAppletProxy(string2);
                } else if (string.equalsIgnoreCase("defaultDirectory")) {
                    this.setDefaultDirectory(string2);
                } else if (string.equalsIgnoreCase("helpPath")) {
                    this.setHelpPath(string2);
                } else if (string.equalsIgnoreCase("defaults")) {
                    this.setDefaults(string2);
                } else if (string.equalsIgnoreCase("defaultColorScheme")) {
                    this.setDefaultColors(string2);
                } else {
                    if (string.equalsIgnoreCase("picking")) {
                        this.setPickingMode(string2);
                        return;
                    }
                    if (string.equalsIgnoreCase("pickingStyle")) {
                        this.setPickingStyle(string2);
                        return;
                    }
                    if (!string.equalsIgnoreCase("dataSeparator")) {
                        if (string.toLowerCase().indexOf("callback") >= 0) {
                            this.setCallbackFunction(string, string2);
                        } else {
                            bl = true;
                        }
                    }
                }
            }
        }
        string = string.toLowerCase();
        boolean bl2 = this.global.htParameterValues.containsKey(string);
        if (!bl2 && bl && string.charAt(0) != '@' && (this.global.htPropertyFlags.containsKey(string) || this.global.htPropertyFlagsRemoved.containsKey(string))) {
            this.scriptError(GT._("ERROR: cannot set boolean flag to string value: {0}", string));
            return;
        }
        if (bl2) {
            this.global.setParameterValue(string, string2);
        } else {
            this.global.setUserVariable(string, new Token(4, string2));
        }
    }

    void removeUserVariable(String string) {
        this.global.removeUserVariable(string);
        if (string.indexOf("callback") >= 0) {
            this.statusManager.setCallbackFunction(string, null);
        }
    }

    boolean isJmolVariable(String string) {
        return this.global.isJmolVariable(string);
    }

    public void setFloatProperty(String string, float f) {
        if (string.charAt(0) == '_') {
            this.global.setParameterValue(string, f);
            return;
        }
        this.setFloatProperty(string, f, false);
    }

    private boolean setFloatProperty(String string, float f, boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        if (string.equalsIgnoreCase("ellipsoidAxisDiameter")) {
            if (bl) {
                f /= 1000.0f;
            }
        } else if (string.equalsIgnoreCase("spinX")) {
            this.setSpin("x", (int)f);
        } else if (string.equalsIgnoreCase("spinY")) {
            this.setSpin("y", (int)f);
        } else if (string.equalsIgnoreCase("spinZ")) {
            this.setSpin("z", (int)f);
        } else if (string.equalsIgnoreCase("spinFPS")) {
            this.setSpin("fps", (int)f);
        } else if (string.equalsIgnoreCase("defaultDrawArrowScale")) {
            this.setDefaultDrawArrowScale(f);
        } else if (string.equalsIgnoreCase("defaultTranslucent")) {
            this.setDefaultTranslucent(f);
        } else if (string.equalsIgnoreCase("axesScale")) {
            this.setAxesScale(f);
        } else if (string.equalsIgnoreCase("visualRange")) {
            this.setVisualRange(f);
        } else if (string.equalsIgnoreCase("navigationDepth")) {
            this.setNavigationDepthPercent(0.0f, f);
        } else if (string.equalsIgnoreCase("navigationSpeed")) {
            this.setNavigationSpeed(f);
        } else if (string.equalsIgnoreCase("navigationSlab")) {
            this.setNavigationSlabOffset(f);
        } else if (string.equalsIgnoreCase("cameraDepth")) {
            this.setCameraDepth(f);
        } else {
            if (string.equalsIgnoreCase("rotationRadius")) {
                this.setRotationRadius(f, true);
                return true;
            }
            if (string.equalsIgnoreCase("hoverDelay")) {
                this.setHoverDelay((int)(f * 1000.0f));
            } else if (string.equalsIgnoreCase("sheetSmoothing")) {
                this.setSheetSmoothing(f);
            } else if (string.equalsIgnoreCase("dipoleScale")) {
                this.setDipoleScale(f);
            } else {
                if (string.equalsIgnoreCase("stereoDegrees")) {
                    this.setStereoDegrees(f);
                    return true;
                }
                if (string.equalsIgnoreCase("vectorScale")) {
                    this.setVectorScale(f);
                    return true;
                }
                if (string.equalsIgnoreCase("vibrationPeriod")) {
                    this.setVibrationPeriod(f);
                    return true;
                }
                if (string.equalsIgnoreCase("vibrationScale")) {
                    this.setVibrationScale(f);
                    return true;
                }
                if (string.equalsIgnoreCase("bondTolerance")) {
                    this.setBondTolerance(f);
                    return true;
                }
                if (string.equalsIgnoreCase("minBondDistance")) {
                    this.setMinBondDistance(f);
                    return true;
                }
                if (string.equalsIgnoreCase("scaleAngstromsPerInch")) {
                    this.setScaleAngstromsPerInch(f);
                } else if (string.equalsIgnoreCase("solventProbeRadius")) {
                    this.setSolventProbeRadius(f);
                } else {
                    if (string.equalsIgnoreCase("radius")) {
                        this.setFloatProperty("solventProbeRadius", f);
                        return true;
                    }
                    if (bl) {
                        return false;
                    }
                    bl3 = true;
                }
            }
        }
        if (!(bl2 = this.global.htParameterValues.containsKey(string = string.toLowerCase())) && bl3 && this.global.htPropertyFlags.containsKey(string)) {
            this.scriptError(GT._("ERROR: cannot set boolean flag to numeric value: {0}", string));
            return true;
        }
        if (bl2) {
            this.global.setParameterValue(string, f);
        } else {
            this.global.setUserVariable(string, new Token(3, new Float(f)));
        }
        return true;
    }

    public void setIntProperty(String string, int n) {
        if (string.charAt(0) == '_') {
            this.global.setParameterValue(string, n);
            return;
        }
        this.setIntProperty(string, n, true);
    }

    private void setIntProperty(String string, int n, boolean bl) {
        boolean bl2 = false;
        if (string.equalsIgnoreCase("delayMaximumMs")) {
            this.setDelayMaximum(n);
        } else {
            if (string.equalsIgnoreCase("logLevel")) {
                Logger.setLogLevel(n);
                Logger.info("logging level set to " + n);
                this.global.setParameterValue("logLevel", n);
                return;
            }
            if (string.equalsIgnoreCase("axesMode")) {
                this.setAxesMode(n);
                return;
            }
            if (!string.equalsIgnoreCase("propertyDataField")) {
                if (string.equalsIgnoreCase("strandCount")) {
                    this.setStrandCount(0, n);
                    return;
                }
                if (string.equalsIgnoreCase("strandCountForStrands")) {
                    this.setStrandCount(10, n);
                    return;
                }
                if (string.equalsIgnoreCase("strandCountForMeshRibbon")) {
                    this.setStrandCount(11, n);
                    return;
                }
                if (string.equalsIgnoreCase("perspectiveModel")) {
                    this.setPerspectiveModel(n);
                } else if (string.equalsIgnoreCase("showScript")) {
                    this.setScriptDelay(n);
                } else if (string.equalsIgnoreCase("specularPower")) {
                    Viewer.setSpecularPower(n);
                } else if (string.equalsIgnoreCase("specularExponent")) {
                    Viewer.setSpecularExponent(n);
                } else {
                    if (string.equalsIgnoreCase("specular")) {
                        this.setIntProperty("specularPercent", n);
                        return;
                    }
                    if (string.equalsIgnoreCase("diffuse")) {
                        this.setIntProperty("diffusePercent", n);
                        return;
                    }
                    if (string.equalsIgnoreCase("ambient")) {
                        this.setIntProperty("ambientPercent", n);
                        return;
                    }
                    if (string.equalsIgnoreCase("specularPercent")) {
                        Viewer.setSpecularPercent(n);
                    } else if (string.equalsIgnoreCase("diffusePercent")) {
                        Viewer.setDiffusePercent(n);
                    } else if (string.equalsIgnoreCase("ambientPercent")) {
                        Viewer.setAmbientPercent(n);
                    } else if (string.equalsIgnoreCase("ribbonAspectRatio")) {
                        this.setRibbonAspectRatio(n);
                    } else if (string.equalsIgnoreCase("pickingSpinRate")) {
                        this.setPickingSpinRate(n);
                    } else if (string.equalsIgnoreCase("animationFps")) {
                        this.setAnimationFps(n);
                    } else if (string.equalsIgnoreCase("percentVdwAtom")) {
                        this.setPercentVdwAtom(n);
                    } else {
                        if (string.equalsIgnoreCase("bondRadiusMilliAngstroms")) {
                            this.setMarBond((short)n);
                            return;
                        }
                        if (string.equalsIgnoreCase("hermiteLevel")) {
                            this.setHermiteLevel(n);
                        } else {
                            if ((n != 0 && n != 1 || !this.setBooleanProperty(string, n == 1, false)) && this.setFloatProperty(string, n, true)) {
                                return;
                            }
                            bl2 = true;
                        }
                    }
                }
            }
        }
        string = string.toLowerCase();
        boolean bl3 = this.global.htParameterValues.containsKey(string);
        if (!bl3 && bl2 && this.global.htPropertyFlags.containsKey(string)) {
            this.scriptError(GT._("ERROR: cannot set boolean flag to numeric value: {0}", string));
            return;
        }
        if (!bl) {
            return;
        }
        if (bl3) {
            this.global.setParameterValue(string, n);
        } else {
            this.global.setUserVariable(string, Token.intToken(n));
        }
    }

    private void setDelayMaximum(int n) {
        this.global.delayMaximumMs = n;
    }

    int getDelayMaximum() {
        return this.global.delayMaximumMs;
    }

    public void setBooleanProperty(String string, boolean bl) {
        if (string.charAt(0) == '_') {
            this.global.setParameterValue(string, bl);
            return;
        }
        this.setBooleanProperty(string, bl, true);
    }

    boolean setBooleanProperty(String string, boolean bl, boolean bl2) {
        boolean bl3 = false;
        boolean bl4 = true;
        if (string.equalsIgnoreCase("messageStyleChime")) {
            this.setMessageStyleChime(bl);
        } else if (string.equalsIgnoreCase("pdbSequential")) {
            this.setPdbLoadInfo(bl, 1);
        } else if (string.equalsIgnoreCase("pdbGetHeader")) {
            this.setPdbLoadInfo(bl, 2);
        } else if (string.equalsIgnoreCase("fontScaling")) {
            this.setFontScaling(bl);
        } else if (string.equalsIgnoreCase("syncMouse")) {
            this.setSyncTarget(0, bl);
        } else if (string.equalsIgnoreCase("syncScript")) {
            this.setSyncTarget(1, bl);
        } else if (string.equalsIgnoreCase("wireframeRotation")) {
            this.setWireframeRotation(bl);
        } else if (string.equalsIgnoreCase("isosurfacePropertySmoothing")) {
            this.setIsosurfacePropertySmoothing(bl);
        } else if (string.equalsIgnoreCase("drawPicking")) {
            this.setDrawPicking(bl);
        } else if (string.equalsIgnoreCase("antialiasDisplay")) {
            this.setAntialias(0, bl);
        } else if (string.equalsIgnoreCase("antialiasTranslucent")) {
            this.setAntialias(1, bl);
        } else if (string.equalsIgnoreCase("antialiasImages")) {
            this.setAntialias(2, bl);
        } else if (string.equalsIgnoreCase("smartAromatic")) {
            this.setSmartAromatic(bl);
        } else if (string.equalsIgnoreCase("applySymmetryToBonds")) {
            this.setApplySymmetryToBonds(bl);
        } else if (string.equalsIgnoreCase("appendNew")) {
            this.setAppendNew(bl);
        } else if (string.equalsIgnoreCase("autoFPS")) {
            this.setAutoFps(bl);
        } else if (string.equalsIgnoreCase("useNumberLocalization")) {
            this.setUseNumberLocalization(bl);
        } else if (string.equalsIgnoreCase("showFrank")) {
            this.setFrankOn(bl);
        } else if (string.equalsIgnoreCase("solventProbe")) {
            this.setSolventOn(bl);
        } else if (string.equalsIgnoreCase("dynamicMeasurements")) {
            this.setDynamicMeasurements(bl);
        } else if (string.equalsIgnoreCase("allowRotateSelected")) {
            this.setAllowRotateSelected(bl);
        } else {
            if (string.equalsIgnoreCase("showScript")) {
                this.setIntProperty("showScript", bl ? 1 : 0);
                return true;
            }
            if (string.equalsIgnoreCase("allowEmbeddedScripts")) {
                this.setAllowEmbeddedScripts(bl);
            } else if (string.equalsIgnoreCase("navigationPeriodic")) {
                this.setNavigationPeriodic(bl);
            } else if (string.equalsIgnoreCase("zShade")) {
                this.setZShade(bl);
            } else if (string.equalsIgnoreCase("drawHover")) {
                this.setDrawHover(bl);
            } else if (string.equalsIgnoreCase("navigationMode")) {
                this.setNavigationMode(bl);
            } else if (string.equalsIgnoreCase("hideNavigationPoint")) {
                this.setHideNavigationPoint(bl);
            } else if (string.equalsIgnoreCase("showNavigationPointAlways")) {
                this.setShowNavigationPointAlways(bl);
            } else if (string.equalsIgnoreCase("refreshing")) {
                this.setRefreshing(bl);
            } else if (string.equalsIgnoreCase("justifyMeasurements")) {
                this.setJustifyMeasurements(bl);
            } else if (string.equalsIgnoreCase("ssBondsBackbone")) {
                this.setSsbondsBackbone(bl);
            } else if (string.equalsIgnoreCase("hbondsBackbone")) {
                this.setHbondsBackbone(bl);
            } else if (string.equalsIgnoreCase("hbondsSolid")) {
                this.setHbondsSolid(bl);
            } else if (string.equalsIgnoreCase("specular")) {
                Viewer.setSpecular(bl);
            } else if (string.equalsIgnoreCase("slabEnabled")) {
                this.setSlabEnabled(bl);
            } else if (string.equalsIgnoreCase("zoomEnabled")) {
                this.setZoomEnabled(bl);
            } else if (string.equalsIgnoreCase("solventProbe")) {
                this.setSolventOn(bl);
            } else if (string.equalsIgnoreCase("highResolution")) {
                this.setHighResolution(bl);
            } else if (string.equalsIgnoreCase("traceAlpha")) {
                this.setTraceAlpha(bl);
            } else if (string.equalsIgnoreCase("zoomLarge")) {
                this.setZoomLarge(bl);
            } else if (string.equalsIgnoreCase("languageTranslation")) {
                GT.setDoTranslate(bl);
            } else if (string.equalsIgnoreCase("hideNotSelected")) {
                this.setHideNotSelected(bl);
            } else if (string.equalsIgnoreCase("colorRasmol")) {
                this.setDefaultColors(bl ? "rasmol" : "jmol");
            } else if (string.equalsIgnoreCase("scriptQueue")) {
                this.setScriptQueue(bl);
            } else if (string.equalsIgnoreCase("dotSurface")) {
                this.setDotSurfaceFlag(bl);
            } else if (string.equalsIgnoreCase("dotsSelectedOnly")) {
                this.setDotsSelectedOnly(bl);
            } else if (string.equalsIgnoreCase("selectionHalos")) {
                this.setSelectionHalos(bl);
            } else if (string.equalsIgnoreCase("selectHydrogen")) {
                this.setRasmolHydrogenSetting(bl);
            } else if (string.equalsIgnoreCase("selectHetero")) {
                this.setRasmolHeteroSetting(bl);
            } else if (string.equalsIgnoreCase("showMultipleBonds")) {
                this.setShowMultipleBonds(bl);
            } else if (string.equalsIgnoreCase("showHiddenSelectionHalos")) {
                this.setShowHiddenSelectionHalos(bl);
            } else if (string.equalsIgnoreCase("windowCentered")) {
                this.setWindowCentered(bl);
            } else if (string.equalsIgnoreCase("displayCellParameters")) {
                this.setDisplayCellParameters(bl);
            } else if (string.equalsIgnoreCase("testFlag1")) {
                this.setTestFlag1(bl);
            } else if (string.equalsIgnoreCase("testFlag2")) {
                this.setTestFlag2(bl);
            } else if (string.equalsIgnoreCase("testFlag3")) {
                this.setTestFlag3(bl);
            } else if (string.equalsIgnoreCase("testFlag4")) {
                this.setTestFlag4(bl);
            } else if (string.equalsIgnoreCase("ribbonBorder")) {
                this.setRibbonBorder(bl);
            } else if (string.equalsIgnoreCase("cartoonRockets")) {
                this.setCartoonRocketFlag(bl);
            } else if (string.equalsIgnoreCase("rocketBarrels")) {
                this.setRocketBarrelFlag(bl);
            } else if (string.equalsIgnoreCase("greyscaleRendering")) {
                this.setGreyscaleRendering(bl);
            } else if (string.equalsIgnoreCase("measurementLabels")) {
                this.setShowMeasurementLabels(bl);
            } else {
                if (string.equalsIgnoreCase("axesWindow")) {
                    this.setAxesModeMolecular(!bl);
                    return true;
                }
                if (string.equalsIgnoreCase("axesMolecular")) {
                    this.setAxesModeMolecular(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("axesUnitCell")) {
                    this.setAxesModeUnitCell(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("axesOrientationRasmol")) {
                    this.setAxesOrientationRasmol(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("debugScript")) {
                    this.setDebugScript(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("perspectiveDepth")) {
                    this.setPerspectiveDepth(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("showAxes")) {
                    this.setShowAxes(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("showBoundBox")) {
                    this.setShowBbcage(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("showHydrogens")) {
                    this.setShowHydrogens(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("showMeasurements")) {
                    this.setShowMeasurements(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("showUnitcell")) {
                    this.setShowUnitCell(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("frank")) {
                    return this.setBooleanProperty("showFrank", bl, true);
                }
                if (string.equalsIgnoreCase("solvent")) {
                    return this.setBooleanProperty("solventProbe", bl, true);
                }
                if (string.equalsIgnoreCase("bonds")) {
                    return this.setBooleanProperty("showMultipleBonds", bl, true);
                }
                if (string.equalsIgnoreCase("hydrogen")) {
                    return this.setBooleanProperty("selectHydrogen", bl, true);
                }
                if (string.equalsIgnoreCase("hetero")) {
                    return this.setBooleanProperty("selectHetero", bl, true);
                }
                if (string.equalsIgnoreCase("showSelections")) {
                    return this.setBooleanProperty("selectionHalos", bl, true);
                }
                bl4 = false;
                if (string.equalsIgnoreCase("bondModeOr")) {
                    this.setBondSelectionModeOr(bl);
                } else if (string.equalsIgnoreCase("zeroBasedXyzRasmol")) {
                    this.setZeroBasedXyzRasmol(bl);
                } else if (string.equalsIgnoreCase("rangeSelected")) {
                    this.setRangeSelected(bl);
                } else if (string.equalsIgnoreCase("measureAllModels")) {
                    this.setMeasureAllModels(bl);
                } else if (string.equalsIgnoreCase("statusReporting")) {
                    this.setAllowStatusReporting(bl);
                } else if (string.equalsIgnoreCase("chainCaseSensitive")) {
                    this.setChainCaseSensitive(bl);
                } else if (string.equalsIgnoreCase("hideNameInPopup")) {
                    this.setHideNameInPopup(bl);
                } else if (string.equalsIgnoreCase("disablePopupMenu")) {
                    this.setDisablePopupMenu(bl);
                } else if (string.equalsIgnoreCase("forceAutoBond")) {
                    this.setForceAutoBond(bl);
                } else {
                    if (string.equalsIgnoreCase("autobond")) {
                        this.setAutoBond(bl);
                        return true;
                    }
                    bl3 = true;
                }
                if (!bl2) {
                    return !bl3;
                }
                bl3 = true;
            }
        }
        if (!bl2) {
            return !bl3;
        }
        boolean bl5 = this.global.htPropertyFlags.containsKey(string = string.toLowerCase());
        if (!bl5 && bl3 && this.global.htParameterValues.containsKey(string)) {
            this.scriptError(GT._("ERROR: Cannot set value of this variable to a boolean: {0}", string));
            return true;
        }
        if (bl5) {
            this.global.setParameterValue(string, bl);
        } else {
            this.global.setUserVariable(string, bl ? Token.tokenOn : Token.tokenOff);
        }
        if (bl3) {
            return false;
        }
        if (bl4) {
            this.setTainted(true);
            this.refresh(0, "viewer.setBooleanProperty");
        }
        return true;
    }

    private void setPdbLoadInfo(boolean bl, int n) {
        switch (n) {
            case 1: {
                this.global.pdbSequential = bl;
                return;
            }
            case 2: {
                this.global.pdbGetHeader = bl;
                return;
            }
        }
    }

    public boolean getPdbLoadInfo(int n) {
        switch (n) {
            case 1: {
                return this.global.pdbSequential;
            }
            case 2: {
                return this.global.pdbGetHeader;
            }
        }
        return false;
    }

    private void setMessageStyleChime(boolean bl) {
        this.global.messageStyleChime = bl;
    }

    boolean getMessageStyleChime() {
        return this.global.messageStyleChime;
    }

    private void setFontScaling(boolean bl) {
        this.global.fontScaling = bl;
    }

    public boolean getFontScaling() {
        return this.global.fontScaling;
    }

    void showParameter(String string, boolean bl, int n) {
        String string2 = "" + this.global.getParameterEscaped(string, n);
        if (bl || string2.indexOf("<not set>") < 0) {
            this.showString(string + " = " + string2);
        }
    }

    public void showString(String string) {
        if (this.isScriptQueued) {
            Logger.warn(string);
        }
        this.scriptEcho(string);
    }

    String getAllSettings(String string) {
        return this.global.getAllSettings(string);
    }

    public boolean getDotSurfaceFlag() {
        return this.global.dotSurface;
    }

    private void setDotSurfaceFlag(boolean bl) {
        this.global.dotSurface = bl;
    }

    public boolean getDotsSelectedOnlyFlag() {
        return this.global.dotsSelectedOnly;
    }

    private void setDotsSelectedOnly(boolean bl) {
        this.global.dotsSelectedOnly = bl;
    }

    public boolean isRangeSelected() {
        return this.global.rangeSelected;
    }

    private void setRangeSelected(boolean bl) {
        this.global.rangeSelected = bl;
    }

    private void setIsosurfacePropertySmoothing(boolean bl) {
        this.global.isosurfacePropertySmoothing = bl;
    }

    boolean getIsosurfacePropertySmoothing() {
        return this.global.isosurfacePropertySmoothing;
    }

    private void setWireframeRotation(boolean bl) {
        this.global.wireframeRotation = bl;
    }

    public boolean getWireframeRotation() {
        return this.global.wireframeRotation;
    }

    boolean isWindowCentered() {
        return this.transformManager.isWindowCentered();
    }

    private void setWindowCentered(boolean bl) {
        this.transformManager.setWindowCentered(bl);
    }

    private void setCameraDepth(float f) {
        this.transformManager.setCameraDepthPercent(f);
        this.refresh(1, "set cameraDepth");
    }

    void setNavigationDepthPercent(float f, float f2) {
        this.transformManager.setNavigationDepthPercent(f, f2);
        this.refresh(1, "set navigationDepth");
    }

    private void setNavigationSpeed(float f) {
        this.global.navigationSpeed = f;
    }

    float getNavigationSpeed() {
        return this.global.navigationSpeed;
    }

    private void setShowNavigationPointAlways(boolean bl) {
        this.global.showNavigationPointAlways = bl;
    }

    private void setHideNavigationPoint(boolean bl) {
        this.global.hideNavigationPoint = bl;
    }

    public boolean getShowNavigationPoint() {
        if (!this.global.navigationMode || !this.transformManager.canNavigate()) {
            return false;
        }
        return this.getNavigating() && !this.global.hideNavigationPoint || this.global.showNavigationPointAlways || this.getInMotion();
    }

    public void setVisualRange(float f) {
        this.transformManager.setVisualRange(f);
        this.refresh(1, "set visualRange");
    }

    private void setSolventProbeRadius(float f) {
        this.global.solventProbeRadius = f;
    }

    float getSolventProbeRadius() {
        return this.global.solventProbeRadius;
    }

    public float getCurrentSolventProbeRadius() {
        return this.global.solventOn ? this.global.solventProbeRadius : 0.0f;
    }

    private void setSolventOn(boolean bl) {
        this.global.solventOn = bl;
    }

    boolean getSolventOn() {
        return this.global.solventOn;
    }

    private void setAllowStatusReporting(boolean bl) {
        this.statusManager.setAllowStatusReporting(bl);
    }

    private void setTestFlag1(boolean bl) {
        this.global.testFlag1 = bl;
    }

    public boolean getTestFlag1() {
        return this.global.testFlag1;
    }

    public boolean getTestFlag2() {
        return this.global.testFlag2;
    }

    private void setTestFlag2(boolean bl) {
        this.global.testFlag2 = bl;
    }

    public boolean getTestFlag3() {
        return this.global.testFlag3;
    }

    private void setTestFlag3(boolean bl) {
        this.global.testFlag3 = bl;
    }

    public boolean getTestFlag4() {
        return this.global.testFlag4;
    }

    private void setTestFlag4(boolean bl) {
        this.global.testFlag4 = bl;
    }

    public void setPerspectiveDepth(boolean bl) {
        this.global.setParameterValue("perspectiveDepth", bl);
        this.transformManager.setPerspectiveDepth(bl);
        this.refresh(0, "Viewer:setPerspectiveDepth()");
    }

    public void setAxesOrientationRasmol(boolean bl) {
        this.global.setParameterValue("axesOrientationRasmol", bl);
        this.global.axesOrientationRasmol = bl;
        this.reset();
    }

    public boolean getAxesOrientationRasmol() {
        return this.global.axesOrientationRasmol;
    }

    void setAxesScale(float f) {
        this.global.axesScale = f;
        this.axesAreTainted = true;
        this.refresh(0, "set axesScale");
    }

    public Point3f[] getAxisPoints() {
        return this.getObjectMad(1) == 0 || this.getAxesMode() != 2 || (Boolean)this.getShapeProperty(26, "axesTypeXY") != false ? null : (Point3f[])this.getShapeProperty(26, "axisPoints");
    }

    public float getAxesScale() {
        return this.global.axesScale;
    }

    private void setAxesMode(int n) {
        switch (n) {
            case 1: {
                this.setAxesModeMolecular(true);
                return;
            }
            case 0: {
                this.setAxesModeMolecular(false);
                return;
            }
            case 2: {
                this.setAxesModeUnitCell(true);
                return;
            }
        }
    }

    private void setAxesModeMolecular(boolean bl) {
        this.global.axesMode = bl ? 1 : 0;
        this.axesAreTainted = true;
        this.global.removeJmolParameter("axesunitcell");
        this.global.removeJmolParameter(bl ? "axeswindow" : "axesmolecular");
        this.global.setParameterValue("axesMode", this.global.axesMode);
        this.global.setParameterValue(bl ? "axesMolecular" : "axesWindow", true);
    }

    void setAxesModeUnitCell(boolean bl) {
        this.global.axesMode = bl ? 2 : 0;
        this.axesAreTainted = true;
        this.global.removeJmolParameter("axesmolecular");
        this.global.removeJmolParameter(bl ? "axeswindow" : "axesunitcell");
        this.global.setParameterValue(bl ? "axesUnitcell" : "axesWindow", true);
        this.global.setParameterValue("axesMode", this.global.axesMode);
    }

    public int getAxesMode() {
        return this.global.axesMode;
    }

    private void setDisplayCellParameters(boolean bl) {
        this.global.displayCellParameters = bl;
    }

    public boolean getDisplayCellParameters() {
        return this.global.displayCellParameters;
    }

    public boolean getPerspectiveDepth() {
        return this.transformManager.getPerspectiveDepth();
    }

    public void setSelectionHalos(boolean bl) {
        if (this.modelSet == null || bl == this.getSelectionHaloEnabled()) {
            return;
        }
        this.global.setParameterValue("selectionHalos", bl);
        this.loadShape(15);
        this.modelSet.setSelectionHaloEnabled(bl);
    }

    public boolean getSelectionHaloEnabled() {
        return this.modelSet.getSelectionHaloEnabled();
    }

    private void setBondSelectionModeOr(boolean bl) {
        this.global.bondModeOr = bl;
        this.refresh(0, "Viewer:setBondSelectionModeOr()");
    }

    public boolean getBondSelectionModeOr() {
        return this.global.bondModeOr;
    }

    public boolean getChainCaseSensitive() {
        return this.global.chainCaseSensitive;
    }

    private void setChainCaseSensitive(boolean bl) {
        this.global.chainCaseSensitive = bl;
    }

    public boolean getRibbonBorder() {
        return this.global.ribbonBorder;
    }

    private void setRibbonBorder(boolean bl) {
        this.global.ribbonBorder = bl;
    }

    public boolean getCartoonRocketFlag() {
        return this.global.cartoonRockets;
    }

    public boolean getRocketBarrelFlag() {
        return this.global.rocketBarrels;
    }

    private void setCartoonRocketFlag(boolean bl) {
        this.global.cartoonRockets = bl;
    }

    private void setRocketBarrelFlag(boolean bl) {
        this.global.rocketBarrels = bl;
    }

    private void setStrandCount(int n, int n2) {
        switch (n) {
            case 10: {
                this.global.strandCountForStrands = n2;
                break;
            }
            case 11: {
                this.global.strandCountForMeshRibbon = n2;
                break;
            }
            default: {
                this.global.strandCountForStrands = n2;
                this.global.strandCountForMeshRibbon = n2;
            }
        }
        this.global.setParameterValue("strandCount", n2);
        this.global.setParameterValue("strandCountForStrands", this.global.strandCountForStrands);
        this.global.setParameterValue("strandCountForMeshRibbon", this.global.strandCountForMeshRibbon);
    }

    public int getStrandCount(int n) {
        return n == 10 ? this.global.strandCountForStrands : this.global.strandCountForMeshRibbon;
    }

    boolean getHideNameInPopup() {
        return this.global.hideNameInPopup;
    }

    private void setHideNameInPopup(boolean bl) {
        this.global.hideNameInPopup = bl;
    }

    private void setNavigationPeriodic(boolean bl) {
        this.global.navigationPeriodic = bl;
    }

    boolean getNavigationPeriodic() {
        return this.global.navigationPeriodic;
    }

    private void setNavigationMode(boolean bl) {
        this.global.navigationMode = bl;
        if (bl && !this.transformManager.canNavigate()) {
            this.setVibrationOff();
            this.setSpinOn(false);
            this.transformManager = this.transformManager.getNavigationManager(this, this.dimScreen.width, this.dimScreen.height);
            this.transformManager.homePosition();
        }
        this.transformManager.setNavigationMode(bl);
    }

    boolean getNavigationMode() {
        return this.global.navigationMode;
    }

    private void setNavigationSlabOffset(float f) {
        this.transformManager.setNavigationSlabOffsetPercent(f);
    }

    private void setPerspectiveModel(int n) {
        this.setVibrationOff();
        this.setSpinOn(false);
        switch (n) {
            case 10: {
                this.transformManager = new TransformManager10(this, this.dimScreen.width, this.dimScreen.height);
                break;
            }
            default: {
                this.transformManager = this.transformManager.getNavigationManager(this, this.dimScreen.width, this.dimScreen.height);
            }
        }
        this.setTransformManagerDefaults();
        this.transformManager.homePosition();
    }

    private void setTransformManagerDefaults() {
        this.transformManager.setCameraDepthPercent(this.global.cameraDepth);
        this.transformManager.setPerspectiveDepth(this.global.perspectiveDepth);
        this.transformManager.setStereoDegrees(this.global.stereoDegrees);
        this.transformManager.setVisualRange(this.global.visualRange);
        this.transformManager.setSpinOn(false);
        this.transformManager.setVibrationPeriod(0.0f);
    }

    private void setZoomLarge(boolean bl) {
        this.global.zoomLarge = bl;
        this.transformManager.scaleFitToScreen(false, this.global.zoomLarge, false, true);
    }

    boolean getZoomLarge() {
        return this.global.zoomLarge;
    }

    private void setTraceAlpha(boolean bl) {
        this.global.traceAlpha = bl;
    }

    public boolean getTraceAlpha() {
        return this.global.traceAlpha;
    }

    public int getHermiteLevel() {
        return this.global.hermiteLevel;
    }

    private void setHermiteLevel(int n) {
        this.global.hermiteLevel = n;
    }

    public boolean getHighResolution() {
        return this.global.highResolutionFlag;
    }

    private void setHighResolution(boolean bl) {
        this.global.highResolutionFlag = bl;
    }

    private void setSsbondsBackbone(boolean bl) {
        this.global.ssbondsBackbone = bl;
    }

    String getLoadState() {
        return this.global.getLoadState();
    }

    public void setAutoBond(boolean bl) {
        this.global.setParameterValue("autobond", bl);
        this.global.autoBond = bl;
    }

    public boolean getAutoBond() {
        return this.global.autoBond;
    }

    int[] makeConnections(float f, float f2, short s, int n, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl) {
        this.clearMinimization();
        this.clearAllMeasurements();
        return this.modelSet.makeConnections(f, f2, s, n, bitSet, bitSet2, bitSet3, bl);
    }

    public void rebond() {
        this.clearMinimization();
        this.modelSet.deleteAllBonds();
        this.modelSet.autoBond(null, null, null, null);
        this.addStateScript("connect;", false, true);
        this.refresh(0, "Viewer:rebond()");
    }

    void setPdbConectBonding(boolean bl) {
        this.clearMinimization();
        this.modelSet.deleteAllBonds();
        BitSet bitSet = new BitSet();
        this.modelSet.setPdbConectBonding(0, 0, bitSet);
        if (bl) {
            this.modelSet.autoBond(null, null, bitSet, null);
            this.addStateScript("connect PDB AUTO;", false, true);
            return;
        }
        this.addStateScript("connect PDB;", false, true);
        this.refresh(0, "Viewer:setPdbConnectBonding()");
    }

    private void setGreyscaleRendering(boolean bl) {
        this.global.greyscaleRendering = bl;
        this.g3d.setGreyscaleMode(bl);
        this.refresh(0, "Viewer:setGreyscaleRendering()");
    }

    boolean getGreyscaleRendering() {
        return this.global.greyscaleRendering;
    }

    private void setDisablePopupMenu(boolean bl) {
        this.global.disablePopupMenu = bl;
    }

    boolean getDisablePopupMenu() {
        return this.global.disablePopupMenu;
    }

    private void setForceAutoBond(boolean bl) {
        this.global.forceAutoBond = bl;
    }

    public boolean getForceAutoBond() {
        return this.global.forceAutoBond;
    }

    public void setPercentVdwAtom(int n) {
        this.global.setParameterValue("percentVdwAtom", n);
        this.global.percentVdwAtom = n;
        this.setShapeSize(0, -n);
    }

    public int getPercentVdwAtom() {
        return this.global.percentVdwAtom;
    }

    public short getDefaultMadAtom() {
        return (short)(this.global.percentVdwAtom == 0 ? 0 : -2000 - this.global.percentVdwAtom);
    }

    public short getMadBond() {
        return (short)(this.global.bondRadiusMilliAngstroms * 2);
    }

    public short getMarBond() {
        return this.global.bondRadiusMilliAngstroms;
    }

    public byte getModeMultipleBond() {
        return this.global.modeMultipleBond;
    }

    private void setShowMultipleBonds(boolean bl) {
        this.global.showMultipleBonds = bl;
        this.refresh(0, "Viewer:setShowMultipleBonds()");
    }

    public boolean getShowMultipleBonds() {
        return this.global.showMultipleBonds;
    }

    public void setShowHydrogens(boolean bl) {
        this.global.setParameterValue("showHydrogens", bl);
        this.global.showHydrogens = bl;
        this.refresh(0, "Viewer:setShowHydrogens()");
    }

    public boolean getShowHydrogens() {
        return this.global.showHydrogens;
    }

    private void setShowHiddenSelectionHalos(boolean bl) {
        this.global.showHiddenSelectionHalos = bl;
        this.refresh(0, "Viewer:setShowHiddenSelectionHalos()");
    }

    public boolean getShowHiddenSelectionHalos() {
        return this.global.showHiddenSelectionHalos;
    }

    public void setShowBbcage(boolean bl) {
        this.setObjectMad(27, "boundbox", (short)(bl ? -4 : 0));
        this.global.setParameterValue("showBoundBox", bl);
    }

    public boolean getShowBbcage() {
        return this.getObjectMad(4) != 0;
    }

    public void setShowUnitCell(boolean bl) {
        this.setObjectMad(28, "unitcell", (short)(bl ? -2 : 0));
        this.global.setParameterValue("showUnitCell", bl);
    }

    public boolean getShowUnitCell() {
        return this.getObjectMad(5) != 0;
    }

    public void setShowAxes(boolean bl) {
        this.setObjectMad(26, "axes", (short)(bl ? -2 : 0));
        this.global.setParameterValue("showAxes", bl);
    }

    public boolean getShowAxes() {
        return this.getObjectMad(1) != 0;
    }

    public void setFrankOn(boolean bl) {
        this.frankOn = bl;
        this.setObjectMad(31, "frank", (short)(bl ? 1 : 0));
    }

    public boolean getShowFrank() {
        return this.isSignedApplet || this.getObjectMad(6) != 0;
    }

    public boolean isSignedApplet() {
        return this.isSignedApplet;
    }

    public void setShowMeasurements(boolean bl) {
        this.global.setParameterValue("showMeasurements", bl);
        this.global.showMeasurements = bl;
        this.refresh(0, "setShowMeasurements()");
    }

    public boolean getShowMeasurements() {
        return this.global.showMeasurements;
    }

    private void setShowMeasurementLabels(boolean bl) {
        this.global.measurementLabels = bl;
    }

    public boolean getShowMeasurementLabels() {
        return this.global.measurementLabels;
    }

    private void setMeasureAllModels(boolean bl) {
        this.global.measureAllModels = bl;
    }

    public boolean getMeasureAllModelsFlag() {
        return this.global.measureAllModels;
    }

    void setMeasureDistanceUnits(String string) {
        this.global.setMeasureDistanceUnits(string);
        this.setShapeProperty(5, "reformatDistances", null);
    }

    public String getMeasureDistanceUnits() {
        return this.global.getMeasureDistanceUnits();
    }

    private void setUseNumberLocalization(boolean bl) {
        this.global.useNumberLocalization = bl;
        TextFormat.setUseNumberLocalization(bl);
    }

    public boolean getUseNumberLocalization() {
        return this.global.useNumberLocalization;
    }

    void setAppendNew(boolean bl) {
        this.global.appendNew = bl;
    }

    public boolean getAppendNew() {
        return this.global.appendNew;
    }

    private void setAutoFps(boolean bl) {
        this.global.autoFps = bl;
    }

    boolean getAutoFps() {
        return this.global.autoFps;
    }

    public void setRasmolDefaults() {
        this.setDefaults("RasMol");
    }

    public void setJmolDefaults() {
        this.setDefaults("Jmol");
    }

    private void setDefaults(String string) {
        if (string.equalsIgnoreCase("RasMol")) {
            this.stateManager.setRasMolDefaults();
            return;
        }
        this.stateManager.setJmolDefaults();
        this.setShapeSize(0, this.getDefaultMadAtom(), this.getModelAtomBitSet(-1, true));
    }

    private void setZeroBasedXyzRasmol(boolean bl) {
        this.global.zeroBasedXyzRasmol = bl;
        this.reset();
    }

    public boolean getZeroBasedXyzRasmol() {
        return this.global.zeroBasedXyzRasmol;
    }

    private void setAntialias(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.global.antialiasDisplay = bl;
                break;
            }
            case 1: {
                this.global.antialiasTranslucent = bl;
                break;
            }
            case 2: {
                this.global.antialiasImages = bl;
                return;
            }
        }
        this.resizeImage(0, 0, false, false, true);
    }

    public Point3f[] allocTempPoints(int n) {
        return this.tempManager.allocTempPoints(n);
    }

    public void freeTempPoints(Point3f[] point3fArray) {
        this.tempManager.freeTempPoints(point3fArray);
    }

    public Point3i[] allocTempScreens(int n) {
        return this.tempManager.allocTempScreens(n);
    }

    public void freeTempScreens(Point3i[] point3iArray) {
        this.tempManager.freeTempScreens(point3iArray);
    }

    public byte[] allocTempBytes(int n) {
        return this.tempManager.allocTempBytes(n);
    }

    public void freeTempBytes(byte[] byArray) {
        this.tempManager.freeTempBytes(byArray);
    }

    Font3D getFont3D(String string, String string2, float f) {
        return this.g3d.getFont3D(string, string2, f);
    }

    public String formatText(String string) {
        int n = string.indexOf("@{");
        if (n < 0 && (n = string.indexOf("%{")) < 0) {
            return string;
        }
        String string2 = TextFormat.simpleReplace(string, "%{", "@{");
        while ((n = string2.indexOf("@{")) >= 0) {
            int n2;
            if (string2.indexOf("}", n2 = ++n + 1) < 0) {
                return string2;
            }
            int n3 = 1;
            int n4 = string2.length();
            while (n3 > 0 && ++n < n4) {
                switch (string2.charAt(n)) {
                    case '{': {
                        ++n3;
                        break;
                    }
                    case '}': {
                        --n3;
                    }
                }
            }
            if (n3 != 0) {
                return string2;
            }
            String string3 = string2.substring(n2, n);
            if (string3.length() == 0) {
                return string2;
            }
            Object object = this.evaluateExpression(string3);
            if (object instanceof Point3f) {
                object = Escape.escape((Point3f)object);
            }
            string2 = string2.substring(0, n2 - 2) + object.toString() + string2.substring(n + 1);
        }
        return string2;
    }

    String getElementSymbol(int n) {
        return this.modelSet.getElementSymbol(n);
    }

    int getElementNumber(int n) {
        return this.modelSet.getElementNumber(n);
    }

    public String getAtomName(int n) {
        return this.modelSet.getAtomName(n);
    }

    public int getAtomNumber(int n) {
        return this.modelSet.getAtomNumber(n);
    }

    float getAtomX(int n) {
        return this.modelSet.getAtomX(n);
    }

    float getAtomY(int n) {
        return this.modelSet.getAtomY(n);
    }

    float getAtomZ(int n) {
        return this.modelSet.getAtomZ(n);
    }

    public Point3f getAtomPoint3f(int n) {
        return this.modelSet.getAtomAt(n);
    }

    public float getAtomRadius(int n) {
        return this.modelSet.getAtomRadius(n);
    }

    public float getAtomVdwRadius(int n) {
        return this.modelSet.getAtomVdwRadius(n);
    }

    public int getAtomArgb(int n) {
        return this.g3d.getColixArgb(this.modelSet.getAtomColix(n));
    }

    String getAtomChain(int n) {
        return this.modelSet.getAtomChain(n);
    }

    public int getAtomModelIndex(int n) {
        return this.modelSet.getAtomModelIndex(n);
    }

    String getAtomSequenceCode(int n) {
        return this.modelSet.getAtomSequenceCode(n);
    }

    public float getBondRadius(int n) {
        return this.modelSet.getBondRadius(n);
    }

    public short getBondOrder(int n) {
        return this.modelSet.getBondOrder(n);
    }

    void assignAromaticBonds() {
        this.modelSet.assignAromaticBonds();
    }

    public boolean getSmartAromatic() {
        return this.global.smartAromatic;
    }

    private void setSmartAromatic(boolean bl) {
        this.global.smartAromatic = bl;
    }

    void resetAromatic() {
        this.modelSet.resetAromatic();
    }

    public int getBondArgb1(int n) {
        return this.g3d.getColixArgb(this.modelSet.getBondColix1(n));
    }

    public int getBondModelIndex(int n) {
        return this.modelSet.getBondModelIndex(n);
    }

    public int getBondArgb2(int n) {
        return this.g3d.getColixArgb(this.modelSet.getBondColix2(n));
    }

    public Point3f[] getPolymerLeadMidPoints(int n, int n2) {
        return this.modelSet.getPolymerLeadMidPoints(n, n2);
    }

    void setStereoMode(int n, String string) {
        this.global.stereoState = string;
        this.transformManager.setStereoMode(n);
        this.setBooleanProperty("greyscaleRendering", n > 1);
    }

    void setStereoMode(int[] nArray, String string) {
        this.global.stereoState = string;
        this.transformManager.setStereoMode(nArray);
        this.setBooleanProperty("greyscaleRendering", true);
    }

    int getStereoMode() {
        return this.transformManager.stereoMode;
    }

    float getStereoDegrees() {
        return this.transformManager.stereoDegrees;
    }

    private void setStereoDegrees(float f) {
        this.transformManager.setStereoDegrees(f);
    }

    public boolean isJvm12orGreater() {
        return this.jvm12orGreater;
    }

    public String getOperatingSystemName() {
        return this.strOSName;
    }

    public String getJavaVendor() {
        return this.strJavaVendor;
    }

    public String getJavaVersion() {
        return this.strJavaVersion;
    }

    public Graphics3D getGraphics3D() {
        return this.g3d;
    }

    public boolean showModelSetDownload() {
        return true;
    }

    public Object getProperty(String string, String string2, String string3) {
        return this.getProperty(string, string2, (Object)string3);
    }

    public Object getProperty(String string, String string2, Object object) {
        return PropertyManager.getProperty(this, string, string2, object);
    }

    String getModelExtract(Object object) {
        return this.fileManager.getFullPathName() + "\nJmol version " + Viewer.getJmolVersion() + "\nEXTRACT: " + object + "\n" + this.modelSet.getModelExtract(this.getAtomBitSet(object));
    }

    public String getHexColorFromIndex(short s) {
        return this.g3d.getHexColorFromIndex(s);
    }

    void setModelVisibility() {
        if (this.modelSet == null) {
            return;
        }
        this.modelSet.setModelVisibility();
    }

    void setFrameTitle(int n, String string) {
        this.modelSet.setFrameTitle(n, string);
    }

    String getFrameTitle(int n) {
        return this.modelSet.getFrameTitle(n);
    }

    void setTainted(boolean bl) {
        this.isTainted = bl && this.refreshing;
        this.axesAreTainted = bl && this.refreshing;
    }

    Point3f checkObjectClicked(int n, int n2, int n3) {
        return this.modelSet.checkObjectClicked(n, n2, n3, this.getVisibleFramesBitSet());
    }

    boolean checkObjectHovered(int n, int n2) {
        if (this.modelSet == null) {
            return false;
        }
        return this.modelSet.checkObjectHovered(n, n2, this.getVisibleFramesBitSet());
    }

    void checkObjectDragged(int n, int n2, int n3, int n4, int n5) {
        this.modelSet.checkObjectDragged(n, n2, n3, n4, n5, this.getVisibleFramesBitSet());
    }

    void rotateAxisAngleAtCenter(Point3f point3f, Vector3f vector3f, float f, float f2, boolean bl, BitSet bitSet) {
        this.transformManager.rotateAxisAngleAtCenter(point3f, vector3f, f, f2, bl, bitSet);
        this.refresh(-1, "rotateAxisAngleAtCenter");
    }

    void rotateAboutPointsInternal(Point3f point3f, Point3f point3f2, float f, float f2, boolean bl, BitSet bitSet) {
        this.transformManager.rotateAboutPointsInternal(point3f, point3f2, f, f2, false, bl, bitSet);
        this.refresh(-1, "rotateAxisAboutPointsInternal");
    }

    private void setPickingSpinRate(int n) {
        if (n < 1) {
            n = 1;
        }
        this.global.pickingSpinRate = n;
    }

    int getPickingSpinRate() {
        return this.global.pickingSpinRate;
    }

    public void startSpinningAxis(int n, int n2, boolean bl) {
        Atom atom = this.modelSet.getAtomAt(n);
        Atom atom2 = this.modelSet.getAtomAt(n2);
        this.startSpinningAxis(atom, atom2, bl);
    }

    public void startSpinningAxis(Point3f point3f, Point3f point3f2, boolean bl) {
        if (this.getSpinOn()) {
            this.setSpinOn(false);
            return;
        }
        this.transformManager.rotateAboutPointsInternal(point3f, point3f2, this.global.pickingSpinRate, Float.MAX_VALUE, bl, true, null);
    }

    public Vector3f getModelDipole() {
        return this.modelSet.getModelDipole(this.getDisplayModelIndex());
    }

    public Vector3f calculateMolecularDipole() {
        return this.modelSet.calculateMolecularDipole(this.getDisplayModelIndex());
    }

    private void setDipoleScale(float f) {
        this.global.dipoleScale = f;
    }

    public float getDipoleScale() {
        return this.global.dipoleScale;
    }

    public void getAtomIdentityInfo(int n, Hashtable hashtable) {
        this.modelSet.getAtomIdentityInfo(n, hashtable);
    }

    void setDefaultLattice(Point3f point3f) {
        this.global.setDefaultLattice(point3f);
        this.global.setParameterValue("defaultLattice", Escape.escape(point3f));
    }

    Point3f getDefaultLattice() {
        return this.global.getDefaultLatticePoint();
    }

    BitSet getTaintedAtoms(byte by) {
        return this.modelSet.getTaintedAtoms(by);
    }

    public void setTaintedAtoms(BitSet bitSet, byte by) {
        this.modelSet.setTaintedAtoms(bitSet, by);
    }

    public String getData(String string, String string2) {
        String string3 = "";
        string3 = string2.toLowerCase().indexOf("property_") == 0 ? "{selected}.label(\"%{" + string2 + "}\")" : (string2.equalsIgnoreCase("PDB") ? "{selected and not hetero}.label(\"ATOM  %5i %-4a%1A%3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines+{selected and hetero}.label(\"HETATM%5i %-4a%1A%3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines" : (string2.equalsIgnoreCase("MOL") ? "\"line1\nline2\nline3\n\"+(\"\"+{selected}.size)%-3+(\"\"+{selected}.bonds.size)%-3+\"  0  0  0\n\"+{selected}.labels(\"%10.4x%10.4y%10.4z %-2e  0  0  0  0  0\").lines+{selected}.bonds.labels(\"%3D1%3D2%3ORDER  0  0  0\").lines" : "\"\" + {selected}.size + \"\n\n\"+{selected}.label(\"%-2e %10.5x %10.5y %10.5z\").lines"));
        if (!string.equals("selected")) {
            string3 = TextFormat.simpleReplace(string3, "selected", string);
        }
        return (String)this.evaluateExpression(string3);
    }

    public synchronized Object evaluateExpression(Object object) {
        return Eval.evaluateExpression(this, object);
    }

    public String getPdbData(BitSet bitSet) {
        if (bitSet == null) {
            bitSet = this.getSelectionSet();
        }
        return this.modelSet.getPdbAtomData(bitSet);
    }

    String getPdbData(int n, String string) {
        return this.modelSet.getPdbData(n, string, this.selectionManager.bsSelection);
    }

    public boolean isJmolDataFrame(int n) {
        return this.modelSet.isJmolDataFrame(n);
    }

    public boolean isJmolDataFrame() {
        return this.modelSet.isJmolDataFrame(this.repaintManager.currentModelIndex);
    }

    int getJmolDataFrameIndex(int n, String string) {
        return this.modelSet.getJmolDataFrameIndex(n, string);
    }

    void setJmolDataFrame(String string, int n, int n2) {
        this.modelSet.setJmolDataFrame(string, n, n2);
    }

    void setFrameTitle(String string) {
        this.loadShape(29);
        this.modelSet.setFrameTitle(this.repaintManager.currentModelIndex, string);
    }

    public String getFrameTitle() {
        return this.modelSet.getFrameTitle(this.repaintManager.currentModelIndex);
    }

    String getJmolFrameType(int n) {
        return this.modelSet.getJmolFrameType(n);
    }

    public int getJmolDataSourceFrame(int n) {
        return this.modelSet.getJmolDataSourceFrame(n);
    }

    void setAtomProperty(BitSet bitSet, int n, int n2, float f, float[] fArray) {
        this.modelSet.setAtomProperty(bitSet, n, n2, f, fArray);
        switch (n) {
            case 3146112: 
            case 3146113: 
            case 3146114: 
            case 3146115: 
            case 3146116: 
            case 3146117: {
                this.refreshMeasures();
            }
        }
    }

    public void setAtomCoord(int n, float f, float f2, float f3) {
        this.modelSet.setAtomCoord(n, f, f2, f3);
    }

    void setAtomCoord(BitSet bitSet, int n, Object object) {
        this.modelSet.setAtomCoord(bitSet, n, object);
        this.refreshMeasures();
    }

    public void setAtomCoordRelative(int n, float f, float f2, float f3) {
        this.modelSet.setAtomCoordRelative(n, f, f2, f3);
    }

    void setAtomCoordRelative(Point3f point3f) {
        this.modelSet.setAtomCoordRelative(point3f, this.selectionManager.bsSelection);
        this.refreshMeasures();
    }

    void setAllowRotateSelected(boolean bl) {
        this.global.allowRotateSelected = bl;
    }

    boolean allowRotateSelected() {
        return this.global.allowRotateSelected;
    }

    void invertSelected(Point3f point3f, BitSet bitSet) {
        this.modelSet.invertSelected(point3f, null, bitSet);
        this.refreshMeasures();
    }

    void invertSelected(Point3f point3f, Point4f point4f) {
        this.modelSet.invertSelected(point3f, point4f, this.selectionManager.bsSelection);
        this.refreshMeasures();
    }

    void rotateAtoms(Matrix3f matrix3f, Matrix3f matrix3f2, boolean bl, Point3f point3f, boolean bl2, BitSet bitSet) {
        this.modelSet.rotateAtoms(matrix3f, matrix3f2, bitSet, bl, point3f, bl2);
        this.refreshMeasures();
    }

    public void refreshMeasures() {
        this.setShapeProperty(5, "refresh", null);
    }

    void setDynamicMeasurements(boolean bl) {
        this.global.dynamicMeasurements = bl;
    }

    public boolean getDynamicMeasurements() {
        return this.global.dynamicMeasurements;
    }

    public float[][] functionXY(String string, int n, int n2) {
        float[][] fArray;
        String string2 = null;
        if (string.indexOf("file:") == 0) {
            string2 = this.getFileAsString(string.substring(5));
        } else if (string.indexOf("data2d_") != 0) {
            return this.statusManager.functionXY(string, n, n2);
        }
        n = Math.abs(n);
        n2 = Math.abs(n2);
        if (string2 == null) {
            fArray = this.getDataFloat2D(string);
            if (fArray != null) {
                return fArray;
            }
            string2 = "";
        }
        fArray = new float[n][n2];
        float[] fArray2 = new float[n * n2];
        Parser.parseFloatArray(string2, null, fArray2);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray[i][j] = fArray2[n3++];
            }
        }
        return fArray;
    }

    String eval(String string) {
        return this.statusManager.eval(string);
    }

    private void setHelpPath(String string) {
        this.global.helpPath = string;
    }

    void getHelp(String string) {
        if (string.length() > 0 && string.indexOf("?") != 0 && this.global.helpPath.indexOf("?") < 0) {
            string = "?search=" + string;
        }
        this.showUrl(this.global.helpPath + string);
    }

    void addCommand(String string) {
        this.commandHistory.addCommand(string);
    }

    String removeCommand() {
        return this.commandHistory.removeCommand();
    }

    public String getSetHistory(int n) {
        return this.commandHistory.getSetHistory(n);
    }

    private void createImage(String string) {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            string = "JPG:jmol.jpg";
        }
        if (string.indexOf(":") < 0) {
            string = string + ":jmol.jpg";
        }
        int n = string.indexOf(":");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String string4 = "-1";
        String string5 = "-1";
        String string6 = "75";
        n = string3.indexOf(9);
        if (n > 0) {
            string4 = string3.substring(n + 1);
            string3 = string3.substring(0, n);
        }
        if ((n = string4.indexOf(9)) > 0) {
            string5 = string4.substring(n + 1);
            string4 = string4.substring(0, n);
        }
        if ((n = string5.indexOf(9)) > 0) {
            string6 = string5.substring(n + 1);
            string5 = string5.substring(0, n);
        }
        try {
            int n2 = Integer.parseInt(string4);
            int n3 = Integer.parseInt(string5);
            int n4 = Integer.parseInt(string6);
            this.createImage(string3, string2, n4, n2, n3);
        }
        catch (Exception exception) {
            System.out.println("error processing write request: " + string);
        }
    }

    public float getImageFontScaling() {
        return this.imageFontScaling;
    }

    public void createImage(String string, Object object, int n, int n2, int n3) {
        int n4 = this.dimScreen.width;
        int n5 = this.dimScreen.height;
        if (n != Integer.MIN_VALUE) {
            this.resizeImage(n2, n3, true, false, false);
            this.setModelVisibility();
        }
        try {
            this.statusManager.createImage(string, object, n);
        }
        catch (Exception exception) {
            Logger.error("Error creating image: " + exception.getMessage());
        }
        if (n != Integer.MIN_VALUE) {
            this.resizeImage(n4, n5, true, false, true);
        }
    }

    private void setImageFontScaling(int n, int n2) {
        float f = this.global.zoomLarge == n2 > n ? n2 : n;
        this.imageFontScaling = f / (float)this.getScreenDim();
    }

    private void setSyncTarget(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.syncingMouse = bl;
                break;
            }
            case 1: {
                this.syncingScripts = bl;
            }
        }
        if (!this.syncingScripts && !this.syncingMouse) {
            this.refresh(-1, "set sync");
        }
    }

    public void syncScript(String string, String string2) {
        boolean bl;
        boolean bl2 = "*".equals(string2);
        boolean bl3 = ">".equals(string2);
        boolean bl4 = "~".equals(string2);
        boolean bl5 = bl = bl4 || ".".equals(string2);
        if (!bl) {
            this.statusManager.syncSend(string, bl2 || bl3 ? null : string2);
            if (!bl2) {
                return;
            }
        }
        if (string.equalsIgnoreCase("on")) {
            this.statusManager.setSyncDriver(1);
            return;
        }
        if (string.equalsIgnoreCase("off")) {
            this.statusManager.setSyncDriver(0);
            return;
        }
        if (string.equalsIgnoreCase("slave")) {
            this.statusManager.setSyncDriver(2);
            return;
        }
        int n = this.statusManager.getSyncMode();
        if (n == 0) {
            return;
        }
        if (n != 1) {
            bl4 = false;
        }
        if (Logger.debugging) {
            Logger.debug(this.htmlName + " syncing with script: " + string);
        }
        if (bl4) {
            this.statusManager.setSyncDriver(3);
        }
        if (string.indexOf("Mouse: ") != 0) {
            this.evalStringQuiet(string, true, false);
            return;
        }
        String[] stringArray = Parser.getTokens(string);
        String string3 = stringArray[1];
        switch (stringArray.length) {
            case 3: {
                if (string3.equals("zoomByFactor")) {
                    this.zoomByFactor(Parser.parseFloat(stringArray[2]));
                    break;
                }
                if (string3.equals("zoomBy")) {
                    this.zoomBy(Parser.parseInt(stringArray[2]));
                    break;
                }
                if (!string3.equals("rotateZBy")) break;
                this.rotateZBy(Parser.parseInt(stringArray[2]));
                break;
            }
            case 4: {
                if (string3.equals("rotateXYBy")) {
                    this.rotateXYBy(Parser.parseInt(stringArray[2]), Parser.parseInt(stringArray[3]));
                    break;
                }
                if (string3.equals("translateXYBy")) {
                    this.translateXYBy(Parser.parseInt(stringArray[2]), Parser.parseInt(stringArray[3]));
                    break;
                }
                if (!string3.equals("rotateMolecule")) break;
                this.rotateMolecule(Parser.parseInt(stringArray[2]), Parser.parseInt(stringArray[3]));
            }
        }
        if (bl4) {
            this.setSyncDriver(4);
        }
    }

    void setSyncDriver(int n) {
        this.statusManager.setSyncDriver(n);
    }

    public float[] getPartialCharges() {
        return this.modelSet.getPartialCharges();
    }

    void setProteinType(byte by, BitSet bitSet) {
        this.modelSet.setProteinType(bitSet == null ? this.selectionManager.bsSelection : bitSet, by);
    }

    void setMenu(String string, boolean bl) {
        if (bl) {
            Logger.info("Setting menu " + (string.length() == 0 ? "to Jmol defaults" : "from file " + string));
        }
        if (string.length() == 0) {
            string = null;
        } else if (bl) {
            string = this.fileManager.getFileAsString(string);
        }
        this.statusManager.setCallbackFunction("menu", string);
    }

    String getMenu(String string) {
        return this.statusManager.eval("_GET_MENU|" + string);
    }

    void setListVariable(String string, Token token) {
        this.global.setListVariable(string, token);
    }

    Object getListVariable(String string, Object object) {
        return this.global.getListVariable(string, object);
    }

    public Point3f getBondPoint3f1(int n) {
        return this.modelSet.getBondAtom1(n);
    }

    public Point3f getBondPoint3f2(int n) {
        return this.modelSet.getBondAtom2(n);
    }

    float getVibrationCoord(int n, char c) {
        return this.modelSet.getVibrationCoord(n, c);
    }

    public Vector3f getVibrationVector(int n) {
        return this.modelSet.getVibrationVector(n);
    }

    public int getVanderwaalsMar(int n) {
        return this.dataManager.defaultVdw == 3 ? this.dataManager.userVdwMars[n] : JmolConstants.getVanderwaalsMar(n, this.dataManager.defaultVdw);
    }

    public int getVanderwaalsMar(int n, int n2) {
        if (n2 == 3 && this.dataManager.bsUserVdws == null) {
            n2 = this.dataManager.defaultVdw;
        }
        return n2 == 3 ? this.dataManager.userVdwMars[n] : JmolConstants.getVanderwaalsMar(n, n2);
    }

    void setDefaultVdw(String string) {
        this.dataManager.setDefaultVdw(string);
        this.global.setParameterValue("defaultVDW", this.getDefaultVdw(Integer.MIN_VALUE));
    }

    String getDefaultVdw(int n) {
        return this.dataManager.getDefaultVdw(n, null);
    }

    public int deleteAtoms(BitSet bitSet, boolean bl) {
        this.clearMinimization();
        if (!bl) {
            return this.selectionManager.deleteAtoms(bitSet);
        }
        this.fileManager.addLoadScript("zap " + Escape.escape(bitSet));
        this.setCurrentModelIndex(0, false);
        this.repaintManager.setAnimationOn(false);
        BitSet bitSet2 = this.modelSet.deleteAtoms(bitSet, true);
        this.setAnimationRange(0, 0);
        this.eval.deleteAtomsInVariables(bitSet2);
        this.repaintManager.clear();
        this.repaintManager.initializePointers(1);
        if (this.getModelCount() > 1) {
            this.setCurrentModelIndex(-1, true);
        }
        this.hoverAtomIndex = -1;
        this.setStatusFileLoaded(0, null, null, null, null);
        this.refreshMeasures();
        return BitSetUtil.cardinalityOf(bitSet2);
    }

    public BitSet getDeletedAtoms() {
        return this.selectionManager.bsDeleted;
    }

    public char getQuaternionFrame() {
        return this.global.quaternionFrame.charAt(0);
    }

    void setQuaternionFrame(String string) {
        this.global.quaternionFrame = "" + (string.toLowerCase() + "c").charAt(0);
    }

    String calculatePointGroup() {
        return this.modelSet.calculatePointGroup(this.selectionManager.bsSelection);
    }

    public String getPointGroupDraw(int n) {
        return this.modelSet.getPointGroupDraw(n);
    }
}

