/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.api.JmolAdapter;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.ModelSet;
import org.jmol.viewer.Viewer;

public final class FrameExportJmolAdapter
extends JmolAdapter {
    Viewer viewer;
    ModelSet modelSet;

    FrameExportJmolAdapter(Viewer viewer, ModelSet modelSet) {
        super("FrameExportJmolAdapter");
        this.viewer = viewer;
        this.modelSet = modelSet;
    }

    public String getAtomSetCollectionName(Object object) {
        return this.viewer.getModelSetName();
    }

    public int getEstimatedAtomCount(Object object) {
        return this.modelSet.getAtomCount();
    }

    public float[] getNotionalUnitcell(Object object) {
        return this.modelSet.getNotionalUnitcell();
    }

    public JmolAdapter.AtomIterator getAtomIterator(Object object) {
        return new AtomIterator();
    }

    public JmolAdapter.BondIterator getBondIterator(Object object) {
        return new BondIterator();
    }

    class BondIterator
    extends JmolAdapter.BondIterator {
        int ibond;
        Bond bond;

        BondIterator() {
        }

        public boolean hasNext() {
            if (this.ibond >= FrameExportJmolAdapter.this.modelSet.getBondCount()) {
                return false;
            }
            this.bond = FrameExportJmolAdapter.this.modelSet.getBonds()[this.ibond++];
            return true;
        }

        public Object getAtomUniqueID1() {
            return new Integer(this.bond.getAtomIndex1());
        }

        public Object getAtomUniqueID2() {
            return new Integer(this.bond.getAtomIndex2());
        }

        public int getEncodedOrder() {
            return this.bond.getOrder();
        }
    }

    class AtomIterator
    extends JmolAdapter.AtomIterator {
        int iatom;
        Atom atom;

        AtomIterator() {
        }

        public boolean hasNext() {
            if (this.iatom == FrameExportJmolAdapter.this.modelSet.getAtomCount()) {
                return false;
            }
            this.atom = FrameExportJmolAdapter.this.modelSet.atoms[this.iatom++];
            return true;
        }

        public Object getUniqueID() {
            return new Integer(this.iatom);
        }

        public int getElementNumber() {
            return this.atom.getElementNumber();
        }

        public String getElementSymbol() {
            return this.atom.getElementSymbol();
        }

        public int getFormalCharge() {
            return this.atom.getFormalCharge();
        }

        public float getPartialCharge() {
            return this.atom.getPartialCharge();
        }

        public float getX() {
            return this.atom.x;
        }

        public float getY() {
            return this.atom.y;
        }

        public float getZ() {
            return this.atom.z;
        }
    }
}

