/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class ColorManager {
    private Viewer viewer;
    private Graphics3D g3d;
    private int[] argbsCpk;
    private int[] altArgbsCpk;
    private float colorHi;
    private float colorLo;
    private float[] colorData;
    private int palette = 0;
    private boolean isDefaultColorRasmol;
    short colixRubberband = (short)22;
    short colixBackgroundContrast;

    ColorManager(Viewer viewer, Graphics3D graphics3D) {
        this.viewer = viewer;
        this.g3d = graphics3D;
        this.argbsCpk = JmolConstants.argbsCpk;
        this.altArgbsCpk = ArrayUtil.arrayCopy(JmolConstants.altArgbsCpk, 0, -1, false);
    }

    void clear() {
    }

    boolean getDefaultColorRasmol() {
        return this.isDefaultColorRasmol;
    }

    void resetElementColors() {
        this.setDefaultColors("Jmol");
    }

    void setDefaultColors(String string) {
        if (string.equalsIgnoreCase("Jmol")) {
            this.isDefaultColorRasmol = false;
            this.argbsCpk = JmolConstants.argbsCpk;
        } else if (string.equalsIgnoreCase("RasMol")) {
            this.isDefaultColorRasmol = true;
            this.argbsCpk = ColorEncoder.getRasmolScale(true);
        } else {
            Logger.error("unrecognized color scheme");
            return;
        }
        this.altArgbsCpk = ArrayUtil.arrayCopy(JmolConstants.altArgbsCpk, 0, -1, false);
        ColorEncoder.makeColorScheme(string, null, true);
        int n = JmolConstants.argbsCpk.length;
        while (--n >= 0) {
            this.g3d.changeColixArgb((short)n, this.argbsCpk[n]);
        }
        n = JmolConstants.altArgbsCpk.length;
        while (--n >= 0) {
            this.g3d.changeColixArgb((short)(JmolConstants.elementNumberMax + n), this.altArgbsCpk[n]);
        }
    }

    void setRubberbandArgb(int n) {
        this.colixRubberband = n == 0 ? (short)0 : Graphics3D.getColix(n);
    }

    void setColixBackgroundContrast(int n) {
        this.colixBackgroundContrast = (short)((Graphics3D.calcGreyscaleRgbFromRgb(n) & 0xFF) < 128 ? 8 : 4);
    }

    short getColixAtomPalette(Atom atom, byte by) {
        int n = 0;
        switch (by) {
            case 83: {
                return this.getPropertyColix(atom.getAtomIndex());
            }
            case 0: 
            case 1: {
                short s = atom.getAtomicAndIsotopeNumber();
                if (s < 256) {
                    return this.g3d.getChangeableColix(s, this.argbsCpk[s]);
                }
                s = (short)JmolConstants.altElementIndexFromNumber(s);
                return this.g3d.getChangeableColix((short)(JmolConstants.elementNumberMax + s), this.altArgbsCpk[s]);
            }
            case 2: {
                int n2 = ColorEncoder.quantize(atom.getPartialCharge(), -1.0f, 1.0f, 31);
                return this.g3d.getChangeableColix((short)(JmolConstants.PARTIAL_CHARGE_COLIX_RED + n2), JmolConstants.argbsRwbScale[n2]);
            }
            case 3: {
                int n3 = atom.getFormalCharge() - -4;
                return this.g3d.getChangeableColix((short)(JmolConstants.FORMAL_CHARGE_COLIX_RED + n3), JmolConstants.argbsFormalCharge[n3]);
            }
            case 5: 
            case 68: {
                float f;
                float f2;
                if (by == 68) {
                    ModelSet modelSet = this.viewer.getModelSet();
                    f2 = modelSet.getBfactor100Lo();
                    f = modelSet.getBfactor100Hi();
                } else {
                    f2 = 0.0f;
                    f = 10000.0f;
                }
                return ColorEncoder.getColorIndexFromPalette(atom.getBfactor100(), f2, f, 3);
            }
            case 85: {
                return ColorEncoder.getColorIndexFromPalette(atom.getStraightness(), -1.0f, 1.0f, 3);
            }
            case 70: {
                float f = this.viewer.getSurfaceDistanceMax();
                return ColorEncoder.getColorIndexFromPalette(atom.getSurfaceDistance100(), 0.0f, f, 3);
            }
            case 8: {
                return ColorEncoder.getColorIndexFromPalette(atom.getGroupID(), 0.0f, 0.0f, 9);
            }
            case 9: {
                return ColorEncoder.getColorIndexFromPalette(atom.getGroupID(), 0.0f, 0.0f, 8);
            }
            case 75: {
                return ColorEncoder.getColorIndexFromPalette(atom.getSelectedGroupIndexWithinChain(), 0.0f, atom.getSelectedGroupCountWithinChain() - 1, 1);
            }
            case 76: {
                return ColorEncoder.getColorIndexFromPalette(atom.getSelectedMonomerIndexWithinPolymer(), 0.0f, atom.getSelectedMonomerCountWithinPolymer() - 1, 1);
            }
            case 77: {
                ModelSet modelSet = this.viewer.getModelSet();
                return ColorEncoder.getColorIndexFromPalette(modelSet.getMoleculeIndex(atom.getAtomIndex()), 0.0f, modelSet.getMoleculeCountInModel(atom.getModelIndex()) - 1, 0);
            }
            case 14: {
                ModelSet modelSet = this.viewer.getModelSet();
                int n4 = atom.getModelIndex();
                return ColorEncoder.getColorIndexFromPalette(modelSet.getAltLocIndexInModel(n4, atom.getAlternateLocationID()), 0.0f, modelSet.getAltLocCountInModel(n4), 0);
            }
            case 15: {
                ModelSet modelSet = this.viewer.getModelSet();
                int n5 = atom.getModelIndex();
                return ColorEncoder.getColorIndexFromPalette(modelSet.getInsertionCodeIndexInModel(n5, atom.getInsertionCode()), 0.0f, modelSet.getInsertionCountInModel(n5), 0);
            }
            case 16: {
                short s = atom.getAtomicAndIsotopeNumber();
                n = ColorManager.getJmolOrRasmolArgb(s, 67108887);
                break;
            }
            case 17: {
                short s = atom.getAtomicAndIsotopeNumber();
                n = ColorManager.getJmolOrRasmolArgb(s, 67108909);
                break;
            }
            case 7: {
                n = JmolConstants.argbsStructure[atom.getProteinStructureType()];
                break;
            }
            case 10: {
                int n6 = atom.getChainID() & 0x1F;
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n6 >= JmolConstants.argbsChainAtom.length) {
                    n6 %= JmolConstants.argbsChainAtom.length;
                }
                n = (atom.isHetero() ? JmolConstants.argbsChainHetero : JmolConstants.argbsChainAtom)[n6];
            }
        }
        return n == 0 ? (short)22 : (short)Graphics3D.getColix(n);
    }

    private short getPropertyColix(int n) {
        if (this.colorData == null || n >= this.colorData.length) {
            return 12;
        }
        return this.getColixForPropertyValue(this.colorData[n]);
    }

    private static int getJmolOrRasmolArgb(int n, int n2) {
        switch (n2) {
            case 67108887: {
                if (n >= 256) break;
                return ColorEncoder.getArgbFromPalette(n, 0.0f, 0.0f, 6);
            }
            case 67108909: {
                if (n >= 256) break;
                return ColorEncoder.getArgbFromPalette(n, 0.0f, 0.0f, 7);
            }
            default: {
                return n2;
            }
        }
        return JmolConstants.altArgbsCpk[JmolConstants.altElementIndexFromNumber(n)];
    }

    void setElementArgb(int n, int n2) {
        if (n2 == 67108887 && this.argbsCpk == JmolConstants.argbsCpk) {
            return;
        }
        n2 = ColorManager.getJmolOrRasmolArgb(n, n2);
        if (this.argbsCpk == JmolConstants.argbsCpk) {
            this.argbsCpk = ArrayUtil.arrayCopy(JmolConstants.argbsCpk, 0, -1, false);
            this.altArgbsCpk = ArrayUtil.arrayCopy(JmolConstants.altArgbsCpk, 0, -1, false);
        }
        if (n < 256) {
            this.argbsCpk[n] = n2;
            this.g3d.changeColixArgb((short)n, n2);
            return;
        }
        n = JmolConstants.altElementIndexFromNumber(n);
        this.altArgbsCpk[n] = n2;
        this.g3d.changeColixArgb((short)(JmolConstants.elementNumberMax + n), n2);
    }

    int setColorScheme(String string, boolean bl) {
        this.palette = ColorEncoder.getColorScheme(string, bl);
        Logger.info("ColorManager: color scheme now \"" + ColorEncoder.getColorSchemeName(this.palette) + "\" color value range: " + this.colorLo + " to " + this.colorHi);
        return this.palette;
    }

    float[] getCurrentColorRange() {
        return new float[]{this.colorLo, this.colorHi};
    }

    void setCurrentColorRange(float[] fArray, BitSet bitSet, String string) {
        this.colorData = fArray;
        this.palette = ColorEncoder.getColorScheme(string, false);
        this.colorHi = Float.MIN_VALUE;
        this.colorLo = Float.MAX_VALUE;
        if (fArray == null) {
            return;
        }
        int n = fArray.length;
        while (--n >= 0) {
            float f;
            if (bitSet != null && !bitSet.get(n) || Float.isNaN(f = fArray[n])) continue;
            this.colorHi = Math.max(this.colorHi, f);
            this.colorLo = Math.min(this.colorLo, f);
        }
        this.setCurrentColorRange(this.colorLo, this.colorHi);
    }

    void setCurrentColorRange(float f, float f2) {
        this.colorHi = f2;
        this.colorLo = f;
        Logger.info("color \"" + ColorEncoder.getColorSchemeName(this.palette) + "\" range " + this.colorLo + " " + this.colorHi);
    }

    static String getState(StringBuffer stringBuffer) {
        return ColorEncoder.getState(stringBuffer);
    }

    static void setUserScale(int[] nArray) {
        ColorEncoder.setUserScale(nArray);
    }

    int[] getColorSchemeArray(String string) {
        return ColorEncoder.getColorSchemeArray(string == null || string.length() == 0 ? this.palette : ColorEncoder.getColorScheme(string, false));
    }

    String getColorSchemeList(String string, boolean bl) {
        if (!bl && ColorEncoder.getColorScheme(string, false) >= 0) {
            return "";
        }
        return ColorEncoder.getColorSchemeList(this.getColorSchemeArray(string));
    }

    short getColixForPropertyValue(float f) {
        return this.colorLo < this.colorHi ? ColorEncoder.getColorIndexFromPalette(f, this.colorLo, this.colorHi, this.palette) : ColorEncoder.getColorIndexFromPalette(-f, -this.colorLo, -this.colorHi, this.palette);
    }

    private static void flushCaches() {
        Graphics3D.flushShadesAndSphereCaches();
    }

    static void setSpecular(boolean bl) {
        if (Graphics3D.getSpecular() == bl) {
            return;
        }
        Graphics3D.setSpecular(bl);
        ColorManager.flushCaches();
    }

    static boolean getSpecular() {
        return Graphics3D.getSpecular();
    }

    static void setSpecularPercent(int n) {
        if (Graphics3D.getSpecularPercent() == n) {
            return;
        }
        Graphics3D.setSpecularPercent(n);
        ColorManager.flushCaches();
    }

    static int getSpecularPercent() {
        return Graphics3D.getSpecularPercent();
    }

    static void setSpecularPower(int n) {
        if (n < 0) {
            if (Graphics3D.getSpecularExponent() == -n) {
                return;
            }
            Graphics3D.setSpecularExponent(-n);
        } else {
            if (Graphics3D.getSpecularPower() == n) {
                return;
            }
            Graphics3D.setSpecularPower(n);
        }
        ColorManager.flushCaches();
    }

    static void setDiffusePercent(int n) {
        if (Graphics3D.getDiffusePercent() == n) {
            return;
        }
        Graphics3D.setDiffusePercent(n);
        ColorManager.flushCaches();
    }

    static int getDiffusePercent() {
        return Graphics3D.getDiffusePercent();
    }

    static void setAmbientPercent(int n) {
        if (Graphics3D.getAmbientPercent() == n) {
            return;
        }
        Graphics3D.setAmbientPercent(n);
        ColorManager.flushCaches();
    }

    static int getAmbientPercent() {
        return Graphics3D.getAmbientPercent();
    }
}

