/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.util.Quadric;

public class UnitCell {
    static final float toRadians = (float)Math.PI / 180;
    static final Point3f[] unitCubePoints = new Point3f[]{new Point3f(0.0f, 0.0f, 0.0f), new Point3f(0.0f, 0.0f, 1.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 1.0f, 1.0f), new Point3f(1.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 1.0f), new Point3f(1.0f, 1.0f, 0.0f), new Point3f(1.0f, 1.0f, 1.0f)};
    public static final int INFO_A = 0;
    public static final int INFO_B = 1;
    public static final int INFO_C = 2;
    public static final int INFO_ALPHA = 3;
    public static final int INFO_BETA = 4;
    public static final int INFO_GAMMA = 5;
    float a;
    float b;
    float c;
    float alpha;
    float beta;
    float gamma;
    float[] notionalUnitcell;
    Matrix4f matrixNotional;
    Matrix4f matrixCartesianToFractional;
    Matrix4f matrixFractionalToCartesian;
    Point3f[] vertices;
    Point3f cartesianOffset = new Point3f();
    Point3f fractionalOffset = new Point3f();
    private Data data;

    public UnitCell(float[] fArray) {
        this.setUnitCell(fArray);
    }

    public final void toCartesian(Point3f point3f) {
        if (this.matrixFractionalToCartesian == null) {
            return;
        }
        this.matrixFractionalToCartesian.transform(point3f);
    }

    public final void toFractional(Point3f point3f) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        this.matrixCartesianToFractional.transform(point3f);
    }

    private final void toFractionalUnitCell(Point3f point3f) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        this.matrixCartesianToFractional.transform(point3f);
        point3f.x = (float)((double)point3f.x - Math.floor(point3f.x));
        point3f.y = (float)((double)point3f.y - Math.floor(point3f.y));
        point3f.z = (float)((double)point3f.z - Math.floor(point3f.z));
    }

    public final void toUnitCell(Point3f point3f, Point3f point3f2) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        this.toFractionalUnitCell(point3f);
        if (point3f2 == null) {
            point3f2 = this.fractionalOffset;
        }
        point3f.add(point3f2);
        this.matrixFractionalToCartesian.transform(point3f);
    }

    public void setOffset(Point3f point3f) {
        this.fractionalOffset.set(point3f);
        this.cartesianOffset.set(point3f);
        this.matrixFractionalToCartesian.transform(this.cartesianOffset);
    }

    public void setOffset(int n) {
        this.setOffset(UnitCell.ijkToPoint3f(n));
    }

    public static Point3f ijkToPoint3f(int n) {
        Point3f point3f = new Point3f();
        point3f.x = n / 100 - 5;
        point3f.y = n % 100 / 10 - 5;
        point3f.z = n % 10 - 5;
        return point3f;
    }

    public final String dumpInfo(boolean bl) {
        return "a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", alpha=" + this.alpha + ", beta=" + this.beta + ", gamma=" + this.gamma + (bl ? "\nfractional to cartesian: " + this.matrixFractionalToCartesian + "\ncartesian to fractional: " + this.matrixCartesianToFractional : "");
    }

    public Point3f[] getVertices() {
        return this.vertices;
    }

    public Point3f getCartesianOffset() {
        return this.cartesianOffset;
    }

    public Point3f getFractionalOffset() {
        return this.fractionalOffset;
    }

    public float[] getNotionalUnitCell() {
        return this.notionalUnitcell;
    }

    public float getInfo(int n) {
        switch (n) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
            case 3: {
                return this.alpha;
            }
            case 4: {
                return this.beta;
            }
            case 5: {
                return this.gamma;
            }
        }
        return Float.NaN;
    }

    private void setUnitCell(float[] fArray) {
        if (fArray == null || fArray[0] == 0.0f) {
            return;
        }
        this.notionalUnitcell = fArray;
        this.a = fArray[0];
        this.b = fArray[1];
        this.c = fArray[2];
        this.alpha = fArray[3];
        this.beta = fArray[4];
        this.gamma = fArray[5];
        this.calcNotionalMatrix();
        this.constructFractionalMatrices();
        this.calcUnitcellVertices();
    }

    public Object[] getEllipsoid(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        if (this.data == null) {
            this.data = new Data();
        }
        return this.data.getEllipsoid(fArray);
    }

    private void calcNotionalMatrix() {
        this.matrixNotional = new Matrix4f();
        if (this.data == null) {
            this.data = new Data();
        }
        this.matrixNotional.setColumn(0, this.a, 0.0f, 0.0f, 0.0f);
        this.matrixNotional.setColumn(1, (float)((double)this.b * this.data.cosGamma), (float)((double)this.b * this.data.sinGamma), 0.0f, 0.0f);
        this.matrixNotional.setColumn(2, (float)((double)this.c * this.data.cosBeta), (float)((double)this.c * (this.data.cosAlpha - this.data.cosBeta * this.data.cosGamma) / this.data.sinGamma), (float)(this.data.volume / ((double)(this.a * this.b) * this.data.sinGamma)), 0.0f);
        this.matrixNotional.setColumn(3, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    private void constructFractionalMatrices() {
        if (this.notionalUnitcell.length > 6 && !Float.isNaN(this.notionalUnitcell[6])) {
            float[] fArray = new float[16];
            for (int i = 0; i < 16; ++i) {
                fArray[i] = this.notionalUnitcell[6 + i];
            }
            this.matrixCartesianToFractional = new Matrix4f(fArray);
            this.matrixFractionalToCartesian = new Matrix4f();
            this.matrixFractionalToCartesian.invert(this.matrixCartesianToFractional);
        } else {
            this.matrixFractionalToCartesian = this.matrixNotional;
            this.matrixCartesianToFractional = new Matrix4f();
            this.matrixCartesianToFractional.invert(this.matrixFractionalToCartesian);
        }
    }

    private void calcUnitcellVertices() {
        this.vertices = new Point3f[8];
        int n = 8;
        while (--n >= 0) {
            this.vertices[n] = new Point3f();
            this.matrixFractionalToCartesian.transform(unitCubePoints[n], this.vertices[n]);
        }
    }

    private class Data {
        double cosAlpha;
        double sinAlpha;
        double cosBeta;
        double sinBeta;
        double cosGamma;
        double sinGamma;
        double volume;
        double cA_;
        double cB_;
        double a_;
        double b_;
        double c_;
        static final double twoP2 = 19.739208802178716;

        Data() {
            this.cosAlpha = Math.cos((float)Math.PI / 180 * UnitCell.this.alpha);
            this.sinAlpha = Math.sin((float)Math.PI / 180 * UnitCell.this.alpha);
            this.cosBeta = Math.cos((float)Math.PI / 180 * UnitCell.this.beta);
            this.sinBeta = Math.sin((float)Math.PI / 180 * UnitCell.this.beta);
            this.cosGamma = Math.cos((float)Math.PI / 180 * UnitCell.this.gamma);
            this.sinGamma = Math.sin((float)Math.PI / 180 * UnitCell.this.gamma);
            double d = Math.sqrt(this.sinAlpha * this.sinAlpha + this.sinBeta * this.sinBeta + this.sinGamma * this.sinGamma + 2.0 * this.cosAlpha * this.cosBeta * this.cosGamma - 2.0);
            this.volume = (double)(UnitCell.this.a * UnitCell.this.b * UnitCell.this.c) * d;
            this.cA_ = (this.cosAlpha - this.cosBeta * this.cosGamma) / this.sinGamma;
            this.cB_ = d / this.sinGamma;
            this.a_ = (double)(UnitCell.this.b * UnitCell.this.c) * this.sinAlpha / this.volume;
            this.b_ = (double)(UnitCell.this.a * UnitCell.this.c) * this.sinBeta / this.volume;
            this.c_ = (double)(UnitCell.this.a * UnitCell.this.b) * this.sinGamma / this.volume;
        }

        Object[] getEllipsoid(float[] fArray) {
            float[] fArray2 = new float[6];
            if (fArray[0] == 0.0f) {
                fArray2[1] = (float)Math.sqrt(fArray[7]);
                return new Object[]{null, fArray2};
            }
            int n = (int)fArray[6];
            boolean bl = n == 4 || n == 5 || n == 8 || n == 9;
            double d = 2 - n % 2;
            double d2 = n == 8 || n == 9 || n == 10 ? 19.739208802178716 : (n == 4 || n == 5 ? 0.25 : (n == 2 || n == 3 ? Math.log(2.0) : 1.0));
            System.out.println("ortep type " + n + " isFractional=" + bl + " D = " + d2 + " C=" + d);
            double d3 = (double)fArray[0] * d2 * (bl ? this.a_ * this.a_ : 1.0);
            double d4 = (double)fArray[1] * d2 * (bl ? this.b_ * this.b_ : 1.0);
            double d5 = (double)fArray[2] * d2 * (bl ? this.c_ * this.c_ : 1.0);
            double d6 = (double)fArray[3] * d2 * (bl ? this.a_ * this.b_ : 1.0) * d;
            double d7 = (double)fArray[4] * d2 * (bl ? this.a_ * this.c_ : 1.0) * d;
            double d8 = (double)fArray[5] * d2 * (bl ? this.b_ * this.c_ : 1.0) * d;
            fArray[7] = (float)Math.pow(d3 / 19.739208802178716 / this.a_ / this.a_ * d4 / 19.739208802178716 / this.b_ / this.b_ * d5 / 19.739208802178716 / this.c_ / this.c_, 0.3333);
            double[] dArray = new double[]{(double)(UnitCell.this.a * UnitCell.this.a) * d3 + (double)(UnitCell.this.b * UnitCell.this.b) * this.cosGamma * this.cosGamma * d4 + (double)(UnitCell.this.c * UnitCell.this.c) * this.cosBeta * this.cosBeta * d5 + (double)(UnitCell.this.a * UnitCell.this.b) * this.cosGamma * d6 + (double)(UnitCell.this.b * UnitCell.this.c) * this.cosGamma * this.cosBeta * d8 + (double)(UnitCell.this.a * UnitCell.this.c) * this.cosBeta * d7, (double)(UnitCell.this.b * UnitCell.this.b) * this.sinGamma * this.sinGamma * d4 + (double)(UnitCell.this.c * UnitCell.this.c) * this.cA_ * this.cA_ * d5 + (double)(UnitCell.this.b * UnitCell.this.c) * this.cA_ * this.sinGamma * d8, (double)(UnitCell.this.c * UnitCell.this.c) * this.cB_ * this.cB_ * d5, (double)(2.0f * UnitCell.this.b * UnitCell.this.b) * this.cosGamma * this.sinGamma * d4 + (double)(2.0f * UnitCell.this.c * UnitCell.this.c) * this.cA_ * this.cosBeta * d5 + (double)(UnitCell.this.a * UnitCell.this.b) * this.sinGamma * d6 + (double)(UnitCell.this.b * UnitCell.this.c) * (this.cA_ * this.cosGamma + this.sinGamma * this.cosBeta) * d8 + (double)(UnitCell.this.a * UnitCell.this.c) * this.cA_ * d7, (double)(2.0f * UnitCell.this.c * UnitCell.this.c) * this.cB_ * this.cosBeta * d5 + (double)(UnitCell.this.b * UnitCell.this.c) * this.cosGamma * d8 + (double)(UnitCell.this.a * UnitCell.this.c) * this.cB_ * d7, (double)(2.0f * UnitCell.this.c * UnitCell.this.c) * this.cA_ * this.cB_ * d5 + (double)(UnitCell.this.b * UnitCell.this.c) * this.cB_ * this.sinGamma * d8};
            System.out.println("UnitCell Bcart=" + dArray[0] + " " + dArray[1] + " " + dArray[2] + " " + dArray[3] + " " + dArray[4] + " " + dArray[5]);
            Vector3f[] vector3fArray = new Vector3f[3];
            for (int i = 0; i < 3; ++i) {
                vector3fArray[i] = new Vector3f();
            }
            Quadric.getAxesForEllipsoid(dArray, vector3fArray, fArray2);
            double d9 = Math.sqrt(0.5) / Math.PI;
            for (int i = 0; i < 3; ++i) {
                fArray2[i] = (float)(d9 / (double)fArray2[i]);
            }
            return new Object[]{vector3fArray, fArray2};
        }
    }
}

