/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Logger;

public class SymmetryOperation
extends Matrix4f {
    String xyzOriginal;
    String xyz;
    boolean doNormalize = true;
    private Point4f temp = new Point4f();
    private static final String[] twelfths = new String[]{"0", "1/12", "1/6", "1/4", "1/3", "5/12", "1/2", "7/12", "2/3", "3/4", "5/6", "11/12"};
    Point3f atomTest = new Point3f();

    public SymmetryOperation() {
    }

    public SymmetryOperation(boolean bl) {
        this.doNormalize = bl;
    }

    public SymmetryOperation(SymmetryOperation symmetryOperation, Point3f[] point3fArray, int n, int n2, boolean bl) {
        this.doNormalize = bl;
        this.xyzOriginal = symmetryOperation.xyzOriginal;
        this.xyz = symmetryOperation.xyz;
        this.set(symmetryOperation);
        this.m03 /= 12.0f;
        this.m13 /= 12.0f;
        this.m23 /= 12.0f;
        if (bl) {
            this.setOffset(point3fArray, n, n2);
        }
    }

    public String getXyz() {
        return this.xyz;
    }

    public String getXyzOriginal() {
        return this.xyzOriginal;
    }

    public void newPoint(Point3f point3f, Point3f point3f2, int n, int n2, int n3) {
        this.temp.set(point3f.x, point3f.y, point3f.z, 1.0f);
        this.transform(this.temp, this.temp);
        point3f2.set(this.temp.x + (float)n, this.temp.y + (float)n2, this.temp.z + (float)n3);
    }

    String dumpInfo() {
        return "\n" + this.xyz + "\ninternal matrix representation:\n" + this.toString();
    }

    static final String dumpSeitz(Matrix4f matrix4f) {
        return "{\t" + (int)matrix4f.m00 + "\t" + (int)matrix4f.m01 + "\t" + (int)matrix4f.m02 + "\t" + SymmetryOperation.twelfthsOf(matrix4f.m03) + "\t}\n" + "{\t" + (int)matrix4f.m10 + "\t" + (int)matrix4f.m11 + "\t" + (int)matrix4f.m12 + "\t" + SymmetryOperation.twelfthsOf(matrix4f.m13) + "\t}\n" + "{\t" + (int)matrix4f.m20 + "\t" + (int)matrix4f.m21 + "\t" + (int)matrix4f.m22 + "\t" + SymmetryOperation.twelfthsOf(matrix4f.m23) + "\t}\n" + "{\t0\t0\t0\t1\t}\n";
    }

    static final String dumpCanonicalSeitz(Matrix4f matrix4f) {
        return "{\t" + (int)matrix4f.m00 + "\t" + (int)matrix4f.m01 + "\t" + (int)matrix4f.m02 + "\t" + SymmetryOperation.twelfthsOf(matrix4f.m03 + 12.0f) + "\t}\n" + "{\t" + (int)matrix4f.m10 + "\t" + (int)matrix4f.m11 + "\t" + (int)matrix4f.m12 + "\t" + SymmetryOperation.twelfthsOf(matrix4f.m13 + 12.0f) + "\t}\n" + "{\t" + (int)matrix4f.m20 + "\t" + (int)matrix4f.m21 + "\t" + (int)matrix4f.m22 + "\t" + SymmetryOperation.twelfthsOf(matrix4f.m23 + 12.0f) + "\t}\n" + "{\t0\t0\t0\t1\t}\n";
    }

    boolean setMatrixFromXYZ(String string) {
        if (string == null) {
            return false;
        }
        this.xyzOriginal = string;
        string = string.toLowerCase();
        float[] fArray = new float[16];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        String string2 = "";
        int n4 = -1;
        fArray[15] = 1.0f;
        float f2 = 1.0f;
        string = string + ",";
        block12: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': 
                case '\'': 
                case '{': 
                case '}': {
                    continue block12;
                }
                case '-': {
                    bl3 = true;
                    continue block12;
                }
                case '+': {
                    bl3 = false;
                    continue block12;
                }
                case '/': {
                    bl = true;
                    continue block12;
                }
                case 'X': 
                case 'x': {
                    n = bl3 ? -1 : 1;
                    break;
                }
                case 'Y': 
                case 'y': {
                    n2 = bl3 ? -1 : 1;
                    break;
                }
                case 'Z': 
                case 'z': {
                    n3 = bl3 ? -1 : 1;
                    break;
                }
                case ',': {
                    if (++n4 > 2) {
                        Logger.warn("Symmetry Operation? " + string);
                        return false;
                    }
                    int n5 = n4 * 4;
                    f *= 12.0f;
                    if (this.doNormalize) {
                        while (f > 6.0f) {
                            f -= 12.0f;
                        }
                        while (f <= -6.0f) {
                            f += 12.0f;
                        }
                    }
                    fArray[n5++] = n;
                    fArray[n5++] = n2;
                    fArray[n5++] = n3;
                    fArray[n5] = f;
                    String string3 = "";
                    string3 = string3 + (n == 0 ? "" : (n < 0 ? "-x" : (string3.length() == 0 ? "x" : "+x")));
                    string3 = string3 + (n2 == 0 ? "" : (n2 < 0 ? "-y" : (string3.length() == 0 ? "y" : "+y")));
                    string3 = string3 + (n3 == 0 ? "" : (n3 < 0 ? "-z" : (string3.length() == 0 ? "z" : "+z")));
                    string3 = string3 + SymmetryOperation.xyzFraction(f, false);
                    string2 = string2 + (string2 == "" ? "" : ",") + string3;
                    if (n4 == 2) {
                        this.set(fArray);
                        this.xyz = string2;
                        n4 = 0;
                        return true;
                    }
                    n3 = 0;
                    n2 = 0;
                    n = 0;
                    f = 0.0f;
                    break;
                }
                case '.': {
                    bl2 = true;
                    f2 = 1.0f;
                    continue block12;
                }
                case '0': {
                    if (!bl2) continue block12;
                }
                default: {
                    int n6 = c - 48;
                    if (bl2 && n6 >= 0 && n6 <= 9) {
                        f2 /= 10.0f;
                        if (f < 0.0f) {
                            bl3 = true;
                        }
                        f += f2 * (float)n6 * (float)(bl3 ? -1 : 1);
                        continue block12;
                    }
                    if (n6 >= 1 && n6 <= 9) {
                        if (bl) {
                            f /= (float)n6;
                            break;
                        }
                        f = (bl3 ? -1.0f : 1.0f) * (float)n6;
                        break;
                    }
                    Logger.warn("symmetry character?" + c);
                }
            }
            bl3 = false;
            bl = false;
            bl2 = false;
        }
        return false;
    }

    static final String getXYZFromMatrix(Matrix4f matrix4f, boolean bl) {
        String string = "";
        float[] fArray = new float[4];
        for (int i = 0; i < 3; ++i) {
            matrix4f.getRow(i, fArray);
            String string2 = "";
            if (fArray[0] != 0.0f) {
                string2 = string2 + (fArray[0] < 0.0f ? "-" : "+") + "x";
            }
            if (fArray[1] != 0.0f) {
                string2 = string2 + (fArray[1] < 0.0f ? "-" : "+") + "y";
            }
            if (fArray[2] != 0.0f) {
                string2 = string2 + (fArray[2] < 0.0f ? "-" : "+") + "z";
            }
            if ((string2 = string2 + SymmetryOperation.xyzFraction(fArray[3], bl)).length() > 0 && string2.charAt(0) == '+') {
                string2 = string2.substring(1);
            }
            string = string + "," + string2;
        }
        return string.substring(1);
    }

    private static final String twelfthsOf(float f) {
        String string = "";
        if (f < 0.0f) {
            string = "-";
            f = -f;
        }
        return string + twelfths[(int)f % 12];
    }

    private static final String xyzFraction(float f, boolean bl) {
        String string;
        if (bl) {
            while (f < 0.0f) {
                f += 12.0f;
            }
        } else if (f > 6.0f) {
            f -= 12.0f;
        }
        return (string = SymmetryOperation.twelfthsOf(f)).charAt(0) == '0' ? "" : (f > 0.0f ? "+" + string : string);
    }

    private void setOffset(Point3f[] point3fArray, int n, int n2) {
        int n3 = n;
        int n4 = n3 + n2;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = n3; i < n4; ++i) {
            this.newPoint(point3fArray[i], this.atomTest, 0, 0, 0);
            f += this.atomTest.x;
            f2 += this.atomTest.y;
            f3 += this.atomTest.z;
        }
        while ((double)f < -0.001 || (double)f >= (double)n2 + 0.001) {
            this.m03 += (float)(f < 0.0f ? 1 : -1);
            f += (float)(f < 0.0f ? n2 : -n2);
        }
        while ((double)f2 < -0.001 || (double)f2 >= (double)n2 + 0.001) {
            this.m13 += (float)(f2 < 0.0f ? 1 : -1);
            f2 += (float)(f2 < 0.0f ? n2 : -n2);
        }
        while ((double)f3 < -0.001 || (double)f3 >= (double)n2 + 0.001) {
            this.m23 += (float)(f3 < 0.0f ? 1 : -1);
            f3 += (float)(f3 < 0.0f ? n2 : -n2);
        }
    }

    private void transformCartesian(UnitCell unitCell, Point3f point3f) {
        unitCell.toFractional(point3f);
        this.transform(point3f);
        unitCell.toCartesian(point3f);
    }

    public Vector3f[] rotateEllipsoid(Point3f point3f, Vector3f[] vector3fArray, UnitCell unitCell, Point3f point3f2, Point3f point3f3) {
        Vector3f[] vector3fArray2 = new Vector3f[3];
        point3f3.set(point3f);
        this.transformCartesian(unitCell, point3f3);
        int n = vector3fArray.length;
        while (--n >= 0) {
            point3f2.set(point3f);
            point3f2.add(vector3fArray[n]);
            this.transformCartesian(unitCell, point3f2);
            vector3fArray2[n] = new Vector3f(point3f2);
            vector3fArray2[n].sub(point3f3);
        }
        return vector3fArray2;
    }
}

