/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;

public class PointGroup {
    private static final int[] axesMaxProperN = new int[]{0, 0, 15, 10, 6, 6, 10};
    private static final int[] axesMaxImproperN = new int[]{9, 0, 0, 0, 1, 0, 10, 0, 1, 0, 6, 0, 1};
    private static int maxProper = axesMaxProperN.length;
    private static int maxImproper = axesMaxImproperN.length;
    private int[] nC;
    private Operation[][] axes;
    private String name = "C_1?";
    private final Vector3f vTemp = new Vector3f();
    private int centerAtomIndex = -1;
    private boolean haveInversionCenter;
    private final Point3f center = new Point3f();
    private static final float LINEAR_DOT_MINIMUM = 0.9999f;
    int maxElement = 0;
    int[] eCounts;
    static final int OPERATION_AXIS = 0;
    static final int OPERATION_PLANE = 1;
    static final int OPERATION_IMPROPER_AXIS = 2;
    static final int OPERATION_INVERSION_CENTER = 3;
    static final String[] typeNames = new String[]{"axis", "plane", "improper axis", "center of inversion"};

    public String getName() {
        return this.name;
    }

    public PointGroup(Atom[] atomArray, BitSet bitSet) {
        this.nC = new int[maxImproper];
        this.axes = new Operation[maxImproper][];
        Point3f[] point3fArray = this.getCenter(atomArray, bitSet);
        if (point3fArray == null) {
            return;
        }
        int[] nArray = new int[point3fArray.length];
        int n = 0;
        int n2 = atomArray.length;
        while (--n2 >= 0) {
            if (!bitSet.get(n2)) continue;
            nArray[n++] = atomArray[n2].getElementNumber();
        }
        this.getElementArrays(point3fArray, nArray);
        this.haveInversionCenter = this.haveInversionCenter(point3fArray, nArray);
        if (this.isLinear(point3fArray)) {
            this.name = this.haveInversionCenter ? "D_(infinity)h" : "C_(infinity)v";
            return;
        }
        this.axes[0] = new Operation[9];
        n2 = 0;
        this.findCAxes(point3fArray, nArray);
        n2 = this.findPlanes(point3fArray, nArray);
        this.findAdditionalAxes(n2, point3fArray, nArray);
        n = this.getHighestOrder(this.nC);
        if (this.nC[3] > 1) {
            this.name = this.nC[5] > 1 ? (this.haveInversionCenter ? "I_h" : "I") : (this.nC[4] > 1 ? (this.haveInversionCenter ? "O_h" : "O") : (n2 > 0 ? (this.haveInversionCenter ? "T_h" : "T_d") : "T"));
        } else if (n < 2) {
            if (n2 == 1) {
                this.name = "C_s";
                return;
            }
            if (this.haveInversionCenter) {
                this.name = "C_i";
                return;
            }
            this.name = "C_1";
        } else if (n % 2 == 1 && this.nC[2] > 0 || n % 2 == 0 && this.nC[2] > 1) {
            if (n2 == 0) {
                this.name = this.axes[n][0].type == 2 ? "S_" + n : "D_" + n;
            } else {
                if (this.axes[n][0].type == 2) {
                    n /= 2;
                }
                this.name = n2 == n ? "D_" + n + "d" : "D_" + n + "h";
            }
        } else {
            this.name = n2 == 0 ? (this.axes[n][0].type == 2 ? "S_" + n : "C_" + n) : (n2 == n ? "C_" + n + "v" : "C_" + n + "h");
        }
        System.out.println(this.drawInfo());
    }

    private void findAdditionalAxes(int n, Point3f[] point3fArray, int[] nArray) {
        Operation[] operationArray = this.axes[0];
        if (n > 1 && n < maxProper && this.nC[n] == 0) {
            this.vTemp.cross(operationArray[0].normalOrAxis, operationArray[1].normalOrAxis);
            if (!this.checkAxisOrder(point3fArray, nArray, n, this.vTemp, this.center) && n > 2) {
                this.vTemp.cross(operationArray[1].normalOrAxis, operationArray[2].normalOrAxis);
                this.checkAxisOrder(point3fArray, nArray, n - 1, this.vTemp, this.center);
            }
        }
        if (this.nC[2] == 0 && n > 2) {
            for (int i = 0; i < n - 1; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    this.vTemp.add(operationArray[1].normalOrAxis, operationArray[2].normalOrAxis);
                    this.checkAxisOrder(point3fArray, nArray, 2, this.vTemp, this.center);
                }
            }
        }
    }

    private Atom[] getCenter(Atom[] atomArray, BitSet bitSet) {
        int n = BitSetUtil.cardinalityOf(bitSet);
        if (n > 100) {
            Logger.error("Too many atoms for point group calculation");
            return null;
        }
        Atom[] atomArray2 = new Atom[n];
        int n2 = 0;
        int n3 = BitSetUtil.length(bitSet);
        while (--n3 >= 0) {
            if (!bitSet.get(n3)) continue;
            atomArray2[n2] = atomArray[n3];
            this.center.add(atomArray2[n2++]);
        }
        if (n2 < 2) {
            return null;
        }
        this.center.scale(1.0f / (float)n2);
        n3 = n2;
        while (--n3 >= 0) {
            if (!((double)atomArray2[n3].distance(this.center) < 0.1)) continue;
            this.centerAtomIndex = n3;
            break;
        }
        return atomArray2;
    }

    private boolean haveInversionCenter(Point3f[] point3fArray, int[] nArray) {
        return this.checkOperation(point3fArray, nArray, null, this.center, true);
    }

    private boolean checkOperation(Point3f[] point3fArray, int[] nArray, Quaternion quaternion, Point3f point3f, boolean bl) {
        Point3f point3f2 = new Point3f();
        int n = 0;
        int n2 = point3fArray.length;
        block0: while (--n2 >= 0 && n < point3fArray.length) {
            if (n2 == this.centerAtomIndex) {
                ++n;
                continue;
            }
            Point3f point3f3 = point3fArray[n2];
            int n3 = nArray[n2];
            if (quaternion != null) {
                point3f2.set(point3f3);
                point3f2.sub(point3f);
                quaternion.transform(point3f2, point3f2);
                point3f2.add(point3f);
            } else {
                point3f2.set(point3f3);
            }
            if (bl) {
                this.vTemp.sub(point3f, point3f2);
                point3f2.scaleAdd(2.0f, this.vTemp, point3f2);
            }
            if ((quaternion != null || bl) && (double)point3f2.distance(point3f3) < 0.1) {
                ++n;
                continue;
            }
            int n4 = point3fArray.length;
            while (--n4 >= 0) {
                Point3f point3f4;
                if (n4 == n2 || nArray[n4] != n3 || !((double)point3f2.distance(point3f4 = point3fArray[n4]) < 0.1)) continue;
                ++n;
                continue block0;
            }
        }
        return n == point3fArray.length;
    }

    private boolean isLinear(Point3f[] point3fArray) {
        Vector3f vector3f = null;
        int n = point3fArray.length;
        while (--n >= 0) {
            if (n == this.centerAtomIndex) continue;
            if (vector3f == null) {
                vector3f = new Vector3f();
                vector3f.sub(point3fArray[n], this.center);
                vector3f.normalize();
                this.vTemp.set(vector3f);
                continue;
            }
            this.vTemp.sub(point3fArray[n], this.center);
            this.vTemp.normalize();
            if (PointGroup.isParallel(vector3f, this.vTemp)) continue;
            return false;
        }
        return true;
    }

    private static boolean isParallel(Vector3f vector3f, Vector3f vector3f2) {
        return Math.abs(vector3f.dot(vector3f2)) >= 0.9999f;
    }

    private void getElementArrays(Point3f[] point3fArray, int[] nArray) {
        int n = point3fArray.length;
        while (--n >= 0) {
            int n2 = nArray[n];
            if (n2 <= this.maxElement) continue;
            this.maxElement = n2;
        }
        this.eCounts = new int[++this.maxElement];
        n = point3fArray.length;
        while (--n >= 0) {
            int n3 = nArray[n];
            this.eCounts[n3] = this.eCounts[n3] + 1;
        }
    }

    private int findCAxes(Point3f[] point3fArray, int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Point3f point3f = new Point3f();
        int n6 = point3fArray.length;
        while (--n6 >= 0) {
            if (n6 == this.centerAtomIndex) continue;
            Point3f point3f2 = point3fArray[n6];
            n5 = nArray[n6];
            n4 = point3fArray.length;
            while (--n4 > n6) {
                float f;
                boolean bl;
                Point3f point3f3 = point3fArray[n4];
                if (nArray[n4] != n5) continue;
                point3f.add(point3f2, point3f3);
                point3f.scale(0.5f);
                vector3f.sub(point3f2, this.center);
                vector3f2.sub(point3f3, this.center);
                vector3f.normalize();
                vector3f2.normalize();
                if (PointGroup.isParallel(vector3f, vector3f2)) {
                    this.getAllAxes(vector3f, point3fArray, nArray);
                    continue;
                }
                if (this.nC[2] < axesMaxProperN[2]) {
                    vector3f3.set(point3f);
                    this.getAllAxes(vector3f3, point3fArray, nArray);
                }
                if (!(bl = (f = (float)(Math.PI * 2 / (double)vector3f.angle(vector3f2))) - (float)(n3 = (int)(f + 0.01f)) <= 0.02f) || this.nC[n3] >= axesMaxProperN[n3]) continue;
                vector3f3.cross(vector3f, vector3f2);
                this.checkAxisOrder(point3fArray, nArray, n3, vector3f3, this.center);
            }
        }
        Vector3f[] vector3fArray = new Vector3f[this.nC[2] * 2];
        for (n2 = 0; n2 < vector3fArray.length; ++n2) {
            vector3fArray[n2] = new Vector3f();
        }
        n2 = 0;
        for (n5 = 0; n5 < this.nC[2]; ++n5) {
            vector3fArray[n2++].set(this.axes[2][n5].normalOrAxis);
            vector3fArray[n2].set(this.axes[2][n5].normalOrAxis);
            vector3fArray[n2++].scale(-1.0f);
        }
        n5 = vector3fArray.length;
        while (--n5 >= 2) {
            n4 = n5;
            while (--n4 >= 1) {
                int n7 = n4;
                while (--n7 >= 0) {
                    vector3f3.set(vector3fArray[n5]);
                    vector3f3.add(vector3fArray[n4]);
                    vector3f3.add(vector3fArray[n7]);
                    if ((double)vector3f3.length() < 1.0) continue;
                    this.checkAxisOrder(point3fArray, nArray, 3, vector3f3, this.center);
                }
            }
        }
        n5 = Integer.MAX_VALUE;
        n4 = -1;
        for (n = 0; n < this.maxElement; ++n) {
            if (this.eCounts[n] >= n5 || this.eCounts[n] <= 2) continue;
            n5 = this.eCounts[n];
            n4 = n;
        }
        block8: for (n = 0; n < point3fArray.length - 2; ++n) {
            if (nArray[n] != n4) continue;
            for (int i = n + 1; i < point3fArray.length - 1; ++i) {
                if (nArray[i] != n4) continue;
                for (n3 = i + 1; n3 < point3fArray.length; ++n3) {
                    if (nArray[n3] != n4) continue;
                    vector3f.sub(point3fArray[n], point3fArray[i]);
                    vector3f2.sub(point3fArray[n], point3fArray[n3]);
                    vector3f.normalize();
                    vector3f2.normalize();
                    vector3f3.cross(vector3f, vector3f2);
                    this.checkAxisOrder(point3fArray, nArray, 3, vector3f3, this.center);
                    point3f.set(point3fArray[n]);
                    point3f.add(point3fArray[i]);
                    point3f.add(point3fArray[n3]);
                    vector3f.set(point3f);
                    vector3f.normalize();
                    if (!PointGroup.isParallel(vector3f, vector3f3)) {
                        this.getAllAxes(vector3f, point3fArray, nArray);
                    }
                    if (this.nC[5] == axesMaxProperN[5]) break block8;
                }
            }
        }
        if (!this.haveInversionCenter) {
            vector3fArray = new Vector3f[this.maxElement];
            n = point3fArray.length;
            while (--n >= 0) {
                int n8 = nArray[n];
                if (vector3fArray[n8] == null) {
                    vector3fArray[n8] = new Vector3f();
                }
                vector3fArray[n8].add(point3fArray[n]);
            }
            for (n = 0; n < this.maxElement; ++n) {
                if (vector3fArray[n] == null) continue;
                vector3fArray[n].scale(1.0f / (float)this.eCounts[n]);
            }
            for (n = 0; n < this.maxElement; ++n) {
                if (vector3fArray[n] == null) continue;
                for (int i = 0; i < this.maxElement; ++i) {
                    if (n == i || vector3fArray[i] == null) continue;
                    vector3f.set(vector3fArray[n]);
                    vector3f.sub(vector3fArray[i]);
                    this.checkAxisOrder(point3fArray, nArray, 2, vector3f, this.center);
                }
            }
        }
        return this.getHighestOrder(this.nC);
    }

    private void getAllAxes(Vector3f vector3f, Point3f[] point3fArray, int[] nArray) {
        int n = maxProper;
        while (--n >= 2) {
            if (this.nC[n] >= axesMaxProperN[n]) continue;
            this.checkAxisOrder(point3fArray, nArray, n, vector3f, this.center);
        }
    }

    private int getHighestOrder(int[] nArray) {
        int n = maxImproper;
        while (--n > 1 && nArray[n] == 0) {
        }
        return n;
    }

    private boolean checkAxisOrder(Point3f[] point3fArray, int[] nArray, int n, Vector3f vector3f, Point3f point3f) {
        switch (n) {
            case 4: 
            case 6: {
                if (this.nC[5] <= 0) break;
                return false;
            }
            case 5: {
                if (this.nC[4] <= 0 && this.nC[6] <= 0) break;
                return false;
            }
        }
        vector3f.normalize();
        if (this.haveAxis(n, vector3f)) {
            return false;
        }
        Quaternion quaternion = new Quaternion(vector3f, 360 / (n < 0 ? -n : n));
        if (!this.checkOperation(point3fArray, nArray, quaternion, point3f, n < 0)) {
            return false;
        }
        this.addAxis(n, vector3f);
        switch (n) {
            case 2: {
                this.checkAxisOrder(point3fArray, nArray, -4, vector3f, point3f);
                break;
            }
            case 3: {
                this.checkAxisOrder(point3fArray, nArray, -6, vector3f, point3f);
                break;
            }
            case 4: {
                this.addAxis(2, vector3f);
                this.checkAxisOrder(point3fArray, nArray, -8, vector3f, point3f);
                break;
            }
            case 5: {
                this.checkAxisOrder(point3fArray, nArray, -10, vector3f, point3f);
                break;
            }
            case 6: {
                this.addAxis(2, vector3f);
                this.addAxis(3, vector3f);
                break;
            }
            case 8: {
                this.addAxis(2, vector3f);
                this.addAxis(4, vector3f);
            }
        }
        return true;
    }

    private void addAxis(int n, Vector3f vector3f) {
        int n2 = Math.abs(n);
        if (this.haveAxis(n, vector3f)) {
            return;
        }
        if (this.axes[n2] == null) {
            this.axes[n2] = new Operation[Math.max(n2 < maxProper ? axesMaxProperN[n2] : 0, axesMaxImproperN[n2])];
        }
        int n3 = n2;
        int n4 = this.nC[n3];
        this.nC[n3] = n4 + 1;
        this.axes[n2][n4] = new Operation(vector3f, n);
    }

    private boolean haveAxis(int n, Vector3f vector3f) {
        int n2 = Math.abs(n);
        if (this.nC[n2] == (n > 0 ? axesMaxProperN[n2] : axesMaxImproperN[n2])) {
            return true;
        }
        if (this.nC[n2] > 0) {
            int n3 = this.nC[n2];
            while (--n3 >= 0) {
                if (!PointGroup.isParallel(vector3f, this.axes[n2][n3].normalOrAxis)) continue;
                return true;
            }
        }
        return false;
    }

    private int findPlanes(Point3f[] point3fArray, int[] nArray) {
        Operation[] operationArray = this.axes[2];
        int n = this.nC[2];
        Point3f point3f = new Point3f();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        int n2 = 0;
        int n3 = point3fArray.length;
        while (--n3 >= 0) {
            if (n3 == this.centerAtomIndex) continue;
            Point3f point3f2 = point3fArray[n3];
            int n4 = nArray[n3];
            int n5 = point3fArray.length;
            while (--n5 > n3) {
                if (nArray[n5] != n4) continue;
                Point3f point3f3 = point3fArray[n5];
                point3f.add(point3f2, point3f3);
                point3f.scale(0.5f);
                vector3f.sub(point3f2, this.center);
                vector3f2.sub(point3f3, this.center);
                if (!PointGroup.isParallel(vector3f, vector3f2)) {
                    vector3f3.cross(vector3f, vector3f2);
                    vector3f3.normalize();
                    n2 = this.getPlane(n2, vector3f3, point3fArray, nArray, this.center);
                }
                vector3f3.set(point3f3);
                vector3f3.sub(point3f2);
                vector3f3.normalize();
                if ((n2 = this.getPlane(n2, vector3f3, point3fArray, nArray, this.center)) != axesMaxImproperN[0]) continue;
                return n2;
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            n2 = this.getPlane(n2, operationArray[n3].normalOrAxis, point3fArray, nArray, this.center);
        }
        return n2;
    }

    private int getPlane(int n, Vector3f vector3f, Point3f[] point3fArray, int[] nArray, Point3f point3f) {
        if (!this.haveAxis(0, vector3f) && this.checkOperation(point3fArray, nArray, new Quaternion(vector3f, 180.0f), this.center, true)) {
            int n2 = this.nC[0];
            this.nC[0] = n2 + 1;
            this.axes[0][n2] = new Operation(vector3f);
        }
        return this.nC[0];
    }

    public String drawInfo() {
        Operation operation;
        int n;
        Vector3f vector3f = new Vector3f();
        int n2 = 0;
        for (int i = 1; i < maxImproper; ++i) {
            n2 += this.nC[i];
        }
        StringBuffer stringBuffer = new StringBuffer("# name=" + this.name + ", nPlanes=" + this.nC[0] + ", nAxes=" + n2 + ";\n");
        stringBuffer.append("draw p0" + (this.haveInversionCenter ? "inv " : " ") + this.center + (this.haveInversionCenter ? "\"i\";\n" : ";\n"));
        for (n = 2; n < maxImproper; ++n) {
            for (int i = 0; i < this.nC[n]; ++i) {
                operation = this.axes[n][i];
                vector3f.set(operation.normalOrAxis);
                vector3f.add(this.center);
                float f = 4.0f + (float)operation.order / 4.0f;
                stringBuffer.append("draw va").append(n).append("_").append(i).append(" width 0.05 scale -" + f + " ").append(Escape.escape(vector3f));
                vector3f.scaleAdd(-2.0f, operation.normalOrAxis, vector3f);
                stringBuffer.append(Escape.escape(vector3f)).append("\"" + operation.getLabel() + "\"").append(operation.type == 2 ? " color red" : "").append(";\n");
            }
        }
        for (n = 0; n < this.nC[0]; ++n) {
            operation = this.axes[0][n];
            vector3f.set(operation.normalOrAxis);
            vector3f.scale(0.01f);
            vector3f.add(this.center);
            stringBuffer.append("draw vp").append(n).append("disk width 6.0 cylinder ").append(Escape.escape(vector3f));
            vector3f.scaleAdd(-0.02f, operation.normalOrAxis, vector3f);
            stringBuffer.append(Escape.escape(vector3f)).append(" color translucent;\n");
            vector3f.set(operation.normalOrAxis);
            vector3f.add(this.center);
            stringBuffer.append("draw vp").append(n).append("ring width 0.05 scale 3.0 arc ").append(Escape.escape(vector3f));
            vector3f.scaleAdd(-2.0f, operation.normalOrAxis, vector3f);
            stringBuffer.append(Escape.escape(vector3f));
            vector3f.x = (float)((double)vector3f.x + 0.011);
            vector3f.y = (float)((double)vector3f.y + 0.012);
            vector3f.z = (float)((double)vector3f.z + 0.013);
            stringBuffer.append(Escape.escape(vector3f)).append("{0 360 0.5} color red;\n");
        }
        return stringBuffer.toString();
    }

    public class Operation {
        int type;
        int order;
        Vector3f normalOrAxis;

        Operation() {
            this.type = 3;
            Logger.info("new operation -- " + typeNames[this.type]);
            this.order = 1;
        }

        Operation(Vector3f vector3f, int n) {
            this.type = n < 0 ? 2 : 0;
            this.order = Math.abs(n);
            this.normalOrAxis = new Quaternion(vector3f, 180.0f).getNormal();
            Logger.info("new operation -- " + typeNames[this.type] + " order = " + n + " " + this.normalOrAxis);
        }

        Operation(Vector3f vector3f) {
            this.type = 1;
            this.normalOrAxis = new Quaternion(vector3f, 180.0f).getNormal();
            Logger.info("new operation -- " + typeNames[this.type] + " " + this.normalOrAxis);
        }

        public String toString() {
            return this.type + " " + this.order + " " + this.normalOrAxis;
        }

        public String getLabel() {
            switch (this.type) {
                case 1: {
                    return "";
                }
                case 2: {
                    return "S" + this.order;
                }
            }
            return "C" + this.order;
        }
    }
}

