/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.awt.FontMetrics;
import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Shape;
import org.jmol.util.Escape;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

public class Text {
    public static final int POINTER_NONE = 0;
    public static final int POINTER_ON = 1;
    public static final int POINTER_BACKGROUND = 2;
    private static final String[] hAlignNames = new String[]{"", "left", "center", "right", ""};
    static final int ALIGN_NONE = 0;
    static final int ALIGN_LEFT = 1;
    static final int ALIGN_CENTER = 2;
    static final int ALIGN_RIGHT = 3;
    static final String[] vAlignNames = new String[]{"xy", "top", "bottom", "middle"};
    static final int VALIGN_XY = 0;
    static final int VALIGN_TOP = 1;
    static final int VALIGN_BOTTOM = 2;
    static final int VALIGN_MIDDLE = 3;
    static final int VALIGN_XYZ = 4;
    private boolean isLabelOrHover;
    private Viewer viewer;
    private JmolRendererInterface g3d;
    Point3f xyz;
    String target;
    private String text;
    private String textUnformatted;
    private String script;
    private float scalePixelsPerMicron;
    private float fontScale;
    private boolean doFormatText;
    private String[] lines;
    private int align;
    int valign;
    private int pointer;
    private int movableX;
    private int movableY;
    private int movableXPercent = Integer.MAX_VALUE;
    private int movableYPercent = Integer.MAX_VALUE;
    private int offsetX;
    private int offsetY;
    private int z;
    private int zSlab;
    private int windowWidth;
    private int windowHeight;
    private boolean adjustForWindow;
    private float boxWidth;
    private float boxHeight;
    private float boxX;
    private float boxY;
    int modelIndex = -1;
    boolean visible = true;
    Font3D font;
    private FontMetrics fm;
    private byte fid;
    private int ascent;
    private int descent;
    private int lineHeight;
    private short colix;
    private short bgcolix;
    private int[] widths;
    private int textWidth;
    private int textHeight;
    final float[] boxXY = new float[2];

    float getScalePixelsPerMicron() {
        return this.scalePixelsPerMicron;
    }

    void setScalePixelsPerMicron(float f) {
        this.fontScale = 0.0f;
        this.scalePixelsPerMicron = f;
    }

    Text(JmolRendererInterface jmolRendererInterface, Font3D font3D, String string, short s, short s2, int n, int n2, int n3, int n4, int n5, float f) {
        this.scalePixelsPerMicron = f;
        this.viewer = null;
        this.g3d = jmolRendererInterface;
        this.isLabelOrHover = true;
        this.setText(string);
        this.colix = s;
        this.bgcolix = s2;
        this.setXYZs(n, n2, n3, n4);
        this.align = n5;
        this.setFont(font3D);
    }

    Text(Viewer viewer, Graphics3D graphics3D, Font3D font3D, String string, short s, int n, int n2, float f) {
        this.viewer = viewer;
        this.g3d = graphics3D;
        this.isLabelOrHover = false;
        this.target = string;
        if (string.equals("error")) {
            n = 1;
        }
        this.align = n2;
        this.valign = n;
        this.font = font3D;
        this.colix = s;
        this.scalePixelsPerMicron = f;
        this.z = 2;
        this.zSlab = Integer.MIN_VALUE;
        this.getFontMetrics();
    }

    private void getFontMetrics() {
        this.fm = this.font.fontMetrics;
        this.descent = this.fm.getDescent();
        this.ascent = this.fm.getAscent();
        this.lineHeight = this.ascent + this.descent;
    }

    void setFid(byte by) {
        if (this.fid == by) {
            return;
        }
        this.fontScale = 0.0f;
        this.setFont(Font3D.getFont3D(by));
    }

    void setModel(int n) {
        this.modelIndex = n;
    }

    void setVisibility(boolean bl) {
        this.visible = bl;
    }

    void setXYZ(Point3f point3f) {
        this.valign = 4;
        this.xyz = point3f;
        this.setAdjustForWindow(false);
    }

    void setAdjustForWindow(boolean bl) {
        this.adjustForWindow = bl;
    }

    void setColix(short s) {
        this.colix = s;
    }

    void setColix(Object object) {
        this.colix = Graphics3D.getColix(object);
    }

    void setTranslucent(float f, boolean bl) {
        if (bl) {
            if (this.bgcolix != 0) {
                this.bgcolix = Graphics3D.getColixTranslucent(this.bgcolix, !Float.isNaN(f), f);
            }
        } else {
            this.colix = Graphics3D.getColixTranslucent(this.colix, !Float.isNaN(f), f);
        }
    }

    void setBgColix(short s) {
        this.bgcolix = s;
    }

    void setBgColix(Object object) {
        this.bgcolix = object == null ? (short)0 : Graphics3D.getColix(object);
    }

    void setMovableX(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableX = n;
        this.movableXPercent = Integer.MAX_VALUE;
    }

    void setMovableY(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableY = n;
        this.movableYPercent = Integer.MAX_VALUE;
    }

    void setMovableXPercent(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableX = Integer.MAX_VALUE;
        this.movableXPercent = n;
    }

    void setMovableYPercent(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableY = Integer.MAX_VALUE;
        this.movableYPercent = n;
    }

    void setXY(int n, int n2) {
        this.setMovableX(n);
        this.setMovableY(n2);
    }

    void setZs(int n, int n2) {
        this.z = n;
        this.zSlab = n2;
    }

    void setXYZs(int n, int n2, int n3, int n4) {
        this.setMovableX(n);
        this.setMovableY(n2);
        this.setZs(n3, n4);
    }

    void setScript(String string) {
        this.script = string == null || string.length() == 0 ? null : string;
    }

    String getScript() {
        return this.script;
    }

    void setOffset(int n) {
        this.offsetX = Text.getXOffset(n);
        this.offsetY = Text.getYOffset(n);
        this.valign = 0;
    }

    static int getXOffset(int n) {
        switch (n) {
            case 0: {
                return 4;
            }
            case 32767: {
                return 0;
            }
        }
        return (byte)(n >> 8 & 0xFF);
    }

    static int getYOffset(int n) {
        switch (n) {
            case 0: {
                return -4;
            }
            case 32767: {
                return 0;
            }
        }
        return -((byte)(n & 0xFF));
    }

    void setText(String string) {
        string = this.fixText(string);
        if (this.text != null && this.text.equals(string)) {
            return;
        }
        this.text = string;
        this.textUnformatted = string;
        boolean bl = this.doFormatText = this.viewer != null && string != null && (string.indexOf("%{") >= 0 || string.indexOf("@{") >= 0);
        if (!this.doFormatText) {
            this.recalc();
        }
    }

    void setFont(Font3D font3D) {
        this.font = font3D;
        if (this.font == null) {
            return;
        }
        this.fid = this.font.fid;
        this.getFontMetrics();
        this.recalc();
    }

    void setFontScale(float f) {
        if (this.fontScale == f) {
            return;
        }
        this.fontScale = f;
        if (this.fontScale != 0.0f) {
            this.setFont(this.g3d.getFont3DScaled(this.font, f));
        }
    }

    boolean setAlignment(String string) {
        if ("left".equals(string)) {
            return this.setAlignment(1);
        }
        if ("center".equals(string)) {
            return this.setAlignment(2);
        }
        if ("right".equals(string)) {
            return this.setAlignment(3);
        }
        return false;
    }

    static String getAlignment(int n) {
        return hAlignNames[n & 3];
    }

    boolean setAlignment(int n) {
        if (this.align != n) {
            this.align = n;
            this.recalc();
        }
        return true;
    }

    void setPointer(int n) {
        this.pointer = n;
    }

    static String getPointer(int n) {
        return (n & 1) == 0 ? "" : ((n & 2) > 0 ? "background" : "on");
    }

    String fixText(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return null;
        }
        while ((n = string.indexOf("\n")) >= 0) {
            string = string.substring(0, n) + "|" + string.substring(n + 1);
        }
        return string;
    }

    void recalc() {
        if (this.text == null) {
            this.text = null;
            this.lines = null;
            this.widths = null;
            return;
        }
        if (this.fm == null) {
            return;
        }
        this.lines = TextFormat.split(this.text, '|');
        this.textWidth = 0;
        this.widths = new int[this.lines.length];
        int n = this.lines.length;
        while (--n >= 0) {
            this.widths[n] = this.stringWidth(this.lines[n]);
            this.textWidth = Math.max(this.textWidth, this.widths[n]);
        }
        this.textHeight = this.lines.length * this.lineHeight;
        this.boxWidth = this.textWidth + (this.fontScale >= 2.0f ? 16 : 8);
        this.boxHeight = this.textHeight + (this.fontScale >= 2.0f ? 16 : 8);
    }

    private void formatText() {
        this.text = this.viewer == null ? this.textUnformatted : this.viewer.formatText(this.textUnformatted);
        this.recalc();
    }

    void render(JmolRendererInterface jmolRendererInterface, float f, float f2) {
        if (this.text == null) {
            return;
        }
        this.windowWidth = jmolRendererInterface.getRenderWidth();
        this.windowHeight = jmolRendererInterface.getRenderHeight();
        if (this.scalePixelsPerMicron < 0.0f && f != 0.0f) {
            this.scalePixelsPerMicron = f;
        }
        if (f != 0.0f && this.scalePixelsPerMicron != 0.0f) {
            this.setFontScale(f / this.scalePixelsPerMicron);
        } else if (this.fontScale != f2) {
            this.setFontScale(f2);
        }
        if (this.doFormatText) {
            this.formatText();
        }
        if (this.isLabelOrHover) {
            this.boxXY[0] = this.movableX;
            this.boxXY[1] = this.movableY;
            Text.setLabelPosition(this.boxWidth, this.boxHeight, (float)this.offsetX * f2, (float)this.offsetY * f2, this.boxXY);
        } else {
            this.setPosition();
        }
        this.boxX = this.boxXY[0];
        this.boxY = this.boxXY[1];
        if (this.adjustForWindow) {
            this.setBoxOffsetsInWindow();
        }
        if (this.bgcolix != 0 && jmolRendererInterface.setColix(this.bgcolix)) {
            Text.showBox(jmolRendererInterface, this.colix, this.bgcolix, (int)this.boxX, (int)this.boxY, this.z + 2, this.zSlab, (int)this.boxWidth, (int)this.boxHeight, this.fontScale, this.isLabelOrHover);
        }
        if (jmolRendererInterface.setColix(this.colix)) {
            float f3 = this.boxWidth;
            float f4 = this.fontScale >= 2.0f ? 8 : 4;
            int n = (int)this.boxX;
            switch (this.align) {
                case 2: {
                    n = (int)((float)n + f3 / 2.0f);
                    break;
                }
                case 3: {
                    n = (int)((float)n + (f3 - f4));
                    break;
                }
                default: {
                    n = (int)((float)n + f4);
                }
            }
            float f5 = n;
            float f6 = this.boxY + (float)this.ascent + f4;
            f3 = this.lineHeight;
            for (int i = 0; i < this.lines.length; ++i) {
                switch (this.align) {
                    case 2: {
                        f5 = n - this.widths[i] / 2;
                        break;
                    }
                    case 3: {
                        f5 = n - this.widths[i];
                    }
                }
                jmolRendererInterface.drawString(this.lines[i], this.font, (int)f5, (int)f6, this.z, this.zSlab);
                f6 += f3;
            }
        }
        if ((this.pointer & 1) != 0) {
            jmolRendererInterface.setColix((this.pointer & 2) != 0 && this.bgcolix != 0 ? this.bgcolix : this.colix);
            if (this.boxX > (float)this.movableX) {
                jmolRendererInterface.drawLine(this.movableX, this.movableY, this.zSlab, (int)this.boxX, (int)(this.boxY + this.boxHeight / 2.0f), this.zSlab);
            } else if (this.boxX + this.boxWidth < (float)this.movableX) {
                jmolRendererInterface.drawLine(this.movableX, this.movableY, this.zSlab, (int)(this.boxX + this.boxWidth), (int)(this.boxY + this.boxHeight / 2.0f), this.zSlab);
            }
        }
    }

    private void setPosition() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        boolean bl;
        boolean bl2 = bl = this.xyz != null;
        if (this.valign == 0 || this.valign == 4) {
            f5 = this.movableXPercent != Integer.MAX_VALUE ? (float)(this.movableXPercent * this.windowWidth / 100) : (bl ? (float)this.movableX : (float)this.movableX * this.fontScale);
            f4 = (float)this.offsetX * this.fontScale;
            f2 = f3 = f5 + f4;
            f = f3;
        } else {
            f = 5.0f * this.fontScale;
            f3 = this.windowWidth / 2;
            f2 = (float)this.windowWidth - f;
        }
        this.boxXY[0] = f;
        switch (this.align) {
            case 2: {
                this.boxXY[0] = f3 - this.boxWidth / 2.0f;
                break;
            }
            case 3: {
                this.boxXY[0] = f2 - this.boxWidth;
            }
        }
        this.boxXY[1] = 0.0f;
        switch (this.valign) {
            case 1: {
                break;
            }
            case 3: {
                this.boxXY[1] = this.windowHeight / 2;
                break;
            }
            case 2: {
                this.boxXY[1] = this.windowHeight;
                break;
            }
            default: {
                f5 = this.movableXPercent != Integer.MAX_VALUE ? (float)(this.movableYPercent * this.windowHeight / 100) : (bl ? (float)this.movableY : (float)this.movableY * this.fontScale);
                f4 = (float)this.offsetY * this.fontScale;
                this.boxXY[1] = (bl ? f5 : (float)this.windowHeight - f5) + f4;
            }
        }
        if (bl) {
            this.boxXY[1] = this.boxXY[1] - (this.align == 2 ? this.boxHeight : (float)this.ascent) / 2.0f;
        }
    }

    static void setLabelPosition(float f, float f2, float f3, float f4, float[] fArray) {
        float f5;
        if (f3 > 0.0f) {
            f5 = f3;
        } else {
            f5 = -f;
            f5 = f3 == 0.0f ? (f5 /= 2.0f) : (f5 += f3);
        }
        float f6 = f4 > 0.0f ? f4 : (f4 == 0.0f ? -f2 / 2.0f - 2.0f : -f2 + f4);
        fArray[0] = fArray[0] + f5;
        fArray[1] = fArray[1] + f6;
    }

    void setBoxOffsetsInWindow() {
        float f = this.boxX;
        float f2 = 5.0f * this.fontScale;
        float f3 = this.boxWidth + f2;
        if (f + f3 > (float)this.windowWidth) {
            f = (float)this.windowWidth - f3;
        }
        if (f < f2) {
            f = f2;
        }
        this.boxX = f;
        f2 = this.isLabelOrHover ? 16.0f * this.fontScale + (float)this.lineHeight : 0.0f;
        float f4 = this.boxY - (float)this.textHeight;
        float f5 = this.boxHeight;
        if (f4 + f5 > (float)this.windowHeight) {
            f4 = (float)this.windowHeight - f5;
        }
        if (f4 < f2) {
            f4 = f2;
        }
        this.boxY = f4;
    }

    private static void showBox(JmolRendererInterface jmolRendererInterface, short s, short s2, int n, int n2, int n3, int n4, int n5, int n6, float f, boolean bl) {
        jmolRendererInterface.fillRect(n, n2, n3, n4, n5, n6);
        jmolRendererInterface.setColix(s);
        if (!bl) {
            return;
        }
        if (f >= 2.0f) {
            jmolRendererInterface.drawRect(n + 3, n2 + 3, n3 - 1, n4, n5 - 6, n6 - 6);
            jmolRendererInterface.drawRect(n + 4, n2 + 4, n3 - 1, n4, n5 - 8, n6 - 8);
        } else {
            jmolRendererInterface.drawRect(n + 1, n2 + 1, n3 - 1, n4, n5 - 2, n6 - 2);
        }
    }

    static final void renderSimpleLabel(JmolRendererInterface jmolRendererInterface, Font3D font3D, String string, short s, short s2, float[] fArray, int n, int n2, int n3, int n4, float f, int n5, boolean bl, short s3) {
        float f2 = font3D.fontMetrics.stringWidth(string) + 8;
        float f3 = f + (float)n5 + 8.0f;
        int n6 = (int)fArray[0];
        int n7 = (int)fArray[1];
        Text.setLabelPosition(f2, f3, n3, n4, fArray);
        float f4 = fArray[0];
        float f5 = fArray[1];
        if (s2 != 0 && jmolRendererInterface.setColix(s2)) {
            Text.showBox(jmolRendererInterface, s, s2, (int)f4, (int)f5, n, n2, (int)f2, (int)f3, 1.0f, true);
        } else {
            jmolRendererInterface.setColix(s);
        }
        jmolRendererInterface.drawString(string, font3D, (int)(f4 + 4.0f), (int)(f5 + 4.0f + f), n - 1, n2);
        if (bl) {
            jmolRendererInterface.setColix(s3);
            if (n3 > 0) {
                jmolRendererInterface.drawLine(n6, n7, n2, (int)f4, (int)(f5 + f3 / 2.0f), n2);
            } else if (n3 < 0) {
                jmolRendererInterface.drawLine(n6, n7, n2, (int)(f4 + f2), (int)(f5 + f3 / 2.0f), n2);
            }
        }
    }

    public String getState(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.text == null || this.isLabelOrHover || this.target.equals("error")) {
            return "";
        }
        if (bl) {
            String string = null;
            switch (this.valign) {
                case 0: {
                    if (this.movableXPercent == Integer.MAX_VALUE || this.movableYPercent == Integer.MAX_VALUE) {
                        string = this.movableXPercent == Integer.MAX_VALUE ? this.movableX + " " : this.movableXPercent + "% ";
                        string = string + (this.movableYPercent == Integer.MAX_VALUE ? this.movableY + "" : this.movableYPercent + "%");
                    } else {
                        string = "[" + this.movableXPercent + " " + this.movableYPercent + "%]";
                    }
                }
                case 4: {
                    if (string == null) {
                        string = Escape.escape(this.xyz);
                    }
                    stringBuffer.append("  set echo ").append(this.target).append(" ").append(string);
                    if (this.align == 1) break;
                    stringBuffer.append("  set echo ").append(this.target).append(" ").append(hAlignNames[this.align]);
                    break;
                }
                default: {
                    stringBuffer.append("  set echo ").append(vAlignNames[this.valign]).append(" ").append(hAlignNames[this.align]);
                }
            }
            stringBuffer.append("; echo ").append(Escape.escape(this.textUnformatted)).append(";\n");
            if (this.script != null) {
                stringBuffer.append("  set echo ").append(this.target).append(" script ").append(Escape.escape(this.script)).append(";\n");
            }
            if (this.modelIndex >= 0) {
                stringBuffer.append("  set echo ").append(this.target).append(" model ").append(this.viewer.getModelNumberDotted(this.modelIndex)).append(";\n");
            }
        }
        if (bl != this.target.equals("top")) {
            return stringBuffer.toString();
        }
        stringBuffer.append("  " + Shape.getFontCommand("echo", this.font));
        if (this.scalePixelsPerMicron > 0.0f) {
            stringBuffer.append(" " + 10000.0f / this.scalePixelsPerMicron);
        }
        stringBuffer.append(";\n");
        stringBuffer.append("  color echo");
        if (Graphics3D.isColixTranslucent(this.colix)) {
            stringBuffer.append(" translucent " + Graphics3D.getColixTranslucencyLevel(this.colix));
        }
        stringBuffer.append(" [x").append(this.g3d.getHexColorFromIndex(this.colix)).append("]");
        if (this.bgcolix != 0) {
            stringBuffer.append("; color echo background");
            if (Graphics3D.isColixTranslucent(this.bgcolix)) {
                stringBuffer.append(" translucent " + Graphics3D.getColixTranslucencyLevel(this.bgcolix));
            }
            stringBuffer.append(" [x").append(this.g3d.getHexColorFromIndex(this.bgcolix)).append("]");
        }
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }

    public boolean checkObjectClicked(int n, int n2, BitSet bitSet) {
        if (this.modelIndex >= 0 && !bitSet.get(this.modelIndex)) {
            return false;
        }
        if (this.g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
        }
        return this.script != null && (float)n >= this.boxX && (float)n <= this.boxX + this.boxWidth && (float)n2 >= this.boxY && (float)n2 <= this.boxY + this.boxHeight;
    }

    private int stringWidth(String string) {
        int n = 0;
        int n2 = 1;
        int n3 = 1;
        if (string == null) {
            return 0;
        }
        if (string.indexOf("<su") < 0) {
            return this.fm.stringWidth(string);
        }
        int n4 = string.length();
        for (int i = 0; i < n4; ++i) {
            if (string.charAt(i) == '<') {
                String string2;
                if (i + 4 < n4 && ((string2 = string.substring(i, i + 5)).equals("<sub>") || string2.equals("<sup>"))) {
                    i += 4;
                    n2 = n3;
                    continue;
                }
                if (i + 5 < n4 && ((string2 = string.substring(i, i + 6)).equals("</sub>") || string2.equals("</sup>"))) {
                    i += 5;
                    n2 = 1;
                    continue;
                }
            }
            n += this.fm.stringWidth(string.substring(i, i + 1)) * n2;
        }
        return n;
    }
}

