/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.shape.FontLineShape;
import org.jmol.symmetry.UnitCell;

public class Axes
extends FontLineShape {
    Point3f axisXY = new Point3f();
    float scale;
    private static final Point3f[] unitAxisPoints = new Point3f[]{new Point3f(1.0f, 0.0f, 0.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 0.0f, 1.0f), new Point3f(-1.0f, 0.0f, 0.0f), new Point3f(0.0f, -1.0f, 0.0f), new Point3f(0.0f, 0.0f, -1.0f)};
    final Point3f originPoint = new Point3f();
    final Point3f[] axisPoints = new Point3f[6];
    static final Point3f pt0 = new Point3f();
    final Point3f ptTemp;
    private static final float MIN_AXIS_LEN = 1.5f;
    Vector3f corner;

    public Axes() {
        int n = 6;
        while (--n >= 0) {
            this.axisPoints[n] = new Point3f();
        }
        this.ptTemp = new Point3f();
        this.corner = new Vector3f();
    }

    Point3f getOriginPoint(boolean bl) {
        return bl ? pt0 : this.originPoint;
    }

    Point3f getAxisPoint(int n, boolean bl) {
        if (!bl && this.axisXY.z == 0.0f) {
            return this.axisPoints[n];
        }
        this.ptTemp.set(this.axisPoints[n]);
        this.ptTemp.sub(this.originPoint);
        this.ptTemp.scale(0.5f);
        return this.ptTemp;
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("position" == string) {
            this.axisXY = (Point3f)object;
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    public void initShape() {
        super.initShape();
        this.myType = "axes";
        this.font3d = this.g3d.getFont3D(14.0f);
        int n = this.viewer.getAxesMode();
        if (n == 2 && this.modelSet.getCellInfos() != null) {
            UnitCell unitCell = this.viewer.getCurrentUnitCell();
            if (unitCell == null) {
                return;
            }
            Point3f[] point3fArray = unitCell.getVertices();
            Point3f point3f = unitCell.getCartesianOffset();
            this.originPoint.set(point3f);
            this.scale = this.viewer.getAxesScale() / 2.0f;
            this.axisPoints[0].scaleAdd(this.scale, point3fArray[4], point3f);
            this.axisPoints[1].scaleAdd(this.scale, point3fArray[2], point3f);
            this.axisPoints[2].scaleAdd(this.scale, point3fArray[1], point3f);
            return;
        }
        if (n == 1) {
            this.originPoint.set(0.0f, 0.0f, 0.0f);
        } else {
            this.originPoint.set(this.viewer.getBoundBoxCenter());
        }
        this.setScale(this.viewer.getAxesScale() / 2.0f);
    }

    public Object getProperty(String string, int n) {
        if (string.equals("axisPoints")) {
            return this.axisPoints;
        }
        if (string == "axesTypeXY") {
            return this.axisXY.z == 0.0f ? Boolean.FALSE : Boolean.TRUE;
        }
        return null;
    }

    void setScale(float f) {
        this.scale = f;
        this.corner.set(this.viewer.getBoundBoxCornerVector());
        int n = 6;
        while (--n >= 0) {
            Point3f point3f = this.axisPoints[n];
            point3f.set(unitAxisPoints[n]);
            if (this.corner.x < 1.5f) {
                this.corner.x = 1.5f;
            }
            if (this.corner.y < 1.5f) {
                this.corner.y = 1.5f;
            }
            if (this.corner.z < 1.5f) {
                this.corner.z = 1.5f;
            }
            if (this.axisXY.z == 0.0f) {
                point3f.x *= this.corner.x * f;
                point3f.y *= this.corner.y * f;
                point3f.z *= this.corner.z * f;
            }
            point3f.add(this.originPoint);
        }
    }

    public String getShapeState() {
        String string = this.axisXY.z == 0.0f ? "" : "  axes position [" + (int)this.axisXY.x + " " + (int)this.axisXY.y + (this.axisXY.z < 0.0f ? " %" : "") + "];\n";
        return super.getShapeState() + "  axisScale = " + this.viewer.getAxesScale() + ";\n" + string;
    }
}

