/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.readers.VoxelReader;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class Parameters {
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_DATA_READ = 2;
    public static final int STATE_DATA_COLORED = 3;
    int state = 0;
    boolean logMessages = false;
    boolean logCompression = false;
    boolean logCube = false;
    boolean isSilent = false;
    float assocCutoff = 0.3f;
    static final int NO_ANISOTROPY = 32;
    static final int IS_SILENT = 64;
    static final int IS_SOLVENTTYPE = 128;
    static final int HAS_MAXGRID = 256;
    static final int CAN_CONTOUR = 512;
    int dataType;
    int surfaceType;
    static final int SURFACE_NONE = 0;
    static final int SURFACE_SPHERE = 65;
    static final int SURFACE_ELLIPSOID2 = 66;
    static final int SURFACE_ELLIPSOID3 = 67;
    static final int SURFACE_LOBE = 68;
    static final int SURFACE_LCAOCARTOON = 69;
    static final int SURFACE_FUNCTIONXY = 518;
    static final int SURFACE_SOLVENT = 171;
    static final int SURFACE_SASURFACE = 172;
    static final int SURFACE_MOLECULARORBITAL = 301;
    static final int SURFACE_ATOMICORBITAL = 14;
    static final int SURFACE_MEP = 304;
    static final int SURFACE_FILE = 529;
    static final int SURFACE_INFO = 530;
    static final int SURFACE_MOLECULAR = 179;
    static final int SURFACE_NOMAP = 180;
    static final int SURFACE_PROPERTY = 181;
    String calculationType = "";
    boolean addHydrogens;
    float solventRadius;
    float solventExtendedAtomRadius;
    float solventAtomRadiusFactor;
    float solventAtomRadiusAbsolute;
    float solventAtomRadiusOffset;
    boolean propertySmoothing;
    boolean useIonic;
    float envelopeRadius;
    float cavityRadius;
    boolean isCavity;
    Boolean pocket;
    int minSet;
    Point4f cappingPlane;
    boolean doCapIsosurface;
    float[] theProperty;
    float solvent_ptsPerAngstrom = 4.0f;
    int solvent_gridMax = 60;
    static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    static final int defaultEdgeFractionBase = 35;
    static final int defaultEdgeFractionRange = 90;
    static final int defaultColorFractionBase = 35;
    static final int defaultColorFractionRange = 90;
    static final float defaultMappedDataMin = 0.0f;
    static final float defaultMappedDataMax = 1.0f;
    static final float defaultCutoff = 0.02f;
    static final float defaultOrbitalCutoff = 0.14f;
    public static final float defaultQMOrbitalCutoff = 0.05f;
    static final int defaultContourCount = 11;
    static final int nContourMax = 100;
    static final int defaultColorNegative = -65536;
    static final int defaultColorPositive = -16776961;
    static final int defaultColorNegativeLCAO = -8388480;
    static final int defaultColorPositiveLCAO = -23296;
    static final float defaultSolventRadius = 1.2f;
    static final float defaultMepCutoff = 0.05f;
    static final float defaultMepMin = -0.05f;
    static final float defaultMepMax = 0.05f;
    boolean colorBySign;
    boolean colorByPhase;
    boolean colorBySets;
    int colorNeg;
    int colorPos;
    int colorPosLCAO;
    int colorNegLCAO;
    int colorPhase;
    boolean iAddGridPoints;
    boolean remappable;
    int atomIndex;
    boolean isAngstroms;
    float scale;
    float[] anisotropy = new float[3];
    boolean isAnisotropic;
    Matrix3f eccentricityMatrix;
    Matrix3f eccentricityMatrixInverse;
    boolean isEccentric;
    float eccentricityScale;
    float eccentricityRatio;
    float[] aniosU;
    float[] anisoB;
    String lcaoType;
    Vector functionXYinfo;
    int psi_n = 2;
    int psi_l = 1;
    int psi_m = 1;
    float psi_Znuc = 1.0f;
    float psi_ptsPerAngstrom = 5.0f;
    public static final int MEP_MAX_GRID = 40;
    int mep_gridMax = 40;
    float mep_ptsPerAngstrom = 3.0f;
    float mep_marginAngstroms = 1.0f;
    int qmOrbitalType;
    int qmOrbitalCount;
    static final int QM_TYPE_UNKNOWN = 0;
    static final int QM_TYPE_GAUSSIAN = 1;
    static final int QM_TYPE_SLATER = 2;
    Hashtable moData;
    Hashtable mo;
    float[] moCoefficients;
    public static final int MO_MAX_GRID = 80;
    int qm_gridMax = 80;
    float qm_ptsPerAngstrom = 10.0f;
    float qm_marginAngstroms = 1.0f;
    int qm_nAtoms;
    int qm_moNumber = Integer.MAX_VALUE;
    Point3f center;
    Point3f point;
    float distance;
    String script;
    BitSet bsSelected;
    BitSet bsIgnore;
    BitSet bsSolvent;
    boolean iUseBitSets = false;
    String[] title;
    boolean blockCubeData;
    int fileIndex;
    String fileName;
    int modelIndex;
    boolean isXLowToHigh;
    boolean insideOut;
    float cutoff = Float.MAX_VALUE;
    boolean isCutoffAbsolute;
    boolean isPositiveOnly;
    boolean rangeAll;
    boolean rangeDefined;
    float valueMappedToRed;
    float valueMappedToBlue;
    float mappedDataMin;
    float mappedDataMax;
    boolean isColorReversed;
    boolean isBicolorMap;
    boolean isSquared;
    Point4f thePlane;
    boolean isContoured;
    int nContours;
    int thisContour;
    boolean contourFromZero;
    float resolution;
    int downsampleFactor;
    int maxSet;

    void initialize() {
        this.addHydrogens = false;
        this.atomIndex = -1;
        this.blockCubeData = false;
        this.bsIgnore = null;
        this.bsSelected = null;
        this.bsSolvent = null;
        this.calculationType = "";
        this.center = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.cappingPlane = null;
        this.colorBySets = false;
        this.colorByPhase = false;
        this.colorBySign = false;
        this.colorNeg = -65536;
        this.colorNegLCAO = -8388480;
        this.colorPos = -16776961;
        this.colorPosLCAO = -23296;
        this.cutoff = Float.MAX_VALUE;
        this.distance = Float.MAX_VALUE;
        this.doCapIsosurface = false;
        this.envelopeRadius = 10.0f;
        this.fileIndex = 1;
        this.fileName = "";
        this.functionXYinfo = null;
        this.iAddGridPoints = false;
        this.insideOut = false;
        this.isAngstroms = false;
        this.isPositiveOnly = false;
        this.isCutoffAbsolute = false;
        this.isBicolorMap = false;
        this.isCavity = false;
        this.isColorReversed = false;
        this.isSquared = false;
        this.isContoured = false;
        this.isAnisotropic = false;
        this.isEccentric = false;
        this.isSilent = false;
        this.iUseBitSets = false;
        this.logCompression = false;
        this.logCube = false;
        this.logMessages = Logger.debugging;
        this.mappedDataMin = Float.MAX_VALUE;
        this.minSet = 0;
        this.nContours = 0;
        this.pocket = null;
        this.rangeDefined = false;
        this.resolution = Float.MAX_VALUE;
        this.scale = Float.NaN;
        this.solventAtomRadiusAbsolute = 0.0f;
        this.solventAtomRadiusFactor = 1.0f;
        this.solventAtomRadiusOffset = 0.0f;
        this.solventExtendedAtomRadius = 0.0f;
        this.state = 1;
        this.thePlane = null;
        this.theProperty = null;
        this.thisContour = -1;
        this.contourFromZero = true;
        this.title = null;
        this.useIonic = false;
        this.rangeAll = false;
    }

    void setAnisotropy(Point3f point3f) {
        this.anisotropy[0] = point3f.x;
        this.anisotropy[1] = point3f.y;
        this.anisotropy[2] = point3f.z;
        this.isAnisotropic = true;
    }

    void setEccentricity(Point4f point4f) {
        Vector3f vector3f = new Vector3f(point4f.x, point4f.y, point4f.z);
        float f = this.scale > 0.0f ? this.scale : (point4f.w < 0.0f ? 1.0f : vector3f.length());
        float f2 = Math.abs(point4f.w);
        vector3f.normalize();
        Vector3f vector3f2 = new Vector3f(0.0f, 0.0f, 1.0f);
        vector3f.add(vector3f2);
        vector3f.normalize();
        if (Float.isNaN(vector3f.x)) {
            vector3f.set(1.0f, 0.0f, 0.0f);
        }
        this.eccentricityMatrix = new Matrix3f();
        this.eccentricityMatrix.setIdentity();
        this.eccentricityMatrix.set(new AxisAngle4f(vector3f, (float)Math.PI));
        this.eccentricityMatrixInverse = new Matrix3f();
        this.eccentricityMatrixInverse.invert(this.eccentricityMatrix);
        this.isAnisotropic = true;
        this.isEccentric = true;
        this.eccentricityScale = f;
        this.eccentricityRatio = f2;
        if (f2 > 1.0f) {
            this.eccentricityScale *= f2;
        }
        this.anisotropy[0] = f2 * f;
        this.anisotropy[1] = f2 * f;
        this.anisotropy[2] = f;
        if (this.center.x == Float.MAX_VALUE) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
    }

    void setPlane(Point4f point4f) {
        this.thePlane = point4f;
        if (this.thePlane.x == 0.0f && this.thePlane.y == 0.0f && this.thePlane.z == 0.0f) {
            this.thePlane.z = 1.0f;
        }
        this.isContoured = true;
    }

    void setSphere(float f) {
        this.dataType = 65;
        this.distance = f;
        this.setEccentricity(new Point4f(0.0f, 0.0f, 1.0f, 1.0f));
        this.cutoff = Float.MIN_VALUE;
        this.isCutoffAbsolute = false;
        this.isSilent = !this.logMessages;
    }

    void setEllipsoid(Point4f point4f) {
        this.dataType = 66;
        this.distance = 1.0f;
        this.setEccentricity(point4f);
        this.cutoff = Float.MIN_VALUE;
        this.isCutoffAbsolute = false;
        this.isSilent = !this.logMessages;
    }

    public void setEllipsoid(float[] fArray) {
        this.anisoB = fArray;
        for (int i = 0; i < 6; ++i) {
            System.out.print(fArray[i] + " ");
        }
        System.out.println(" in Parameters setEllipsoid" + this.center);
        this.dataType = 67;
        this.distance = 0.3f * (Float.isNaN(this.scale) ? 1.0f : this.scale);
        this.cutoff = Float.MIN_VALUE;
        this.isCutoffAbsolute = false;
        boolean bl = this.isSilent = !this.logMessages;
        if (this.center.x == Float.MAX_VALUE) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
        if (this.resolution == Float.MAX_VALUE) {
            this.resolution = 6.0f;
        }
    }

    void setLobe(Point4f point4f) {
        this.dataType = 68;
        this.setEccentricity(point4f);
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = 0.14f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isSilent = !this.logMessages;
        this.script = " center " + Escape.escape(this.center) + (Float.isNaN(this.scale) ? "" : " scale " + this.scale) + " LOBE {" + point4f.x + " " + point4f.y + " " + point4f.z + " " + point4f.w + "};";
    }

    void setLcao(String string, int n) {
        this.lcaoType = string;
        if (n == 1) {
            this.colorPosLCAO = this.colorNegLCAO;
        }
        this.isSilent = !this.logMessages;
    }

    void setRadius(boolean bl, float f) {
        this.useIonic = bl;
        if (f >= 100.0f) {
            this.solventAtomRadiusFactor = (f - 100.0f) / 100.0f;
        } else if (f > 10.0f) {
            this.solventAtomRadiusAbsolute = f - 10.0f;
        } else {
            this.solventAtomRadiusOffset = f;
        }
    }

    void setSolvent(String string, float f) {
        this.isAnisotropic = false;
        this.isEccentric = false;
        this.solventRadius = f;
        if (this.solventRadius < 0.0f) {
            this.solventRadius = 1.2f;
        }
        this.dataType = "nomap" == string ? 180 : ("molecular" == string ? 179 : ("sasurface" == string || this.solventRadius == 0.0f ? 172 : 171));
        switch (this.dataType) {
            case 180: {
                this.calculationType = "unmapped plane";
                break;
            }
            case 179: {
                this.calculationType = "molecular surface with radius " + this.solventRadius;
                break;
            }
            case 171: {
                this.calculationType = "solvent-excluded surface with radius " + this.solventRadius;
                break;
            }
            case 172: {
                this.calculationType = "solvent-accessible surface with radius " + this.solventExtendedAtomRadius;
            }
        }
        switch (this.dataType) {
            case 180: {
                this.solventExtendedAtomRadius = this.solventRadius;
                this.solventRadius = 0.0f;
                this.isContoured = false;
                break;
            }
            case 179: {
                this.solventExtendedAtomRadius = 0.0f;
                break;
            }
            case 171: {
                this.solventExtendedAtomRadius = 0.0f;
                if (this.bsIgnore != null) break;
                this.bsIgnore = this.bsSolvent;
                break;
            }
            case 172: {
                this.solventExtendedAtomRadius = this.solventRadius;
                this.solventRadius = 0.0f;
                if (this.bsIgnore != null) break;
                this.bsIgnore = this.bsSolvent;
            }
        }
    }

    void setFunctionXY(Vector vector) {
        this.dataType = 518;
        this.functionXYinfo = vector;
        this.cutoff = Float.MIN_VALUE;
        this.isAnisotropic = false;
        this.isEccentric = false;
    }

    boolean setAtomicOrbital(float[] fArray) {
        this.dataType = 14;
        this.psi_n = (int)fArray[0];
        this.psi_l = (int)fArray[1];
        this.psi_m = (int)fArray[2];
        this.psi_Znuc = fArray[3];
        this.psi_ptsPerAngstrom = 10.0f;
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = 0.14f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isCutoffAbsolute = true;
        if (this.state < 2 && this.thePlane == null) {
            if (this.colorBySign) {
                this.isBicolorMap = true;
            }
            if (this.resolution == Float.MAX_VALUE) {
                this.resolution = 6.0f;
            }
        }
        return this.psi_Znuc > 0.0f && Math.abs(this.psi_m) <= this.psi_l && this.psi_l < this.psi_n;
    }

    void setMep(float[] fArray, boolean bl) {
        this.dataType = 304;
        this.theProperty = fArray;
        this.isAnisotropic = false;
        this.isEccentric = false;
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = 0.05f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isCutoffAbsolute = this.cutoff > 0.0f && !this.isPositiveOnly;
        this.contourFromZero = false;
        if (this.state >= 2 || this.thePlane != null) {
            if (!this.rangeDefined && !this.rangeAll) {
                this.valueMappedToRed = -0.05f;
                this.valueMappedToBlue = 0.05f;
                this.rangeDefined = true;
            }
        } else {
            this.colorBySign = true;
            this.isBicolorMap = true;
        }
    }

    void setMO(int n) {
        this.iUseBitSets = true;
        this.qm_moNumber = n;
        int n2 = this.moData.containsKey("gaussians") ? 1 : (this.qmOrbitalType = this.moData.containsKey("slaterInfo") ? 2 : 0);
        if (this.qmOrbitalType == 0) {
            Logger.error("MO ERROR: No basis functions found in file for MO calculation. (GAUSSIAN 'gfprint' keyword may be missing?)");
            this.mo = null;
        } else {
            Vector vector = (Vector)this.moData.get("mos");
            this.qmOrbitalCount = vector.size();
            this.calculationType = (String)this.moData.get("calculationType");
            this.calculationType = "Molecular orbital #" + this.qm_moNumber + "/" + this.qmOrbitalCount + " " + (this.calculationType == null ? "" : this.calculationType);
            this.mo = (Hashtable)vector.get(this.qm_moNumber - 1);
            if (this.title == null) {
                this.title = new String[5];
                this.title[0] = "%F";
                this.title[1] = "Model %M  MO %I/%N %T";
                this.title[2] = "Energy = %E %U";
                this.title[3] = "?Symmetry = %S";
                this.title[4] = "?Occupancy = %O";
            }
            this.moCoefficients = (float[])this.mo.get("coefficients");
            this.dataType = 301;
        }
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = 0.05f;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        boolean bl = this.isCutoffAbsolute = this.cutoff > 0.0f && !this.isPositiveOnly;
        if (this.state >= 2 || this.thePlane != null) {
            return;
        }
        this.colorBySign = true;
        if (this.colorByPhase && this.colorPhase == 0) {
            this.colorByPhase = false;
        }
        this.isBicolorMap = true;
    }

    void setMapRanges(VoxelReader voxelReader) {
        if (this.colorByPhase || this.colorBySign || (this.thePlane != null || this.isBicolorMap) && !this.isContoured) {
            this.mappedDataMin = -1.0f;
            this.mappedDataMax = 1.0f;
        }
        if (this.mappedDataMin == Float.MAX_VALUE || this.mappedDataMin == this.mappedDataMax) {
            this.mappedDataMin = voxelReader.getMinMappedValue();
            this.mappedDataMax = voxelReader.getMaxMappedValue();
        }
        if (this.mappedDataMin == 0.0f && this.mappedDataMax == 0.0f) {
            this.mappedDataMin = -1.0f;
            this.mappedDataMax = 1.0f;
        }
        if (!this.rangeDefined) {
            this.valueMappedToRed = this.mappedDataMin;
            this.valueMappedToBlue = this.mappedDataMax;
        }
    }
}

