/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jmol.util.Logger;

public class GT {
    private static boolean ignoreApplicationBundle = false;
    private static GT getTextWrapper;
    private ResourceBundle[] translationResources = null;
    private int translationResourcesCount = 0;
    private boolean doTranslate = true;
    private String language;
    private static Language[] languageList;

    public GT(String string) {
        this.getTranslation(string);
    }

    private GT() {
        this.getTranslation(null);
    }

    public static Language[] getLanguageList() {
        return languageList != null ? languageList : GT.getTextWrapper().createLanguageList();
    }

    private synchronized Language[] createLanguageList() {
        boolean bl = this.doTranslate;
        this.doTranslate = false;
        languageList = new Language[]{new Language("ca", GT._("Catalan"), true), new Language("cs", GT._("Czech"), true), new Language("da", GT._("Danish"), false), new Language("nl", GT._("Dutch"), true), new Language("en_US", GT._("English"), true), new Language("et", GT._("Estonian"), true), new Language("fr", GT._("French"), true), new Language("de", GT._("German"), true), new Language("hu", GT._("Hungarian"), true), new Language("it", GT._("Italian"), false), new Language("ko", GT._("Korean"), true), new Language("pl", GT._("Polish"), false), new Language("pt_BR", GT._("Portuguese - Brazil"), true), new Language("pt", GT._("Portuguese"), true), new Language("ru", GT._("Russian"), false), new Language("es", GT._("Spanish"), true), new Language("sv", GT._("Swedish"), false), new Language("tr", GT._("Turkish"), true)};
        this.doTranslate = bl;
        return languageList;
    }

    private String getSupported(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (languageList == null) {
            this.createLanguageList();
        }
        for (int i = 0; i < languageList.length; ++i) {
            if (!GT.languageList[i].code.equalsIgnoreCase(string)) continue;
            return GT.languageList[i].code;
        }
        return bl ? null : this.findClosest(string);
    }

    private String findClosest(String string) {
        int n = languageList.length;
        while (--n >= 0) {
            if (!GT.languageList[n].code.startsWith(string)) continue;
            return GT.languageList[n].code;
        }
        return null;
    }

    public static String getLanguage() {
        return GT.getTextWrapper().language;
    }

    private synchronized void getTranslation(String string) {
        String string2;
        Locale locale;
        this.translationResources = null;
        this.translationResourcesCount = 0;
        getTextWrapper = this;
        if (string != null && string.length() == 0) {
            string = "none";
        }
        if (string != null) {
            this.language = string;
        }
        if ("none".equals(this.language)) {
            this.language = null;
        }
        if (this.language == null && (locale = Locale.getDefault()) != null) {
            this.language = locale.getLanguage();
            if (locale.getCountry() != null) {
                this.language = this.language + "_" + locale.getCountry();
                if (locale.getVariant() != null && locale.getVariant().length() > 0) {
                    this.language = this.language + "_" + locale.getVariant();
                }
            }
        }
        if (this.language == null) {
            this.language = "en_US";
        }
        String string3 = this.language;
        String string4 = this.language;
        String string5 = this.language;
        int n = this.language.indexOf("_");
        if (n >= 0) {
            string3 = string3.substring(0, n);
            ++n;
            if ((n = this.language.indexOf("_", n)) >= 0) {
                string4 = this.language.substring(0, n);
            } else {
                string5 = null;
            }
        } else {
            string4 = null;
            string5 = null;
        }
        this.language = this.getSupported(string5, false);
        if (this.language == null && (this.language = this.getSupported(string4, false)) == null && (this.language = this.getSupported(string3, false)) == null) {
            this.language = "en";
            string3 = "en";
            Logger.debug("English: no need for gettext wrapper");
            return;
        }
        string5 = null;
        string4 = null;
        switch (this.language.length()) {
            case 2: {
                string3 = this.language;
                break;
            }
            case 5: {
                string4 = this.language;
                string3 = this.language.substring(0, 2);
                break;
            }
            default: {
                string5 = this.language;
                string4 = this.language.substring(0, 5);
                string3 = this.language.substring(0, 2);
            }
        }
        if ("en".equals(string3)) {
            return;
        }
        string4 = this.getSupported(string4, false);
        if ((string3 = this.getSupported(string3, false)) == string4) {
            string3 = null;
        }
        if (string4 == string5) {
            string4 = null;
        }
        if (Logger.debugging) {
            Logger.debug("Instantiating gettext wrapper for " + this.language + " using files for language:" + string3 + " country:" + string4 + " variant:" + string5);
        }
        try {
            if (!ignoreApplicationBundle) {
                string2 = "org.jmol.translation.Jmol.Messages_";
                if (string5 != null) {
                    this.addBundle(string2 + string5);
                }
                if (string4 != null) {
                    this.addBundle(string2 + string4);
                }
                if (string3 != null) {
                    this.addBundle(string2 + string3);
                }
            }
        }
        catch (Exception exception) {
            Logger.error("Some exception occurred!", exception);
            this.translationResources = null;
        }
        try {
            string2 = "org.jmol.translation.JmolApplet.Messages_";
            if (string5 != null) {
                this.addBundle(string2 + string5);
            }
            if (string4 != null) {
                this.addBundle(string2 + string4);
            }
            if (string3 != null) {
                this.addBundle(string2 + string3);
            }
        }
        catch (Exception exception) {
            Logger.error("Some exception occurred!", exception);
        }
    }

    private void addBundle(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.error("GT could not find the class " + string);
        }
        if (clazz != null && ResourceBundle.class.isAssignableFrom(clazz)) {
            try {
                ResourceBundle resourceBundle = (ResourceBundle)clazz.newInstance();
                if (resourceBundle != null) {
                    if (this.translationResources == null) {
                        this.translationResources = new ResourceBundle[8];
                        this.translationResourcesCount = 0;
                    }
                    this.translationResources[this.translationResourcesCount] = resourceBundle;
                    ++this.translationResourcesCount;
                    Logger.debug("GT adding " + string);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.warn("Illegal Access Exception: " + illegalAccessException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                Logger.warn("Instantiation Excaption: " + instantiationException.getMessage());
            }
        }
    }

    private static GT getTextWrapper() {
        return getTextWrapper == null ? (getTextWrapper = new GT()) : getTextWrapper;
    }

    public static void ignoreApplicationBundle() {
        ignoreApplicationBundle = true;
    }

    public static void setDoTranslate(boolean bl) {
        GT.getTextWrapper().doTranslate = bl;
    }

    public static boolean getDoTranslate() {
        return GT.getTextWrapper().doTranslate;
    }

    public static String _(String string) {
        return GT.getTextWrapper().getString(string);
    }

    public static String _(String string, String string2) {
        return GT.getTextWrapper().getString(string, new Object[]{string2});
    }

    public static String _(String string, int n) {
        return GT.getTextWrapper().getString(string, new Object[]{new Integer(n)});
    }

    public static String _(String string, Object[] objectArray) {
        return GT.getTextWrapper().getString(string, objectArray);
    }

    public static String _(String string, boolean bl) {
        return GT._(string, (Object[])null, bl);
    }

    public static String _(String string, String string2, boolean bl) {
        return GT._(string, new Object[]{string2});
    }

    public static String _(String string, int n, boolean bl) {
        return GT._(string, new Object[]{new Integer(n)});
    }

    public static synchronized String _(String string, Object[] objectArray, boolean bl) {
        String string2;
        boolean bl2 = GT.getTextWrapper().doTranslate;
        if (!bl2) {
            GT.setDoTranslate(true);
        }
        String string3 = string2 = objectArray == null ? GT._(string) : GT._(string, objectArray);
        if (!bl2) {
            GT.setDoTranslate(false);
        }
        return string2;
    }

    private String getString(String string) {
        if (!this.doTranslate) {
            return string;
        }
        for (int i = 0; i < this.translationResourcesCount; ++i) {
            try {
                String string2 = this.translationResources[i].getString(string);
                return string2;
            }
            catch (MissingResourceException missingResourceException) {
                continue;
            }
        }
        if (this.translationResourcesCount > 0 && Logger.debugging) {
            Logger.debug("No trans, using default: " + string);
        }
        return string;
    }

    private String getString(String string, Object[] objectArray) {
        String string2 = null;
        if (!this.doTranslate) {
            return MessageFormat.format(string, objectArray);
        }
        for (int i = 0; i < this.translationResourcesCount; ++i) {
            try {
                string2 = MessageFormat.format(this.translationResources[i].getString(string), objectArray);
                return string2;
            }
            catch (MissingResourceException missingResourceException) {
                continue;
            }
        }
        string2 = MessageFormat.format(string, objectArray);
        if (this.translationResourcesCount > 0 && Logger.debugging) {
            Logger.debug("No trans, using default: " + string2);
        }
        return string2;
    }

    public static class Language {
        public final String code;
        public final String language;
        public final boolean display;

        public Language(String string, String string2, boolean bl) {
            this.code = string;
            this.language = string2;
            this.display = bl;
        }
    }
}

