/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.export._Exporter;
import org.jmol.g3d.Font3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.Text;
import org.jmol.util.BitSetUtil;

public class _VrmlExporter
extends _Exporter {
    public _VrmlExporter() {
        this.use2dBondOrderCalculation = false;
    }

    private void output(String string) {
        this.output.append(string);
    }

    public void getHeader() {
        this.output("#VRML V2.0 utf8\n");
        this.output("Transform {\n");
        this.output("translation " + -this.center.x + " " + -this.center.y + " " + -this.center.z + "\n");
        this.output("children [\n");
    }

    public void getFooter() {
        this.output("]\n");
        this.output("}\n");
    }

    public void renderAtom(Atom atom, short s) {
        String string = this.rgbFractionalFromColix(s, ' ');
        float f = (float)atom.getMadAtom() / 2000.0f;
        this.output("Transform {\n");
        this.output("translation " + atom.x + " " + atom.y + " " + atom.z + "\n");
        this.output("children [\n");
        this.output("Shape {\n");
        this.output("geometry Sphere { radius " + f + " }\n");
        this.output("appearance Appearance {\n");
        this.output("material Material { diffuseColor " + string + " }\n");
        this.output("}\n");
        this.output("}\n");
        this.output("]\n");
        this.output("}\n");
    }

    public void fillCylinder(Point3f point3f, Point3f point3f2, short s, short s2, byte by, int n, int n2) {
        if (s == s2) {
            this.renderCylinder(point3f, point3f2, s, by, n);
            return;
        }
        this.tempV2.set(point3f2);
        this.tempV2.add(point3f);
        this.tempV2.scale(0.5f);
        this.tempP1.set(this.tempV2);
        this.renderCylinder(point3f, this.tempP1, s, by, n);
        this.renderCylinder(this.tempP1, point3f2, s2, by, n);
    }

    public void renderCylinder(Point3f point3f, Point3f point3f2, short s, byte by, int n) {
        String string = this.rgbFractionalFromColix(s, ' ');
        float f = point3f.distance(point3f2);
        float f2 = (float)n / 2000.0f;
        this.tempV1.set(point3f2);
        this.tempV1.add(point3f);
        this.tempV1.scale(0.5f);
        this.output("Transform {\n");
        this.output("translation " + this.tempV1.x + " " + this.tempV1.y + " " + this.tempV1.z + "\n");
        this.tempV1.sub(point3f);
        this.getAxisAngle(this.tempV1);
        this.output("rotation " + this.tempA.x + " " + this.tempA.y + " " + this.tempA.z + " " + this.tempA.angle + "\n");
        this.output("children[\n");
        this.output("Shape {\n");
        this.output("geometry Cylinder { height " + f + " radius " + f2 + " }\n");
        this.output("appearance Appearance {\n");
        this.output("material Material { diffuseColor " + string + " }\n");
        this.output("}\n");
        this.output("}\n");
        this.output("]\n");
        this.output("}\n");
    }

    public void renderIsosurface(Point3f[] point3fArray, short s, short[] sArray, Vector3f[] vector3fArray, int[][] nArray, BitSet bitSet, int n, int n2) {
        if (n == 0) {
            return;
        }
        int n3 = 0;
        int n4 = BitSetUtil.length(bitSet);
        while (--n4 >= 0) {
            if (!bitSet.get(n4)) continue;
            n3 += n2 == 4 && nArray[n4].length == 4 ? 2 : 1;
        }
        if (n3 == 0) {
            return;
        }
        String string = this.rgbFractionalFromColix(s, ' ');
        this.output("Shape {\n");
        this.output("appearance Appearance {\n");
        this.output("material Material { diffuseColor " + string + " }\n");
        this.output("}\n");
        this.output("geometry IndexedFaceSet {\n");
        this.output("coord Coordinate {\n");
        this.output("point [\n");
        for (int i = 0; i < n; ++i) {
            String string2 = " ";
            this.output(string2 + point3fArray[i].x + " " + point3fArray[i].y + " " + point3fArray[i].z + "\n");
            if (i != 0) continue;
            string2 = ",";
        }
        this.output("]\n");
        this.output("}\n");
        this.output("coordIndex [\n");
        String string3 = " ";
        int n5 = BitSetUtil.length(bitSet);
        while (--n5 >= 0) {
            if (!bitSet.get(n5)) continue;
            this.output(string3 + nArray[n5][0] + " " + nArray[n5][1] + " " + nArray[n5][2] + " -1\n");
            if (n5 == 0) {
                string3 = ",";
            }
            if (n2 != 4 || nArray[n5].length != 4) continue;
            this.output(string3 + nArray[n5][0] + " " + nArray[n5][2] + " " + nArray[n5][3] + " -1\n");
        }
        this.output("]\n");
        this.output("}\n");
        this.output("}\n");
    }

    public void renderText(Text text) {
    }

    public void drawString(short s, String string, Font3D font3D, int n, int n2, int n3, int n4) {
    }

    public void fillCylinder(short s, byte by, int n, Point3f point3f, Point3f point3f2) {
    }

    public void drawCircleCentered(short s, int n, int n2, int n3, int n4, boolean bl) {
    }

    public void fillScreenedCircleCentered(short s, int n, int n2, int n3, int n4) {
    }

    public void drawPixel(short s, int n, int n2, int n3) {
    }

    public void drawTextPixel(int n, int n2, int n3, int n4) {
    }

    public void fillTriangle(short s, Point3f point3f, Point3f point3f2, Point3f point3f3) {
    }

    public void fillCone(short s, byte by, int n, Point3f point3f, Point3f point3f2) {
    }

    public void fillSphereCentered(short s, int n, Point3f point3f) {
    }

    public void plotText(int n, int n2, int n3, int n4, String string, Font3D font3D) {
    }

    public void fillHermite(short s, int n, int n2, int n3, int n4, Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
    }

    public void drawHermite(short s, int n, Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
    }

    public void drawHermite(short s, boolean bl, boolean bl2, int n, Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, Point3f point3f5, Point3f point3f6, Point3f point3f7, Point3f point3f8, int n2) {
    }

    public void renderEllipsoid(short s, int n, int n2, int n3, int n4, double[] dArray, Point3i[] point3iArray) {
    }
}

