/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.BitSet;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolExportInterface;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Hermite3D;
import org.jmol.shape.ShapeRenderer;

public final class Export3D
implements JmolRendererInterface {
    private Graphics3D g3d;
    private short colix;
    private Hermite3D hermite3d;
    private int width;
    private int height;
    private int slab;
    private JmolExportInterface exporter;
    private Point3f ptA = new Point3f();
    private Point3f ptB = new Point3f();
    private Point3f ptC = new Point3f();
    private Point3f ptD = new Point3f();
    private Point3i ptAi = new Point3i();
    private Point3i ptBi = new Point3i();

    public JmolExportInterface getExporter() {
        return this.exporter;
    }

    public Export3D() {
        this.hermite3d = new Hermite3D(this);
    }

    public void setg3dExporter(Graphics3D graphics3D, JmolExportInterface jmolExportInterface) {
        this.g3d = graphics3D;
        this.width = graphics3D.getRenderWidth();
        this.height = graphics3D.getRenderHeight();
        this.slab = graphics3D.getSlab();
        this.exporter = jmolExportInterface;
        jmolExportInterface.setRenderer(this);
    }

    public void setSlab(int n) {
        this.slab = n;
        this.g3d.setSlab(n);
    }

    public void setRenderer(ShapeRenderer shapeRenderer) {
    }

    public void fillScreenedCircleCentered(short s, int n, int n2, int n3, int n4) {
        if (this.isClippedZ(n4)) {
            return;
        }
        this.exporter.fillScreenedCircleCentered(s, n, n2, n3, n4);
    }

    public void drawCircleCentered(short s, int n, int n2, int n3, int n4, boolean bl) {
        if (this.isClippedZ(n4)) {
            return;
        }
        this.exporter.drawCircleCentered(s, n, n2, n3, n4, bl);
    }

    public void fillSphereCentered(int n, int n2, int n3, int n4) {
        this.ptA.set(n2, n3, n4);
        this.fillSphereCentered(n, this.ptA);
    }

    public void fillSphereCentered(int n, Point3i point3i) {
        this.ptA.set(point3i.x, point3i.y, point3i.z);
        this.fillSphereCentered(n, this.ptA);
    }

    public void fillSphereCentered(int n, Point3f point3f) {
        if (n == 0) {
            return;
        }
        this.exporter.fillSphereCentered(this.colix, n, point3f);
    }

    public void drawRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n4 != 0 && this.isClippedZ(n4)) {
            return;
        }
        int n7 = n5 - 1;
        int n8 = n6 - 1;
        int n9 = n + n7;
        int n10 = n2 + n8;
        if (n2 >= 0 && n2 < this.height) {
            this.drawHLine(n, n2, n3, n7);
        }
        if (n10 >= 0 && n10 < this.height) {
            this.drawHLine(n, n10, n3, n7);
        }
        if (n >= 0 && n < this.width) {
            this.drawVLine(n, n2, n3, n8);
        }
        if (n9 >= 0 && n9 < this.width) {
            this.drawVLine(n9, n2, n3, n8);
        }
    }

    private void drawHLine(int n, int n2, int n3, int n4) {
        int n5 = this.g3d.getColixArgb(this.colix);
        if (n4 < 0) {
            n += n4;
            n4 = -n4;
        }
        for (int i = 0; i <= n4; ++i) {
            this.exporter.drawTextPixel(n5, n + i, n2, n3);
        }
    }

    private void drawVLine(int n, int n2, int n3, int n4) {
        int n5 = this.g3d.getColixArgb(this.colix);
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        for (int i = 0; i <= n4; ++i) {
            this.exporter.drawTextPixel(n5, n, n2 + i, n3);
        }
    }

    public void fillRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isClippedZ(n4)) {
            return;
        }
        this.ptA.set(n, n2, n3);
        this.ptB.set(n + n5, n2, n3);
        this.ptC.set(n + n5, n2 + n6, n3);
        this.ptD.set(n, n2 + n6, n3);
        this.fillQuadrilateral(this.ptA, this.ptB, this.ptC, this.ptD);
    }

    public void drawString(String string, Font3D font3D, int n, int n2, int n3, int n4) {
        if (string == null) {
            return;
        }
        if (this.isClippedZ(n4)) {
            return;
        }
        this.drawStringNoSlab(string, font3D, n, n2, n3);
    }

    public void drawStringNoSlab(String string, Font3D font3D, int n, int n2, int n3) {
        if (string == null) {
            return;
        }
        n3 = Math.max(this.slab, n3);
        if (font3D == null) {
            font3D = this.g3d.getFont3DCurrent();
        } else {
            this.g3d.setFont(font3D);
        }
        this.exporter.plotText(n, n2, n3, this.getColixArgb(this.colix), string, font3D);
    }

    public void drawPixel(int n, int n2, int n3) {
        this.plotPixelClipped(n, n2, n3);
    }

    void plotPixelClipped(int n, int n2, int n3) {
        if (this.g3d.isClipped(n, n2, n3)) {
            return;
        }
        this.exporter.drawPixel(this.colix, n, n2, n3);
    }

    public void plotPixelClippedNoSlab(int n, int n2, int n3, int n4) {
        n4 = Math.max(this.slab, n4);
        this.exporter.drawTextPixel(n, n2, n3, n4);
    }

    public void plotPixelClipped(Point3i point3i) {
        if (this.g3d.isClipped(point3i.x, point3i.y, point3i.z)) {
            return;
        }
        this.exporter.drawPixel(this.colix, point3i.x, point3i.y, point3i.z);
    }

    public void drawPoints(int n, int[] nArray) {
        int n2 = n * 3;
        while (n2 > 0) {
            int n3;
            int n4;
            int n5 = nArray[--n2];
            --n2;
            if (this.g3d.isClipped(n4 = nArray[--n2], n3 = nArray[n2], n5)) continue;
            this.exporter.drawPixel(this.colix, n4, n3, n5);
        }
    }

    public void drawDashedLine(int n, int n2, Point3i point3i, Point3i point3i2) {
        this.drawLine(point3i, point3i2);
    }

    public void drawDottedLine(Point3i point3i, Point3i point3i2) {
        this.drawLine(point3i, point3i2);
    }

    public void drawLine(int n, int n2, int n3, int n4, int n5, int n6) {
        this.ptAi.set(n, n2, n3);
        this.ptBi.set(n4, n5, n6);
        this.drawLine(this.ptAi, this.ptBi);
    }

    public void drawLine(short s, short s2, int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillCylinder(s, s2, (byte)2, 2, n, n2, n3, n4, n5, n6);
    }

    public void drawLine(Point3i point3i, Point3i point3i2) {
        this.ptA.set(point3i.x, point3i.y, point3i.z);
        this.ptB.set(point3i2.x, point3i2.y, point3i2.z);
        this.exporter.fillCylinder(this.colix, (byte)2, 1, this.ptA, this.ptB);
    }

    public void fillCylinder(short s, short s2, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.ptA.set(n2, n3, n4);
        this.ptB.set(n5, n6, n7);
        this.exporter.fillCylinder(this.ptA, this.ptB, s, s2, by, n, 1);
    }

    public void fillCylinder(byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.fillCylinder(this.colix, this.colix, by, n, n2, n3, n4, n5, n6, n7);
    }

    public void fillCylinder(byte by, int n, Point3i point3i, Point3i point3i2) {
        if (n <= 0) {
            return;
        }
        this.ptA.set(point3i.x, point3i.y, point3i.z);
        this.ptB.set(point3i2.x, point3i2.y, point3i2.z);
        this.exporter.fillCylinder(this.colix, by, n, this.ptA, this.ptB);
    }

    public void fillCylinderBits(byte by, int n, Point3f point3f, Point3f point3f2) {
        if (n <= 0) {
            return;
        }
        this.exporter.fillCylinder(this.colix, by, n, point3f, point3f2);
    }

    public void fillCone(byte by, int n, Point3i point3i, Point3i point3i2) {
        this.ptA.set(point3i.x, point3i.y, point3i.z);
        this.ptB.set(point3i2.x, point3i2.y, point3i2.z);
        this.fillCone(by, n, this.ptA, this.ptB);
    }

    public void fillCone(byte by, int n, Point3f point3f, Point3f point3f2) {
        this.exporter.fillCone(this.colix, by, n, point3f, point3f2);
    }

    public void drawHermite(int n, Point3i point3i, Point3i point3i2, Point3i point3i3, Point3i point3i4) {
        this.hermite3d.render(false, n, 0, 0, 0, point3i, point3i2, point3i3, point3i4);
    }

    public void drawHermite(boolean bl, boolean bl2, int n, Point3i point3i, Point3i point3i2, Point3i point3i3, Point3i point3i4, Point3i point3i5, Point3i point3i6, Point3i point3i7, Point3i point3i8, int n2) {
        this.hermite3d.render2(bl, bl2, n, point3i, point3i2, point3i3, point3i4, point3i5, point3i6, point3i7, point3i8, n2);
    }

    public void fillHermite(int n, int n2, int n3, int n4, Point3i point3i, Point3i point3i2, Point3i point3i3, Point3i point3i4) {
        this.hermite3d.render(true, n, n2, n3, n4, point3i, point3i2, point3i3, point3i4);
    }

    public void drawTriangle(Point3i point3i, short s, Point3i point3i2, short s2, Point3i point3i3, short s3, int n) {
        int n2 = point3i.x;
        int n3 = point3i.y;
        int n4 = point3i.z;
        int n5 = point3i2.x;
        int n6 = point3i2.y;
        int n7 = point3i2.z;
        int n8 = point3i3.x;
        int n9 = point3i3.y;
        int n10 = point3i3.z;
        if ((n & 1) == 1) {
            this.drawLine(s, s2, n2, n3, n4, n5, n6, n7);
        }
        if ((n & 2) == 2) {
            this.drawLine(s2, s3, n5, n6, n7, n8, n9, n10);
        }
        if ((n & 4) == 4) {
            this.drawLine(s, s3, n2, n3, n4, n8, n9, n10);
        }
    }

    public void drawTriangle(Point3i point3i, Point3i point3i2, Point3i point3i3, int n) {
    }

    public void drawCylinderTriangle(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.fillCylinder((byte)3, n10, n, n2, n3, n4, n5, n6);
        this.fillCylinder((byte)3, n10, n, n2, n3, n7, n8, n9);
        this.fillCylinder((byte)3, n10, n4, n5, n6, n7, n8, n9);
    }

    public void drawfillTriangle(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.ptA.set(n, n2, n3);
        this.ptB.set(n4, n5, n6);
        this.ptC.set(n7, n8, n9);
        this.fillTriangle(this.ptA, this.ptB, this.ptC);
    }

    public void fillTriangle(Point3i point3i, int n, Point3i point3i2, int n2, Point3i point3i3, int n3) {
        this.ptA.set(point3i.x, point3i.y, point3i.z);
        this.ptB.set(point3i2.x, point3i2.y, point3i2.z);
        this.ptC.set(point3i3.x, point3i3.y, point3i3.z);
        this.exporter.fillTriangle(this.colix, this.ptA, this.ptB, this.ptC);
    }

    public void fillTriangle(Point3i point3i, short s, short s2, Point3i point3i2, short s3, short s4, Point3i point3i3, short s5, short s6) {
        if (s != s3 || s3 != s5) {
            return;
        }
        this.ptA.set(point3i.x, point3i.y, point3i.z);
        this.ptB.set(point3i2.x, point3i2.y, point3i2.z);
        this.ptC.set(point3i3.x, point3i3.y, point3i3.z);
        this.exporter.fillTriangle(s, this.ptA, this.ptB, this.ptC);
    }

    public void fillTriangle(short s, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.ptA.set(n, n2, n3);
        this.ptB.set(n4, n5, n6);
        this.ptC.set(n7, n8, n9);
        this.exporter.fillTriangle(this.colix, this.ptA, this.ptB, this.ptC);
    }

    public void fillTriangle(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        this.exporter.fillTriangle(this.colix, point3f, point3f2, point3f3);
    }

    public void fillTriangle(Point3i point3i, Point3i point3i2, Point3i point3i3) {
        this.ptA.set(point3i.x, point3i.y, point3i.z);
        this.ptB.set(point3i2.x, point3i2.y, point3i2.z);
        this.ptC.set(point3i3.x, point3i3.y, point3i3.z);
        this.exporter.fillTriangle(this.colix, this.ptA, this.ptB, this.ptC);
    }

    public void fillTriangle(Point3i point3i, short s, short s2, Point3i point3i2, short s3, short s4, Point3i point3i3, short s5, short s6, float f) {
        this.fillTriangle(point3i, s, s2, point3i2, s3, s4, point3i3, s5, s6);
    }

    public void drawQuadrilateral(short s, Point3i point3i, Point3i point3i2, Point3i point3i3, Point3i point3i4) {
        this.setColix(s);
        this.drawLine(point3i, point3i2);
        this.drawLine(point3i2, point3i3);
        this.drawLine(point3i3, point3i4);
        this.drawLine(point3i4, point3i);
    }

    public void fillQuadrilateral(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
        this.exporter.fillTriangle(this.colix, point3f, point3f2, point3f3);
        this.exporter.fillTriangle(this.colix, point3f, point3f3, point3f4);
    }

    public void fillQuadrilateral(Point3i point3i, short s, short s2, Point3i point3i2, short s3, short s4, Point3i point3i3, short s5, short s6, Point3i point3i4, short s7, short s8) {
        this.fillTriangle(point3i, s, s2, point3i2, s3, s4, point3i3, s5, s6);
        this.fillTriangle(point3i, s, s2, point3i3, s5, s6, point3i4, s7, s8);
    }

    public void renderIsosurface(Point3f[] point3fArray, short s, short[] sArray, Vector3f[] vector3fArray, int[][] nArray, BitSet bitSet, int n, int n2) {
        this.exporter.renderIsosurface(point3fArray, s, sArray, vector3fArray, nArray, bitSet, n, n2);
    }

    public void renderEllipsoid(int n, int n2, int n3, int n4, Matrix3f matrix3f, double[] dArray, Matrix4f matrix4f, int n5, Point3i[] point3iArray) {
        this.exporter.renderEllipsoid(this.colix, n, n2, n3, n4, dArray, point3iArray);
    }

    public boolean isAntialiased() {
        return false;
    }

    public boolean checkTranslucent(boolean bl) {
        return true;
    }

    public boolean haveTranslucentObjects() {
        return true;
    }

    public int getRenderWidth() {
        return this.g3d.getRenderWidth();
    }

    public int getRenderHeight() {
        return this.g3d.getRenderHeight();
    }

    public int getSlab() {
        return this.g3d.getSlab();
    }

    public int getDepth() {
        return this.g3d.getDepth();
    }

    public boolean setColix(short s) {
        this.colix = s;
        this.g3d.setColix(s);
        return true;
    }

    public void setFont(byte by) {
        this.g3d.setFont(by);
    }

    public Font3D getFont3DCurrent() {
        return this.g3d.getFont3DCurrent();
    }

    public boolean isInDisplayRange(int n, int n2) {
        return this.g3d.isInDisplayRange(n, n2);
    }

    public boolean isClippedZ(int n) {
        return this.g3d.isClippedZ(n);
    }

    public boolean isClippedXY(int n, int n2, int n3) {
        return this.g3d.isClippedXY(n, n2, n3);
    }

    public int getColixArgb(short s) {
        return this.g3d.getColixArgb(s);
    }

    public String getHexColorFromIndex(short s) {
        return this.g3d.getHexColorFromIndex(s);
    }

    public int calcSurfaceShade(Point3i point3i, Point3i point3i2, Point3i point3i3) {
        return this.g3d.calcSurfaceShade(point3i, point3i2, point3i3);
    }

    public byte getFontFid(String string, float f) {
        return this.g3d.getFontFid(string, f);
    }

    public boolean isDirectedTowardsCamera(short s) {
        return this.g3d.isDirectedTowardsCamera(s);
    }

    public short getNormix(Vector3f vector3f) {
        return this.g3d.getNormix(vector3f);
    }

    public short getInverseNormix(short s) {
        return this.g3d.getInverseNormix(s);
    }

    public Vector3f[] getTransformedVertexVectors() {
        return this.g3d.getTransformedVertexVectors();
    }

    public Vector3f getNormixVector(short s) {
        return this.g3d.getNormixVector(s);
    }

    public Font3D getFont3DScaled(Font3D font3D, float f) {
        return this.g3d.getFont3DScaled(font3D, f);
    }

    public byte getFontFid(float f) {
        return this.g3d.getFontFid(f);
    }
}

