/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class GaussianReader
extends AtomSetCollectionReader {
    private static final int STD_ORIENTATION_ATOMIC_NUMBER_OFFSET = 1;
    private static final int FREQ_FIRST_VECTOR_OFFSET = 2;
    private String energyString = "";
    private String energyKey = "";
    private int calculationNumber = 1;
    private int scanPoint = -1;
    private int equivalentAtomSets = 0;
    int atomCount = 0;
    int shellCount = 0;
    int gaussianCount = 0;
    Hashtable moData = new Hashtable();
    Vector orbitals = new Vector();

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("gaussian");
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        try {
            while (this.readLine() != null) {
                if (this.line.startsWith(" Step number")) {
                    this.equivalentAtomSets = 0;
                    ++n2;
                    int n3 = this.line.indexOf("scan point");
                    this.scanPoint = n3 > 0 ? this.parseInt(this.line, n3 + 10) : -1;
                } else if (this.line.indexOf("-- Stationary point found") > 0) {
                    if (this.scanPoint >= 0) {
                        ++this.scanPoint;
                    }
                } else if (this.line.indexOf("Input orientation:") >= 0 || this.line.indexOf("Z-Matrix orientation:") >= 0 || this.line.indexOf("Standard orientation:") >= 0) {
                    if (++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0) {
                        if (!bl) continue;
                        break;
                    }
                    ++this.equivalentAtomSets;
                    if (Logger.debugging) {
                        Logger.debug(" model " + this.modelNumber + " step " + n2 + " equivalentAtomSet " + this.equivalentAtomSets + " calculation " + this.calculationNumber + " scan point " + this.scanPoint + this.line);
                    }
                    this.readAtoms();
                    bl = true;
                } else if (bl && this.line.startsWith(" Energy=")) {
                    this.setEnergy();
                } else if (bl && this.line.startsWith(" SCF Done:")) {
                    this.readSCFDone();
                } else if (bl && this.line.startsWith(" Harmonic frequencies")) {
                    this.readFrequencies();
                } else if (bl && (this.line.startsWith(" Total atomic charges:") || this.line.startsWith(" Mulliken atomic charges:"))) {
                    this.readPartialCharges();
                } else if (bl && this.line.startsWith(" Dipole moment")) {
                    this.readDipoleMoment();
                } else if (bl && this.line.startsWith(" Standard basis:")) {
                    Logger.debug(this.line);
                    this.moData.put("energyUnits", "");
                    this.moData.put("calculationType", this.line.substring(17).trim());
                } else if (bl && this.line.startsWith(" General basis read from cards:")) {
                    Logger.debug(this.line);
                    this.moData.put("energyUnits", "");
                    this.moData.put("calculationType", this.line.substring(31).trim());
                } else if (bl && this.line.startsWith(" AO basis set:")) {
                    this.readBasis();
                    this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", this.moData);
                } else if (bl && this.line.indexOf("Molecular Orbital Coefficients") >= 0) {
                    this.readMolecularOrbitals();
                    if (Logger.debugging) {
                        Logger.debug(this.orbitals.size() + " molecular orbitals read");
                    }
                    this.moData.put("mos", this.orbitals);
                    this.setMOData(this.moData);
                } else if (this.line.startsWith(" Normal termination of Gaussian")) {
                    ++this.calculationNumber;
                    this.equivalentAtomSets = 0;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    private void readSCFDone() throws Exception {
        String[] stringArray = GaussianReader.getTokens(this.line, 11);
        this.energyKey = stringArray[0];
        this.energyString = stringArray[2] + " " + stringArray[3];
        this.atomSetCollection.setAtomSetNames(this.energyKey + " = " + this.energyString, this.equivalentAtomSets);
        this.atomSetCollection.setAtomSetProperties(this.energyKey, this.energyString, this.equivalentAtomSets);
        stringArray = GaussianReader.getTokens(this.readLine());
        this.atomSetCollection.setAtomSetProperties(stringArray[0], stringArray[2], this.equivalentAtomSets);
        this.atomSetCollection.setAtomSetProperties(stringArray[3], stringArray[5], this.equivalentAtomSets);
        stringArray = GaussianReader.getTokens(this.readLine());
        this.atomSetCollection.setAtomSetProperties(stringArray[0], stringArray[2], this.equivalentAtomSets);
    }

    private void setEnergy() {
        String[] stringArray = this.getTokens();
        this.energyKey = "Energy";
        this.energyString = stringArray[1];
        this.atomSetCollection.setAtomSetNames("Energy = " + stringArray[1], this.equivalentAtomSets);
    }

    private void readAtoms() throws Exception {
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetName(this.energyKey + " = " + this.energyString);
        String string = this.getTokens()[0];
        this.discardLines(4);
        while (this.readLine() != null && !this.line.startsWith(" --")) {
            String[] stringArray = this.getTokens();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementNumber = (byte)this.parseInt(stringArray[1]);
            if (atom.elementNumber < 0) {
                atom.elementNumber = 0;
            }
            int n = stringArray.length - 3;
            atom.x = this.parseFloat(stringArray[n]);
            atom.y = this.parseFloat(stringArray[++n]);
            atom.z = this.parseFloat(stringArray[++n]);
        }
        this.atomSetCollection.setAtomSetProperty(".PATH", "Calculation " + this.calculationNumber + (this.scanPoint >= 0 ? SmarterJmolAdapter.PATH_SEPARATOR + "Scan Point " + this.scanPoint : "") + SmarterJmolAdapter.PATH_SEPARATOR + string);
    }

    void readBasis() throws Exception {
        int n;
        Object object;
        String[] stringArray;
        boolean bl;
        Vector<float[][]> vector = new Vector<float[][]>();
        Vector<String[]> vector2 = new Vector<String[]>();
        this.atomCount = -1;
        this.gaussianCount = 0;
        this.shellCount = 0;
        String string = "";
        String string2 = (String)this.moData.get("calculationType");
        boolean bl2 = string2 != null && string2.indexOf("5D") > 0;
        boolean bl3 = bl = string2 != null && string2.indexOf("7F") > 0;
        while (this.readLine() != null && this.line.startsWith(" Atom")) {
            ++this.shellCount;
            stringArray = this.getTokens();
            object = new int[4];
            if (!stringArray[1].equals(string)) {
                ++this.atomCount;
            }
            string = stringArray[1];
            object[0] = (float[])this.atomCount;
            String string3 = stringArray[4];
            object[1] = bl && string3.indexOf("F") >= 0 || bl2 && string3.indexOf("D") >= 0 ? (Object)JmolAdapter.getQuantumShellTagIDSpherical(stringArray[4]) : (float[])JmolAdapter.getQuantumShellTagID(stringArray[4]);
            n = this.parseInt(stringArray[5]);
            object[2] = (float[])this.gaussianCount;
            object[3] = (float[])n;
            vector.addElement((float[][])object);
            this.gaussianCount += n;
            for (int i = 0; i < n; ++i) {
                vector2.addElement(GaussianReader.getTokens(this.readLine()));
            }
        }
        if (this.atomCount == -1) {
            this.atomCount = 0;
        }
        object = new float[this.gaussianCount][];
        for (int i = 0; i < this.gaussianCount; ++i) {
            stringArray = (String[])vector2.get(i);
            object[i] = new float[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                object[i][n] = this.parseFloat(stringArray[n]);
            }
        }
        this.moData.put("shells", vector);
        this.moData.put("gaussians", object);
        if (Logger.debugging) {
            Logger.debug(this.shellCount + " slater shells read");
            Logger.debug(this.gaussianCount + " gaussian primitives read");
        }
    }

    void readMolecularOrbitals() throws Exception {
        Hashtable[] hashtableArray = new Hashtable[5];
        Vector[] vectorArray = new Vector[5];
        int n = 0;
        while (this.readLine() != null && this.line.toUpperCase().indexOf("DENS") < 0) {
            int n2;
            String[] stringArray;
            if (this.line.indexOf("                    ") == 0) {
                this.addMOData(n, vectorArray, hashtableArray);
                stringArray = GaussianReader.getTokens(this.readLine());
                n = stringArray.length;
                for (n2 = 0; n2 < n; ++n2) {
                    hashtableArray[n2] = new Hashtable();
                    vectorArray[n2] = new Vector();
                    hashtableArray[n2].put("symmetry", stringArray[n2]);
                }
                stringArray = GaussianReader.getStrings(this.readLine().substring(21), n, 10);
                for (n2 = 0; n2 < n; ++n2) {
                    hashtableArray[n2].put("energy", new Float(stringArray[n2]));
                }
                continue;
            }
            if (this.line.length() < 21 || this.line.charAt(11) != ' ' && !Character.isDigit(this.line.charAt(11))) continue;
            try {
                stringArray = GaussianReader.getStrings(this.line.substring(21), n, 10);
                for (n2 = 0; n2 < n; ++n2) {
                    vectorArray[n2].addElement(stringArray[n2]);
                }
            }
            catch (Exception exception) {
                Logger.error("Error reading Gaussian file Molecular Orbitals at line: " + this.line);
                break;
            }
        }
        this.addMOData(n, vectorArray, hashtableArray);
    }

    void addMOData(int n, Vector[] vectorArray, Hashtable[] hashtableArray) {
        for (int i = 0; i < n; ++i) {
            float[] fArray = new float[vectorArray[i].size()];
            int n2 = fArray.length;
            while (--n2 >= 0) {
                fArray[n2] = this.parseFloat((String)vectorArray[i].get(n2));
            }
            hashtableArray[i].put("coefficients", fArray);
            this.orbitals.addElement(hashtableArray[i]);
        }
    }

    private void readFrequencies() throws Exception, IOException {
        while (this.readLine() != null && this.line.indexOf(":") < 0) {
        }
        if (this.line == null) {
            throw new Exception("No frequencies encountered");
        }
        while ((this.line = this.readLine()) != null && this.line.length() > 15) {
            int n;
            String[] stringArray = GaussianReader.getTokens(this.readLine());
            String[] stringArray2 = GaussianReader.getTokens(this.discardLinesUntilStartsWith(" Frequencies"), 15);
            String[] stringArray3 = GaussianReader.getTokens(this.discardLinesUntilStartsWith(" Red. masses"), 15);
            String[] stringArray4 = GaussianReader.getTokens(this.discardLinesUntilStartsWith(" Frc consts"), 15);
            String[] stringArray5 = GaussianReader.getTokens(this.discardLinesUntilStartsWith(" IR Inten"), 15);
            int n2 = stringArray2.length;
            for (n = 0; n < n2; ++n) {
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetName(stringArray[n] + " " + stringArray2[n] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty(this.energyKey, this.energyString);
                this.atomSetCollection.setAtomSetProperty("Frequency", stringArray2[n] + " cm**-1");
                this.atomSetCollection.setAtomSetProperty("Reduced Mass", stringArray3[n] + " AMU");
                this.atomSetCollection.setAtomSetProperty("Force Constant", stringArray4[n] + " mDyne/A");
                this.atomSetCollection.setAtomSetProperty("IR Intensity", stringArray5[n] + " KM/Mole");
                this.atomSetCollection.setAtomSetProperty(".PATH", "Calculation " + this.calculationNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies");
            }
            n = this.atomSetCollection.getLastAtomSetAtomCount();
            int n3 = this.atomSetCollection.getAtomCount() - n2 * n;
            this.discardLinesUntilStartsWith(" Atom AN");
            Atom[] atomArray = this.atomSetCollection.getAtoms();
            for (int i = 0; i < n; ++i) {
                String[] stringArray6 = GaussianReader.getTokens(this.readLine());
                int n4 = this.parseInt(stringArray6[0]);
                int n5 = 2;
                for (int j = 0; j < n2; ++j) {
                    int n6 = n3 + j * n + n4 - 1;
                    Atom atom = atomArray[n6];
                    float f = this.parseFloat(stringArray6[n5++]);
                    float f2 = this.parseFloat(stringArray6[n5++]);
                    float f3 = this.parseFloat(stringArray6[n5++]);
                    atom.addVibrationVector(f, f2, f3);
                }
            }
        }
    }

    void readDipoleMoment() throws Exception {
        String[] stringArray = GaussianReader.getTokens(this.readLine());
        if (stringArray.length != 8) {
            return;
        }
        Vector3f vector3f = new Vector3f(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[3]), this.parseFloat(stringArray[5]));
        Logger.info("Molecular dipole for model " + this.atomSetCollection.getAtomSetCount() + " = " + vector3f);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("dipole", vector3f);
    }

    void readPartialCharges() throws Exception {
        this.discardLines(1);
        int n = this.atomSetCollection.getAtomCount();
        int n2 = this.atomSetCollection.getLastAtomSetAtomIndex();
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        for (int i = n2; i < n; ++i) {
            while (atomArray[i].elementNumber == 0) {
                ++i;
            }
            atomArray[i].partialCharge = this.parseFloat(GaussianReader.getTokens(this.readLine())[2]);
        }
    }
}

