/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.readers.more.GamessReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class GamessUKReader
extends GamessReader {
    private Vector symmetries;
    private Vector occupancies;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("gamessUK");
        try {
            this.readLine();
            boolean bl = false;
            while (this.line != null) {
                if (this.line.indexOf("molecular geometry") >= 0) {
                    if (++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0) {
                        if (!bl) {
                            this.readLine();
                            continue;
                        }
                        break;
                    }
                    this.readAtomsInBohrCoordinates();
                    bl = true;
                } else if (!bl || this.line.indexOf("FREQUENCY_INFO_WOULD_BE_HERE") < 0) {
                    if (bl && this.line.indexOf("contracted primitive functions") >= 0) {
                        this.readGaussianBasis("======================================================", "======");
                        continue;
                    }
                    if (bl && this.line.indexOf("SYMMETRY ASSIGNMENT") >= 0) {
                        this.readOrbitalSymmetryAndOccupancy();
                        continue;
                    }
                    if (bl && this.line.indexOf("eigenvectors") >= 0) {
                        this.readMolecularOrbitals();
                        this.setOrbitalSymmetryAndOccupancy();
                        continue;
                    }
                }
                this.readLine();
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    protected void readAtomsInBohrCoordinates() throws Exception {
        this.discardLinesUntilContains("*****");
        this.discardLinesUntilContains("atom");
        this.discardLinesUntilContains("*****");
        this.atomSetCollection.newAtomSet();
        while (this.readLine() != null && this.line.indexOf("*****") < 0) {
            if (this.line.charAt(14) == ' ') continue;
            String[] stringArray = this.getTokens();
            String string = stringArray[1];
            int n = (int)this.parseFloat(stringArray[2]);
            float f = this.parseFloat(stringArray[3]);
            float f2 = this.parseFloat(stringArray[4]);
            float f3 = this.parseFloat(stringArray[5]);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) break;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = string;
            atom.set(f, f2, f3);
            atom.scale(0.5291772f);
            atom.elementSymbol = AtomSetCollectionReader.getElementSymbol(n);
            this.atomNames.addElement(string);
        }
    }

    protected String fixShellTag(String string) {
        return string.substring(1).toUpperCase();
    }

    private void readOrbitalSymmetryAndOccupancy() throws Exception {
        this.discardLines(4);
        this.symmetries = new Vector();
        this.occupancies = new Vector();
        while (this.readLine() != null && this.line.indexOf("====") < 0) {
            String[] stringArray = GamessUKReader.getTokens(this.line.substring(20));
            this.symmetries.addElement(stringArray[0] + " " + stringArray[1]);
            this.occupancies.addElement(new Float(this.parseFloat(stringArray[5])));
        }
    }

    private void setOrbitalSymmetryAndOccupancy() {
        if (this.symmetries.size() < this.orbitals.size()) {
            return;
        }
        int n = this.orbitals.size();
        while (--n >= 0) {
            Hashtable hashtable = (Hashtable)this.orbitals.elementAt(n);
            hashtable.put("symmetry", this.symmetries.elementAt(n));
            hashtable.put("occupancy", this.occupancies.elementAt(n));
        }
    }

    protected void getMOHeader(String[] stringArray, Hashtable[] hashtableArray, int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            hashtableArray[i].put("energy", new Float(stringArray[i]));
        }
        this.discardLines(5);
    }
}

