/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public abstract class GamessReader
extends AtomSetCollectionReader {
    protected int atomCount = 0;
    protected int shellCount = 0;
    protected int gaussianCount = 0;
    protected String calculationType = "?";
    protected Hashtable moData = new Hashtable();
    protected Vector orbitals = new Vector();
    protected Vector atomNames = new Vector();

    public abstract AtomSetCollection readAtomSetCollection(BufferedReader var1);

    protected abstract void readAtomsInBohrCoordinates() throws Exception;

    protected void readGaussianBasis(String string, String string2) throws Exception {
        int n;
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        this.gaussianCount = 0;
        int n2 = 0;
        this.shellCount = 0;
        String string3 = "0";
        this.discardLinesUntilContains(string);
        this.readLine();
        int[] nArray = null;
        Hashtable hashtable = new Hashtable();
        Vector<int[]> vector2 = new Vector<int[]>();
        String string4 = null;
        block4: while (this.readLine() != null && this.line.indexOf(string2) < 0) {
            if (this.line.indexOf("(") >= 0) {
                this.line = GamessReader.fixBasisLine(this.line);
            }
            stringArray = this.getTokens();
            switch (stringArray.length) {
                case 1: {
                    if (string4 != null) {
                        if (nArray != null) {
                            nArray[2] = n2;
                            vector2.addElement(nArray);
                            nArray = null;
                        }
                        hashtable.put(string4, vector2);
                    }
                    vector2 = new Vector();
                    string4 = stringArray[0];
                    continue block4;
                }
                case 0: {
                    continue block4;
                }
            }
            if (!stringArray[0].equals(string3)) {
                if (nArray != null) {
                    nArray[2] = n2;
                    vector2.addElement(nArray);
                }
                string3 = stringArray[0];
                ++this.shellCount;
                nArray = new int[]{JmolAdapter.getQuantumShellTagID(this.fixShellTag(stringArray[1])), this.gaussianCount, 0};
                n2 = 0;
            }
            ++n2;
            ++this.gaussianCount;
            vector.addElement(stringArray);
        }
        if (nArray != null) {
            nArray[2] = n2;
            vector2.addElement(nArray);
        }
        if (string4 != null) {
            hashtable.put(string4, vector2);
        }
        Vector<int[]> vector3 = new Vector<int[]>();
        this.atomCount = this.atomNames.size();
        for (int i = 0; i < this.atomCount; ++i) {
            string4 = (String)this.atomNames.elementAt(i);
            Vector vector4 = (Vector)hashtable.get(string4);
            if (vector4 == null) {
                Logger.error("slater for atom " + i + " atomType " + string4 + " was not found in listing. Ignoring molecular orbitals");
                return;
            }
            for (n = 0; n < vector4.size(); ++n) {
                nArray = (int[])vector4.elementAt(n);
                vector3.addElement(new int[]{i, nArray[0], nArray[1], nArray[2]});
            }
        }
        float[][] fArrayArray = new float[this.gaussianCount][];
        for (int i = 0; i < this.gaussianCount; ++i) {
            stringArray = (String[])vector.get(i);
            fArrayArray[i] = new float[stringArray.length - 3];
            for (n = 3; n < stringArray.length; ++n) {
                fArrayArray[i][n - 3] = this.parseFloat(stringArray[n]);
            }
        }
        this.moData.put("shells", vector3);
        this.moData.put("gaussians", fArrayArray);
        if (Logger.debugging) {
            Logger.debug(this.shellCount + " slater shells read");
            Logger.debug(this.gaussianCount + " gaussian primitives read");
        }
        this.moData.put("calculationType", this.calculationType);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", this.moData);
    }

    protected abstract String fixShellTag(String var1);

    protected void readMolecularOrbitals() throws Exception {
        Hashtable[] hashtableArray = null;
        Vector[] vectorArray = null;
        Vector<String> vector = null;
        this.readLine();
        int n = 0;
        while (this.readLine() != null) {
            int n2;
            String[] stringArray = this.getTokens();
            if (Logger.debugging) {
                Logger.debug(stringArray.length + " --- " + this.line);
            }
            if (this.line.indexOf("end") >= 0) break;
            if (this.line.length() == 0 || this.line.indexOf("--") >= 0 || this.line.indexOf(".....") >= 0) {
                for (n2 = 0; n2 < n; ++n2) {
                    float[] fArray = new float[vectorArray[n2].size()];
                    int n3 = 0;
                    while (n3 < fArray.length) {
                        if (((String)vector.get(n3)).equals("XXX")) {
                            int n4;
                            Hashtable hashtable = new Hashtable();
                            for (n4 = 0; n4 < 10; ++n4) {
                                hashtable.put(vector.get(n3 + n4), vectorArray[n2].get(n3 + n4));
                            }
                            for (n4 = 0; n4 < 10; ++n4) {
                                String string = JmolAdapter.getQuantumSubshellTag(5, n4);
                                fArray[n3++] = this.parseFloat((String)hashtable.get(string));
                            }
                            continue;
                        }
                        fArray[n3] = this.parseFloat((String)vectorArray[n2].get(n3));
                        ++n3;
                    }
                    hashtableArray[n2].put("coefficients", fArray);
                    this.orbitals.addElement(hashtableArray[n2]);
                }
                n = 0;
                if (this.line.length() != 0) break;
                continue;
            }
            if (n == 0) {
                n = stringArray.length;
                if (hashtableArray == null || n > hashtableArray.length) {
                    hashtableArray = new Hashtable[n];
                    vectorArray = new Vector[n];
                }
                for (n2 = 0; n2 < n; ++n2) {
                    hashtableArray[n2] = new Hashtable();
                    vectorArray[n2] = new Vector();
                }
                this.getMOHeader(stringArray, hashtableArray, n);
                vector = new Vector<String>();
                continue;
            }
            n2 = stringArray.length - n;
            vector.addElement(JmolAdapter.canonicalizeQuantumSubshellTag(stringArray[n2 - 1].toUpperCase()));
            for (int i = 0; i < n; ++i) {
                vectorArray[i].addElement(stringArray[i + n2]);
            }
            this.line = "";
        }
        this.moData.put("mos", this.orbitals);
        this.setMOData(this.moData);
    }

    protected abstract void getMOHeader(String[] var1, Hashtable[] var2, int var3) throws Exception;

    protected void readFrequencies() throws Exception {
        int n = 0;
        int n2 = this.atomSetCollection.getAtomCount();
        float[] fArray = new float[5];
        float[] fArray2 = new float[5];
        float[] fArray3 = new float[5];
        float[] fArray4 = new float[5];
        this.discardLinesUntilContains("FREQUENCY:");
        while (this.line != null && this.line.indexOf("FREQUENCY:") >= 0) {
            int n3 = n;
            int n4 = 0;
            String[] stringArray = this.getTokens();
            for (int i = 0; i < stringArray.length; ++i) {
                float f = this.parseFloat(stringArray[i]);
                if (stringArray[i].equals("I")) {
                    fArray4[n4 - 1] = -fArray4[n4 - 1];
                }
                if (Float.isNaN(f)) continue;
                fArray4[n4] = f;
                ++n4;
                if (Logger.debugging) {
                    Logger.debug(n + " frequency=" + f);
                }
                if (n4 == 5) break;
            }
            String[] stringArray2 = null;
            String[] stringArray3 = null;
            this.readLine();
            if (this.line.indexOf("MASS") >= 0) {
                stringArray2 = this.getTokens();
                this.readLine();
            }
            if (this.line.indexOf("INTENS") >= 0) {
                stringArray3 = this.getTokens();
            }
            for (int i = 0; i < n4; ++i) {
                if (++n > 1) {
                    this.atomSetCollection.cloneFirstAtomSet();
                }
                this.atomSetCollection.setAtomSetName(fArray4[i] + " cm-1");
                this.atomSetCollection.setAtomSetProperty("Frequency", fArray4[i] + " cm-1");
                if (stringArray2 != null) {
                    this.atomSetCollection.setAtomSetProperty("Reduced Mass", stringArray2[i + 2] + " AMU");
                }
                if (stringArray3 == null) continue;
                this.atomSetCollection.setAtomSetProperty("IR Intensity", stringArray3[i + 2] + " D^2/AMU-Angstrom^2");
            }
            Atom[] atomArray = this.atomSetCollection.getAtoms();
            this.discardLinesUntilBlank();
            for (int i = 0; i < n2; ++i) {
                this.readLine();
                this.readComponents(n4, fArray);
                this.readLine();
                this.readComponents(n4, fArray2);
                this.readLine();
                this.readComponents(n4, fArray3);
                for (int j = 0; j < n4; ++j) {
                    int n5 = (n3 + j) * n2 + i;
                    Atom atom = atomArray[n5];
                    atom.vectorX = fArray[j];
                    atom.vectorY = fArray2[j];
                    atom.vectorZ = fArray3[j];
                }
            }
            this.discardLines(12);
            this.readLine();
        }
    }

    private void readComponents(int n, float[] fArray) {
        int n2 = 0;
        int n3 = 20;
        while (n2 < n) {
            fArray[n2] = this.parseFloat(this.line, n3, n3 + 12);
            ++n2;
            n3 += 12;
        }
    }

    protected static String fixBasisLine(String string) {
        int n;
        string = string.replace(')', ' ');
        while ((n = string.indexOf("(")) >= 0) {
            int n2 = n;
            while (string.charAt(--n2) == ' ') {
            }
            while (string.charAt(--n2) != ' ') {
            }
            string = string.substring(0, ++n2) + string.substring(n + 1);
        }
        return string;
    }
}

