/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JmolConstants;

public class NucleicMonomer
extends PhosphorusMonomer {
    static final byte C6 = 1;
    private static final byte O2Pr = 2;
    private static final byte C5 = 3;
    private static final byte N1 = 4;
    private static final byte C2 = 5;
    private static final byte N3 = 6;
    private static final byte C4 = 7;
    private static final byte O2 = 8;
    private static final byte N7 = 9;
    private static final byte C8 = 10;
    private static final byte N9 = 11;
    private static final byte O4 = 12;
    private static final byte O6 = 13;
    private static final byte N4 = 14;
    private static final byte NP = 15;
    private static final byte N6 = 16;
    private static final byte N2 = 17;
    private static final byte H5T = 18;
    private static final byte O5Pr = 19;
    private static final byte H3T = 20;
    private static final byte O3Pr = 21;
    private static final byte C3Pr = 22;
    private static final byte O1P = 23;
    private static final byte O2P = 24;
    static final byte[] interestingNucleicAtomIDs = new byte[]{-14, 37, -80, 36, 32, 33, 34, 35, -39, -40, -41, -42, -48, -47, -43, -14, -45, -44, -73, -7, -89, 10, 9, -75, -77};
    private boolean hasRnaO2Prime;
    private static final byte[] ring6OffsetIndexes = new byte[]{3, 1, 4, 5, 6, 7};
    private static final byte[] ring5OffsetIndexes = new byte[]{3, 9, 10, 11, 7};

    public static Monomer validateAndAllocate(Chain chain, String string, int n, int n2, int n3, int[] nArray, Atom[] atomArray) {
        byte[] byArray = Monomer.scanForOffsets(n2, nArray, interestingNucleicAtomIDs);
        if (byArray == null) {
            return null;
        }
        if (!Monomer.checkOptional(byArray, (byte)19, n2, nArray[73])) {
            return null;
        }
        Monomer.checkOptional(byArray, (byte)20, n2, nArray[89]);
        Monomer.checkOptional(byArray, (byte)18, n2, nArray[90]);
        Monomer.checkOptional(byArray, (byte)23, n2, nArray[75]);
        Monomer.checkOptional(byArray, (byte)24, n2, nArray[77]);
        NucleicMonomer nucleicMonomer = new NucleicMonomer(chain, string, n, n2, n3, byArray);
        return nucleicMonomer;
    }

    NucleicMonomer(Chain chain, String string, int n, int n2, int n3, byte[] byArray) {
        super(chain, string, n, n2, n3, byArray);
        if (byArray[15] == -1 && (byArray[0] = byArray[18]) == -1) {
            byArray[0] = byArray[19];
        }
        this.hasRnaO2Prime = byArray[2] != -1;
        this.isPyrimidine = byArray[8] != -1;
        this.isPurine = byArray[9] != -1 && byArray[10] != -1 && byArray[11] != -1;
    }

    public boolean isNucleicMonomer() {
        return true;
    }

    public boolean isDna() {
        return !this.hasRnaO2Prime;
    }

    public boolean isRna() {
        return this.hasRnaO2Prime;
    }

    public boolean isPurine() {
        return this.isPurine;
    }

    public boolean isPyrimidine() {
        return this.isPyrimidine;
    }

    public boolean isGuanine() {
        return this.offsets[17] != -1;
    }

    public byte getProteinStructureType() {
        return this.hasRnaO2Prime ? (byte)5 : 4;
    }

    Atom getN1() {
        return this.getAtomFromOffsetIndex(4);
    }

    Atom getN3() {
        return this.getAtomFromOffsetIndex(6);
    }

    Atom getN2() {
        return this.getAtomFromOffsetIndex(17);
    }

    Atom getO2() {
        return this.getAtomFromOffsetIndex(8);
    }

    Atom getO6() {
        return this.getAtomFromOffsetIndex(13);
    }

    Atom getN4() {
        return this.getAtomFromOffsetIndex(14);
    }

    Atom getN6() {
        return this.getAtomFromOffsetIndex(16);
    }

    Atom getO4() {
        return this.getAtomFromOffsetIndex(12);
    }

    Atom getTerminatorAtom() {
        return this.getAtomFromOffsetIndex(this.offsets[20] != -1 ? 20 : 21);
    }

    public void getBaseRing6Points(Point3f[] point3fArray) {
        int n = 6;
        while (--n >= 0) {
            point3fArray[n] = this.getAtomFromOffsetIndex(ring6OffsetIndexes[n]);
        }
    }

    public boolean maybeGetBaseRing5Points(Point3f[] point3fArray) {
        if (this.isPurine) {
            int n = 5;
            while (--n >= 0) {
                point3fArray[n] = this.getAtomFromOffsetIndex(ring5OffsetIndexes[n]);
            }
        }
        return this.isPurine;
    }

    boolean isConnectedAfter(Monomer monomer) {
        if (monomer == null) {
            return true;
        }
        Atom atom = this.getAtomFromOffsetIndex(15);
        if (atom == null) {
            return false;
        }
        if (!(monomer instanceof NucleicMonomer)) {
            return false;
        }
        NucleicMonomer nucleicMonomer = (NucleicMonomer)monomer;
        if (nucleicMonomer.getAtomFromOffsetIndex(21).isBonded(atom)) {
            return true;
        }
        return super.isConnectedAfter(monomer);
    }

    public void findNearestAtomIndex(int n, int n2, Atom[] atomArray, short s, short s2) {
        int n3;
        Atom atom = atomArray[0];
        Atom atom2 = this.getLeadAtom();
        Atom atom3 = this.getAtomFromOffsetIndex(19);
        Atom atom4 = this.getAtomFromOffsetIndex(22);
        int n4 = s / 2;
        if (n4 < 1900) {
            n4 = 1900;
        }
        if ((n3 = this.scaleToScreen(atom2.screenZ, n4)) < 4) {
            n3 = 4;
        }
        if (this.isCursorOnTopOf(atom2, n, n2, n3, atom) || this.isCursorOnTopOf(atom3, n, n2, n3, atom) || this.isCursorOnTopOf(atom4, n, n2, n3, atom)) {
            atomArray[0] = atom2;
        }
    }

    public void setModelClickability() {
        Atom atom;
        if (this.isAtomHidden(this.getLeadAtomIndex())) {
            return;
        }
        int n = 6;
        while (--n >= 0) {
            atom = this.getAtomFromOffsetIndex(ring6OffsetIndexes[n]);
            atom.setClickable(JmolConstants.CARTOON_VISIBILITY_FLAG);
        }
        if (this.isPurine) {
            n = 5;
            while (--n >= 0) {
                atom = this.getAtomFromOffsetIndex(ring5OffsetIndexes[n]);
                atom.setClickable(JmolConstants.CARTOON_VISIBILITY_FLAG);
            }
        }
    }

    Point3f getQuaternionFrameCenter(char c) {
        return this.getAtomFromOffsetIndex(this.isPurine ? 11 : 4);
    }

    public Quaternion getQuaternion(char c) {
        Atom atom;
        Atom atom2;
        Point3f point3f = this.getQuaternionFrameCenter(c);
        if (this.isPurine) {
            atom2 = this.getAtomFromOffsetIndex(7);
            atom = this.getAtomFromOffsetIndex(10);
        } else {
            atom2 = this.getAtomFromOffsetIndex(5);
            atom = this.getAtomFromOffsetIndex(1);
        }
        if (point3f == null || atom2 == null || atom == null) {
            return null;
        }
        Vector3f vector3f = new Vector3f((Tuple3f)atom2);
        vector3f.sub((Tuple3f)point3f);
        Vector3f vector3f2 = new Vector3f((Tuple3f)atom);
        vector3f2.sub((Tuple3f)point3f);
        return Quaternion.getQuaternionFrame((Vector3f)vector3f, (Vector3f)vector3f2, null);
    }
}

