/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.Point3f;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Helix;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Sheet;
import org.jmol.modelsetbio.Turn;
import org.jmol.util.Logger;
import org.jmol.util.Measure;

public class AlphaPolymer
extends BioPolymer {
    static final byte CODE_NADA = 0;
    static final byte CODE_RIGHT_HELIX = 1;
    static final byte CODE_BETA_SHEET = 2;
    static final byte CODE_LEFT_HELIX = 3;
    static final byte CODE_LEFT_TURN = 4;
    static final byte CODE_RIGHT_TURN = 5;
    static final byte TAG_NADA = 0;
    static final byte TAG_TURN = 1;
    static final byte TAG_SHEET = 2;
    static final byte TAG_HELIX = 3;

    AlphaPolymer(Monomer[] monomerArray) {
        super(monomerArray);
    }

    public void addSecondaryStructure(byte by, char c, int n, char c2, int n2) {
        int n3;
        int n4 = this.getIndex(c, n);
        if (n4 == -1 || (n3 = this.getIndex(c2, n2)) == -1) {
            return;
        }
        this.addSecondaryStructure(by, n4, n3);
    }

    void addSecondaryStructure(byte by, int n, int n2) {
        if (n2 < n) {
            Logger.error((String)("AlphaPolymer:addSecondaryStructure error:  indexStart:" + n + " indexEnd:" + n2));
            return;
        }
        int n3 = n2 - n + 1;
        ProteinStructure proteinStructure = null;
        switch (by) {
            case 3: {
                proteinStructure = new Helix(this, n, n3);
                break;
            }
            case 2: {
                proteinStructure = new Sheet(this, n, n3);
                break;
            }
            case 1: {
                proteinStructure = new Turn(this, n, n3);
                break;
            }
            default: {
                Logger.error((String)"unrecognized secondary structure type");
                return;
            }
        }
        for (int i = n; i <= n2; ++i) {
            this.monomers[i].setStructure(proteinStructure);
        }
    }

    void calcHydrogenBonds() {
    }

    public void calculateStructures() {
        if (this.monomerCount < 4) {
            return;
        }
        float[] fArray = this.calculateAnglesInDegrees();
        byte[] byArray = this.calculateCodes(fArray);
        this.checkBetaSheetAlphaHelixOverlap(byArray, fArray);
        byte[] byArray2 = this.calculateRunsFourOrMore(byArray);
        this.extendRuns(byArray2);
        this.searchForTurns(byArray, fArray, byArray2);
        this.addStructuresFromTags(byArray2);
    }

    float[] calculateAnglesInDegrees() {
        float[] fArray = new float[this.monomerCount];
        int n = this.monomerCount - 1;
        while (--n >= 2) {
            fArray[n] = Measure.computeTorsion((Point3f)this.monomers[n - 2].getLeadAtomPoint(), (Point3f)this.monomers[n - 1].getLeadAtomPoint(), (Point3f)this.monomers[n].getLeadAtomPoint(), (Point3f)this.monomers[n + 1].getLeadAtomPoint(), (boolean)true);
        }
        return fArray;
    }

    byte[] calculateCodes(float[] fArray) {
        byte[] byArray = new byte[this.monomerCount];
        int n = this.monomerCount - 1;
        while (--n >= 2) {
            float f = fArray[n];
            byArray[n] = f >= 10.0f && f < 120.0f ? 1 : (f >= 120.0f || f < -90.0f ? 2 : (f >= -90.0f && f < 0.0f ? 3 : 0));
        }
        return byArray;
    }

    void checkBetaSheetAlphaHelixOverlap(byte[] byArray, float[] fArray) {
        int n = this.monomerCount - 2;
        while (--n >= 2) {
            if (byArray[n] != 2 || !(fArray[n] <= 140.0f) || byArray[n - 2] != 1 || byArray[n - 1] != 1 || byArray[n + 1] != 1 || byArray[n + 2] != 1) continue;
            byArray[n] = 1;
        }
    }

    byte[] calculateRunsFourOrMore(byte[] byArray) {
        byte[] byArray2 = new byte[this.monomerCount];
        int n = 0;
        byte by = 0;
        int n2 = 0;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (byArray[i] == by && by != 0 && by != 2) {
                if (++n2 == 4) {
                    n = by == 2 ? 2 : 3;
                    int n3 = 4;
                    while (--n3 >= 0) {
                        byArray2[i - n3] = n;
                    }
                    continue;
                }
                if (n2 <= 4) continue;
                byArray2[i] = n;
                continue;
            }
            n2 = 1;
            by = byArray[i];
        }
        return byArray2;
    }

    void extendRuns(byte[] byArray) {
        for (int i = 1; i < this.monomerCount - 4; ++i) {
            if (byArray[i] != 0 || byArray[i + 1] == 0) continue;
            byArray[i] = byArray[i + 1];
        }
        byArray[0] = byArray[1];
        byArray[this.monomerCount - 1] = byArray[this.monomerCount - 2];
    }

    void searchForTurns(byte[] byArray, float[] fArray, byte[] byArray2) {
        int n = this.monomerCount - 1;
        while (--n >= 2) {
            byArray[n] = 0;
            if (byArray2[n] != 0) continue;
            float f = fArray[n];
            if (f >= -90.0f && f < 0.0f) {
                byArray[n] = 4;
                continue;
            }
            if (!(f >= 0.0f) || !(f < 90.0f)) continue;
            byArray[n] = 5;
        }
        n = this.monomerCount - 1;
        while (--n >= 0) {
            if (byArray[n] == 0 || byArray[n + 1] != byArray[n] || byArray2[n] != 0) continue;
            byArray2[n] = 1;
        }
    }

    void addStructuresFromTags(byte[] byArray) {
        int n = 0;
        while (n < this.monomerCount) {
            int n2;
            byte by = byArray[n];
            if (by == 0) {
                ++n;
                continue;
            }
            for (n2 = n + 1; n2 < this.monomerCount && byArray[n2] == by; ++n2) {
            }
            this.addSecondaryStructure(by, n, n2 - 1);
            n = n2;
        }
    }
}

