/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.LimitedLineReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VoxelReader;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

class VolumeFileReader
extends VoxelReader {
    protected BufferedReader br;
    protected boolean endOfData;
    protected boolean negativeAtomCount;
    protected int atomCount;
    private int nSurfaces;
    protected boolean isAngstroms;
    protected boolean canDownsample;
    private int[] downsampleRemainders;
    String line;
    int[] next = new int[1];

    VolumeFileReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator);
        this.br = bufferedReader;
    }

    static String determineFileType(BufferedReader bufferedReader) {
        LimitedLineReader limitedLineReader = new LimitedLineReader(bufferedReader, 10);
        limitedLineReader = new LimitedLineReader(bufferedReader, 16000);
        String string = limitedLineReader.info();
        if (string.indexOf("#JVXL+") == 0) {
            return "Jvxl+";
        }
        if (string.indexOf("#JVXL") == 0) {
            return "Jvxl";
        }
        if (string.indexOf("&plot") == 0) {
            return "Jaguar";
        }
        if (string.indexOf("!NTITLE") >= 0 || string.indexOf("REMARKS ") >= 0) {
            return "Xplor";
        }
        string = limitedLineReader.readNonCommentLine();
        if (string.indexOf("object 1 class gridpositions counts") == 0) {
            return "Apbs";
        }
        String[] stringArray = Parser.getTokens((String)string);
        string = limitedLineReader.readNonCommentLine();
        if (stringArray.length == 2 && Parser.parseInt((String)stringArray[0]) == 3 && Parser.parseInt((String)stringArray[1]) != Integer.MIN_VALUE && (stringArray = Parser.getTokens((String)string)).length == 3 && Parser.parseInt((String)stringArray[0]) != Integer.MIN_VALUE && Parser.parseInt((String)stringArray[1]) != Integer.MIN_VALUE && Parser.parseInt((String)stringArray[2]) != Integer.MIN_VALUE) {
            return "PltFormatted";
        }
        string = limitedLineReader.readNonCommentLine();
        int n = Parser.parseInt((String)string);
        if (n == Integer.MIN_VALUE) {
            return string.indexOf("+") == 0 ? "Jvxl+" : "UNKNOWN";
        }
        if (n >= 0) {
            return "Cube";
        }
        n = -n;
        int n2 = 4 + n;
        while (--n2 >= 0) {
            string = limitedLineReader.readNonCommentLine();
            if (string != null) continue;
            return "UNKNOWN";
        }
        n2 = Parser.parseInt((String)string);
        if (n2 == Integer.MIN_VALUE) {
            return "UNKNOWN";
        }
        return n2 < 0 ? "Jvxl" : "Cube";
    }

    void discardTempData(boolean bl) {
        try {
            if (this.br != null) {
                this.br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.discardTempData(bl);
    }

    void readVolumeParameters() {
        this.endOfData = false;
        this.nSurfaces = this.readVolumetricHeader();
        if (this.nSurfaces < this.params.fileIndex) {
            Logger.warn((String)("not enough surfaces in file -- resetting params.fileIndex to " + this.nSurfaces));
            this.params.fileIndex = this.nSurfaces;
        }
    }

    void readVolumeData(boolean bl) {
        this.gotoAndReadVoxelData(bl);
        Logger.info((String)("Read " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " data points"));
    }

    protected int readVolumetricHeader() {
        try {
            int n;
            this.readTitleLines();
            Logger.info((String)this.jvxlFileHeaderBuffer.toString());
            this.readAtomCountAndOrigin();
            Logger.info((String)("voxel grid origin:" + this.volumetricOrigin));
            int n2 = this.params.downsampleFactor;
            boolean bl = this.canDownsample && n2 > 0;
            for (n = 0; n < 3; ++n) {
                this.readVoxelVector(n);
            }
            if (bl) {
                this.downsampleRemainders = new int[3];
                Logger.info((String)("downsample factor = " + n2));
                for (n = 0; n < 3; ++n) {
                    int n3 = this.voxelCounts[n];
                    this.downsampleRemainders[n] = n3 % n2;
                    int n4 = n;
                    this.voxelCounts[n4] = this.voxelCounts[n4] / n2;
                    this.volumetricVectors[n].scale((float)n2);
                    Logger.info((String)("downsampling axis " + (n + 1) + " from " + n3 + " to " + this.voxelCounts[n]));
                }
            }
            for (n = 0; n < 3; ++n) {
                this.line = this.voxelCounts[n] + " " + this.volumetricVectors[n].x + " " + this.volumetricVectors[n].y + " " + this.volumetricVectors[n].z;
                this.jvxlFileHeaderBuffer.append(this.line).append('\n');
                Logger.info((String)("voxel grid count/vector:" + this.line));
                if (this.isAngstroms) continue;
                this.volumetricVectors[n].scale(0.5291772f);
            }
            JvxlReader.jvxlReadAtoms(this.br, this.jvxlFileHeaderBuffer, this.atomCount, this.volumeData);
            return this.readExtraLine();
        }
        catch (Exception exception) {
            Logger.error((String)exception.toString());
            throw new NullPointerException();
        }
    }

    protected void readTitleLines() throws Exception {
    }

    protected int skipComments(boolean bl) throws Exception {
        int n = 1;
        while ((this.line = this.br.readLine()) != null && (!bl && this.line.length() == 0 || this.line.indexOf("#") == 0)) {
            if (bl) {
                this.jvxlFileHeaderBuffer.append(this.line).append('\n');
            }
            ++n;
        }
        return n;
    }

    protected void readAtomCountAndOrigin() throws Exception {
    }

    protected void readVoxelVector(int n) throws Exception {
        this.line = this.br.readLine();
        Vector3f vector3f = this.volumetricVectors[n];
        this.voxelCounts[n] = this.parseInt(this.line);
        if (this.voxelCounts[n] == Integer.MIN_VALUE) {
            this.next[0] = this.line.indexOf(" ");
        }
        vector3f.set(this.parseFloat(), this.parseFloat(), this.parseFloat());
    }

    protected int readExtraLine() throws Exception {
        if (!this.negativeAtomCount) {
            return 1;
        }
        this.line = this.br.readLine();
        Logger.info((String)("Reading extra CUBE information line: " + this.line));
        return this.parseInt(this.line);
    }

    protected void readVoxelData(boolean bl) throws Exception {
        this.next[0] = 0;
        boolean bl2 = false;
        int n = this.params.downsampleFactor;
        boolean bl3 = this.canDownsample && n > 0;
        int n2 = 0;
        if (this.params.thePlane != null) {
            this.params.cutoff = 0.0f;
        } else if (this.isJvxl) {
            this.params.cutoff = this.params.isBicolorMap || this.params.colorBySign ? 0.01f : 0.5f;
        }
        this.voxelData = new float[this.nPointsX][][];
        this.nDataPoints = 0;
        this.line = "";
        StringBuffer stringBuffer = new StringBuffer();
        this.jvxlNSurfaceInts = 0;
        boolean bl4 = !this.isJvxl && this.params.thePlane == null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (bl3) {
            n3 = n - 1;
            n5 = this.nPointsZ * n + this.downsampleRemainders[2];
            n4 = this.downsampleRemainders[2] + (n - 1) * n5;
            n5 = this.downsampleRemainders[1] * n5 + (n - 1) * n5 * (this.nPointsY * n + this.downsampleRemainders[1]);
        }
        if (bl || this.isJvxl && this.params.thePlane == null) {
            for (int i = 0; i < this.nPointsX; ++i) {
                float[][] fArrayArray = new float[this.nPointsY][];
                this.voxelData[i] = fArrayArray;
                for (int j = 0; j < this.nPointsY; ++j) {
                    float[] fArray = new float[this.nPointsZ];
                    fArrayArray[j] = fArray;
                    for (int k = 0; k < this.nPointsZ; ++k) {
                        fArray[k] = this.getNextVoxelValue(stringBuffer);
                        ++this.nDataPoints;
                        if (!bl3) continue;
                        this.skipVoxels(n3);
                    }
                    if (!bl3) continue;
                    this.skipVoxels(n4);
                }
                if (!bl3) continue;
                this.skipVoxels(n5);
            }
        } else {
            float f = this.params.cutoff;
            boolean bl5 = this.params.isCutoffAbsolute;
            for (int i = 0; i < this.nPointsX; ++i) {
                float[][] fArrayArray = new float[this.nPointsY][];
                this.voxelData[i] = fArrayArray;
                for (int j = 0; j < this.nPointsY; ++j) {
                    float[] fArray = new float[this.nPointsZ];
                    fArrayArray[j] = fArray;
                    for (int k = 0; k < this.nPointsZ; ++k) {
                        float f2;
                        fArray[k] = f2 = this.getNextVoxelValue(stringBuffer);
                        ++this.nDataPoints;
                        if (bl2 == VoxelReader.isInside(f2, f, bl5)) {
                            ++n2;
                        } else {
                            if (bl4 && n2 != 0) {
                                stringBuffer.append(' ').append(n2);
                                ++this.jvxlNSurfaceInts;
                            }
                            n2 = 1;
                            boolean bl6 = bl2 = !bl2;
                        }
                        if (!bl3) continue;
                        this.skipVoxels(n3);
                    }
                    if (!bl3) continue;
                    this.skipVoxels(n4);
                }
                if (!bl3) continue;
                this.skipVoxels(n5);
            }
        }
        if (bl4) {
            stringBuffer.append(' ').append(n2).append('\n');
            ++this.jvxlNSurfaceInts;
        }
        if (!bl) {
            JvxlReader.setSurfaceInfo(this.jvxlData, this.params.thePlane, this.jvxlNSurfaceInts, stringBuffer);
        }
        this.volumeData.setVoxelData(this.voxelData);
    }

    private void skipVoxels(int n) throws Exception {
        int n2 = n;
        while (--n2 >= 0) {
            this.getNextVoxelValue(null);
        }
    }

    protected float getNextVoxelValue(StringBuffer stringBuffer) throws Exception {
        float f = 0.0f;
        if (this.nSurfaces > 1 && !this.params.blockCubeData) {
            int n;
            for (n = 1; n < this.params.fileIndex; ++n) {
                this.nextVoxel();
            }
            f = this.nextVoxel();
            for (n = this.params.fileIndex; n < this.nSurfaces; ++n) {
                this.nextVoxel();
            }
        } else {
            f = this.nextVoxel();
        }
        return f;
    }

    protected float nextVoxel() throws Exception {
        float f = this.parseFloat();
        if (Float.isNaN(f)) {
            while ((this.line = this.br.readLine()) != null && Float.isNaN(f = this.parseFloat(this.line))) {
            }
            if (this.line == null) {
                if (!this.endOfData) {
                    Logger.warn((String)("end of file reading cube voxel data? nBytes=" + this.nBytes + " nDataPoints=" + this.nDataPoints + " (line):" + this.line));
                }
                this.endOfData = true;
                this.line = "0 0 0 0 0 0 0 0 0 0";
            }
            this.nBytes += this.line.length() + 1;
        }
        return f;
    }

    protected void gotoData(int n, int n2) throws Exception {
        if (!this.params.blockCubeData) {
            return;
        }
        if (n > 0) {
            Logger.info((String)("skipping " + n + " data sets, " + n2 + " points each"));
        }
        for (int i = 0; i < n; ++i) {
            this.skipData(n2);
        }
    }

    private void skipData(int n) throws Exception {
        for (int i = 0; i < n; i += this.countData(this.line)) {
            this.line = this.br.readLine();
        }
    }

    private int countData(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c;
            while (n2 < n3 && ((c = string.charAt(n2)) == ' ' || c == '\t')) {
                ++n2;
            }
            if (n2 < n3) {
                ++n;
            }
            while (n2 < n3 && (c = string.charAt(n2)) != ' ' && c != '\t') {
                ++n2;
            }
        }
        return n;
    }

    String[] getTokens() {
        return Parser.getTokens((String)this.line, (int)0);
    }

    float parseFloat() {
        return Parser.parseFloat((String)this.line, (int[])this.next);
    }

    float parseFloat(String string) {
        this.next[0] = 0;
        return Parser.parseFloat((String)string, (int[])this.next);
    }

    float parseFloatNext(String string) {
        return Parser.parseFloat((String)string, (int[])this.next);
    }

    int parseInt() {
        return Parser.parseInt((String)this.line, (int[])this.next);
    }

    int parseInt(String string) {
        this.next[0] = 0;
        return Parser.parseInt((String)string, (int[])this.next);
    }

    int parseIntNext(String string) {
        return Parser.parseInt((String)string, (int[])this.next);
    }

    int parseInt(String string, int n) {
        this.next[0] = n;
        return Parser.parseInt((String)string, (int[])this.next);
    }
}

