/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VoxelReader;
import org.jmol.util.Logger;

class VolumeDataReader
extends VoxelReader {
    protected int dataType;
    protected boolean precalculateVoxelData;
    protected boolean allowMapData;
    protected Point3f center;
    protected Point3f point;
    protected float[] anisotropy;
    protected boolean isAnisotropic;
    protected Matrix3f eccentricityMatrix;
    protected Matrix3f eccentricityMatrixInverse;
    protected boolean isEccentric;
    protected float eccentricityScale;
    protected float eccentricityRatio;

    VolumeDataReader(SurfaceGenerator surfaceGenerator) {
        super(surfaceGenerator);
        this.dataType = this.params.dataType;
        this.precalculateVoxelData = true;
        this.allowMapData = true;
        this.center = this.params.center;
        this.anisotropy = this.params.anisotropy;
        this.isAnisotropic = this.params.isAnisotropic;
        this.eccentricityMatrix = this.params.eccentricityMatrix;
        this.eccentricityMatrixInverse = this.params.eccentricityMatrixInverse;
        this.isEccentric = this.params.isEccentric;
        this.eccentricityScale = this.params.eccentricityScale;
        this.eccentricityRatio = this.params.eccentricityRatio;
    }

    void setup() {
        this.jvxlFileHeaderBuffer = new StringBuffer("volume data read from file\n\n");
        JvxlReader.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    void readVolumeParameters() {
        this.setup();
        this.initializeVolumetricData();
    }

    void readVolumeData(boolean bl) {
        try {
            this.readVoxelData(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    protected void readVoxelDataIndividually(boolean bl) throws Exception {
        if (bl && !this.allowMapData) {
            return;
        }
        boolean bl2 = false;
        int n = 0;
        this.voxelData = new float[this.nPointsX][this.nPointsY][this.nPointsZ];
        this.nDataPoints = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        float f = this.params.cutoff;
        boolean bl3 = this.params.isCutoffAbsolute;
        for (int i = 0; i < this.nPointsX; ++i) {
            float[][] fArrayArray = new float[this.nPointsY][];
            this.voxelData[i] = fArrayArray;
            for (int j = 0; j < this.nPointsY; ++j) {
                fArrayArray[j] = new float[this.nPointsZ];
                float[] fArray = fArrayArray[j];
                for (int k = 0; k < this.nPointsZ; ++k) {
                    float f2 = fArray[k] = this.getValue(i, j, k);
                    ++this.nDataPoints;
                    if (bl2 == VoxelReader.isInside(f2, f, bl3)) {
                        ++n;
                        continue;
                    }
                    if (!bl) {
                        stringBuffer.append(' ').append(n);
                    }
                    ++n2;
                    n = 1;
                    bl2 = !bl2;
                }
            }
        }
        if (!bl) {
            stringBuffer.append(' ').append(n).append('\n');
            JvxlReader.setSurfaceInfo(this.jvxlData, this.params.thePlane, n2, stringBuffer);
        }
        this.volumeData.setVoxelData(this.voxelData);
    }

    protected float getValue(int n, int n2, int n3) {
        return 0.0f;
    }

    protected int setVoxelRange(int n, float f, float f2, float f3, int n2) {
        int n3;
        if (f >= f2) {
            f = -10.0f;
            f2 = 10.0f;
        }
        float f4 = f2 - f;
        float f5 = this.params.resolution;
        if (f5 != Float.MAX_VALUE) {
            f3 = f5;
            n3 = (int)(f4 * f3);
        } else {
            n3 = (int)(f4 * f3);
        }
        if (n3 > n2) {
            if ((this.dataType & 0x100) > 0) {
                if (f5 != Float.MAX_VALUE) {
                    Logger.info((String)("Maximum number of voxels for index=" + n));
                }
                n3 = n2;
            } else if (f5 == Float.MAX_VALUE) {
                n3 = n2;
            }
        }
        f3 = (float)n3 / f4;
        float f6 = this.volumeData.volumetricVectorLengths[n] = 1.0f / f3;
        this.voxelCounts[n] = n3 + ((this.dataType & 0x80) != 0 ? 3 : 0);
        switch (n) {
            case 0: {
                this.volumetricVectors[0].set(f6, 0.0f, 0.0f);
                this.volumetricOrigin.x = f;
                break;
            }
            case 1: {
                this.volumetricVectors[1].set(0.0f, f6, 0.0f);
                this.volumetricOrigin.y = f;
                break;
            }
            case 2: {
                this.volumetricVectors[2].set(0.0f, 0.0f, f6);
                this.volumetricOrigin.z = f;
                if (this.isEccentric) {
                    this.eccentricityMatrix.transform((Tuple3f)this.volumetricOrigin);
                }
                if (this.center.x == Float.MAX_VALUE) break;
                this.volumetricOrigin.add((Tuple3f)this.center);
            }
        }
        if (this.isEccentric) {
            this.eccentricityMatrix.transform((Tuple3f)this.volumetricVectors[n]);
        }
        return this.voxelCounts[n];
    }

    protected void readVoxelData(boolean bl) throws Exception {
        if (!this.precalculateVoxelData) {
            this.readVoxelDataIndividually(bl);
            return;
        }
        this.generateCube();
        if (bl) {
            return;
        }
        this.nDataPoints = JvxlReader.jvxlCreateSurfaceData(this.jvxlData, this.volumeData.voxelData, this.params.cutoff, this.params.isCutoffAbsolute, this.nPointsX, this.nPointsY, this.nPointsZ);
    }

    protected void generateCube() {
        Logger.info((String)"data type: user volumeData");
        Logger.info((String)("voxel grid origin:" + this.volumetricOrigin));
        for (int i = 0; i < 3; ++i) {
            Logger.info((String)("voxel grid vector:" + this.volumetricVectors[i]));
        }
        Logger.info((String)("Read " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " data points"));
    }
}

