/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

class JaguarReader
extends VolumeFileReader {
    private float[] extents = new float[3];

    JaguarReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.isAngstroms = false;
        this.jvxlData.wasCubic = true;
    }

    protected void readTitleLines() throws Exception {
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.jvxlFileHeaderBuffer.append("Jaguar data\n");
        this.jvxlFileHeaderBuffer.append("\n");
    }

    protected void readAtomCountAndOrigin() throws Exception {
        String string;
        this.atomCount = 0;
        this.negativeAtomCount = false;
        while ((string = this.br.readLine()) != null && string.indexOf("origin=") < 0) {
        }
        String[] stringArray = Parser.getTokens((String)string, (int)0);
        if (stringArray.length == 4 && stringArray[0].equals("origin=")) {
            this.volumetricOrigin.set(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
            JvxlReader.jvxlCheckAtomLine(this.isXLowToHigh, this.isAngstroms, "0", "0 " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3], this.jvxlFileHeaderBuffer);
            if (!this.isAngstroms) {
                this.volumetricOrigin.scale(0.5291772f);
            }
        }
    }

    protected void readVoxelVector(int n) throws Exception {
        String[] stringArray = Parser.getTokens((String)this.br.readLine());
        this.extents[n] = this.parseFloat(stringArray[n + 1]);
        if (n < 2) {
            return;
        }
        stringArray = Parser.getTokens((String)this.br.readLine());
        this.voxelCounts[0] = this.parseInt(stringArray[1]);
        this.voxelCounts[1] = this.parseInt(stringArray[2]);
        this.voxelCounts[2] = this.parseInt(stringArray[3]);
        float f = this.isAngstroms ? 1.0f : 0.5291772f;
        float f2 = this.extents[0] / (float)(this.voxelCounts[0] - 1);
        this.volumetricVectors[0].set(f2 * f, 0.0f, 0.0f);
        this.jvxlFileHeaderBuffer.append(this.voxelCounts[0] + " " + f2 + " 0.0 0.0\n");
        f2 = this.extents[1] / (float)(this.voxelCounts[1] - 1);
        this.volumetricVectors[1].set(0.0f, f2 * f, 0.0f);
        this.jvxlFileHeaderBuffer.append(this.voxelCounts[1] + " 0.0 " + f2 + " 0.0\n");
        f2 = this.extents[2] / (float)(this.voxelCounts[2] - 1);
        this.volumetricVectors[2].set(0.0f, 0.0f, f2 * f);
        this.jvxlFileHeaderBuffer.append(this.voxelCounts[2] + " 0.0 0.0 " + f2 + "\n");
        this.br.readLine();
    }

    protected float nextVoxel() throws Exception {
        float f;
        if (this.endOfData || (this.line = this.br.readLine()) == null || Float.isNaN(f = this.parseFloat(this.line))) {
            if (!this.endOfData) {
                Logger.warn((String)("end of file reading cube voxel data? nBytes=" + this.nBytes + " nDataPoints=" + this.nDataPoints + " (line):" + this.line));
            }
            this.endOfData = true;
            return 0.0f;
        }
        return f;
    }
}

