/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeDataReader;

class IsoShapeReader
extends VolumeDataReader {
    private int psi_n = 2;
    private int psi_l = 1;
    private int psi_m = 1;
    private float psi_Znuc = 1.0f;
    private float sphere_radiusAngstroms;
    private boolean allowNegative = true;
    private double[] rfactor = new double[10];
    private double[] pfactor = new double[10];
    private static final double A0 = (double)0.52918f;
    private static final double ROOT2 = 1.414214;
    private float radius;
    private float ppa;
    private int maxGrid;
    private static final float[] fact = new float[20];
    private final Point3f ptPsi = new Point3f();

    IsoShapeReader(SurfaceGenerator surfaceGenerator, float f) {
        super(surfaceGenerator);
        this.sphere_radiusAngstroms = f;
    }

    IsoShapeReader(SurfaceGenerator surfaceGenerator, int n, int n2, int n3, float f) {
        super(surfaceGenerator);
        this.psi_n = n;
        this.psi_l = n2;
        this.psi_m = n3;
        this.psi_Znuc = f;
        this.sphere_radiusAngstroms = 0.0f;
    }

    protected void setup() {
        this.precalculateVoxelData = false;
        if (this.center.x == Float.MAX_VALUE) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
        String string = "sphere";
        switch (this.dataType) {
            case 14: {
                this.calcFactors(this.psi_n, this.psi_l, this.psi_m);
                this.radius = this.autoScaleOrbital();
                this.ppa = 5.0f;
                this.maxGrid = 40;
                string = "hydrogen-like orbital";
                break;
            }
            case 68: {
                this.allowNegative = false;
                this.calcFactors(this.psi_n, this.psi_l, this.psi_m);
                this.radius = 1.1f * this.eccentricityRatio * this.eccentricityScale;
                if (this.eccentricityScale > 0.0f && this.eccentricityScale < 1.0f) {
                    this.radius /= this.eccentricityScale;
                }
                this.ppa = 10.0f;
                this.maxGrid = 21;
                string = "lobe";
                break;
            }
            case 67: {
                string = "ellipsoid(thermal)";
                this.radius = 3.0f * this.sphere_radiusAngstroms;
                this.ppa = 10.0f;
                this.maxGrid = 22;
                break;
            }
            case 66: {
                string = "ellipsoid";
            }
            default: {
                this.radius = 1.2f * this.sphere_radiusAngstroms * this.eccentricityScale;
                this.ppa = 10.0f;
                this.maxGrid = 22;
            }
        }
        this.setVoxelRange(0, -this.radius, this.radius, this.ppa, this.maxGrid);
        this.setVoxelRange(1, -this.radius, this.radius, this.ppa, this.maxGrid);
        if (this.allowNegative) {
            this.setVoxelRange(2, -this.radius, this.radius, this.ppa, this.maxGrid);
        } else {
            this.setVoxelRange(2, 0.0f, this.radius / this.eccentricityRatio, this.ppa, this.maxGrid);
        }
        this.setHeader(string + "\n");
    }

    protected float getValue(int n, int n2, int n3) {
        this.volumeData.voxelPtToXYZ(n, n2, n3, this.ptPsi);
        this.ptPsi.sub((Tuple3f)this.center);
        if (this.isEccentric) {
            this.eccentricityMatrixInverse.transform((Tuple3f)this.ptPsi);
        }
        if (this.isAnisotropic) {
            this.ptPsi.x /= this.anisotropy[0];
            this.ptPsi.y /= this.anisotropy[1];
            this.ptPsi.z /= this.anisotropy[2];
        }
        if (this.sphere_radiusAngstroms > 0.0f) {
            if (this.params.anisoB != null) {
                return this.sphere_radiusAngstroms - (float)Math.sqrt(this.ptPsi.x * this.ptPsi.x + this.ptPsi.y * this.ptPsi.y + this.ptPsi.z * this.ptPsi.z) / (float)Math.sqrt(this.params.anisoB[0] * this.ptPsi.x * this.ptPsi.x + this.params.anisoB[1] * this.ptPsi.y * this.ptPsi.y + this.params.anisoB[2] * this.ptPsi.z * this.ptPsi.z + this.params.anisoB[3] * this.ptPsi.x * this.ptPsi.y + this.params.anisoB[4] * this.ptPsi.x * this.ptPsi.z + this.params.anisoB[5] * this.ptPsi.y * this.ptPsi.z);
            }
            return this.sphere_radiusAngstroms - (float)Math.sqrt(this.ptPsi.x * this.ptPsi.x + this.ptPsi.y * this.ptPsi.y + this.ptPsi.z * this.ptPsi.z);
        }
        float f = (float)this.hydrogenAtomPsiAt(this.ptPsi, this.psi_n, this.psi_l, this.psi_m);
        return this.allowNegative || f >= 0.0f ? f : 0.0f;
    }

    private void setHeader(String string) {
        this.jvxlFileHeaderBuffer = new StringBuffer(string);
        if (this.sphere_radiusAngstroms > 0.0f) {
            this.jvxlFileHeaderBuffer.append(" rad=").append(this.sphere_radiusAngstroms);
        } else {
            this.jvxlFileHeaderBuffer.append(" n=").append(this.psi_n).append(", l=").append(this.psi_l).append(", m=").append(this.psi_m).append(" Znuc=").append(this.psi_Znuc).append(" res=").append(this.ppa).append(" rad=").append(this.radius);
        }
        this.jvxlFileHeaderBuffer.append(this.isAnisotropic ? " anisotropy=(" + this.anisotropy[0] + "," + this.anisotropy[1] + "," + this.anisotropy[2] + ")\n" : "\n");
        JvxlReader.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    private float autoScaleOrbital() {
        float f = ((float)(this.psi_n * (this.psi_n + 3)) - 5.0f) / this.psi_Znuc;
        if (f < 1.0f) {
            f = 1.0f;
        }
        if (this.psi_n < 3) {
            f += 1.0f;
        }
        float f2 = 0.0f;
        if (!this.isAnisotropic) {
            return f;
        }
        int n = 3;
        while (--n >= 0) {
            if (!(this.anisotropy[n] > f2)) continue;
            f2 = this.anisotropy[n];
        }
        return f * f2;
    }

    private void calcFactors(int n, int n2, int n3) {
        int n4;
        int n5 = Math.abs(n3);
        double d = Math.pow((double)(2.0f * this.psi_Znuc / (float)n) / (double)0.52918f, 1.5) * Math.sqrt((double)(fact[n - n2 - 1] / 2.0f / (float)n) / Math.pow(fact[n + n2], 3.0));
        double d2 = fact[n + n2] * fact[n + n2];
        double d3 = Math.pow(2.0, -n2) * (double)fact[n2] * (double)fact[n2 + n5] * Math.sqrt((float)(2 * n2 + 1) * fact[n2 - n5] / 2.0f / fact[n2 + n5]);
        for (n4 = 0; n4 <= n - n2 - 1; ++n4) {
            this.rfactor[n4] = d * d2 / (double)fact[n4] / (double)fact[n - n2 - n4 - 1] / (double)fact[2 * n2 + n4 + 1];
        }
        for (n4 = n5; n4 <= n2; ++n4) {
            this.pfactor[n4] = Math.pow(-1.0, n2 - n4) * d3 / (double)fact[n4] / (double)fact[n2 + n5 - n4] / (double)fact[n2 - n4] / (double)fact[n4 - n5];
        }
    }

    private double hydrogenAtomPsiAt(Point3f point3f, int n, int n2, int n3) {
        int n4 = Math.abs(n3);
        double d = point3f.x * point3f.x + point3f.y * point3f.y;
        double d2 = d + (double)(point3f.z * point3f.z);
        double d3 = Math.sqrt(d2);
        double d4 = 2.0 * (double)this.psi_Znuc * d3 / (double)n / (double)0.52918f;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i <= n - n2 - 1; ++i) {
            d7 += Math.pow(-d4, i) * this.rfactor[i];
        }
        double d8 = Math.exp(-d4 / 2.0) * Math.pow(d4, n2) * d7;
        double d9 = Math.atan2(point3f.y, point3f.x);
        double d10 = Math.atan2(Math.sqrt(d), point3f.z);
        double d11 = Math.cos(d10);
        double d12 = Math.sin(d10);
        d7 = 0.0;
        for (int i = n4; i <= n2; ++i) {
            d7 += Math.pow(1.0 + d11, i - n4) * Math.pow(1.0 - d11, n2 - i) * this.pfactor[i];
        }
        d5 = Math.abs(Math.pow(d12, n4)) * d7;
        d6 = n3 == 0 ? 1.0 : (n3 > 0 ? Math.cos((double)n3 * d9) * 1.414214 : Math.sin((double)(-n3) * d9) * 1.414214);
        if (Math.abs(d6) < 1.0E-10) {
            d6 = 0.0;
        }
        return d8 * d5 * d6;
    }

    static {
        IsoShapeReader.fact[0] = 1.0f;
        for (int i = 1; i < 20; ++i) {
            IsoShapeReader.fact[i] = fact[i - 1] * (float)i;
        }
    }
}

