/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;

public class ZipUtil {
    public static boolean isZipFile(InputStream inputStream) throws Exception {
        byte[] byArray = new byte[4];
        inputStream.mark(5);
        int n = inputStream.read(byArray, 0, 4);
        inputStream.reset();
        return n == 4 && byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4;
    }

    public static boolean isZipFile(byte[] byArray) throws Exception {
        return byArray.length > 4 && byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4;
    }

    public static Object getZipFileContents(InputStream inputStream, String[] stringArray, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray == null || n >= stringArray.length) {
            return ZipUtil.getZipDirectoryAsStringAndClose(inputStream);
        }
        String string = stringArray[n];
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry;
            boolean bl2 = string.equals(".");
            if (bl2 || string.lastIndexOf("/") == string.length() - 1) {
                ZipEntry zipEntry2;
                while ((zipEntry2 = zipInputStream.getNextEntry()) != null) {
                    String string2 = zipEntry2.getName();
                    if (!bl2 && !string2.startsWith(string)) continue;
                    stringBuffer.append(string2).append('\n');
                }
                if (bl) {
                    return new StringBufferInputStream(stringBuffer.toString());
                }
                return stringBuffer.toString();
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string.equals(zipEntry.getName())) continue;
                byte[] byArray = ZipUtil.getZipEntryAsBytes(zipInputStream);
                if (ZipUtil.isZipFile(byArray)) {
                    return ZipUtil.getZipFileContents(new BufferedInputStream(new ByteArrayInputStream(byArray)), stringArray, ++n, bl);
                }
                if (bl) {
                    return new ByteArrayInputStream(byArray);
                }
                return new String(byArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static byte[] getZipFileContentsAsBytes(InputStream inputStream, String[] stringArray, int n) {
        byte[] byArray = new byte[]{};
        String string = stringArray[n];
        if (string.lastIndexOf("/") == string.length() - 1) {
            return byArray;
        }
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string.equals(zipEntry.getName())) continue;
                byte[] byArray2 = ZipUtil.getZipEntryAsBytes(zipInputStream);
                if (ZipUtil.isZipFile(byArray2) && stringArray != null && ++n < stringArray.length) {
                    return ZipUtil.getZipFileContentsAsBytes(new BufferedInputStream(new ByteArrayInputStream(byArray2)), stringArray, n);
                }
                return byArray2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public static String getZipDirectoryAsStringAndClose(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[]{};
        try {
            stringArray = ZipUtil.getZipDirectoryOrErrorAndClose(inputStream, false);
            inputStream.close();
        }
        catch (Exception exception) {
            Logger.error(exception.getMessage());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]).append('\n');
        }
        return stringBuffer.toString();
    }

    public static String[] getZipDirectoryAndClose(InputStream inputStream, boolean bl) {
        String[] stringArray = new String[]{};
        try {
            stringArray = ZipUtil.getZipDirectoryOrErrorAndClose(inputStream, bl);
            inputStream.close();
        }
        catch (Exception exception) {
            Logger.error(exception.getMessage());
        }
        return stringArray;
    }

    private static String[] getZipDirectoryOrErrorAndClose(InputStream inputStream, boolean bl) throws IOException {
        ZipEntry zipEntry;
        Vector<String> vector = new Vector<String>();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        String string = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string2 = zipEntry.getName();
            if (bl && string2.equals("JmolManifest")) {
                string = ZipUtil.getZipEntryAsString(zipInputStream);
                continue;
            }
            vector.addElement(string2);
        }
        zipInputStream.close();
        if (bl) {
            vector.add(0, string == null ? "" : string + "\n############\n");
        }
        int n = vector.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static String getZipEntryAsString(ZipInputStream zipInputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[1024];
        while (zipInputStream.available() == 1 && (n = zipInputStream.read(byArray)) > 0) {
            stringBuffer.append(new String(byArray, 0, n));
        }
        return stringBuffer.toString();
    }

    public static byte[] getZipEntryAsBytes(ZipInputStream zipInputStream) throws IOException {
        byte[] byArray = new byte[1024];
        byte[] byArray2 = new byte[4096];
        int n = 0;
        int n2 = 0;
        while (zipInputStream.available() == 1 && (n = zipInputStream.read(byArray)) > 0) {
            if ((n2 += n) >= byArray2.length) {
                byArray2 = ArrayUtil.ensureLength(byArray2, n2 * 2);
            }
            System.arraycopy(byArray, 0, byArray2, n2 - n, n);
        }
        byArray = new byte[n2];
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        return byArray;
    }

    public static byte[] getStreamAsBytes(BufferedInputStream bufferedInputStream) throws IOException {
        byte[] byArray = new byte[1024];
        byte[] byArray2 = new byte[4096];
        int n = 0;
        int n2 = 0;
        while ((n = bufferedInputStream.read(byArray)) > 0) {
            if ((n2 += n) >= byArray2.length) {
                byArray2 = ArrayUtil.ensureLength(byArray2, n2 * 2);
            }
            System.arraycopy(byArray, 0, byArray2, n2 - n, n);
        }
        byArray = new byte[n2];
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        return byArray;
    }
}

