/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class Quaternion {
    public float q0;
    public float q1;
    public float q2;
    public float q3;
    public Matrix3f mat;

    private Quaternion(float f, float f2, float f3, float f4) {
        this.q0 = f;
        this.q1 = f2;
        this.q2 = f3;
        this.q3 = f4;
        this.fixQ();
    }

    public Quaternion(Point4f point4f) {
        float f = point4f.distance(new Point4f(0.0f, 0.0f, 0.0f, 0.0f));
        if (f == 0.0f) {
            this.q0 = 1.0f;
            return;
        }
        this.q0 = point4f.w / f;
        this.q1 = point4f.x / f;
        this.q2 = point4f.y / f;
        this.q3 = point4f.z / f;
        this.fixQ();
    }

    public Quaternion(Tuple3f tuple3f, float f) {
        if (tuple3f.x == 0.0f && tuple3f.y == 0.0f && tuple3f.z == 0.0f) {
            this.q0 = 1.0f;
            return;
        }
        double d = Math.sin((double)(f / 2.0f) * Math.PI / 180.0) / Math.sqrt(tuple3f.x * tuple3f.x + tuple3f.y * tuple3f.y + tuple3f.z * tuple3f.z);
        this.q0 = (float)Math.cos((double)(f / 2.0f) * Math.PI / 180.0);
        this.q1 = (float)((double)tuple3f.x * d);
        this.q2 = (float)((double)tuple3f.y * d);
        this.q3 = (float)((double)tuple3f.z * d);
        this.fixQ();
    }

    private Quaternion fixQ() {
        if (this.q0 < 0.0f) {
            this.q0 = -this.q0;
            this.q1 = -this.q1;
            this.q2 = -this.q2;
            this.q3 = -this.q3;
        }
        return this;
    }

    public Quaternion(Matrix3f matrix3f) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = matrix3f.m00 + matrix3f.m11 + matrix3f.m22;
        if (d5 >= 0.5) {
            d4 = Math.sqrt(1.0 + d5);
            d3 = (double)(matrix3f.m21 - matrix3f.m12) / d4;
            d2 = (double)(matrix3f.m02 - matrix3f.m20) / d4;
            d = (double)(matrix3f.m10 - matrix3f.m01) / d4;
        } else {
            double d6;
            double d7 = (double)(matrix3f.m00 + matrix3f.m00) - d5;
            if (d6 >= 0.5) {
                d3 = Math.sqrt(1.0 + d7);
                d4 = (double)(matrix3f.m21 - matrix3f.m12) / d3;
                d2 = (double)(matrix3f.m10 + matrix3f.m01) / d3;
                d = (double)(matrix3f.m20 + matrix3f.m02) / d3;
            } else {
                double d8;
                d7 = (double)(matrix3f.m11 + matrix3f.m11) - d5;
                if (d8 >= 0.5) {
                    d2 = Math.sqrt(1.0 + d7);
                    d4 = (double)(matrix3f.m02 - matrix3f.m20) / d2;
                    d3 = (double)(matrix3f.m10 + matrix3f.m01) / d2;
                    d = (double)(matrix3f.m21 + matrix3f.m12) / d2;
                } else {
                    d = Math.sqrt(1.0 + (double)matrix3f.m22 + (double)matrix3f.m22 - d5);
                    d4 = (double)(matrix3f.m10 - matrix3f.m01) / d;
                    d3 = (double)(matrix3f.m20 + matrix3f.m02) / d;
                    d2 = (double)(matrix3f.m21 + matrix3f.m12) / d;
                }
            }
        }
        this.q0 = (float)(d4 * 0.5);
        this.q1 = (float)(d3 * 0.5);
        this.q2 = (float)(d2 * 0.5);
        this.q3 = (float)(d * 0.5);
        this.fixQ();
    }

    public static final Quaternion getQuaternionFrame(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        if (vector3f3 == null) {
            vector3f3 = new Vector3f();
            vector3f3.cross(vector3f, vector3f2);
        }
        Vector3f vector3f4 = new Vector3f();
        vector3f4.cross(vector3f3, vector3f);
        vector3f.normalize();
        vector3f4.normalize();
        vector3f3.normalize();
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.setColumn(0, vector3f);
        matrix3f.setColumn(1, vector3f4);
        matrix3f.setColumn(2, vector3f3);
        Quaternion quaternion = new Quaternion(matrix3f);
        return quaternion;
    }

    public Matrix3f getMatrix() {
        if (this.mat == null) {
            this.setMatrix();
        }
        return this.mat;
    }

    private void setMatrix() {
        this.mat = new Matrix3f();
        this.mat.m00 = this.q0 * this.q0 + this.q1 * this.q1 - this.q2 * this.q2 - this.q3 * this.q3;
        this.mat.m01 = 2.0f * this.q1 * this.q2 - 2.0f * this.q0 * this.q3;
        this.mat.m02 = 2.0f * this.q1 * this.q3 + 2.0f * this.q0 * this.q2;
        this.mat.m10 = 2.0f * this.q1 * this.q2 + 2.0f * this.q0 * this.q3;
        this.mat.m11 = this.q0 * this.q0 - this.q1 * this.q1 + this.q2 * this.q2 - this.q3 * this.q3;
        this.mat.m12 = 2.0f * this.q2 * this.q3 - 2.0f * this.q0 * this.q1;
        this.mat.m20 = 2.0f * this.q1 * this.q3 - 2.0f * this.q0 * this.q2;
        this.mat.m21 = 2.0f * this.q2 * this.q3 + 2.0f * this.q0 * this.q1;
        this.mat.m22 = this.q0 * this.q0 - this.q1 * this.q1 - this.q2 * this.q2 + this.q3 * this.q3;
    }

    public Quaternion add(float f) {
        return new Quaternion((Tuple3f)this.getNormal(), this.getTheta() + f);
    }

    public Quaternion mul(float f) {
        if (f == 1.0f) {
            return new Quaternion(this.q0, this.q1, this.q2, this.q3);
        }
        return new Quaternion((Tuple3f)this.getNormal(), this.getTheta() * f);
    }

    public Quaternion mul(Quaternion quaternion) {
        return new Quaternion(this.q0 * quaternion.q0 - this.q1 * quaternion.q1 - this.q2 * quaternion.q2 - this.q3 * quaternion.q3, this.q0 * quaternion.q1 + this.q1 * quaternion.q0 + this.q2 * quaternion.q3 - this.q3 * quaternion.q2, this.q0 * quaternion.q2 + this.q2 * quaternion.q0 + this.q3 * quaternion.q1 - this.q1 * quaternion.q3, this.q0 * quaternion.q3 + this.q3 * quaternion.q0 + this.q1 * quaternion.q2 - this.q2 * quaternion.q1);
    }

    public Quaternion div(Quaternion quaternion) {
        return this.mul(quaternion.inv());
    }

    public Quaternion divLeft(Quaternion quaternion) {
        return this.inv().mul(quaternion);
    }

    public float dot(Quaternion quaternion) {
        return this.q0 * quaternion.q0 + this.q1 * quaternion.q1 + this.q2 * quaternion.q2 + this.q3 * quaternion.q3;
    }

    public Quaternion inv() {
        return new Quaternion(this.q0, -this.q1, -this.q2, -this.q3);
    }

    public String toString() {
        this.fixQ();
        return "{" + this.q1 + " " + this.q2 + " " + this.q3 + " " + this.q0 + "}";
    }

    public Vector3f getVector(int n) {
        if (n == -1) {
            this.fixQ();
            return new Vector3f(this.q1, this.q2, this.q3);
        }
        if (this.mat == null) {
            this.setMatrix();
        }
        Vector3f vector3f = new Vector3f();
        this.mat.getColumn(n, vector3f);
        return vector3f;
    }

    public Vector3f getNormal() {
        this.fixQ();
        Vector3f vector3f = new Vector3f(this.q1, this.q2, this.q3);
        vector3f.normalize();
        return vector3f;
    }

    public float getTheta() {
        this.fixQ();
        return (float)(Math.acos(this.q0) * 2.0 * 180.0 / Math.PI);
    }

    public void getThetaDirected(Point4f point4f) {
        float f = this.getTheta();
        Vector3f vector3f = this.getNormal();
        if (point4f.x * this.q1 + point4f.y * this.q2 + point4f.z * this.q3 < 0.0f) {
            vector3f.scale(-1.0f);
            f = -f;
        }
        point4f.set(vector3f.x, vector3f.y, vector3f.z, f);
    }

    public Point4f toPoint4f() {
        this.fixQ();
        return new Point4f(this.q1, this.q2, this.q3, this.q0);
    }

    public Point3f transform(Point3f point3f) {
        if (this.mat == null) {
            this.setMatrix();
        }
        Point3f point3f2 = new Point3f(point3f);
        this.mat.transform((Tuple3f)point3f2);
        return point3f2;
    }

    public void transform(Point3f point3f, Point3f point3f2) {
        if (this.mat == null) {
            this.setMatrix();
        }
        this.mat.transform((Tuple3f)point3f, (Tuple3f)point3f2);
    }

    public Vector3f transform(Vector3f vector3f) {
        if (this.mat == null) {
            this.setMatrix();
        }
        Vector3f vector3f2 = new Vector3f(vector3f);
        this.mat.transform((Tuple3f)vector3f2);
        return vector3f2;
    }
}

