/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import org.jmol.g3d.Platform3D;

final class Swing3D
extends Platform3D {
    static final DirectColorModel rgbColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
    static final int[] sampleModelBitMasks = new int[]{0xFF0000, 65280, 255};

    Swing3D() {
    }

    Image allocateImage() {
        return new BufferedImage(rgbColorModel, Raster.createWritableRaster(new SinglePixelPackedSampleModel(3, this.windowWidth, this.windowHeight, sampleModelBitMasks), new DataBufferInt(this.pBuffer, this.windowSize), null), false, null);
    }

    Image allocateOffscreenImage(int n, int n2) {
        return new BufferedImage(n, n2, 1);
    }

    Graphics getGraphics(Image image) {
        return Swing3D.getStaticGraphics(image);
    }

    static Graphics getStaticGraphics(Image image) {
        Graphics2D graphics2D = ((BufferedImage)image).createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        return graphics2D;
    }
}

