/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.api.JmolExportInterface;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.shape.ShapeRenderer;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public class FrameRenderer {
    boolean logTime;
    Viewer viewer;
    ShapeRenderer[] renderers = new ShapeRenderer[32];

    FrameRenderer(Viewer viewer) {
        this.viewer = viewer;
    }

    void render(Graphics3D graphics3D, ModelSet modelSet) {
        if (modelSet == null || !this.viewer.mustRenderFlag()) {
            return;
        }
        this.logTime = this.viewer.getTestFlag1();
        this.viewer.finalizeTransformParameters();
        if (this.logTime) {
            Logger.startTimer();
        }
        for (int i = 0; i < 32 && graphics3D.currentlyRendering(); ++i) {
            Shape shape = modelSet.getShape(i);
            if (shape == null) continue;
            this.getRenderer(i, graphics3D).render(graphics3D, modelSet, shape);
        }
        if (this.logTime) {
            Logger.checkTimer("render time");
        }
    }

    public void clear() {
        for (int i = 0; i < 32; ++i) {
            this.renderers[i] = null;
        }
    }

    ShapeRenderer getRenderer(int n, Graphics3D graphics3D) {
        if (this.renderers[n] == null) {
            this.renderers[n] = this.allocateRenderer(n, graphics3D);
        }
        return this.renderers[n];
    }

    ShapeRenderer allocateRenderer(int n, Graphics3D graphics3D) {
        String string = JmolConstants.getShapeClassName(n) + "Renderer";
        try {
            Class<?> clazz = Class.forName(string);
            ShapeRenderer shapeRenderer = (ShapeRenderer)clazz.newInstance();
            shapeRenderer.setViewerG3dShapeID(this.viewer, graphics3D, n);
            return shapeRenderer;
        }
        catch (Exception exception) {
            Logger.error("Could not instantiate renderer:" + string, exception);
            return null;
        }
    }

    String generateOutput(String string, Graphics3D graphics3D, ModelSet modelSet, String string2) {
        this.viewer.finalizeTransformParameters();
        JmolExportInterface jmolExportInterface = null;
        JmolRendererInterface jmolRendererInterface = null;
        CharSequence charSequence = null;
        try {
            charSequence = string2 == null ? new StringBuffer() : string2;
            Class<?> clazz = Class.forName("org.jmol.export._" + string + "Exporter");
            jmolExportInterface = (JmolExportInterface)clazz.newInstance();
            clazz = Class.forName("org.jmol.export.Export3D");
            jmolRendererInterface = (JmolRendererInterface)clazz.newInstance();
        }
        catch (Exception exception) {
            Logger.error("Cannot export " + string);
            return "";
        }
        if (!jmolExportInterface.initializeOutput(this.viewer, graphics3D, charSequence)) {
            return null;
        }
        jmolExportInterface.getHeader();
        jmolRendererInterface.setg3dExporter(graphics3D, jmolExportInterface);
        for (int i = 0; i < 32; ++i) {
            ShapeRenderer shapeRenderer;
            Shape shape = modelSet.getShape(i);
            if (shape == null || (shapeRenderer = this.getGenerator(i, graphics3D)) == null) continue;
            shapeRenderer.setGenerator(true);
            jmolRendererInterface.setRenderer(shapeRenderer);
            shapeRenderer.render(jmolRendererInterface, modelSet, shape);
        }
        jmolExportInterface.getFooter();
        return jmolExportInterface.finalizeOutput();
    }

    ShapeRenderer getGenerator(int n, Graphics3D graphics3D) {
        String string = "org.jmol.export." + JmolConstants.getShapeClassName(~n) + "Generator";
        try {
            Class<?> clazz = Class.forName(string);
            ShapeRenderer shapeRenderer = (ShapeRenderer)clazz.newInstance();
            shapeRenderer.setViewerG3dShapeID(this.viewer, graphics3D, n);
            return shapeRenderer;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

