/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

public class Int2ObjHash {
    int entryCount;
    Entry[] entries;

    public Int2ObjHash(int n) {
        this.entries = new Entry[n];
    }

    public Int2ObjHash() {
        this(256);
    }

    public synchronized Object get(int n) {
        Entry[] entryArray = this.entries;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == n) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public synchronized void put(int n, Object object) {
        Entry[] entryArray = this.entries;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.key == n) {
                entry.value = object;
                return;
            }
            entry = entry.next;
        }
        if (this.entryCount > entryArray.length) {
            this.rehash();
        }
        entryArray = this.entries;
        n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        entryArray[n2] = new Entry(n, object, entryArray[n2]);
        ++this.entryCount;
    }

    private void rehash() {
        Entry[] entryArray = this.entries;
        int n = entryArray.length;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        int n3 = n;
        while (--n3 >= 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.key & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
        this.entries = entryArray2;
    }

    static class Entry {
        int key;
        Object value;
        Entry next;

        Entry(int n, Object object, Entry entry) {
            this.key = n;
            this.value = object;
            this.next = entry;
        }
    }
}

