/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.shape.Mesh;
import org.jmol.shapespecial.MeshFileCollection;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BinaryDocument;
import org.jmol.util.Logger;

public class Pmesh
extends MeshFileCollection {
    private boolean isOnePerLine;
    private boolean isBinary;
    private int modelIndex;
    private boolean iHaveModelIndex;
    String pmeshError;
    private static final String PMESH_BINARY_MAGIC_NUMBER = "PM\u0001\u0000";
    BufferedReader br;
    PmeshBinaryDocument doc;

    public void initShape() {
        super.initShape();
        this.myType = "pmesh";
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("init" == string) {
            this.br = null;
            this.doc = null;
            this.pmeshError = null;
            this.isFixed = false;
            this.isBinary = false;
            this.isOnePerLine = false;
            this.script = (String)object;
            this.getModelIndex(this.script);
            super.setProperty("thisID", "+PREVIOUS_MESH+", null);
        }
        if ("modelIndex" == string) {
            if (!this.iHaveModelIndex) {
                this.modelIndex = (Integer)object;
            }
            return;
        }
        if ("fixed" == string) {
            this.isFixed = (Boolean)object;
            this.modelIndex = -1;
            this.setModelIndex(-1, -1);
            return;
        }
        if ("bufferedReaderOnePerLine" == string) {
            this.isOnePerLine = true;
            string = "bufferedReader";
        }
        if ("fileData" == string) {
            if (this.currentMesh == null) {
                this.allocMesh(null);
            }
            this.currentMesh.clear("pmesh");
            if (object instanceof BufferedReader) {
                this.br = (BufferedReader)object;
            } else {
                this.doc = new PmeshBinaryDocument(new BufferedInputStream((InputStream)object));
                this.isBinary = this.doc.readHeader();
                if (!this.isBinary) {
                    return;
                }
            }
            this.currentMesh.isValid = this.readPmesh();
            this.closeReaders();
            if (this.currentMesh.isValid) {
                this.currentMesh.initialize(2);
                this.currentMesh.visible = true;
                this.currentMesh.title = this.title;
            } else {
                Logger.error(this.pmeshError);
            }
            this.setModelIndex(-1, this.modelIndex);
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            int n2 = this.meshCount;
            while (--n2 >= 0) {
                if (this.meshes[n2] == null) continue;
                if (this.meshes[n2].modelIndex == n) {
                    --this.meshCount;
                    if (this.meshes[n2] == this.currentMesh) {
                        this.currentMesh = null;
                    }
                    this.meshes = (Mesh[])ArrayUtil.deleteElements(this.meshes, n2, 1);
                    continue;
                }
                if (this.meshes[n2].modelIndex <= n) continue;
                --this.meshes[n2].modelIndex;
            }
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    public Object getProperty(String string, int n) {
        if (string.equals("pmeshError")) {
            return this.pmeshError;
        }
        if (string.startsWith("checkMagicNumber:")) {
            return string.indexOf(PMESH_BINARY_MAGIC_NUMBER) >= 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return super.getProperty(string, n);
    }

    private boolean readPmesh() {
        try {
            if (!this.readVertexCount()) {
                return false;
            }
            Logger.debug("vertexCount=" + this.currentMesh.vertexCount);
            if (!this.readVertices()) {
                return false;
            }
            Logger.debug("vertices read");
            if (!this.readPolygonCount()) {
                return false;
            }
            Logger.debug("polygonCount=" + this.currentMesh.polygonCount);
            if (!this.readPolygonIndexes()) {
                return false;
            }
            Logger.debug("polygonIndexes read");
            if (this.currentMesh.polygonCount == 0) {
                this.currentMesh.setPolygonCount(1);
                this.currentMesh.polygonIndexes[0] = new int[]{0, 0, 0};
            }
        }
        catch (Exception exception) {
            if (this.pmeshError == null) {
                this.pmeshError = "pmesh ERROR: read exception: " + exception;
            }
            return false;
        }
        return true;
    }

    private void closeReaders() {
        try {
            if (this.doc != null) {
                this.doc.close();
            }
            if (this.br != null) {
                this.br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doc = null;
        this.br = null;
    }

    private int getInt() throws Exception {
        return this.isBinary ? this.doc.readInt() : this.parseInt(this.br.readLine());
    }

    private boolean readVertexCount() throws Exception {
        int n;
        this.pmeshError = "pmesh ERROR: vertex count must be positive";
        this.currentMesh.vertexCount = 0;
        this.currentMesh.vertices = new Point3f[0];
        int n2 = n = this.isBinary ? this.doc.getVertexCount() : this.getInt();
        if (n <= 0) {
            this.pmeshError = this.pmeshError + " (" + n + ")";
            return false;
        }
        this.currentMesh.vertexCount = n;
        this.currentMesh.vertices = new Point3f[n];
        this.pmeshError = null;
        return true;
    }

    private boolean readVertices() throws Exception {
        this.pmeshError = "pmesh ERROR: invalid vertex list";
        if (this.isBinary) {
            this.doc.readPoint3fArray(this.currentMesh.vertices);
        } else if (this.isOnePerLine) {
            for (int i = 0; i < this.currentMesh.vertexCount; ++i) {
                float f = this.parseFloat(this.br.readLine());
                float f2 = this.parseFloat(this.br.readLine());
                float f3 = this.parseFloat(this.br.readLine());
                this.currentMesh.vertices[i] = new Point3f(f, f2, f3);
            }
        } else {
            for (int i = 0; i < this.currentMesh.vertexCount; ++i) {
                this.line = this.br.readLine();
                float f = this.parseFloat(this.line);
                float f4 = this.parseFloat();
                float f5 = this.parseFloat();
                this.currentMesh.vertices[i] = new Point3f(f, f4, f5);
            }
        }
        this.pmeshError = null;
        return true;
    }

    private boolean readPolygonCount() throws Exception {
        int n;
        int n2 = n = this.isBinary ? this.doc.getPolygonCount() : this.parseInt(this.br.readLine());
        if (n >= 0) {
            this.currentMesh.setPolygonCount(n);
        } else {
            this.pmeshError = "pmesh ERROR: polygon count must be >= 0 (" + n + ")";
        }
        return n >= 0;
    }

    private boolean readPolygonIndexes() throws Exception {
        for (int i = 0; i < this.currentMesh.polygonCount; ++i) {
            this.currentMesh.polygonIndexes[i] = this.readPolygon(i);
            if (this.currentMesh.polygonIndexes[i] != null) continue;
            return false;
        }
        return true;
    }

    private int[] readPolygon(int n) throws Exception {
        int n2;
        int n3;
        int n4 = this.getInt();
        int n5 = n3 = this.isBinary ? n4 : n4 - 1;
        if (n3 < 1 || n3 > 4) {
            this.pmeshError = "pmesh ERROR: bad polygon (must have 1-4 vertices) at #" + (n + 1);
            return null;
        }
        int n6 = n3 < 3 ? 3 : n3;
        int[] nArray = new int[n6];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = this.getInt();
            if (nArray[n2] >= 0 && nArray[n2] < this.currentMesh.vertexCount) continue;
            this.pmeshError = "pmesh ERROR: invalid vertex index: " + nArray[n2];
            return null;
        }
        for (n2 = n3; n2 < n6; ++n2) {
            nArray[n2] = nArray[n2 - 1];
        }
        if (this.isBinary || (n2 = this.getInt()) == nArray[0]) {
            return nArray;
        }
        this.pmeshError = "pmesh ERROR: last polygon point reference (" + n2 + ") is not the same as the first (" + nArray[0] + ") for polygon " + (n + 1);
        return null;
    }

    class PmeshBinaryDocument
    extends BinaryDocument {
        private int vertexCount;
        private int polygonCount;

        PmeshBinaryDocument(BufferedInputStream bufferedInputStream) {
            this.isRandom = false;
            this.stream = new DataInputStream(bufferedInputStream);
        }

        boolean readHeader() {
            Pmesh.this.pmeshError = "could not read binary Pmesh file header";
            byte[] byArray = new byte[8];
            try {
                this.readByteArray(byArray, 0, 8);
                if (!new String(byArray).startsWith(Pmesh.PMESH_BINARY_MAGIC_NUMBER)) {
                    return false;
                }
                this.isBigEndian = byArray[5] == 0;
                this.vertexCount = this.readInt();
                this.polygonCount = this.readInt();
                byte[] byArray2 = new byte[64];
                this.readByteArray(byArray2, 0, 64);
            }
            catch (Exception exception) {
                Pmesh.this.pmeshError = Pmesh.this.pmeshError + " " + exception.getMessage();
                this.close();
                return false;
            }
            Pmesh.this.pmeshError = null;
            return true;
        }

        void close() {
            try {
                this.stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        int getPolygonCount() {
            return this.polygonCount;
        }

        int getVertexCount() {
            return this.vertexCount;
        }
    }
}

