/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point4f;
import org.jmol.shape.Shape;
import org.jmol.shapespecial.Isosurface;
import org.jmol.shapespecial.IsosurfaceMesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class MolecularOrbital
extends Isosurface {
    private String moTranslucency = null;
    private Float moTranslucentLevel = null;
    private Point4f moPlane = null;
    private Float moCutoff = null;
    private Float moResolution = null;
    private Float moScale = null;
    private Integer moColorPos = null;
    private Integer moColorNeg = null;
    private boolean moIsPositiveOnly = false;
    private boolean moFill = false;
    private boolean moMesh = true;
    private boolean moDots = false;
    private boolean moFrontOnly = true;
    private String moTitleFormat = null;
    private boolean moDebug;
    private int myColorPt;
    private String strID;
    private int moNumber;
    private Hashtable htModels;
    private Hashtable thisModel;

    public void initShape() {
        super.initShape();
        this.myType = "molecularOrbital";
        super.setProperty("thisID", "mo", null);
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (Logger.debugging) {
            Logger.debug("MolecularOrbital.setProperty " + string + " " + object);
        }
        if ("init" == string) {
            this.myColorPt = 0;
            this.moDebug = false;
            int n = (Integer)object;
            this.strID = this.getId(n);
            super.setProperty("init", null, null);
            if (this.htModels == null) {
                this.htModels = new Hashtable();
            }
            if (!this.htModels.containsKey(this.strID)) {
                this.htModels.put(this.strID, new Hashtable());
            }
            this.thisModel = (Hashtable)this.htModels.get(this.strID);
            this.moNumber = !this.thisModel.containsKey("moNumber") ? 0 : (Integer)this.thisModel.get("moNumber");
            return;
        }
        if ("cutoff" == string) {
            this.thisModel.put("moCutoff", object);
            this.thisModel.put("moIsPositiveOnly", Boolean.FALSE);
            return;
        }
        if ("scale" == string) {
            this.thisModel.put("moScale", this.moScale);
            return;
        }
        if ("cutoffPositive" == string) {
            this.thisModel.put("moCutoff", object);
            this.thisModel.put("moIsPositiveOnly", Boolean.TRUE);
            return;
        }
        if ("resolution" == string) {
            this.thisModel.put("moResolution", object);
            return;
        }
        if ("titleFormat" == string) {
            this.moTitleFormat = (String)object;
            return;
        }
        if ("color" == string) {
            this.thisModel.remove("moTranslucency");
            super.setProperty("color", object, bitSet);
            string = "colorRGB";
            this.myColorPt = 0;
        }
        if ("colorRGB" == string) {
            this.moColorPos = (Integer)object;
            if (this.myColorPt++ == 0) {
                this.moColorNeg = this.moColorPos;
            }
            this.thisModel.put("moColorNeg", this.moColorNeg);
            this.thisModel.put("moColorPos", this.moColorPos);
            return;
        }
        if ("plane" == string) {
            if (object == null) {
                this.thisModel.remove("moPlane");
            } else {
                this.thisModel.put("moPlane", object);
            }
            return;
        }
        if ("molecularOrbital" == string) {
            this.moNumber = (Integer)object;
            this.thisModel.put("moNumber", object);
            this.setOrbital(this.moNumber);
            return;
        }
        if ("translucentLevel" == string) {
            if (this.thisModel == null) {
                if (this.currentMesh == null) {
                    return;
                }
                this.thisModel = (Hashtable)this.htModels.get(this.currentMesh.thisID);
            }
            this.thisModel.put("moTranslucentLevel", object);
        }
        if ("translucency" == string) {
            if (this.thisModel == null) {
                if (this.currentMesh == null) {
                    return;
                }
                this.thisModel = (Hashtable)this.htModels.get(this.currentMesh.thisID);
            }
            this.thisModel.put("moTranslucency", object);
        }
        if ("dots" == string) {
            boolean bl = this.moDots = object == Boolean.TRUE;
        }
        if ("mesh" == string) {
            boolean bl = this.moMesh = object == Boolean.TRUE;
        }
        if ("frontOnly" == string) {
            boolean bl = this.moFrontOnly = object == Boolean.TRUE;
        }
        if ("fill" == string) {
            boolean bl = this.moFill = object == Boolean.TRUE;
        }
        if ("delete" == string) {
            this.htModels.remove(this.strID);
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
            int n2 = this.meshCount;
            while (--n2 >= 0) {
                if (this.meshes[n2] == null) continue;
                if (this.meshes[n2].modelIndex == n) {
                    --this.meshCount;
                    if (this.meshes[n2] == this.currentMesh) {
                        this.currentMesh = null;
                        this.thisModel = null;
                    }
                    this.meshes = (IsosurfaceMesh[])ArrayUtil.deleteElements(this.meshes, n2, 1);
                    continue;
                }
                Hashtable hashtable2 = (Hashtable)this.htModels.get(this.meshes[n2].thisID);
                if (this.meshes[n2].modelIndex > n) {
                    --this.meshes[n2].modelIndex;
                    this.meshes[n2].thisID = this.getId(this.meshes[n2].modelIndex);
                }
                hashtable.put(this.meshes[n2].thisID, hashtable2);
            }
            this.htModels = hashtable;
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    private String getId(int n) {
        return "mo_model" + this.viewer.getModelNumber(n);
    }

    public Object getProperty(String string, int n) {
        if (string == "list") {
            return super.getProperty(string, n);
        }
        if (string == "moNumber") {
            return new Integer(this.moNumber);
        }
        if (string == "showMO") {
            int n2;
            int n3;
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "jvxlFileData";
            Vector vector = (Vector)this.sg.getMoData().get("mos");
            int n4 = n3 = vector == null ? 0 : vector.size();
            if (n3 == 0) {
                return "";
            }
            int n5 = n;
            int n6 = this.moNumber;
            if (n6 == 0) {
                n5 = 0;
            }
            int n7 = n5 > 0 ? 1 : n3;
            for (int i = n2 = n7 == 1 && n6 > 0 ? n6 : 1; i <= n3; ++i) {
                if (n5 != 0 && n5 != i && (n5 != Integer.MAX_VALUE || i != n6)) continue;
                if (n5 != Integer.MAX_VALUE) {
                    super.setProperty("init", "mo_show", null);
                    this.setOrbital(i);
                }
                stringBuffer.append(super.getProperty(string2, n7));
                string2 = "jvxlSurfaceData";
                if (n5 != Integer.MAX_VALUE) {
                    super.setProperty("delete", "mo_show", null);
                }
                if (n7 == 1) break;
            }
            return stringBuffer.toString();
        }
        return null;
    }

    protected void clearSg() {
    }

    private boolean getSettings(String string) {
        this.thisModel = (Hashtable)this.htModels.get(string);
        if (this.thisModel == null || this.thisModel.get("moNumber") == null) {
            return false;
        }
        this.moTranslucency = (String)this.thisModel.get("moTranslucency");
        this.moTranslucentLevel = (Float)this.thisModel.get("moTranslucentLevel");
        this.moPlane = (Point4f)this.thisModel.get("moPlane");
        this.moCutoff = (Float)this.thisModel.get("moCutoff");
        if (this.moCutoff == null) {
            this.moCutoff = (Float)this.sg.getMoData().get("defaultCutoff");
        }
        if (this.moCutoff == null) {
            this.moCutoff = new Float(0.05f);
        }
        this.moResolution = (Float)this.thisModel.get("moResolution");
        this.moScale = (Float)this.thisModel.get("moScale");
        this.moColorPos = (Integer)this.thisModel.get("moColorPos");
        this.moColorNeg = (Integer)this.thisModel.get("moColorNeg");
        this.moNumber = (Integer)this.thisModel.get("moNumber");
        Object v = this.thisModel.get("moIsPositiveOnly");
        this.moIsPositiveOnly = v != null && (Boolean)v != false;
        return true;
    }

    private void setOrbital(int n) {
        super.setProperty("reset", this.strID, null);
        if (this.moDebug) {
            super.setProperty("debug", Boolean.TRUE, null);
        }
        this.getSettings(this.strID);
        if (this.moScale != null) {
            super.setProperty("scale", this.moScale, null);
        }
        if (this.moResolution != null) {
            super.setProperty("resolution", this.moResolution, null);
        }
        if (this.moPlane != null) {
            super.setProperty("plane", this.moPlane, null);
            if (this.moCutoff != null) {
                super.setProperty("red", new Float(-this.moCutoff.floatValue()), null);
                super.setProperty("blue", this.moCutoff, null);
            }
        } else {
            if (this.moCutoff != null) {
                super.setProperty(this.moIsPositiveOnly ? "cutoffPositive" : "cutoff", this.moCutoff, null);
            }
            if (this.moColorNeg != null) {
                super.setProperty("colorRGB", this.moColorNeg, null);
            }
            if (this.moColorPos != null) {
                super.setProperty("colorRGB", this.moColorPos, null);
            }
        }
        super.setProperty("title", this.moTitleFormat, null);
        super.setProperty("fileName", this.viewer.getFileName(), null);
        super.setProperty("molecularOrbital", new Integer(n), null);
        if (this.moTranslucentLevel != null) {
            super.setProperty("translucenctLevel", this.moTranslucentLevel, null);
        }
        if (this.moTranslucency != null) {
            super.setProperty("translucency", this.moTranslucency, null);
        }
        super.setProperty("fill", this.moFill ? Boolean.TRUE : Boolean.FALSE, null);
        super.setProperty("mesh", this.moMesh ? Boolean.TRUE : Boolean.FALSE, null);
        super.setProperty("dots", this.moDots ? Boolean.TRUE : Boolean.FALSE, null);
        super.setProperty("frontOnly", this.moFrontOnly ? Boolean.TRUE : Boolean.FALSE, null);
        this.thisModel.put("mesh", this.currentMesh);
    }

    public String getShapeState() {
        if (this.htModels == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.modelCount; ++i) {
            stringBuffer.append(this.getMoState(i));
        }
        return stringBuffer.toString();
    }

    private String getMoState(int n) {
        this.strID = this.getId(n);
        if (!this.getSettings(this.strID)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.modelCount > 1) {
            Shape.appendCmd(stringBuffer, "frame " + this.viewer.getModelNumber(n));
        }
        if (this.moCutoff != null) {
            Shape.appendCmd(stringBuffer, "mo cutoff " + (this.sg.getIsPositiveOnly() ? "+" : "") + this.moCutoff);
        }
        if (this.moScale != null) {
            Shape.appendCmd(stringBuffer, "mo scale " + this.moScale);
        }
        if (this.moResolution != null) {
            Shape.appendCmd(stringBuffer, "mo resolution " + this.moResolution);
        }
        if (this.moPlane != null) {
            Shape.appendCmd(stringBuffer, "mo plane {" + this.moPlane.x + " " + this.moPlane.y + " " + this.moPlane.z + " " + this.moPlane.w + "}");
        }
        if (this.moTitleFormat != null) {
            Shape.appendCmd(stringBuffer, "mo titleFormat " + Escape.escape(this.moTitleFormat));
        }
        if (this.moColorNeg != null) {
            Shape.appendCmd(stringBuffer, "mo color " + Escape.escapeColor(this.moColorNeg) + (this.moColorNeg.equals(this.moColorPos) ? "" : " " + Escape.escapeColor(this.moColorPos)));
        }
        Shape.appendCmd(stringBuffer, "mo " + this.moNumber);
        if (this.moTranslucency != null) {
            Shape.appendCmd(stringBuffer, "mo translucent " + this.moTranslucentLevel);
        }
        Shape.appendCmd(stringBuffer, ((IsosurfaceMesh)this.thisModel.get("mesh")).getState("mo"));
        return stringBuffer.toString();
    }
}

