/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.shape.Mesh;
import org.jmol.shapespecial.IsosurfaceMesh;
import org.jmol.shapespecial.MeshFileCollection;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public class Isosurface
extends MeshFileCollection
implements MeshDataServer {
    private IsosurfaceMesh[] isomeshes = new IsosurfaceMesh[4];
    private IsosurfaceMesh thisMesh;
    private int lighting;
    private boolean iHaveBitSets;
    private int atomIndex;
    private int moNumber;
    private short defaultColix;
    private Point3f center;
    private boolean isPhaseColored;
    protected SurfaceGenerator sg;
    private JvxlData jvxlData;
    private ColorEncoder colorEncoder = new ColorEncoder();
    private int indexColorPositive;
    private int indexColorNegative;
    private int nLCAO = 0;
    private Point4f lcaoDir = new Point4f();
    private boolean associateNormals;

    public void allocMesh(String string) {
        this.isomeshes = (IsosurfaceMesh[])ArrayUtil.ensureLength(this.isomeshes, this.meshCount + 1);
        this.meshes = this.isomeshes;
        IsosurfaceMesh isosurfaceMesh = new IsosurfaceMesh(string, this.g3d, this.colix);
        this.isomeshes[this.meshCount++] = isosurfaceMesh;
        this.thisMesh = isosurfaceMesh;
        this.currentMesh = isosurfaceMesh;
        this.jvxlData = this.thisMesh.jvxlData;
        this.sg.setJvxlData(this.jvxlData);
    }

    public void initShape() {
        super.initShape();
        this.myType = "isosurface";
        this.jvxlData = new JvxlData();
        this.sg = new SurfaceGenerator(this.viewer, this, this.colorEncoder, null, this.jvxlData);
    }

    protected void clearSg() {
        this.sg = null;
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (Logger.debugging) {
            Logger.debug("Isosurface setProperty: " + string + " = " + object);
        }
        if ("delete" == string) {
            this.setPropertySuper(string, object, bitSet);
            if (!this.explicitID) {
                this.nUnnamed = 0;
                this.nLCAO = 0;
            }
            return;
        }
        if ("remapcolor" == string) {
            if (this.thisMesh != null) {
                this.remapColors();
            }
            return;
        }
        if ("thisID" == string) {
            this.setPropertySuper("thisID", object, null);
            return;
        }
        if ("map" == string) {
            this.setProperty("squareData", Boolean.FALSE, null);
            return;
        }
        if ("color" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.vertexColixes = null;
                this.thisMesh.isColorSolid = true;
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.isomeshes[n].vertexColixes = null;
                    this.isomeshes[n].isColorSolid = true;
                }
            }
            this.setPropertySuper(string, object, bitSet);
            return;
        }
        if ("fixed" == string) {
            this.isFixed = (Boolean)object;
            this.setModelIndex();
            return;
        }
        if ("modelIndex" == string) {
            if (!this.iHaveModelIndex) {
                this.modelIndex = (Integer)object;
                this.sg.setModelIndex(this.modelIndex);
                this.isFixed = this.modelIndex < 0;
            }
            this.isFixed = this.modelIndex < 0;
            return;
        }
        if ("lcaoCartoon" == string) {
            Vector3f[] vector3fArray = (Vector3f[])object;
            if (!this.explicitID) {
                this.setPropertySuper("thisID", null, null);
            }
            if (this.sg.setParameter("lcaoCartoonCenter", vector3fArray[2])) {
                return;
            }
            this.drawLcaoCartoon(vector3fArray[0], vector3fArray[1], vector3fArray[3]);
            return;
        }
        if ("title" == string) {
            if (object instanceof String && "-".equals((String)object)) {
                object = null;
            }
            this.setPropertySuper(string, object, bitSet);
            this.sg.setParameter("title", this.title, bitSet);
            return;
        }
        if ("select" == string && this.iHaveBitSets) {
            return;
        }
        if ("ignore" == string && this.iHaveBitSets) {
            return;
        }
        if ("atomIndex" == string) {
            this.atomIndex = (Integer)object;
        }
        if ("pocket" == string) {
            Boolean bl = (Boolean)object;
            int n = this.lighting = bl != false ? 2 : 0;
        }
        if ("colorRGB" == string) {
            int n = (Integer)object;
            this.defaultColix = Graphics3D.getColix(n);
        }
        if ("molecularOrbital" == string) {
            this.moNumber = (Integer)object;
        }
        if (string == "functionXY" && this.sg.isStateDataRead()) {
            this.setScriptInfo();
        }
        if ("center" == string) {
            this.center.set((Point3f)object);
        }
        if ("phase" == string) {
            this.isPhaseColored = true;
        }
        if ("finalize" == string) {
            this.setScriptInfo();
            this.setJvxlInfo();
            this.clearSg();
            return;
        }
        if ("init" == string) {
            this.jvxlData = new JvxlData();
            this.sg = new SurfaceGenerator(this.viewer, this, this.colorEncoder, null, this.jvxlData);
        }
        if (this.sg != null && this.sg.setParameter(string, object, bitSet)) {
            return;
        }
        if ("init" == string) {
            this.setPropertySuper("thisID", "+PREVIOUS_MESH+", null);
            this.iHaveBitSets = this.getScriptBitSets((String)object, null);
            if (!this.iHaveBitSets) {
                this.sg.setParameter("select", bitSet);
            }
            this.initializeIsosurface();
            this.sg.setModelIndex(this.modelIndex);
            return;
        }
        if ("clear" == string) {
            this.discardTempData(true);
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            BitSet bitSet2 = new BitSet();
            bitSet2.set(n);
            int n2 = ((int[])((Object[])object)[2])[1];
            int n3 = ((int[])((Object[])object)[2])[2];
            int n4 = this.meshCount;
            while (--n4 >= 0) {
                Mesh mesh = this.meshes[n4];
                if (mesh == null) continue;
                if (mesh.modelIndex == n) {
                    --this.meshCount;
                    if (mesh == this.currentMesh) {
                        this.thisMesh = null;
                        this.currentMesh = null;
                    }
                    this.isomeshes = (IsosurfaceMesh[])ArrayUtil.deleteElements(this.meshes, n4, 1);
                    this.meshes = this.isomeshes;
                    continue;
                }
                if (mesh.modelIndex <= n) continue;
                --mesh.modelIndex;
                if (mesh.atomIndex >= n2) {
                    mesh.atomIndex -= n3;
                }
                if (mesh.bitsets == null) continue;
                BitSetUtil.deleteBits(mesh.bitsets[0], bitSet);
                BitSetUtil.deleteBits(mesh.bitsets[1], bitSet);
                BitSetUtil.deleteBits(mesh.bitsets[2], bitSet2);
            }
            return;
        }
        this.setPropertySuper(string, object, bitSet);
    }

    private void setPropertySuper(String string, Object object, BitSet bitSet) {
        this.currentMesh = this.thisMesh;
        super.setProperty(string, object, bitSet);
        this.thisMesh = (IsosurfaceMesh)this.currentMesh;
        this.jvxlData = this.thisMesh == null ? null : this.thisMesh.jvxlData;
    }

    public Object getProperty(String string, int n) {
        if (string == "dataRange") {
            float[] fArray;
            if (this.thisMesh == null) {
                fArray = null;
            } else {
                float[] fArray2 = new float[4];
                fArray2[0] = this.jvxlData.mappedDataMin;
                fArray2[1] = this.jvxlData.mappedDataMax;
                fArray2[2] = this.jvxlData.valueMappedToRed;
                fArray = fArray2;
                fArray2[3] = this.jvxlData.valueMappedToBlue;
            }
            return fArray;
        }
        if (string == "moNumber") {
            return new Integer(this.moNumber);
        }
        Object object = super.getProperty(string, n);
        if (object != null) {
            return object;
        }
        if (this.thisMesh == null) {
            return "no current isosurface";
        }
        if (string == "plane") {
            return this.jvxlData.jvxlPlane;
        }
        if (string == "jvxlFileData") {
            return JvxlReader.jvxlGetFile(this.jvxlData, this.title, "", true, n, this.thisMesh.getState(this.myType), this.thisMesh.scriptCommand == null ? "" : this.thisMesh.scriptCommand);
        }
        if (string == "jvxlSurfaceData") {
            return JvxlReader.jvxlGetFile(this.jvxlData, this.title, "", false, 1, this.thisMesh.getState(this.myType), this.thisMesh.scriptCommand == null ? "" : this.thisMesh.scriptCommand);
        }
        return null;
    }

    private boolean getScriptBitSets(String string, BitSet[] bitSetArray) {
        this.script = string;
        this.getModelIndex(string);
        if (string == null) {
            return false;
        }
        int n = string.indexOf("# ({");
        if (n < 0) {
            return false;
        }
        int n2 = string.indexOf("})", n);
        if (n2 < 0) {
            return false;
        }
        BitSet bitSet = Escape.unescapeBitset(string.substring(n + 3, n2 + 1));
        if (bitSetArray == null) {
            this.sg.setParameter("select", bitSet);
        } else {
            bitSetArray[0] = bitSet;
        }
        n = string.indexOf("({", n2);
        if (n < 0) {
            return true;
        }
        n2 = string.indexOf("})", n);
        if (n2 < 0) {
            return false;
        }
        bitSet = Escape.unescapeBitset(string.substring(n + 1, n2 + 1));
        if (bitSetArray == null) {
            this.sg.setParameter("ignore", bitSet);
        } else {
            bitSetArray[1] = bitSet;
        }
        n = string.indexOf("/({", n2);
        if (n == n2 + 2) {
            n2 = string.indexOf("})", n);
            if (n2 < 0) {
                return false;
            }
            bitSet = Escape.unescapeBitset(string.substring(n + 3, n2 + 1));
            if (bitSetArray == null) {
                this.viewer.setTrajectory(bitSet);
            } else {
                bitSetArray[2] = bitSet;
            }
        }
        return true;
    }

    private void initializeIsosurface() {
        this.lighting = 0;
        if (!this.iHaveModelIndex) {
            this.modelIndex = this.viewer.getCurrentModelIndex();
        }
        boolean bl = this.isFixed = this.modelIndex < 0;
        if (this.modelIndex < 0) {
            this.modelIndex = 0;
        }
        this.title = null;
        this.atomIndex = -1;
        this.colix = (short)5;
        this.defaultColix = 0;
        this.isPhaseColored = false;
        this.center = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.linkedMesh = null;
        this.initState();
    }

    private void initState() {
        this.associateNormals = true;
        this.sg.initState();
    }

    private void discardTempData(boolean bl) {
        if (!bl) {
            return;
        }
        this.title = null;
        if (this.thisMesh == null) {
            return;
        }
        this.thisMesh.surfaceSet = null;
    }

    private short getDefaultColix() {
        int n;
        if (this.defaultColix != 0) {
            return this.defaultColix;
        }
        if (!this.sg.isCubeData()) {
            return this.colix;
        }
        if (this.sg.getCutoff() >= 0.0f) {
            this.indexColorPositive %= JmolConstants.argbsIsosurfacePositive.length;
            n = JmolConstants.argbsIsosurfacePositive[this.indexColorPositive++];
        } else {
            this.indexColorNegative %= JmolConstants.argbsIsosurfaceNegative.length;
            n = JmolConstants.argbsIsosurfaceNegative[this.indexColorNegative++];
        }
        return Graphics3D.getColix(n);
    }

    private void drawLcaoCartoon(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        Object object;
        Object object2;
        boolean bl;
        String string = this.sg.setLcao();
        float f = vector3f3.x + vector3f3.y + vector3f3.z;
        this.defaultColix = Graphics3D.getColix(this.sg.getColor(1));
        int n = this.sg.getColor(-1);
        Vector3f vector3f4 = new Vector3f();
        boolean bl2 = bl = string.length() > 0 && string.charAt(0) == '-';
        if (bl) {
            string = string.substring(1);
        }
        int n2 = bl ? -1 : 1;
        vector3f4.cross(vector3f, vector3f2);
        if (f != 0.0f) {
            object2 = new AxisAngle4f();
            if (vector3f3.x != 0.0f) {
                ((AxisAngle4f)object2).set(vector3f2, f);
            } else if (vector3f3.y != 0.0f) {
                ((AxisAngle4f)object2).set(vector3f4, f);
            } else {
                ((AxisAngle4f)object2).set(vector3f, f);
            }
            object = new Matrix3f();
            ((Matrix3f)object).set((AxisAngle4f)object2);
            ((Matrix3f)object).transform(vector3f2);
            ((Matrix3f)object).transform(vector3f4);
            ((Matrix3f)object).transform(vector3f);
        }
        if (this.thisMesh == null && this.nLCAO == 0) {
            this.nLCAO = this.meshCount;
        }
        Object object3 = object2 = this.thisMesh == null ? "lcao" + ++this.nLCAO + "_" + string : this.thisMesh.thisID;
        if (this.thisMesh == null) {
            this.allocMesh((String)object2);
        }
        if (string.equals("px")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(vector3f2, n2);
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(vector3f2, -n2);
            this.thisMesh.colix = Graphics3D.getColix(n);
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("py")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(vector3f4, n2);
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(vector3f4, -n2);
            this.thisMesh.colix = Graphics3D.getColix(n);
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("pz")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(vector3f, n2);
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(vector3f, -n2);
            this.thisMesh.colix = Graphics3D.getColix(n);
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("pxa")) {
            this.createLcaoLobe(vector3f2, n2);
            return;
        }
        if (string.equals("pxb")) {
            this.createLcaoLobe(vector3f2, -n2);
            return;
        }
        if (string.equals("pya")) {
            this.createLcaoLobe(vector3f4, n2);
            return;
        }
        if (string.equals("pyb")) {
            this.createLcaoLobe(vector3f4, -n2);
            return;
        }
        if (string.equals("pza")) {
            this.createLcaoLobe(vector3f, n2);
            return;
        }
        if (string.equals("pzb")) {
            this.createLcaoLobe(vector3f, -n2);
            return;
        }
        if (string.indexOf("sp") == 0 || string.indexOf("lp") == 0) {
            this.createLcaoLobe(vector3f, n2);
            return;
        }
        this.createLcaoLobe(null, 1.0f);
    }

    private void createLcaoLobe(Vector3f vector3f, float f) {
        this.initState();
        if (Logger.debugging) {
            Logger.debug("creating isosurface ID " + this.thisMesh.thisID);
        }
        this.thisMesh.colix = this.defaultColix;
        if (vector3f == null) {
            this.setProperty("sphere", new Float(f / 2.0f), null);
        } else {
            this.lcaoDir.x = vector3f.x * f;
            this.lcaoDir.y = vector3f.y * f;
            this.lcaoDir.z = vector3f.z * f;
            this.lcaoDir.w = 0.7f;
            this.setProperty("lobe", this.lcaoDir, null);
        }
        this.setScriptInfo();
    }

    public void invalidateTriangles() {
        this.thisMesh.invalidateTriangles();
    }

    public void fillMeshData(MeshData meshData, int n) {
        if (meshData == null) {
            if (this.thisMesh == null) {
                this.allocMesh(null);
            }
            this.thisMesh.clear("isosurface", this.sg.getIAddGridPoints(), this.thisMesh.showTriangles);
            this.thisMesh.colix = this.getDefaultColix();
            if (this.isPhaseColored || this.thisMesh.jvxlData.isBicolorMap) {
                this.thisMesh.isColorSolid = false;
            }
            return;
        }
        switch (n) {
            case 1: {
                meshData.vertices = this.thisMesh.vertices;
                meshData.vertexValues = this.thisMesh.vertexValues;
                meshData.vertexCount = this.thisMesh.vertexCount;
                meshData.vertexIncrement = this.thisMesh.vertexIncrement;
                meshData.polygonCount = this.thisMesh.polygonCount;
                meshData.polygonIndexes = this.thisMesh.polygonIndexes;
                return;
            }
            case 2: {
                if (this.thisMesh.vertexColixes == null || this.thisMesh.vertexCount > this.thisMesh.vertexColixes.length) {
                    this.thisMesh.vertexColixes = new short[this.thisMesh.vertexCount];
                }
                meshData.vertexColixes = this.thisMesh.vertexColixes;
                return;
            }
            case 3: {
                this.thisMesh.surfaceSet = meshData.surfaceSet;
                this.thisMesh.vertexSets = meshData.vertexSets;
                this.thisMesh.nSets = meshData.nSets;
                return;
            }
        }
    }

    public void notifySurfaceGenerationCompleted() {
        this.setModelIndex();
        if (this.sg == null) {
            System.out.println("isosurface -- OHOH");
        }
        this.thisMesh.insideOut = this.sg.isInsideOut();
        this.thisMesh.initialize(this.sg.getPlane() != null ? 2 : this.lighting);
    }

    public void notifySurfaceMappingCompleted() {
        this.setModelIndex();
        String string = this.colorEncoder.getColorSchemeName();
        this.viewer.setPropertyColorScheme(string, false);
        this.viewer.setCurrentColorRange(this.jvxlData.valueMappedToRed, this.jvxlData.valueMappedToBlue);
        this.thisMesh.isColorSolid = false;
        this.thisMesh.colorCommand = "color $" + this.thisMesh.thisID + " " + this.getUserColorScheme(string) + " range " + (this.jvxlData.isColorReversed ? this.jvxlData.valueMappedToBlue + " " + this.jvxlData.valueMappedToRed : this.jvxlData.valueMappedToRed + " " + this.jvxlData.valueMappedToBlue);
    }

    public Point3f[] calculateGeodesicSurface(BitSet bitSet, float f) {
        return this.viewer.calculateSurface(bitSet, f);
    }

    public int getSurfacePointIndex(float f, boolean bl, int n, int n2, int n3, Point3i point3i, int n4, int n5, float f2, float f3, Point3f point3f, Vector3f vector3f, boolean bl2) {
        return 0;
    }

    public int addVertexCopy(Point3f point3f, float f, int n) {
        return this.thisMesh.addVertexCopy(point3f, f, n, this.associateNormals);
    }

    public void addTriangleCheck(int n, int n2, int n3, int n4, boolean bl) {
        if (bl && !MeshData.checkCutoff(n, n2, n3, this.thisMesh.vertexValues)) {
            return;
        }
        this.thisMesh.addTriangleCheck(n, n2, n3, n4);
    }

    private void setModelIndex() {
        this.setModelIndex(this.atomIndex, this.modelIndex);
        this.thisMesh.ptCenter.set(this.center);
    }

    protected void setScriptInfo() {
        this.thisMesh.title = this.sg.getTitle();
        String string = this.sg.getScript();
        this.thisMesh.bitsets = null;
        if (string != null) {
            if (string.charAt(0) == ' ') {
                string = this.myType + " ID " + this.thisMesh.thisID + string;
            } else if (this.sg.getIUseBitSets()) {
                this.thisMesh.bitsets = new BitSet[3];
                this.thisMesh.bitsets[0] = this.sg.getBsSelected();
                this.thisMesh.bitsets[1] = this.sg.getBsIgnore();
                this.thisMesh.bitsets[2] = this.viewer.getBitSetTrajectories();
            }
        }
        this.thisMesh.scriptCommand = string;
        Vector vector = (Vector)this.sg.getProperty("functionXYinfo", 0);
        if (this.thisMesh.data1 == null) {
            this.thisMesh.data1 = vector;
        } else {
            this.thisMesh.data2 = vector;
        }
    }

    private void setJvxlInfo() {
        if (this.sg.getJvxlData() != this.jvxlData) {
            this.jvxlData = this.thisMesh.jvxlData = this.sg.getJvxlData();
        }
        this.jvxlData.jvxlDefinitionLine = JvxlReader.jvxlGetDefinitionLine(this.jvxlData, false);
        this.jvxlData.jvxlInfoLine = JvxlReader.jvxlGetDefinitionLine(this.jvxlData, true);
    }

    public Vector getShapeDetail() {
        Vector vector = new Vector();
        for (int i = 0; i < this.meshCount; ++i) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            IsosurfaceMesh isosurfaceMesh = this.isomeshes[i];
            if (isosurfaceMesh == null) continue;
            hashtable.put("ID", isosurfaceMesh.thisID == null ? "<noid>" : isosurfaceMesh.thisID);
            hashtable.put("vertexCount", new Integer(isosurfaceMesh.vertexCount));
            if (isosurfaceMesh.ptCenter.x != Float.MAX_VALUE) {
                hashtable.put("center", isosurfaceMesh.ptCenter);
            }
            if (isosurfaceMesh.jvxlData.jvxlDefinitionLine != null) {
                hashtable.put("jvxlDefinitionLine", isosurfaceMesh.jvxlData.jvxlDefinitionLine);
            }
            hashtable.put("modelIndex", new Integer(isosurfaceMesh.modelIndex));
            if (isosurfaceMesh.title != null) {
                hashtable.put("title", isosurfaceMesh.title);
            }
            vector.addElement(hashtable);
        }
        return vector;
    }

    protected void remapColors() {
        JvxlData jvxlData = this.thisMesh.jvxlData;
        float[] fArray = this.thisMesh.vertexValues;
        short[] sArray = this.thisMesh.vertexColixes;
        if (fArray == null || jvxlData.isBicolorMap || jvxlData.vertexCount == 0) {
            return;
        }
        if (sArray == null) {
            sArray = this.thisMesh.vertexColixes = new short[this.thisMesh.vertexCount];
        }
        int n = this.thisMesh.vertexCount;
        while (--n >= 0) {
            sArray[n] = this.viewer.getColixForPropertyValue(fArray[n]);
        }
        float[] fArray2 = this.viewer.getCurrentColorRange();
        jvxlData.valueMappedToRed = Math.min(fArray2[0], fArray2[1]);
        jvxlData.valueMappedToBlue = Math.max(fArray2[0], fArray2[1]);
        jvxlData.isJvxlPrecisionColor = true;
        JvxlReader.jvxlCreateColorData(jvxlData, fArray);
        String string = this.viewer.getPropertyColorScheme();
        this.thisMesh.colorCommand = "color $" + this.thisMesh.thisID + " " + this.getUserColorScheme(string) + " range " + fArray2[0] + " " + fArray2[1];
        this.thisMesh.isColorSolid = false;
    }

    private String getUserColorScheme(String string) {
        String string2 = this.viewer.getColorSchemeList(string, false);
        return "\"" + (string2.length() == 0 ? string : string2) + "\"";
    }
}

