/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Model;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.shape.Shape;
import org.jmol.shapebio.BioShape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.viewer.JmolConstants;

public abstract class BioShapeCollection
extends Shape {
    Atom[] atoms;
    short madOn = (short)-2;
    short madHelixSheet = (short)3000;
    short madTurnRandom = (short)800;
    short madDnaRna = (short)5000;
    boolean isActive = false;
    BioShape[] bioShapes;

    public final void initModelSet() {
        this.isBioShape = true;
        this.atoms = this.modelSet.atoms;
        this.initialize();
    }

    public void setSize(int n, BitSet bitSet) {
        short s = (short)n;
        this.initialize();
        int n2 = this.bioShapes.length;
        while (--n2 >= 0) {
            BioShape bioShape = this.bioShapes[n2];
            if (bioShape.monomerCount <= 0) continue;
            bioShape.setMad(s, bitSet);
        }
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (string == "deleteModelAtoms") {
            this.atoms = (Atom[])((Object[])object)[1];
            int n = ((int[])((Object[])object)[2])[0];
            int n2 = this.bioShapes.length;
            while (--n2 >= 0) {
                BioShape bioShape = this.bioShapes[n2];
                if (bioShape.modelIndex > n) {
                    --bioShape.modelIndex;
                    bioShape.leadAtomIndices = bioShape.bioPolymer.getLeadAtomIndices();
                    continue;
                }
                if (bioShape.modelIndex != n) continue;
                this.bioShapes = (BioShape[])ArrayUtil.deleteElements(this.bioShapes, n2, 1);
            }
            return;
        }
        this.initialize();
        if ("color" == string) {
            byte by = JmolConstants.pidOf(object);
            short s = Graphics3D.getColix(object);
            int n = this.bioShapes.length;
            while (--n >= 0) {
                BioShape bioShape = this.bioShapes[n];
                if (bioShape.monomerCount <= 0) continue;
                bioShape.setColix(s, by, bitSet);
            }
            return;
        }
        if ("translucency" == string) {
            boolean bl = "translucent".equals(object);
            int n = this.bioShapes.length;
            while (--n >= 0) {
                BioShape bioShape = this.bioShapes[n];
                if (bioShape.monomerCount <= 0) continue;
                bioShape.setTranslucent(bl, bitSet, this.translucentLevel);
            }
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    public String getShapeState() {
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        int n = this.bioShapes.length;
        while (--n >= 0) {
            BioShape bioShape = this.bioShapes[n];
            if (bioShape.monomerCount <= 0) continue;
            bioShape.setShapeState(hashtable, hashtable2);
        }
        return "\n" + Shape.getShapeCommands(hashtable, hashtable2, this.modelSet.getAtomCount(), this.shapeID == 7 ? "Backbone" : "select");
    }

    void initialize() {
        int n = this.modelSet.getModelCount();
        Model[] modelArray = this.modelSet.getModels();
        int n2 = this.modelSet.getBioPolymerCount();
        BioShape[] bioShapeArray = new BioShape[n2--];
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = this.modelSet.getBioPolymerCountInModel(n3);
            while (--n4 >= 0) {
                bioShapeArray[n2] = this.bioShapes == null || this.bioShapes.length <= n2 || this.bioShapes[n2] == null ? new BioShape(this, n3, (BioPolymer)modelArray[n3].getBioPolymer(n4)) : this.bioShapes[n2];
                --n2;
            }
        }
        this.bioShapes = bioShapeArray;
    }

    public void findNearestAtomIndex(int n, int n2, Atom[] atomArray) {
        int n3 = this.bioShapes.length;
        while (--n3 >= 0) {
            BioShape bioShape = this.bioShapes[n3];
            bioShape.bioPolymer.findNearestAtomIndex(n, n2, atomArray, this.bioShapes[n3].mads, this.myVisibilityFlag);
        }
    }

    public void setVisibilityFlags(BitSet bitSet) {
        if (this.bioShapes == null) {
            return;
        }
        bitSet = BitSetUtil.copy(bitSet);
        int n = this.modelSet.getModelCount();
        while (--n >= 0) {
            if (!bitSet.get(n) || !this.modelSet.isTrajectory(n)) continue;
            bitSet.set(this.modelSet.getTrajectoryIndex(n));
        }
        n = this.bioShapes.length;
        while (--n >= 0) {
            BioShape bioShape = this.bioShapes[n];
            bioShape.modelVisibilityFlags = bitSet.get(bioShape.modelIndex) ? this.myVisibilityFlag : 0;
        }
    }

    public void setModelClickability() {
        if (this.bioShapes == null) {
            return;
        }
        int n = this.bioShapes.length;
        while (--n >= 0) {
            this.bioShapes[n].setModelClickability();
        }
    }

    int getMpsShapeCount() {
        return this.bioShapes.length;
    }

    BioShape getBioShape(int n) {
        return this.bioShapes[n];
    }
}

