/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Mesh;
import org.jmol.shape.Shape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;

public abstract class MeshCollection
extends Shape {
    public int meshCount;
    public Mesh[] meshes = new Mesh[4];
    public Mesh currentMesh;
    public int modelCount;
    public boolean isFixed;
    public String script;
    public int nUnnamed;
    public short colix;
    public String myType;
    public boolean explicitID;
    protected String previousMeshID;
    protected Mesh linkedMesh;
    protected boolean iHaveModelIndex;
    protected int modelIndex;
    public String[] title;
    protected boolean allowMesh = true;

    private Mesh setMesh(String string) {
        this.linkedMesh = null;
        if (string == null || string.indexOf("*") >= 0) {
            this.currentMesh = null;
            return null;
        }
        int n = this.getIndexFromName(string);
        if (n >= 0) {
            this.currentMesh = this.meshes[n];
            if (string.equals("+PREVIOUS_MESH+")) {
                this.linkedMesh = this.currentMesh.linkedMesh;
            }
        } else {
            this.allocMesh(string);
        }
        if (this.currentMesh.thisID == null) {
            this.currentMesh.thisID = this.myType + ++this.nUnnamed;
        }
        this.previousMeshID = this.currentMesh.thisID;
        return this.currentMesh;
    }

    public void allocMesh(String string) {
        this.meshes = (Mesh[])ArrayUtil.ensureLength(this.meshes, this.meshCount + 1);
        Mesh mesh = new Mesh(string, this.g3d, this.colix);
        this.meshes[this.meshCount++] = mesh;
        this.currentMesh = mesh;
        this.previousMeshID = null;
    }

    public void initShape() {
        super.initShape();
        this.colix = (short)5;
        this.modelCount = this.viewer.getModelCount();
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (Logger.debugging) {
            Logger.debug("MeshCollection.setProperty(" + string + "," + object + ")");
        }
        if ("init" == string) {
            this.title = null;
            return;
        }
        if ("link" == string) {
            if (this.meshCount >= 2 && this.currentMesh != null) {
                this.currentMesh.linkedMesh = this.meshes[this.meshCount - 2];
            }
            return;
        }
        if ("commandOption" == string) {
            String string2 = "# " + (String)object;
            if (this.script.indexOf(string2) < 0) {
                this.script = this.script + " " + string2;
            }
            return;
        }
        if ("thisID" == string) {
            String string3 = (String)object;
            this.setMesh(string3);
            boolean bl = this.explicitID = string3 != null && !string3.equals("+PREVIOUS_MESH+");
            if (this.explicitID) {
                this.previousMeshID = string3;
            }
            return;
        }
        if ("title" == string) {
            if (object == null) {
                this.title = null;
            } else if (object instanceof String[]) {
                this.title = (String[])object;
            } else {
                int n = 1;
                String string4 = (String)object;
                int n2 = string4.length();
                while (--n2 >= 0) {
                    if (string4.charAt(n2) != '|') continue;
                    ++n;
                }
                this.title = new String[n];
                n = 0;
                n2 = -1;
                for (int i = 0; i < string4.length(); ++i) {
                    if (string4.charAt(i) != '|') continue;
                    this.title[n++] = string4.substring(n2 + 1, i);
                    n2 = i;
                }
                this.title[n] = string4.substring(n2 + 1);
            }
            return;
        }
        if ("delete" == string) {
            this.deleteMesh();
            return;
        }
        if ("reset" == string) {
            String string5 = (String)object;
            if (this.setMesh(string5) == null) {
                return;
            }
            this.deleteMesh();
            this.setMesh(string5);
            return;
        }
        boolean bl = "on" == string;
        if (bl || "off" == string) {
            if (this.currentMesh != null) {
                this.currentMesh.visible = bl;
            } else {
                String string6;
                int n = 0;
                String string7 = string6 = this.explicitID && this.previousMeshID != null && (n = this.previousMeshID.indexOf("*")) >= 0 ? this.previousMeshID.substring(0, n).toLowerCase() : null;
                if (string6 == null || string6.length() == 0) {
                    n = this.meshCount;
                    while (--n >= 0) {
                        this.meshes[n].visible = bl;
                    }
                } else {
                    for (n = 0; n < this.meshCount; ++n) {
                        if (this.meshes[n].thisID.toLowerCase().indexOf(string6) != 0) continue;
                        this.meshes[n].visible = bl;
                    }
                }
            }
            return;
        }
        if ("color" == string) {
            if (object == null) {
                return;
            }
            this.colix = Graphics3D.getColix(object);
            if (this.currentMesh != null) {
                this.currentMesh.colix = this.colix;
                if (this.linkedMesh != null) {
                    this.linkedMesh.colix = this.colix;
                }
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n].colix = this.colix;
                }
            }
            return;
        }
        if ("translucency" == string) {
            boolean bl2 = ((String)object).equals("translucent");
            if (this.currentMesh != null) {
                this.currentMesh.setTranslucent(bl2, this.translucentLevel);
                if (this.linkedMesh != null) {
                    this.linkedMesh.setTranslucent(bl2, this.translucentLevel);
                }
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n].setTranslucent(bl2, this.translucentLevel);
                }
            }
            return;
        }
        boolean bl3 = "nodots" == string;
        if (bl3 || "dots" == string) {
            boolean bl4;
            boolean bl5 = bl4 = !bl3 && object == Boolean.TRUE;
            if (this.currentMesh != null) {
                this.currentMesh.showPoints = bl4;
                if (this.linkedMesh != null) {
                    this.linkedMesh.showPoints = bl4;
                }
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n].showPoints = bl4;
                }
            }
            return;
        }
        bl3 = "nomesh" == string;
        if (bl3 || "mesh" == string) {
            boolean bl6;
            boolean bl7 = bl6 = !bl3 && object == Boolean.TRUE;
            if (this.currentMesh != null) {
                this.currentMesh.drawTriangles = bl6;
                if (this.linkedMesh != null) {
                    this.linkedMesh.drawTriangles = bl6;
                }
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n].drawTriangles = bl6;
                }
            }
            return;
        }
        bl3 = "nofill" == string;
        if (bl3 || "fill" == string) {
            boolean bl8;
            boolean bl9 = bl8 = !bl3 && object == Boolean.TRUE;
            if (this.currentMesh != null) {
                this.currentMesh.fillTriangles = bl8;
                if (this.linkedMesh != null) {
                    this.linkedMesh.fillTriangles = bl8;
                }
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n].fillTriangles = bl8;
                }
            }
            return;
        }
        if ("triangles" == string) {
            boolean bl10;
            boolean bl11 = bl10 = object == Boolean.TRUE;
            if (this.currentMesh != null) {
                this.currentMesh.showTriangles = bl10;
                if (this.linkedMesh != null) {
                    this.linkedMesh.showTriangles = bl10;
                }
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n].showTriangles = bl10;
                }
            }
            return;
        }
        if ("frontOnly" == string) {
            boolean bl12;
            boolean bl13 = bl12 = object == Boolean.TRUE;
            if (this.currentMesh != null) {
                this.currentMesh.frontOnly = bl12;
                if (this.linkedMesh != null) {
                    this.linkedMesh.frontOnly = bl12;
                }
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n].frontOnly = bl12;
                }
            }
            return;
        }
        bl3 = "lighting" == string;
        if (bl3 || Parser.isOneOf(string, "backlit;frontlit;fulllit")) {
            int n;
            int n3 = bl3 ? (Integer)object : ("frontlit" == string ? 0 : (n = "backlit" == string ? 1 : 2));
            if (this.currentMesh != null) {
                this.currentMesh.setLighting(n);
                if (this.linkedMesh != null) {
                    this.linkedMesh.setLighting(n);
                }
            } else {
                int n4 = this.meshCount;
                while (--n4 >= 0) {
                    this.meshes[n4].setLighting(n);
                }
            }
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    public Object getProperty(String string, int n) {
        if (string == "count") {
            int n2 = 0;
            for (int i = 0; i < this.meshCount; ++i) {
                if (this.meshes[i] == null || this.meshes[i].vertexCount <= 0) continue;
                ++n2;
            }
            return new Integer(n2);
        }
        if (string == "ID") {
            return this.currentMesh == null ? (String)null : this.currentMesh.thisID;
        }
        if (string == "list") {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            for (int i = 0; i < this.meshCount; ++i) {
                if (this.meshes[i] == null || this.meshes[i].vertexCount == 0) continue;
                Mesh mesh = this.meshes[i];
                stringBuffer.append(++n3).append(" id:" + mesh.thisID).append("; model:" + this.viewer.getModelNumberDotted(mesh.modelIndex)).append("; vertices:" + mesh.vertexCount).append("; polygons:" + mesh.polygonCount).append("; visible:" + mesh.visible);
                if (mesh.title != null) {
                    String string2 = "";
                    for (int j = 0; j < mesh.title.length; ++j) {
                        string2 = string2 + (j == 0 ? "; title:" : " | ") + mesh.title[j];
                    }
                    if (string2.length() > 100) {
                        string2 = string2.substring(0, 100) + "...";
                    }
                    stringBuffer.append(string2);
                }
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private void deleteMesh() {
        int n = 0;
        if (this.explicitID && this.currentMesh != null) {
            n = this.meshCount;
            while (this.meshes[--n] != this.currentMesh) {
            }
            this.deleteMesh(n);
        } else {
            String string;
            String string2 = string = this.explicitID && this.previousMeshID != null && (n = this.previousMeshID.indexOf("*")) >= 0 ? this.previousMeshID.substring(0, n).toLowerCase() : null;
            if (string == null || string.length() == 0) {
                n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n] = null;
                }
                this.meshCount = 0;
                this.nUnnamed = 0;
            } else {
                n = this.meshCount;
                while (--n >= 0) {
                    if (this.meshes[n].thisID.toLowerCase().indexOf(string) != 0) continue;
                    this.deleteMesh(n);
                }
            }
        }
        this.currentMesh = null;
    }

    public void deleteMesh(int n) {
        for (int i = n + 1; i < this.meshCount; ++i) {
            this.meshes[i - 1] = this.meshes[i];
        }
        this.meshes[--this.meshCount] = null;
    }

    public int getIndexFromName(String string) {
        if ("+PREVIOUS_MESH+".equals(string)) {
            return this.previousMeshID == null ? this.meshCount - 1 : this.getIndexFromName(this.previousMeshID);
        }
        int n = this.meshCount;
        while (--n >= 0) {
            if (this.meshes[n] == null || !string.equals(this.meshes[n].thisID)) continue;
            return n;
        }
        return -1;
    }

    public void setModelIndex(int n, int n2) {
        if (this.currentMesh == null) {
            return;
        }
        this.currentMesh.visible = true;
        this.currentMesh.atomIndex = n;
        this.currentMesh.modelIndex = this.currentMesh.atomIndex >= 0 ? this.viewer.getAtomModelIndex(n) : (this.isFixed ? -1 : (n2 >= 0 ? n2 : this.viewer.getCurrentModelIndex()));
        this.currentMesh.scriptCommand = this.script;
    }

    public String getShapeState() {
        StringBuffer stringBuffer = new StringBuffer("\n");
        for (int i = 0; i < this.meshCount; ++i) {
            String string;
            Mesh mesh = this.meshes[i];
            String string2 = mesh.scriptCommand;
            if (string2 == null) continue;
            int n = string2.indexOf(";#");
            if (n >= 0) {
                string2 = string2.substring(0, n + 1);
            }
            if (mesh.bitsets != null) {
                string2 = string2 + "# " + (mesh.bitsets[0] == null ? "({null})" : Escape.escape(mesh.bitsets[0])) + " " + (mesh.bitsets[1] == null ? "({null})" : Escape.escape(mesh.bitsets[1])) + (mesh.bitsets[2] == null ? "" : "/" + Escape.escape(mesh.bitsets[2]));
            }
            if (mesh.modelIndex >= 0) {
                string2 = string2 + "# MODEL({" + mesh.modelIndex + "})";
            }
            if (mesh.linkedMesh != null) {
                string2 = string2 + " LINK";
            }
            if (mesh.data1 != null) {
                string = ((String)mesh.data1.elementAt(0)).toLowerCase();
                if (string.indexOf("data2d_") != 0) {
                    string = "data2d_" + string;
                }
                string = TextFormat.simpleReplace(string, "_xyz", "_");
                string2 = Escape.encapsulateData(string, mesh.data1.elementAt(5)) + "  " + string2 + "# DATA=\"" + string + "\"";
            }
            if (mesh.data2 != null) {
                string = ((String)mesh.data2.elementAt(0)).toLowerCase();
                if (string.indexOf("data2d_") != 0) {
                    string = "data2d_" + string;
                }
                string = TextFormat.simpleReplace(string, "_xyz", "_");
                string2 = Escape.encapsulateData(string, mesh.data2.elementAt(5)) + "  " + string2 + "# DATA2=\"" + string + "\"";
            }
            if (mesh.modelIndex >= 0 && this.modelCount > 1) {
                Shape.appendCmd(stringBuffer, "frame " + this.viewer.getModelNumberDotted(mesh.modelIndex));
            }
            Shape.appendCmd(stringBuffer, string2);
            if (string2.charAt(0) == '#') continue;
            if (this.allowMesh) {
                Shape.appendCmd(stringBuffer, mesh.getState(this.myType));
            }
            if (mesh.isColorSolid) {
                Shape.appendCmd(stringBuffer, this.getColorCommand("$" + mesh.thisID, mesh.colix));
                continue;
            }
            if (mesh.colorCommand == null) continue;
            Shape.appendCmd(stringBuffer, mesh.colorCommand);
        }
        return stringBuffer.toString();
    }

    public void setVisibilityFlags(BitSet bitSet) {
        int n = this.meshCount;
        while (--n >= 0) {
            Mesh mesh = this.meshes[n];
            mesh.visibilityFlags = mesh.visible && mesh.isValid && (mesh.modelIndex < 0 || bitSet.get(mesh.modelIndex) && (mesh.atomIndex < 0 || !this.modelSet.isAtomHidden(mesh.atomIndex))) ? this.myVisibilityFlag : 0;
        }
    }

    protected void getModelIndex(String string) {
        int n;
        this.iHaveModelIndex = false;
        this.modelIndex = -1;
        if (string == null || (n = string.indexOf("MODEL({")) < 0) {
            return;
        }
        int n2 = string.indexOf("})", n);
        if (n2 < 0) {
            return;
        }
        BitSet bitSet = Escape.unescapeBitset(string.substring(n + 3, n2 + 1));
        this.modelIndex = bitSet == null ? -1 : BitSetUtil.firstSetBit(bitSet);
        this.iHaveModelIndex = this.modelIndex >= 0;
    }
}

