/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.api.MOCalculationInterface;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.util.Logger;

public class MOCalculation
extends QuantumCalculation
implements MOCalculationInterface {
    private static int MAX_GRID = 80;
    float[] CX = new float[MAX_GRID];
    float[] CY = new float[MAX_GRID];
    float[] CZ = new float[MAX_GRID];
    float[] DXY = new float[MAX_GRID];
    float[] DXZ = new float[MAX_GRID];
    float[] DYZ = new float[MAX_GRID];
    float[] EX = new float[MAX_GRID];
    float[] EY = new float[MAX_GRID];
    float[] EZ = new float[MAX_GRID];
    String calculationType;
    Vector shells;
    float[][] gaussians;
    int[][] slaterInfo;
    float[][] slaterData;
    float[] moCoefficients;
    int moCoeff;
    int gaussianPtr;
    int firstAtomOffset;
    private static final String[][] shellOrder = new String[][]{{"S"}, {"X", "Y", "Z"}, {"S", "X", "Y", "Z"}, {"XX", "YY", "ZZ", "XY", "XZ", "YZ"}, {"d0", "d1+", "d1-", "d2+", "d2-"}, {"XXX", "YYY", "ZZZ", "XYY", "XXY", "XXZ", "XZZ", "YZZ", "YYZ", "XYZ"}, {"f0", "f1+", "f1-", "f2+", "f2-", "f3+", "f3-"}};
    public static final int SHELL_S = 0;
    public static final int SHELL_P = 1;
    public static final int SHELL_SP = 2;
    public static final int SHELL_L = 2;
    public static final int SHELL_D_CARTESIAN = 3;
    public static final int SHELL_D_SPHERICAL = 4;
    public static final int SHELL_F_CARTESIAN = 5;
    public static final int SHELL_F_SPHERICAL = 6;
    private static final String[] quantumShellTags = new String[]{"S", "P", "SP", "L", "D", "5D", "F", "7F"};
    private static final int[] quantumShellIDs = new int[]{0, 1, 2, 2, 3, 4, 5, 6};
    private static final float ROOT3 = 1.7320508f;

    public static final int getQuantumShellTagID(String string) {
        int n = quantumShellTags.length;
        while (--n >= 0) {
            if (!string.equals(quantumShellTags[n])) continue;
            return quantumShellIDs[n];
        }
        return -1;
    }

    public static final int getQuantumShellTagIDSpherical(String string) {
        int n;
        return n + ((n = MOCalculation.getQuantumShellTagID(string)) < 3 ? 0 : n % 2);
    }

    public static final String getQuantumShellTag(int n) {
        int n2 = quantumShellTags.length;
        while (--n2 >= 0) {
            if (n != quantumShellIDs[n2]) continue;
            return quantumShellTags[n2];
        }
        return "" + n;
    }

    public static final String canonicalizeQuantumSubshellTag(String string) {
        char c = string.charAt(0);
        if (c == 'X' || c == 'Y' || c == 'Z') {
            char[] cArray = string.toCharArray();
            Arrays.sort(cArray);
            return new String(cArray);
        }
        return string;
    }

    public static final int getQuantumSubshellTagID(int n, String string) {
        int n2 = shellOrder[n].length;
        while (--n2 >= 0) {
            if (!shellOrder[n][n2].equals(string)) continue;
            return n2;
        }
        return -1;
    }

    public static final String getQuantumSubshellTag(int n, int n2) {
        return shellOrder[n][n2];
    }

    public void calculate(VolumeData volumeData, BitSet bitSet, String string, Point3f[] point3fArray, int n, Vector vector, float[][] fArray, Hashtable hashtable, int[][] nArray, float[][] fArray2, float[] fArray3) {
        this.calculationType = string;
        this.atomCoordAngstroms = point3fArray;
        this.firstAtomOffset = n;
        this.shells = vector;
        this.gaussians = fArray;
        this.slaterInfo = nArray;
        this.slaterData = fArray2;
        this.moCoefficients = fArray3;
        this.initialize(MAX_GRID);
        this.setVolume(volumeData, bitSet);
        this.atomIndex = n - 1;
        this.doDebug = Logger.debugging;
        if (nArray != null) {
            this.createSlaterCube();
        } else {
            this.createGaussianCube();
        }
    }

    private void createSlaterCube() {
        this.moCoeff = 0;
        int n = this.slaterInfo.length;
        for (int i = 0; i < n; ++i) {
            this.processSlater(i);
        }
    }

    private void createGaussianCube() {
        if (!this.checkCalculationType()) {
            return;
        }
        int n = this.shells.size();
        this.moCoeff = 0;
        for (int i = 0; i < n; ++i) {
            this.processShell(i);
            if (!this.doDebug) continue;
            Logger.debug("createGaussianCube shell=" + i + " moCoeff=" + this.moCoeff + "/" + this.moCoefficients.length);
        }
    }

    private boolean checkCalculationType() {
        if (this.calculationType == null) {
            Logger.warn("calculation type not identified -- continuing");
            return true;
        }
        if (this.calculationType.indexOf("+") >= 0 || this.calculationType.indexOf("*") >= 0) {
            Logger.warn("polarization/diffuse wavefunctions have not been tested fully: " + this.calculationType + " -- continuing");
        }
        if (this.calculationType.indexOf("?") >= 0) {
            Logger.warn("unknown calculation type may not render correctly -- continuing");
        } else {
            Logger.info("calculation type: " + this.calculationType + " OK.");
        }
        return true;
    }

    private void processShell(int n) {
        int n2 = this.atomIndex;
        int[] nArray = (int[])this.shells.get(n);
        this.atomIndex = nArray[0] + this.firstAtomOffset;
        int n3 = nArray[1];
        this.gaussianPtr = nArray[2];
        int n4 = nArray[3];
        if (this.doDebug) {
            Logger.debug("processShell: " + n + " type=" + MOCalculation.getQuantumShellTag(n3) + " nGaussians=" + n4 + " atom=" + this.atomIndex);
        }
        if (this.atomIndex != n2 && this.atomCoordBohr[this.atomIndex] != null) {
            float f = this.atomCoordBohr[this.atomIndex].x;
            float f2 = this.atomCoordBohr[this.atomIndex].y;
            float f3 = this.atomCoordBohr[this.atomIndex].z;
            int n5 = this.countsXYZ[0];
            while (--n5 >= 0) {
                this.X2[n5] = this.X[n5] = this.xyzBohr[n5][0] - f;
                int n6 = n5;
                this.X2[n6] = this.X2[n6] * this.X[n5];
            }
            n5 = this.countsXYZ[1];
            while (--n5 >= 0) {
                this.Y2[n5] = this.Y[n5] = this.xyzBohr[n5][1] - f2;
                int n7 = n5;
                this.Y2[n7] = this.Y2[n7] * this.Y[n5];
            }
            n5 = this.countsXYZ[2];
            while (--n5 >= 0) {
                this.Z2[n5] = this.Z[n5] = this.xyzBohr[n5][2] - f3;
                int n8 = n5;
                this.Z2[n8] = this.Z2[n8] * this.Z[n5];
            }
        }
        switch (n3) {
            case 0: {
                this.addDataS(n4);
                break;
            }
            case 1: {
                this.addDataP(n4);
                break;
            }
            case 2: {
                this.addDataSP(n4);
                break;
            }
            case 3: {
                this.addData6D(n4);
                break;
            }
            case 4: {
                this.addData5D(n4);
                break;
            }
            case 5: {
                this.addData10F(n4);
                break;
            }
            case 6: {
                this.addData7F(n4);
                break;
            }
            default: {
                Logger.warn(" Unsupported basis type for atomno=" + (this.atomIndex + 1) + " -- use \"set loglevel 5\" to debug.");
                return;
            }
        }
    }

    private void addDataS(int n) {
        if (!this.atomSet.get(this.atomIndex)) {
            ++this.moCoeff;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, "S ");
        }
        int n2 = this.moCoeff;
        this.setMinMax();
        for (int i = 0; i < n; ++i) {
            this.moCoeff = n2;
            float f = this.gaussians[this.gaussianPtr + i][0];
            float f2 = this.gaussians[this.gaussianPtr + i][1];
            float f3 = f2 * (float)Math.pow(f, 0.75) * 0.7127055f;
            f3 *= this.moCoefficients[this.moCoeff++];
            int n3 = this.xMax;
            while (--n3 >= this.xMin) {
                this.EX[n3] = f3 * (float)Math.exp(-this.X2[n3] * f);
            }
            n3 = this.yMax;
            while (--n3 >= this.yMin) {
                this.EY[n3] = (float)Math.exp(-this.Y2[n3] * f);
            }
            n3 = this.zMax;
            while (--n3 >= this.zMin) {
                this.EZ[n3] = (float)Math.exp(-this.Z2[n3] * f);
            }
            n3 = this.xMax;
            while (--n3 >= this.xMin) {
                int n4 = this.yMax;
                while (--n4 >= this.yMin) {
                    int n5 = this.zMax;
                    while (--n5 >= this.zMin) {
                        float[] fArray = this.voxelData[n3][n4];
                        int n6 = n5;
                        fArray[n6] = fArray[n6] + this.EX[n3] * this.EY[n4] * this.EZ[n5];
                    }
                }
            }
        }
    }

    private void addDataP(int n) {
        if (!this.atomSet.get(this.atomIndex)) {
            this.moCoeff += 3;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, "X Y Z ");
        }
        this.setMinMax();
        int n2 = this.moCoeff;
        for (int i = 0; i < n; ++i) {
            this.moCoeff = n2;
            float f = this.gaussians[this.gaussianPtr + i][0];
            float f2 = this.gaussians[this.gaussianPtr + i][1];
            float f3 = f2 * (float)Math.pow(f, 1.25) * 1.425411f;
            float f4 = f3 * this.moCoefficients[this.moCoeff++];
            float f5 = f3 * this.moCoefficients[this.moCoeff++];
            float f6 = f3 * this.moCoefficients[this.moCoeff++];
            this.calcSP(f, 0.0f, f4, f5, f6);
        }
    }

    private void addDataSP(int n) {
        if (!this.atomSet.get(this.atomIndex)) {
            this.moCoeff += 4;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, "S X Y Z ");
        }
        this.setMinMax();
        int n2 = this.moCoeff;
        for (int i = 0; i < n; ++i) {
            this.moCoeff = n2;
            float f = this.gaussians[this.gaussianPtr + i][0];
            float f2 = this.gaussians[this.gaussianPtr + i][1];
            float f3 = this.gaussians[this.gaussianPtr + i][2];
            float f4 = f2 * (float)Math.pow(f, 0.75) * 0.7127055f;
            float f5 = f3 * (float)Math.pow(f, 1.25) * 1.425411f;
            float f6 = f2 == 0.0f ? 0.0f : f4 * this.moCoefficients[this.moCoeff++];
            float f7 = f5 * this.moCoefficients[this.moCoeff++];
            float f8 = f5 * this.moCoefficients[this.moCoeff++];
            float f9 = f5 * this.moCoefficients[this.moCoeff++];
            this.calcSP(f, f6, f7, f8, f9);
        }
    }

    private void setCE(float f, float f2, float f3, float f4, float f5) {
        int n = this.xMax;
        while (--n >= this.xMin) {
            this.CX[n] = f2 + f3 * this.X[n];
            this.EX[n] = (float)Math.exp(-this.X2[n] * f);
        }
        n = this.yMax;
        while (--n >= this.yMin) {
            this.CY[n] = f4 * this.Y[n];
            this.EY[n] = (float)Math.exp(-this.Y2[n] * f);
        }
        n = this.zMax;
        while (--n >= this.zMin) {
            this.CZ[n] = f5 * this.Z[n];
            this.EZ[n] = (float)Math.exp(-this.Z2[n] * f);
        }
    }

    private void calcSP(float f, float f2, float f3, float f4, float f5) {
        this.setCE(f, f2, f3, f4, f5);
        int n = this.xMax;
        while (--n >= this.xMin) {
            int n2 = this.yMax;
            while (--n2 >= this.yMin) {
                int n3 = this.zMax;
                while (--n3 >= this.zMin) {
                    float[] fArray = this.voxelData[n][n2];
                    int n4 = n3;
                    fArray[n4] = fArray[n4] + (this.CX[n] + this.CY[n2] + this.CZ[n3]) * this.EX[n] * this.EY[n2] * this.EZ[n3];
                }
            }
        }
    }

    private void addData6D(int n) {
        if (!this.atomSet.get(this.atomIndex)) {
            this.moCoeff += 6;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, "XXYYZZXYXZYZ");
        }
        this.setMinMax();
        int n2 = this.moCoeff;
        for (int i = 0; i < n; ++i) {
            this.moCoeff = n2;
            float f = this.gaussians[this.gaussianPtr + i][0];
            float f2 = this.gaussians[this.gaussianPtr + i][1];
            float f3 = f2 * (float)Math.pow(f, 1.75) * 2.850822f;
            float f4 = f3 / 1.7320508f * this.moCoefficients[this.moCoeff++];
            float f5 = f3 / 1.7320508f * this.moCoefficients[this.moCoeff++];
            float f6 = f3 / 1.7320508f * this.moCoefficients[this.moCoeff++];
            float f7 = f3 * this.moCoefficients[this.moCoeff++];
            float f8 = f3 * this.moCoefficients[this.moCoeff++];
            float f9 = f3 * this.moCoefficients[this.moCoeff++];
            this.setCE(f, 0.0f, f4, f5, f6);
            int n3 = this.xMax;
            while (--n3 >= this.xMin) {
                this.DXY[n3] = f7 * this.X[n3];
                this.DXZ[n3] = f8 * this.X[n3];
            }
            n3 = this.yMax;
            while (--n3 >= this.yMin) {
                this.DYZ[n3] = f9 * this.Y[n3];
            }
            n3 = this.xMax;
            while (--n3 >= this.xMin) {
                float f10 = this.CX[n3] * this.X[n3];
                float f11 = this.DXY[n3];
                float f12 = this.DXZ[n3];
                int n4 = this.yMax;
                while (--n4 >= this.yMin) {
                    float f13 = f10 + (this.CY[n4] + f11) * this.Y[n4];
                    float f14 = f12 + this.DYZ[n4];
                    int n5 = this.zMax;
                    while (--n5 >= this.zMin) {
                        float[] fArray = this.voxelData[n3][n4];
                        int n6 = n5;
                        fArray[n6] = fArray[n6] + (f13 + (this.CZ[n5] + f14) * this.Z[n5]) * this.EX[n3] * this.EY[n4] * this.EZ[n5];
                    }
                }
            }
        }
    }

    private void addData10F(int n) {
        if (!this.atomSet.get(this.atomIndex)) {
            this.moCoeff += 10;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, 5);
        }
        this.setMinMax();
        float f = (float)Math.pow(1056.818280307081, 0.25);
        float f2 = f / (float)Math.sqrt(15.0);
        float f3 = f / (float)Math.sqrt(3.0);
        int n2 = n;
        while (--n2 >= 0) {
            float f4 = this.gaussians[this.gaussianPtr + n2][0];
            float f5 = this.gaussians[this.gaussianPtr + n2][1];
            this.setCE(f4, 0.0f, 0.0f, 0.0f, 0.0f);
            float f6 = f5 * (float)Math.pow(f4, 2.25);
            float f7 = f6 * f2 * this.moCoefficients[this.moCoeff];
            float f8 = f6 * f2 * this.moCoefficients[this.moCoeff + 1];
            float f9 = f6 * f2 * this.moCoefficients[this.moCoeff + 2];
            float f10 = f6 * f3 * this.moCoefficients[this.moCoeff + 3];
            float f11 = f6 * f3 * this.moCoefficients[this.moCoeff + 4];
            float f12 = f6 * f3 * this.moCoefficients[this.moCoeff + 5];
            float f13 = f6 * f3 * this.moCoefficients[this.moCoeff + 6];
            float f14 = f6 * f3 * this.moCoefficients[this.moCoeff + 7];
            float f15 = f6 * f3 * this.moCoefficients[this.moCoeff + 8];
            float f16 = f6 * f * this.moCoefficients[this.moCoeff + 9];
            int n3 = this.xMax;
            while (--n3 >= this.xMin) {
                float f17 = this.X[n3];
                float f18 = f17 * f17;
                float f19 = this.EX[n3];
                float f20 = f7 * f18 * f17;
                int n4 = this.yMax;
                while (--n4 >= this.yMin) {
                    float f21 = this.Y[n4];
                    float f22 = f21 * f21;
                    float f23 = this.EY[n4];
                    float f24 = f8 * f22 * f21;
                    float f25 = f11 * f18 * f21;
                    float f26 = f10 * f17 * f22;
                    int n5 = this.zMax;
                    while (--n5 >= this.zMin) {
                        float f27 = this.Z[n5];
                        float f28 = f27 * f27;
                        float f29 = this.EZ[n5];
                        float f30 = f9 * f28 * f27;
                        float f31 = f12 * f18 * f27;
                        float f32 = f13 * f17 * f28;
                        float f33 = f15 * f22 * f27;
                        float f34 = f14 * f21 * f28;
                        float f35 = f16 * f17 * f21 * f27;
                        float[] fArray = this.voxelData[n3][n4];
                        int n6 = n5;
                        fArray[n6] = fArray[n6] + f19 * f23 * f29 * (f20 + f24 + f30 + f26 + f25 + f31 + f32 + f34 + f33 + f35);
                    }
                }
            }
        }
        this.moCoeff += 10;
    }

    private void addData5D(int n) {
        if (!this.atomSet.get(this.atomIndex)) {
            this.moCoeff += 5;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, 4);
        }
        this.setMinMax();
        float f = (float)Math.pow(66.05114251919257, 0.25);
        float f2 = f / (float)Math.sqrt(3.0);
        float f3 = (float)Math.sqrt(0.0);
        int n2 = n;
        while (--n2 >= 0) {
            float f4 = this.gaussians[this.gaussianPtr + n2][0];
            float f5 = this.gaussians[this.gaussianPtr + n2][1];
            float f6 = f5 * (float)Math.pow(f4, 1.75);
            float f7 = f6 * this.moCoefficients[this.moCoeff];
            float f8 = f6 * this.moCoefficients[this.moCoeff + 1];
            float f9 = f6 * this.moCoefficients[this.moCoeff + 2];
            float f10 = f6 * this.moCoefficients[this.moCoeff + 3];
            float f11 = f6 * this.moCoefficients[this.moCoeff + 4];
            this.setCE(f4, 0.0f, 0.0f, 0.0f, 0.0f);
            int n3 = this.xMax;
            while (--n3 >= this.xMin) {
                float f12 = this.X[n3];
                float f13 = this.EX[n3];
                float f14 = f2 * f12 * f12;
                int n4 = this.yMax;
                while (--n4 >= this.yMin) {
                    float f15 = this.Y[n4];
                    float f16 = this.EY[n4];
                    float f17 = f2 * f15 * f15;
                    float f18 = f * f12 * f15;
                    int n5 = this.zMax;
                    while (--n5 >= this.zMin) {
                        float f19 = this.Z[n5];
                        float f20 = this.EZ[n5];
                        float f21 = f2 * f19 * f19;
                        float f22 = f * f12 * f19;
                        float f23 = f * f15 * f19;
                        float[] fArray = this.voxelData[n3][n4];
                        int n6 = n5;
                        fArray[n6] = (float)((double)fArray[n6] + (double)(f13 * f16 * f20) * ((double)f7 * ((double)f21 - 0.5 * (double)(f14 + f17)) + (double)(f8 * f22) + (double)(f9 * f23) + (double)(f10 * f3 * (f14 - f17)) + (double)(f11 * f18)));
                    }
                }
            }
        }
        this.moCoeff += 5;
    }

    private void addData7F(int n) {
        if (!this.atomSet.get(this.atomIndex)) {
            this.moCoeff += 7;
            return;
        }
        if (this.doDebug) {
            this.dumpInfo(n, 6);
        }
        this.setMinMax();
        float f = (float)Math.pow(1056.818280307081, 0.25);
        float f2 = f / (float)Math.sqrt(3.0);
        float f3 = f / (float)Math.sqrt(15.0);
        float f4 = (float)(3.0 / (2.0 * Math.sqrt(5.0)));
        float f5 = (float)Math.sqrt(1.2);
        float f6 = (float)Math.sqrt(0.375);
        float f7 = (float)Math.sqrt(0.075);
        float f8 = f5;
        float f9 = f6;
        float f10 = f7;
        float f11 = (float)Math.sqrt(0.75);
        float f12 = (float)Math.sqrt(0.625);
        float f13 = 0.75f * (float)Math.sqrt(2.0);
        float f14 = f12;
        float f15 = f13;
        int n2 = n;
        while (--n2 >= 0) {
            float f16 = this.gaussians[this.gaussianPtr + n2][0];
            float f17 = this.gaussians[this.gaussianPtr + n2][1];
            float f18 = f17 * (float)Math.pow(f16, 2.25);
            float f19 = f18 * this.moCoefficients[this.moCoeff];
            float f20 = f18 * this.moCoefficients[this.moCoeff + 1];
            float f21 = f18 * this.moCoefficients[this.moCoeff + 2];
            float f22 = f18 * this.moCoefficients[this.moCoeff + 3];
            float f23 = f18 * this.moCoefficients[this.moCoeff + 4];
            float f24 = f18 * this.moCoefficients[this.moCoeff + 5];
            float f25 = f18 * this.moCoefficients[this.moCoeff + 6];
            this.setCE(f16, 0.0f, 0.0f, 0.0f, 0.0f);
            int n3 = this.xMax;
            while (--n3 >= this.xMin) {
                float f26 = this.X[n3];
                float f27 = f26 * f26;
                float f28 = this.EX[n3];
                float f29 = f3 * f26 * f27;
                int n4 = this.yMax;
                while (--n4 >= this.yMin) {
                    float f30 = this.Y[n4];
                    float f31 = f30 * f30;
                    float f32 = this.EY[n4];
                    float f33 = f3 * f30 * f31;
                    float f34 = f2 * f26 * f31;
                    float f35 = f2 * f27 * f30;
                    int n5 = this.zMax;
                    while (--n5 >= this.zMin) {
                        float f36 = this.Z[n5];
                        float f37 = f36 * f36;
                        float f38 = this.EZ[n5];
                        float f39 = f3 * f36 * f37;
                        float f40 = f2 * f27 * f36;
                        float f41 = f2 * f26 * f37;
                        float f42 = f2 * f31 * f36;
                        float f43 = f2 * f30 * f37;
                        float f44 = f * f26 * f30 * f36;
                        float f45 = f19 * (f39 - f4 * (f40 + f42));
                        float f46 = f20 * (f5 * f41 - f6 * f29 - f7 * f34);
                        float f47 = f21 * (f8 * f43 - f9 * f33 - f10 * f35);
                        float f48 = f22 * (f11 * (f40 - f42));
                        float f49 = f23 * f44;
                        float f50 = f24 * (f12 * f29 - f13 * f34);
                        float f51 = f25 * (-f14 * f33 + f15 * f35);
                        float[] fArray = this.voxelData[n3][n4];
                        int n6 = n5;
                        fArray[n6] = fArray[n6] + f28 * f32 * f38 * (f45 + f46 + f47 + f48 + f49 + f50 + f51);
                    }
                }
            }
        }
        this.moCoeff += 7;
    }

    private void processSlater(int n) {
        float f;
        this.atomIndex = this.slaterInfo[n][0];
        float f2 = -this.slaterData[n][0];
        if (!this.atomSet.get(this.atomIndex)) {
            if (f2 <= 0.0f) {
                ++this.moCoeff;
            }
            return;
        }
        int n2 = this.slaterInfo[n][1];
        int n3 = this.slaterInfo[n][2];
        int n4 = this.slaterInfo[n][3];
        int n5 = this.slaterInfo[n][4];
        if (f2 > 0.0f) {
            f2 = -f2;
            --this.moCoeff;
        }
        if ((f = this.slaterData[n][1] * this.moCoefficients[this.moCoeff++]) == 0.0f) {
            return;
        }
        this.setMinMax();
        int n6 = this.xMax;
        while (--n6 >= this.xMin) {
            this.X[n6] = this.xyzBohr[n6][0] - this.atomCoordBohr[this.atomIndex].x;
        }
        n6 = this.yMax;
        while (--n6 >= this.yMin) {
            this.Y[n6] = this.xyzBohr[n6][1] - this.atomCoordBohr[this.atomIndex].y;
        }
        n6 = this.zMax;
        while (--n6 >= this.zMin) {
            this.Z[n6] = this.xyzBohr[n6][2] - this.atomCoordBohr[this.atomIndex].z;
        }
        if (n2 == -2 || n3 == -2) {
            n6 = this.xMax;
            while (--n6 >= this.xMin) {
                float f3 = this.X[n6] * this.X[n6];
                int n7 = this.yMax;
                while (--n7 >= this.yMin) {
                    float f4 = this.Y[n7] * this.Y[n7];
                    int n8 = this.zMax;
                    while (--n8 >= this.zMin) {
                        float f5 = this.Z[n8] * this.Z[n8];
                        float f6 = (float)Math.sqrt(f3 + f4 + f5);
                        float f7 = f * (float)Math.exp(f2 * f6) * ((n2 == -2 ? 2.0f * f5 - f3 : f3) - f4);
                        int n9 = n5;
                        while (--n9 >= 0) {
                            f7 *= f6;
                        }
                        float[] fArray = this.voxelData[n6][n7];
                        int n10 = n8;
                        fArray[n10] = fArray[n10] + f7;
                    }
                }
            }
        } else {
            n6 = this.xMax;
            while (--n6 >= this.xMin) {
                float f8 = this.X[n6];
                int n11 = this.yMax;
                while (--n11 >= this.yMin) {
                    float f9 = this.Y[n11];
                    int n12 = this.zMax;
                    while (--n12 >= this.zMin) {
                        float f10 = this.Z[n12];
                        float f11 = (float)Math.sqrt(f8 * f8 + f9 * f9 + f10 * f10);
                        float f12 = f * (float)Math.exp(f2 * f11);
                        int n13 = n2;
                        while (--n13 >= 0) {
                            f12 *= f8;
                        }
                        n13 = n3;
                        while (--n13 >= 0) {
                            f12 *= f9;
                        }
                        n13 = n4;
                        while (--n13 >= 0) {
                            f12 *= f10;
                        }
                        n13 = n5;
                        while (--n13 >= 0) {
                            f12 *= f11;
                        }
                        float[] fArray = this.voxelData[n6][n11];
                        int n14 = n12;
                        fArray[n14] = fArray[n14] + f12;
                    }
                }
            }
        }
    }

    private void dumpInfo(int n, String string) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            float f = this.gaussians[this.gaussianPtr + n2][0];
            float f2 = this.gaussians[this.gaussianPtr + n2][1];
            if (!Logger.debugging) continue;
            Logger.debug("Gaussian " + (n2 + 1) + " alpha=" + f + " c=" + f2);
        }
        n2 = string.length() / 2;
        if (Logger.debugging) {
            for (int i = 0; i < n2; ++i) {
                Logger.debug("MO coeff " + string.substring(2 * i, 2 * i + 2) + " " + (this.moCoeff + i + 1) + " " + this.moCoefficients[this.moCoeff + i]);
            }
        }
    }

    private void dumpInfo(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < n; ++n3) {
            float f = this.gaussians[this.gaussianPtr + n3][0];
            float f2 = this.gaussians[this.gaussianPtr + n3][1];
            if (!Logger.debugging) continue;
            Logger.debug("Gaussian " + (n3 + 1) + " alpha=" + f + " c=" + f2);
        }
        if (n2 >= 0 && Logger.debugging) {
            for (n3 = 0; n3 < shellOrder[n2].length; ++n3) {
                Logger.debug("MO coeff " + shellOrder[n2][n3] + " " + (this.moCoeff + n3 + 1) + " " + this.moCoefficients[this.moCoeff + n3]);
            }
        }
    }
}

