/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.atomdata.AtomData;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelCollection;
import org.jmol.shape.Shape;
import org.jmol.symmetry.PointGroup;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public abstract class ModelSet
extends ModelCollection {
    private boolean selectionHaloEnabled = false;
    private boolean echoShapeActive = false;
    protected String modelSetTypeName;
    protected final Shape[] shapes = new Shape[32];
    protected final Atom[] closest = new Atom[1];
    private static final boolean useRasMolHbondsCalculation = true;

    protected void releaseModelSet() {
        for (int i = 0; i < 32; ++i) {
            this.shapes[i] = null;
        }
        this.models = null;
        this.closest[0] = null;
        super.releaseModelSet();
    }

    public void setSelectionHaloEnabled(boolean bl) {
        if (this.selectionHaloEnabled != bl) {
            this.selectionHaloEnabled = bl;
        }
    }

    public boolean getSelectionHaloEnabled() {
        return this.selectionHaloEnabled;
    }

    public boolean getEchoStateActive() {
        return this.echoShapeActive;
    }

    public void setEchoStateActive(boolean bl) {
        this.echoShapeActive = bl;
    }

    public String getModelSetTypeName() {
        return this.modelSetTypeName;
    }

    private Shape allocateShape(int n) {
        if (n == 2 || n == 3) {
            return null;
        }
        String string = JmolConstants.getShapeClassName(n);
        try {
            Class<?> clazz = Class.forName(string);
            Shape shape = (Shape)clazz.newInstance();
            shape.initializeShape(this.viewer, this.g3d, this, n);
            return shape;
        }
        catch (Exception exception) {
            Logger.error("Could not instantiate shape:" + string, exception);
            return null;
        }
    }

    public Shape getShape(int n) {
        return this.shapes[n];
    }

    public int getModelNumberIndex(int n, boolean bl, boolean bl2) {
        if (bl) {
            for (int i = 0; i < this.modelCount; ++i) {
                if (this.modelNumbers[i] != n) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (this.modelFileNumbers[i] != n) continue;
            if (bl2 && this.isTrajectory(i)) {
                this.setTrajectory(i);
            }
            return i;
        }
        return -1;
    }

    public String getTrajectoryInfo() {
        String string = "";
        if (this.trajectories == null) {
            return "";
        }
        int n = this.modelCount;
        while (--n >= 0) {
            if (this.models[n].selectedTrajectory < 0) continue;
            string = " or " + this.getModelNumberDotted(this.models[n].selectedTrajectory) + string;
            n = this.models[n].trajectoryBaseIndex;
        }
        if (string.length() > 0) {
            string = "set trajectory {" + string.substring(4) + "}";
        }
        return string;
    }

    public BitSet getBitSetTrajectories() {
        if (this.trajectories == null) {
            return null;
        }
        BitSet bitSet = new BitSet();
        int n = this.modelCount;
        while (--n >= 0) {
            if (this.models[n].selectedTrajectory < 0) continue;
            bitSet.set(this.models[n].selectedTrajectory);
            n = this.models[n].trajectoryBaseIndex;
        }
        return bitSet;
    }

    public void setTrajectory(BitSet bitSet) {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!bitSet.get(i)) continue;
            this.setTrajectory(i);
        }
    }

    public void setTrajectory(int n) {
        int n2;
        if (n < 0 || !this.models[n].isTrajectory) {
            return;
        }
        int n3 = this.models[n].firstAtomIndex;
        if (this.atoms[n3].modelIndex == n) {
            return;
        }
        int n4 = this.models[n].trajectoryBaseIndex;
        this.models[n4].selectedTrajectory = n;
        Point3f[] point3fArray = (Point3f[])this.trajectories.get(n);
        BitSet bitSet = new BitSet();
        int n5 = this.getAtomCountInModel(n);
        int n6 = 0;
        for (n2 = n3; n2 < n5 && n6 < point3fArray.length && point3fArray[n6] != null; ++n2) {
            this.atoms[n2].set(point3fArray[n6++]);
            this.atoms[n2].modelIndex = (short)n;
            bitSet.set(n2);
        }
        this.bspf.clearBspt(n4);
        this.recalculateLeadMidpointsAndWingVectors(n4);
        Integer n7 = new Integer(n4);
        for (n2 = 0; n2 < 32; ++n2) {
            if (this.shapes[n2] == null) continue;
            this.setShapeProperty(n2, "refreshTrajectories", n7, bitSet);
        }
        if (this.models[n4].hasCalculatedHBonds) {
            this.clearCalculatedHydrogenBonds(n4, null);
            this.models[n4].calcHydrogenBonds(bitSet, bitSet);
        }
        if ((n2 = this.viewer.getCurrentModelIndex()) >= 0 && n2 != n && this.models[n2].fileIndex == this.models[n].fileIndex) {
            this.viewer.setCurrentModelIndex(n, false);
        }
    }

    public BitSet getAtomBits(int n, Object object) {
        switch (n) {
            case 0x100022: {
                return this.getSpecModel((Integer)object);
            }
        }
        return super.getAtomBits(n, object);
    }

    private BitSet getSpecModel(int n) {
        int n2 = this.getModelNumberIndex(n, true, true);
        return n2 < 0 && n > 0 ? new BitSet() : this.getModelAtomBitSet(n2, true);
    }

    public int findNearestAtomIndex(int n, int n2) {
        int n3;
        if (this.atomCount == 0) {
            return -1;
        }
        this.closest[0] = null;
        if (this.g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
        }
        this.findNearestAtomIndex(n, n2, this.closest);
        for (n3 = 0; n3 < this.shapes.length && this.closest[0] == null; ++n3) {
            if (this.shapes[n3] == null) continue;
            this.shapes[n3].findNearestAtomIndex(n, n2, this.closest);
        }
        n3 = this.closest[0] == null ? -1 : this.closest[0].atomIndex;
        this.closest[0] = null;
        return n3;
    }

    public void setShapeSize(int n, int n2, BitSet bitSet) {
        if (n2 != 0) {
            this.loadShape(n);
        }
        if (this.shapes[n] != null) {
            this.shapes[n].setSize(n2, bitSet);
        }
    }

    public Shape loadShape(int n) {
        if (this.shapes[n] == null) {
            this.shapes[n] = this.allocateShape(n);
        }
        return this.shapes[n];
    }

    public void setShapeProperty(int n, String string, Object object, BitSet bitSet) {
        if (this.shapes[n] != null) {
            this.shapes[n].setProperty(string.intern(), object, bitSet);
        }
    }

    public Object getShapeProperty(int n, String string, int n2) {
        return this.shapes[n] == null ? null : this.shapes[n].getProperty(string, n2);
    }

    public int getShapeIdFromObjectName(String string) {
        for (int i = 16; i < 26; ++i) {
            if (this.shapes[i] == null || this.shapes[i].getIndexFromName(string) < 0) continue;
            return i;
        }
        return -1;
    }

    public void setModelVisibility() {
        int n;
        BitSet bitSet = this.viewer.getVisibleFramesBitSet();
        for (n = 1; n < 32; ++n) {
            if (this.shapes[n] == null) continue;
            this.shapes[n].setVisibilityFlags(bitSet);
        }
        this.shapes[0].setVisibilityFlags(bitSet);
        for (n = 0; n < 32; ++n) {
            Shape shape = this.shapes[n];
            if (shape == null) continue;
            shape.setModelClickability();
        }
    }

    public void fillAtomData(AtomData atomData, int n) {
        if (n == 3) {
            int[] nArray = new int[1];
            atomData.hAtomRadius = (float)this.viewer.getVanderwaalsMar(1) / 1000.0f;
            atomData.hAtoms = this.getAdditionalHydrogens(atomData.bsSelected, nArray);
            atomData.hydrogenAtomCount = nArray[0];
            return;
        }
        atomData.firstAtomIndex = atomData.modelIndex < 0 ? Math.max(0, BitSetUtil.firstSetBit(atomData.bsSelected)) : this.models[atomData.modelIndex].firstAtomIndex;
        atomData.firstModelIndex = this.atomCount == 0 ? 0 : (int)this.atoms[atomData.firstAtomIndex].modelIndex;
        atomData.lastModelIndex = atomData.firstModelIndex;
        atomData.modelName = this.getModelNumberDotted(atomData.firstModelIndex);
        super.fillAtomData(atomData, n);
    }

    public boolean frankClicked(int n, int n2) {
        Shape shape = this.shapes[31];
        return shape != null && shape.wasClicked(n, n2);
    }

    public boolean checkObjectHovered(int n, int n2, BitSet bitSet) {
        Shape shape = this.shapes[29];
        if (shape != null && shape.checkObjectHovered(n, n2, bitSet)) {
            return true;
        }
        shape = this.shapes[21];
        if (shape == null || !this.viewer.getDrawHover()) {
            return false;
        }
        return shape.checkObjectHovered(n, n2, bitSet);
    }

    public Point3f checkObjectClicked(int n, int n2, int n3, BitSet bitSet) {
        Shape shape = this.shapes[29];
        Point3f point3f = null;
        if (shape != null && n3 != 0 && (point3f = shape.checkObjectClicked(n, n2, n3, bitSet)) != null) {
            return point3f;
        }
        shape = this.shapes[21];
        return shape == null ? null : shape.checkObjectClicked(n, n2, n3, bitSet);
    }

    public void checkObjectDragged(int n, int n2, int n3, int n4, int n5, BitSet bitSet) {
        Shape shape;
        for (int i = 0; !(i >= 32 || (shape = this.shapes[i]) != null && shape.checkObjectDragged(n, n2, n3, n4, n5, bitSet)); ++i) {
        }
    }

    public Hashtable getShapeInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 32; ++i) {
            Shape shape = this.shapes[i];
            if (shape == null) continue;
            String string = JmolConstants.shapeClassBases[i];
            Vector vector = shape.getShapeDetail();
            if (vector == null) continue;
            Hashtable<String, Vector> hashtable2 = new Hashtable<String, Vector>();
            hashtable2.put("obj", vector);
            hashtable.put(string, hashtable2);
        }
        if (stringBuffer.length() > 0) {
            hashtable.put("shapeCommands", stringBuffer.toString());
        }
        return hashtable;
    }

    public void calculateStructures(BitSet bitSet) {
        int n;
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = BitSetUtil.invertInPlace(this.modelsOf(bitSet, bitSet2), this.modelCount);
        for (n = 0; n < this.modelCount; ++n) {
            if (bitSet3.get(n)) continue;
            this.addBioPolymerToModel(null, this.models[n]);
        }
        this.calculatePolymers(bitSet3);
        this.calculateStructuresAllExcept(bitSet3, false);
        for (n = 0; n < this.shapes.length; ++n) {
            if (this.shapes[n] == null || !this.shapes[n].isBioShape) continue;
            this.shapes[n].setSize(0, bitSet2);
            this.shapes[n].setProperty("color", new Byte(1), bitSet2);
        }
    }

    public String calculatePointGroup(BitSet bitSet) {
        PointGroup pointGroup;
        int n = BitSetUtil.firstSetBit(bitSet);
        int n2 = this.atoms[n].getModelIndex();
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bitSet.get(i) || this.atoms[i].modelIndex == n2) continue;
            bitSet.clear(i);
        }
        this.models[n2].pointGroup = pointGroup = new PointGroup(this.atoms, bitSet);
        return pointGroup.getName();
    }

    public String getPointGroupDraw(int n) {
        if (n < 0) {
            return "";
        }
        if (this.models[n].pointGroup == null) {
            this.calculatePointGroup(this.viewer.getSelectionSet());
        }
        return this.models[n].pointGroup.drawInfo();
    }

    private BitSet modelsOf(BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3 = new BitSet(this.modelCount);
        for (int i = 0; i < this.atomCount; ++i) {
            int n = this.models[this.atoms[i].modelIndex].trajectoryBaseIndex;
            if (bitSet != null && !bitSet.get(i) || this.isJmolDataFrame(n)) continue;
            bitSet3.set(n);
            bitSet2.set(i);
        }
        return bitSet3;
    }

    public int autoHbond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        this.bsPseudoHBonds = new BitSet();
        if (this.bondCount > 0) {
            this.calcHydrogenBonds(bitSet, bitSet2);
            bitSet3 = this.bsPseudoHBonds;
            return BitSetUtil.cardinalityOf(bitSet3);
        }
        this.initializeBspf();
        return super.autoHbond(bitSet, bitSet2, bitSet3);
    }

    protected void assignAromaticBonds(boolean bl) {
        super.assignAromaticBonds(bl, null);
        if (bl) {
            this.setShapeSize(1, Integer.MIN_VALUE, this.bsAromatic);
        }
    }

    public int[] makeConnections(float f, float f2, short s, int n, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl) {
        if (n == 0) {
            String string = "connect ";
            if (f != 0.1f) {
                string = string + f + " ";
            }
            if (f2 != 1.0E8f) {
                string = string + f2 + " ";
            }
            this.addStateScript(string, bl ? bitSet : null, bl ? null : bitSet, bl ? null : bitSet2, " delete;", false, true);
        }
        return super.makeConnections(f, f2, s, n, bitSet, bitSet2, bitSet3, bl);
    }

    public void setPdbConectBonding(int n, int n2, BitSet bitSet) {
        short s = this.viewer.getMadBond();
        for (int i = n2; i < this.modelCount; ++i) {
            int n3;
            Vector vector = (Vector)this.getModelAuxiliaryInfo(i, "PDB_CONECT_bonds");
            if (vector == null) continue;
            int n4 = vector.size();
            int[] nArray = (int[])this.getModelAuxiliaryInfo(i, "PDB_CONECT_firstAtom_count_max");
            int n5 = nArray[0] + n;
            int n6 = n5 + nArray[1];
            int n7 = nArray[2];
            int[] nArray2 = new int[n7 + 1];
            for (n3 = n5; n3 < n6; ++n3) {
                int n8 = this.atomSerials[n3];
                if (n8 <= 0) continue;
                nArray2[n8] = n3 + 1;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                int[] nArray3 = (int[])vector.get(n3);
                int n9 = nArray3[0];
                int n10 = nArray3[1];
                short s2 = (short)nArray3[2];
                if (n9 < 0 || n10 < 0 || n9 > n7 || n10 > n7) continue;
                int n11 = nArray2[n9] - 1;
                int n12 = nArray2[n10] - 1;
                if (n11 < 0 || n12 < 0) continue;
                if (bitSet != null) {
                    if (this.atoms[n11].isHetero()) {
                        bitSet.set(n11);
                    }
                    if (this.atoms[n12].isHetero()) {
                        bitSet.set(n12);
                    }
                }
                this.checkValencesAndBond(this.atoms[n11], this.atoms[n12], s2, s2 == 2048 ? (short)1 : s, null);
            }
        }
    }

    public void deleteAllBonds() {
        int n = this.stateScripts.size();
        while (--n >= 0) {
            if (!((ModelCollection.StateScript)this.stateScripts.get(n)).isConnect()) continue;
            this.stateScripts.removeElementAt(n);
        }
        super.deleteAllBonds();
    }

    public String getDefinedState(StringBuffer stringBuffer, boolean bl) {
        String string;
        int n = this.stateScripts.size();
        if (n == 0) {
            return "";
        }
        boolean bl2 = false;
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            ModelCollection.StateScript stateScript = (ModelCollection.StateScript)this.stateScripts.get(i);
            if (stateScript.postDefinitions || (string = stateScript.toString()).length() <= 0) continue;
            stringBuffer2.append("  ").append(string).append("\n");
            bl2 = true;
        }
        if (!bl2) {
            return "";
        }
        string = "";
        if (bl && stringBuffer != null) {
            stringBuffer.append("  _setDefinedState;\n");
            string = "function _setDefinedState();\n\n";
        }
        if (stringBuffer != null) {
            stringBuffer2.append("\nend function;\n\n");
        }
        return string + stringBuffer2.toString();
    }

    public String getState(StringBuffer stringBuffer, boolean bl) {
        String string;
        int n;
        StringBuffer stringBuffer2 = new StringBuffer();
        if (bl && stringBuffer != null) {
            stringBuffer.append("  _setModelState;\n");
            stringBuffer2.append("function _setModelState();\n");
        }
        if (bl) {
            Object object;
            int n2;
            n = this.stateScripts.size();
            for (n2 = 0; n2 < n; ++n2) {
                object = (ModelCollection.StateScript)this.stateScripts.get(n2);
                if (!((ModelCollection.StateScript)object).postDefinitions || (string = ((ModelCollection.StateScript)object).toString()).length() <= 0) continue;
                stringBuffer2.append("  ").append(string).append("\n");
            }
            for (n2 = 0; n2 < this.bondCount; ++n2) {
                if ((this.bonds[n2].order & Short.MIN_VALUE) == 0 && !this.bonds[n2].isHydrogen()) continue;
                object = this.bonds[n2];
                stringBuffer2.append("  connect ").append("({").append(((Bond)object).atom1.atomIndex).append("}) ").append("({").append(((Bond)object).atom2.atomIndex).append("}) ").append(JmolConstants.getBondOrderNameFromOrder(((Bond)object).order)).append(";\n");
            }
            stringBuffer2.append("\n");
        }
        this.setModelVisibility();
        for (n = 0; n < 32; ++n) {
            Shape shape = this.shapes[n];
            if (shape == null || !bl && !JmolConstants.isShapeSecondary(n) || (string = shape.getShapeState()) == null || string.length() <= 1) continue;
            stringBuffer2.append(string);
        }
        if (bl) {
            for (n = 0; n < this.modelCount; ++n) {
                String string2 = this.frameTitles[n];
                if (string2 != null && string2.length() > 0) {
                    stringBuffer2.append("  frame " + this.getModelNumberDotted(n) + "; frame title " + Escape.escape(string2) + ";\n");
                }
                if (this.models[n].orientation == null) continue;
                stringBuffer2.append("  frame " + this.getModelNumberDotted(n) + "; " + this.models[n].orientation.getMoveToText() + "\n");
            }
            stringBuffer2.append("  set fontScaling " + this.viewer.getFontScaling() + ";\n");
        }
        if (stringBuffer != null) {
            stringBuffer2.append("\nend function;\n\n");
        }
        return stringBuffer2.toString();
    }

    public int getVanderwaalsMar(int n) {
        return this.viewer.getVanderwaalsMar(n);
    }

    void includeAllRelatedFrames(BitSet bitSet) {
        for (int i = 0; i < this.modelCount; ++i) {
            if (bitSet.get(i)) {
                int n;
                if (!this.isTrajectory(i) || bitSet.get(n = this.models[i].trajectoryBaseIndex)) continue;
                bitSet.set(n);
                this.includeAllRelatedFrames(bitSet);
                return;
            }
            if ((!this.isTrajectory(i) || !bitSet.get(this.models[i].trajectoryBaseIndex)) && (!this.isJmolDataFrame(i) || !bitSet.get(this.models[i].dataSourceFrame))) continue;
            bitSet.set(i);
        }
    }

    public BitSet deleteAtoms(BitSet bitSet, boolean bl) {
        int n;
        if (!bl) {
            return null;
        }
        BitSet bitSet2 = this.getModelBitSet(bitSet);
        this.includeAllRelatedFrames(bitSet2);
        int n2 = 0;
        int n3 = BitSetUtil.cardinalityOf(bitSet2);
        if (n3 == 0) {
            return null;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (!bitSet2.get(i)) continue;
            this.clearDataFrameReference(i);
        }
        if (n3 == this.modelCount) {
            BitSet bitSet3 = this.getModelAtomBitSet(-1, true);
            this.viewer.zap(true, false);
            return bitSet3;
        }
        this.bspf = null;
        Model[] modelArray = new Model[this.modelCount - n3];
        Model[] modelArray2 = this.models;
        BitSet bitSet4 = new BitSet();
        int n4 = 0;
        for (n = 0; n < this.modelCount; ++n) {
            if (bitSet2.get(n)) {
                this.getAtomCountInModel(n);
                bitSet4.or(this.getModelAtomBitSet(n, false));
                continue;
            }
            this.models[n].modelIndex = n4;
            modelArray[n4++] = this.models[n];
        }
        this.models = modelArray;
        n = this.modelCount;
        BitSet bitSet5 = this.getBondsForSelectedAtoms(bitSet4, true);
        this.deleteBonds(bitSet5);
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            if (!bitSet2.get(i)) {
                ++n5;
                continue;
            }
            int n6 = modelArray2[i].atomCount;
            if (n6 == 0) continue;
            n2 += n6;
            BitSet bitSet6 = modelArray2[i].bsAtoms;
            int n7 = modelArray2[i].firstAtomIndex;
            BitSetUtil.deleteBits(this.bsSymmetry, bitSet6);
            super.deleteAtoms(n5, n7, n6, bitSet6, bitSet5);
            int n8 = n;
            while (--n8 > i) {
                modelArray2[n8].fixIndices(n5, n6, bitSet6);
            }
            Object[] objectArray = new Object[]{modelArray, this.atoms, new int[]{n5, n7, n6}};
            for (int j = 0; j < 32; ++j) {
                if (this.shapes[j] == null) continue;
                this.setShapeProperty(j, "deleteModelAtoms", objectArray, bitSet6);
            }
            --this.modelCount;
        }
        super.deleteAtoms(-1, 0, 0, null, null);
        return bitSet4;
    }
}

