/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import org.jmol.bspt.CubeIterator;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;
import org.jmol.modelset.BondIteratorSelected;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Logger;

public abstract class BondCollection
extends AtomCollection {
    Bond[] bonds;
    int bondCount;
    private static final int bondGrowthIncrement = 250;
    protected static final int MAX_BONDS_LENGTH_TO_CACHE = 5;
    protected static final int MAX_NUM_TO_CACHE = 200;
    protected int[] numCached = new int[5];
    protected Bond[][][] freeBonds = new Bond[5][][];
    protected BitSet bsPseudoHBonds;
    private boolean haveWarned;
    protected short defaultCovalentMad;
    private float hbondMax;
    private float hbondMin;
    private float hbondMin2;
    private BitSet bsAromaticSingle;
    private BitSet bsAromaticDouble;
    protected BitSet bsAromatic;

    public BondCollection() {
        int n = 5;
        while (--n > 0) {
            this.freeBonds[n] = new Bond[200][];
        }
        this.haveWarned = false;
        this.hbondMax = 3.25f;
        this.hbondMin = 2.5f;
        this.hbondMin2 = this.hbondMin * this.hbondMin;
        this.bsAromatic = new BitSet();
    }

    protected void releaseModelSet() {
        this.bonds = null;
        this.freeBonds = null;
        super.releaseModelSet();
    }

    void merge(ModelSet modelSet) {
        super.merge(modelSet);
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public Bond getBondAt(int n) {
        return this.bonds[n];
    }

    public int getBondCount() {
        return this.bondCount;
    }

    public BondIterator getBondIterator(short s, BitSet bitSet) {
        return new BondIteratorSelected(this.bonds, this.bondCount, s, bitSet, this.viewer.getBondSelectionModeOr());
    }

    public BondIterator getBondIterator(BitSet bitSet) {
        return new BondIteratorSelected(this.bonds, this.bondCount, bitSet);
    }

    public Atom getBondAtom1(int n) {
        return this.bonds[n].atom1;
    }

    public Atom getBondAtom2(int n) {
        return this.bonds[n].atom2;
    }

    public float getBondRadius(int n) {
        return this.bonds[n].getRadius();
    }

    public short getBondOrder(int n) {
        return this.bonds[n].getOrder();
    }

    public short getBondColix1(int n) {
        return this.bonds[n].getColix1();
    }

    public short getBondColix2(int n) {
        return this.bonds[n].getColix2();
    }

    public int getBondModelIndex(int n) {
        return this.bonds[n].atom1.atomIndex;
    }

    protected int getBondCountInModel(int n) {
        int n2 = 0;
        int n3 = this.bondCount;
        while (--n3 >= 0) {
            if (this.bonds[n3].atom1.modelIndex != n) continue;
            ++n2;
        }
        return n2;
    }

    public BitSet getBondsForSelectedAtoms(BitSet bitSet) {
        return this.getBondsForSelectedAtoms(bitSet, this.viewer.getBondSelectionModeOr());
    }

    protected BitSet getBondsForSelectedAtoms(BitSet bitSet, boolean bl) {
        BitSet bitSet2 = new BitSet();
        for (int i = 0; i < this.bondCount; ++i) {
            boolean bl2;
            boolean bl3;
            Bond bond = this.bonds[i];
            if (!(!bl & (bl3 = bitSet.get(bond.atom1.atomIndex)) & (bl2 = bitSet.get(bond.atom2.atomIndex))) && !(bl & (bl3 | bl2))) continue;
            bitSet2.set(i);
        }
        return bitSet2;
    }

    public Bond bondAtoms(Atom atom, Atom atom2, short s, short s2, BitSet bitSet) {
        Bond bond = this.getOrAddBond(atom, atom2, s, s2, bitSet);
        bond.order = (short)(bond.order | Short.MIN_VALUE);
        return bond;
    }

    private Bond getOrAddBond(Atom atom, Atom atom2, short s, short s2, BitSet bitSet) {
        int n;
        if (atom.isBonded(atom2)) {
            n = atom.getBond((Atom)atom2).index;
        } else {
            if (this.bondCount == this.bonds.length) {
                this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount + 250);
            }
            if (s == Short.MAX_VALUE || s == 16383) {
                s = 1;
            }
            n = this.setBond((int)this.bondCount++, (Bond)this.bondMutually((Atom)atom, (Atom)atom2, (short)s, (short)s2)).index;
        }
        if (bitSet != null) {
            bitSet.set(n);
        }
        return this.bonds[n];
    }

    protected Bond setBond(int n, Bond bond) {
        bond.index = n;
        this.bonds[bond.index] = bond;
        return this.bonds[bond.index];
    }

    protected Bond bondMutually(Atom atom, Atom atom2, short s, short s2) {
        Bond bond = new Bond(atom, atom2, s, s2, 0);
        this.addBondToAtom(atom, bond);
        this.addBondToAtom(atom2, bond);
        return bond;
    }

    private void addBondToAtom(Atom atom, Bond bond) {
        if (atom.bonds == null) {
            atom.bonds = new Bond[1];
            atom.bonds[0] = bond;
        } else {
            atom.bonds = this.addToBonds(bond, atom.bonds);
        }
    }

    private Bond[] addToBonds(Bond bond, Bond[] bondArray) {
        Bond[] bondArray2;
        if (bondArray == null) {
            if (this.numCached[1] > 0) {
                this.numCached[1] = this.numCached[1] - 1;
                bondArray2 = this.freeBonds[1][this.numCached[1]];
            } else {
                bondArray2 = new Bond[]{bond};
            }
        } else {
            int n = bondArray.length;
            int n2 = n + 1;
            if (n2 < 5 && this.numCached[n2] > 0) {
                int n3 = n2;
                int n4 = this.numCached[n3] - 1;
                this.numCached[n3] = n4;
                bondArray2 = this.freeBonds[n2][n4];
            } else {
                bondArray2 = new Bond[n2];
            }
            bondArray2[n] = bond;
            int n5 = n;
            while (--n5 >= 0) {
                bondArray2[n5] = bondArray[n5];
            }
            if (n < 5 && this.numCached[n] < 200) {
                int n6 = n;
                int n7 = this.numCached[n6];
                this.numCached[n6] = n7 + 1;
                this.freeBonds[n][n7] = bondArray;
            }
        }
        return bondArray2;
    }

    void addHydrogenBond(Atom atom, Atom atom2, short s, BitSet bitSet, BitSet bitSet2) {
        boolean bl;
        if (atom == null || atom2 == null) {
            return;
        }
        boolean bl2 = bitSet == null || bitSet.get(atom.atomIndex);
        boolean bl3 = bitSet2 == null || bitSet2.get(atom.atomIndex);
        boolean bl4 = bitSet == null || bitSet.get(atom2.atomIndex);
        boolean bl5 = bl = bitSet2 == null || bitSet2.get(atom2.atomIndex);
        if (bl2 && bl || bl3 && bl4) {
            this.getOrAddBond(atom, atom2, s, (short)1, this.bsPseudoHBonds);
        }
    }

    protected short getBondOrder(Atom atom, float f, Atom atom2, float f2, float f3, float f4, float f5) {
        if (f == 0.0f || f2 == 0.0f) {
            return 0;
        }
        float f6 = f + f2 + f5;
        float f7 = f6 * f6;
        if (f3 < f4) {
            return 0;
        }
        if (f3 <= f7) {
            return 1;
        }
        return 0;
    }

    void checkValencesAndBond(Atom atom, Atom atom2, short s, short s2, BitSet bitSet) {
        if (atom.getCurrentBondCount() > 20 || atom2.getCurrentBondCount() > 20) {
            if (!this.haveWarned) {
                Logger.warn("maximum auto bond count reached");
            }
            this.haveWarned = true;
            return;
        }
        int n = atom.getFormalCharge();
        if (n != 0) {
            int n2 = atom2.getFormalCharge();
            if (n < 0 && n2 < 0 || n > 0 && n2 > 0) {
                return;
            }
        }
        if (atom.alternateLocationID != atom2.alternateLocationID && atom.alternateLocationID != '\u0000' && atom2.alternateLocationID != '\u0000') {
            return;
        }
        this.getOrAddBond(atom, atom2, s, s2, bitSet);
    }

    protected void deleteAllBonds() {
        this.viewer.setShapeProperty(1, "reset", null);
        int n = this.bondCount;
        while (--n >= 0) {
            this.bonds[n].deleteAtomReferences();
            this.bonds[n] = null;
        }
        this.bondCount = 0;
    }

    protected short getDefaultMadFromOrder(short s) {
        return (s & 0x7800) > 0 ? (short)1 : this.defaultCovalentMad;
    }

    protected int[] deleteConnections(float f, float f2, short s, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, float f3, float f4) {
        BitSet bitSet3 = new BitSet();
        int n = 0;
        short s2 = s = (short)(s | Short.MIN_VALUE);
        if (!bl2 && (s & 0x7800) != 0) {
            s = (short)30720;
        }
        int n2 = this.bondCount;
        while (--n2 >= 0) {
            float f5;
            Bond bond = this.bonds[n2];
            Atom atom = bond.atom1;
            Atom atom2 = bond.atom2;
            if (!(!bl && (bitSet.get(atom.atomIndex) && bitSet2.get(atom2.atomIndex) || bitSet.get(atom2.atomIndex) && bitSet2.get(atom.atomIndex))) && (!bl || !bitSet.get(n2)) || !bond.atom1.isBonded(bond.atom2) || !((f5 = atom.distanceSquared(atom2)) >= f3) || !(f5 <= f4) || !bl2 && s2 != (bond.order & 0xFFFFFEFF | Short.MIN_VALUE) && (s & bond.order & 0x7800) == 0) continue;
            bitSet3.set(n2);
            ++n;
        }
        if (n > 0) {
            this.deleteBonds(bitSet3);
        }
        return new int[]{0, n};
    }

    protected void deleteBonds(BitSet bitSet) {
        int n;
        int n2 = 0;
        for (n = 0; n < this.bondCount; ++n) {
            Bond bond = this.bonds[n];
            if (!bitSet.get(n)) {
                this.setBond(n2++, bond);
                continue;
            }
            bond.deleteAtomReferences();
        }
        n = this.bondCount;
        while (--n >= n2) {
            this.bonds[n] = null;
        }
        this.bondCount = n2;
        BitSet[] bitSetArray = (BitSet[])this.viewer.getShapeProperty(1, "sets");
        for (int i = 0; i < bitSetArray.length; ++i) {
            BitSetUtil.deleteBits(bitSetArray[i], bitSet);
        }
        BitSetUtil.deleteBits(this.bsPseudoHBonds, bitSet);
        BitSetUtil.deleteBits(this.bsAromatic, bitSet);
    }

    protected int autoHbond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        int n = 0;
        if (Logger.debugging) {
            Logger.startTimer();
        }
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            Atom atom = this.atoms[n2];
            short s = atom.getElementNumber();
            if (s != 7 && s != 8) continue;
            CubeIterator cubeIterator = this.bspf.getCubeIterator(atom.modelIndex);
            cubeIterator.initializeHemisphere(atom, this.hbondMax);
            while (cubeIterator.hasMoreElements()) {
                Atom atom2 = (Atom)cubeIterator.nextElement();
                short s2 = atom2.getElementNumber();
                if (s2 != 7 && s2 != 8 || atom2 == atom || cubeIterator.foundDistance2() < this.hbondMin2 || atom.isBonded(atom2)) continue;
                this.getOrAddBond(atom, atom2, (short)2048, (short)1, this.bsPseudoHBonds);
                ++n;
            }
            cubeIterator.release();
        }
        this.viewer.setShapeSize(1, Integer.MIN_VALUE, this.bsPseudoHBonds);
        if (Logger.debugging) {
            Logger.checkTimer("Time to hbond");
        }
        return n;
    }

    public void resetAromatic() {
        int n = this.bondCount;
        while (--n >= 0) {
            Bond bond = this.bonds[n];
            if (!bond.isAromatic()) continue;
            bond.setOrder((short)515);
        }
    }

    public void assignAromaticBonds() {
        this.assignAromaticBonds(true, null);
    }

    protected void assignAromaticBonds(boolean bl, BitSet bitSet) {
        if (!bl) {
            this.bsAromatic = new BitSet();
        }
        this.bsAromaticSingle = new BitSet();
        this.bsAromaticDouble = new BitSet();
        int n = this.bondCount;
        while (--n >= 0) {
            if (bitSet != null && !bitSet.get(n)) continue;
            Bond bond = this.bonds[n];
            if (this.bsAromatic.get(n)) {
                bond.setOrder((short)515);
            }
            switch (bond.order & Short.MAX_VALUE) {
                case 515: {
                    this.bsAromatic.set(n);
                    break;
                }
                case 513: {
                    this.bsAromaticSingle.set(n);
                    break;
                }
                case 514: {
                    this.bsAromaticDouble.set(n);
                }
            }
        }
        int n2 = this.bondCount;
        while (--n2 >= 0) {
            Bond bond;
            if (bitSet != null && !bitSet.get(n2) || !(bond = this.bonds[n2]).is(515) || this.bsAromaticDouble.get(n2) || this.bsAromaticSingle.get(n2) || this.assignAromaticDouble(bond)) continue;
            this.assignAromaticSingle(bond);
        }
        n2 = this.bondCount;
        while (--n2 >= 0) {
            if (bitSet != null && !bitSet.get(n2)) continue;
            Bond bond = this.bonds[n2];
            if (this.bsAromaticDouble.get(n2)) {
                if (bond.is(514)) continue;
                this.bsAromatic.set(n2);
                bond.setOrder((short)514);
                continue;
            }
            if (!this.bsAromaticSingle.get(n2) && !bond.isAromatic() || bond.is(513)) continue;
            this.bsAromatic.set(n2);
            bond.setOrder((short)513);
        }
        this.assignAromaticNandO(bitSet);
        this.bsAromaticSingle = null;
        this.bsAromaticDouble = null;
    }

    private boolean assignAromaticDouble(Bond bond) {
        int n = bond.index;
        if (this.bsAromaticSingle.get(n)) {
            return false;
        }
        if (this.bsAromaticDouble.get(n)) {
            return true;
        }
        this.bsAromaticDouble.set(n);
        if (!this.assignAromaticSingle(bond.atom1, n) || !this.assignAromaticSingle(bond.atom2, n)) {
            this.bsAromaticDouble.clear(n);
            return false;
        }
        return true;
    }

    private boolean assignAromaticSingle(Bond bond) {
        int n = bond.index;
        if (this.bsAromaticDouble.get(n)) {
            return false;
        }
        if (this.bsAromaticSingle.get(n)) {
            return true;
        }
        this.bsAromaticSingle.set(n);
        if (!this.assignAromaticDouble(bond.atom1) || !this.assignAromaticDouble(bond.atom2)) {
            this.bsAromaticSingle.clear(n);
            return false;
        }
        return true;
    }

    private boolean assignAromaticSingle(Atom atom, int n) {
        Bond[] bondArray = atom.bonds;
        if (this.assignAromaticSingleHetero(atom)) {
            return false;
        }
        int n2 = bondArray.length;
        while (--n2 >= 0) {
            Bond bond = bondArray[n2];
            int n3 = bond.index;
            if (n3 == n || !bond.isAromatic() || this.bsAromaticSingle.get(n3) || !this.bsAromaticDouble.get(n3) && this.assignAromaticSingle(bond)) continue;
            return false;
        }
        return true;
    }

    private boolean assignAromaticDouble(Atom atom) {
        Bond[] bondArray = atom.bonds;
        boolean bl = this.assignAromaticSingleHetero(atom);
        int n = -1;
        int n2 = bondArray.length;
        while (--n2 >= 0) {
            if (this.bsAromaticDouble.get(bondArray[n2].index)) {
                bl = true;
            }
            if (!bondArray[n2].isAromatic()) continue;
            n = n2;
        }
        n2 = bondArray.length;
        while (--n2 >= 0) {
            Bond bond = bondArray[n2];
            int n3 = bond.index;
            if (!bond.isAromatic() || this.bsAromaticDouble.get(n3) || this.bsAromaticSingle.get(n3)) continue;
            if (!bl && this.assignAromaticDouble(bond)) {
                bl = true;
                continue;
            }
            if (!bl && n2 >= n || this.assignAromaticSingle(bond)) continue;
            return false;
        }
        return bl;
    }

    private boolean assignAromaticSingleHetero(Atom atom) {
        short s = atom.getElementNumber();
        switch (s) {
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                break;
            }
            default: {
                return true;
            }
        }
        int n = atom.getValence();
        switch (s) {
            case 6: {
                return n == 4;
            }
            case 7: 
            case 8: {
                return n == 10 - s && atom.getFormalCharge() < 1;
            }
            case 16: {
                return n == 18 - s && atom.getFormalCharge() < 1;
            }
        }
        return false;
    }

    private void assignAromaticNandO(BitSet bitSet) {
        int n = this.bondCount;
        while (--n >= 0) {
            Atom atom;
            short s;
            Bond bond;
            if (bitSet != null && !bitSet.get(n) || !(bond = this.bonds[n]).is(513)) continue;
            Atom atom2 = bond.atom2;
            short s2 = atom2.getElementNumber();
            if (s2 == 7 || s2 == 8) {
                s = s2;
                atom = atom2;
                atom2 = bond.atom1;
                s2 = atom2.getElementNumber();
            } else {
                atom = bond.atom1;
                s = atom.getElementNumber();
            }
            if (s != 7 && s != 8) continue;
            int n2 = atom.getValence();
            int n3 = atom.getCovalentBondCount();
            int n4 = atom.getFormalCharge();
            switch (s) {
                case 7: {
                    if (n2 != 3 || n3 != 3 || n4 >= 1 || s2 != 6 || atom2.getValence() != 3) break;
                    bond.setOrder((short)514);
                    break;
                }
                case 8: {
                    if (n2 != 1 || n4 != 0 || s2 != 14 && s2 != 16) break;
                    bond.setOrder((short)514);
                }
            }
        }
    }

    protected BitSet getAtomBits(int n, Object object) {
        switch (n) {
            case 0x10000D: {
                BitSet bitSet = new BitSet();
                int n2 = this.bondCount;
                while (--n2 >= 0) {
                    if (!this.bonds[n2].isAromatic()) continue;
                    bitSet.set(this.bonds[n2].atom1.atomIndex);
                    bitSet.set(this.bonds[n2].atom2.atomIndex);
                }
                return bitSet;
            }
            case 141557762: {
                BitSet bitSet = new BitSet();
                BitSet bitSet2 = (BitSet)object;
                int n3 = this.bondCount;
                while (--n3 >= 0) {
                    if (!bitSet2.get(n3)) continue;
                    bitSet.set(this.bonds[n3].atom1.atomIndex);
                    bitSet.set(this.bonds[n3].atom2.atomIndex);
                }
                return bitSet;
            }
        }
        return super.getAtomBits(n, object);
    }
}

