/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.util;

public class Eigen {
    private double[] d;
    private double[] e;
    private double[][] Vx = new double[3][3];
    private double[][] Vo = new double[3][3];

    public Eigen(double[][] dArray) {
        int n;
        int n2;
        this.d = new double[3];
        this.e = new double[3];
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                double d = dArray[n2][n];
                this.Vo[n2][n] = d;
                this.Vx[n2][n] = d;
            }
        }
        this.tred2();
        this.tql2();
        for (n2 = 0; n2 < 2; ++n2) {
            int n3;
            n = n2;
            double d = this.d[n2];
            for (n3 = n2 + 1; n3 < 3; ++n3) {
                if (!(this.d[n3] < d)) continue;
                n = n3;
                d = this.d[n3];
            }
            if (n == n2) continue;
            this.d[n] = this.d[n2];
            this.d[n2] = d;
            for (n3 = 0; n3 < 3; ++n3) {
                d = this.Vx[n2][n3];
                this.Vx[n2][n3] = this.Vx[n][n3];
                this.Vx[n][n3] = d;
            }
        }
    }

    public double[][] getEigenvectors() {
        return this.Vx;
    }

    public double[] getEigenvalues() {
        return this.d;
    }

    private void tred2() {
        double d;
        int n;
        for (n = 0; n < 3; ++n) {
            this.d[n] = this.Vx[n][2];
        }
        for (n = 2; n > 0; --n) {
            int n2;
            d = 0.0;
            double d2 = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                d += Math.abs(this.d[n2]);
            }
            if (d == 0.0) {
                this.e[n] = this.d[n - 1];
                for (n2 = 0; n2 < n; ++n2) {
                    this.d[n2] = this.Vx[n2][n - 1];
                    this.Vx[n2][n] = 0.0;
                    this.Vx[n][n2] = 0.0;
                }
            } else {
                int n3;
                int n4;
                for (n2 = 0; n2 < n; ++n2) {
                    int n5 = n2;
                    this.d[n5] = this.d[n5] / d;
                    d2 += this.d[n2] * this.d[n2];
                }
                double d3 = this.d[n - 1];
                double d4 = Math.sqrt(d2);
                if (d3 > 0.0) {
                    d4 = -d4;
                }
                this.e[n] = d * d4;
                d2 -= d3 * d4;
                this.d[n - 1] = d3 - d4;
                for (n4 = 0; n4 < n; ++n4) {
                    this.e[n4] = 0.0;
                }
                for (n4 = 0; n4 < n; ++n4) {
                    this.Vx[n][n4] = d3 = this.d[n4];
                    d4 = this.e[n4] + this.Vx[n4][n4] * d3;
                    for (int i = n4 + 1; i <= n - 1; ++i) {
                        d4 += this.Vx[n4][i] * this.d[i];
                        int n6 = i;
                        this.e[n6] = this.e[n6] + this.Vx[n4][i] * d3;
                    }
                    this.e[n4] = d4;
                }
                d3 = 0.0;
                for (n4 = 0; n4 < n; ++n4) {
                    int n7 = n4;
                    this.e[n7] = this.e[n7] / d2;
                    d3 += this.e[n4] * this.d[n4];
                }
                double d5 = d3 / (d2 + d2);
                for (n3 = 0; n3 < n; ++n3) {
                    int n8 = n3;
                    this.e[n8] = this.e[n8] - d5 * this.d[n3];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    d3 = this.d[n3];
                    d4 = this.e[n3];
                    for (int i = n3; i <= n - 1; ++i) {
                        double[] dArray = this.Vx[n3];
                        int n9 = i;
                        dArray[n9] = dArray[n9] - (d3 * this.e[i] + d4 * this.d[i]);
                    }
                    this.d[n3] = this.Vx[n3][n - 1];
                    this.Vx[n3][n] = 0.0;
                }
            }
            this.d[n] = d2;
        }
        for (n = 0; n < 2; ++n) {
            int n10;
            this.Vx[n][2] = this.Vx[n][n];
            this.Vx[n][n] = 1.0;
            d = this.d[n + 1];
            if (d != 0.0) {
                for (n10 = 0; n10 <= n; ++n10) {
                    this.d[n10] = this.Vx[n + 1][n10] / d;
                }
                for (n10 = 0; n10 <= n; ++n10) {
                    int n11;
                    double d6 = 0.0;
                    for (n11 = 0; n11 <= n; ++n11) {
                        d6 += this.Vx[n + 1][n11] * this.Vx[n10][n11];
                    }
                    for (n11 = 0; n11 <= n; ++n11) {
                        double[] dArray = this.Vx[n10];
                        int n12 = n11;
                        dArray[n12] = dArray[n12] - d6 * this.d[n11];
                    }
                }
            }
            for (n10 = 0; n10 <= n; ++n10) {
                this.Vx[n + 1][n10] = 0.0;
            }
        }
        for (n = 0; n < 3; ++n) {
            this.d[n] = this.Vx[n][2];
            this.Vx[n][2] = 0.0;
        }
        this.Vx[2][2] = 1.0;
        this.e[0] = 0.0;
    }

    private void tql2() {
        for (int i = 1; i < 3; ++i) {
            this.e[i - 1] = this.e[i];
        }
        this.e[2] = 0.0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Math.pow(2.0, -52.0);
        for (int i = 0; i < 3; ++i) {
            int n;
            d2 = Math.max(d2, Math.abs(this.d[i]) + Math.abs(this.e[i]));
            for (n = i; n < 3 && !(Math.abs(this.e[n]) <= d3 * d2); ++n) {
            }
            if (n > i) {
                int n2 = 0;
                do {
                    double d4;
                    ++n2;
                    double d5 = this.d[i];
                    double d6 = (this.d[i + 1] - d5) / (2.0 * this.e[i]);
                    double d7 = Eigen.hypot(d6, 1.0);
                    if (d6 < 0.0) {
                        d7 = -d7;
                    }
                    this.d[i] = this.e[i] / (d6 + d7);
                    this.d[i + 1] = this.e[i] * (d6 + d7);
                    double d8 = this.d[i + 1];
                    double d9 = d5 - this.d[i];
                    int n3 = i + 2;
                    while (n3 < 3) {
                        int n4 = n3++;
                        this.d[n4] = this.d[n4] - d9;
                    }
                    d += d9;
                    d6 = this.d[n];
                    double d10 = d4 = 1.0;
                    double d11 = d4;
                    double d12 = this.e[i + 1];
                    double d13 = 0.0;
                    double d14 = 0.0;
                    for (int j = n - 1; j >= i; --j) {
                        d11 = d10;
                        d10 = d4;
                        d14 = d13;
                        d5 = d4 * this.e[j];
                        d9 = d4 * d6;
                        d7 = Eigen.hypot(d6, this.e[j]);
                        this.e[j + 1] = d13 * d7;
                        d13 = this.e[j] / d7;
                        d4 = d6 / d7;
                        d6 = d4 * this.d[j] - d13 * d5;
                        this.d[j + 1] = d9 + d13 * (d4 * d5 + d13 * this.d[j]);
                        for (int k = 0; k < 3; ++k) {
                            d9 = this.Vx[j + 1][k];
                            this.Vx[j + 1][k] = d13 * this.Vx[j][k] + d4 * d9;
                            this.Vx[j][k] = d4 * this.Vx[j][k] - d13 * d9;
                        }
                    }
                    d6 = -d13 * d14 * d11 * d12 * this.e[i] / d8;
                    this.e[i] = d13 * d6;
                    this.d[i] = d4 * d6;
                } while (Math.abs(this.e[i]) > d3 * d2);
            }
            this.d[i] = this.d[i] + d;
            this.e[i] = 0.0;
        }
    }

    private static double hypot(double d, double d2) {
        double d3;
        if (Math.abs(d) > Math.abs(d2)) {
            d3 = d2 / d;
            d3 = Math.abs(d) * Math.sqrt(1.0 + d3 * d3);
        } else if (d2 != 0.0) {
            d3 = d / d2;
            d3 = Math.abs(d2) * Math.sqrt(1.0 + d3 * d3);
        } else {
            d3 = 0.0;
        }
        return d3;
    }

    public void dump() {
        System.out.println("-----Eigen input-----");
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                System.out.print(this.Vo[i][j] + "\t");
            }
            System.out.println();
        }
        this.dump(0);
        this.dump(1);
        this.dump(2);
    }

    private void dump(int n) {
        System.out.println("Eigen: lambda = " + this.d[n] + " for " + this.Vx[n][0] + " " + this.Vx[n][1] + " " + this.Vx[n][2]);
    }

    public static float[][] toFloat3x3(double[][] dArray) {
        float[][] fArray = new float[3][3];
        int n = 3;
        while (--n >= 0) {
            int n2 = 3;
            while (--n2 >= 0) {
                fArray[n][n2] = (float)dArray[n][n2];
            }
        }
        return fArray;
    }

    public static float[] toFloat(double[] dArray) {
        float[] fArray = new float[dArray.length];
        int n = dArray.length;
        while (--n >= 0) {
            fArray[n] = (float)dArray[n];
        }
        return fArray;
    }
}

