/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;

public class VolumeData {
    public final Point3f volumetricOrigin = new Point3f();
    public final float[] origin = new float[3];
    public final Vector3f[] volumetricVectors = new Vector3f[3];
    public final int[] voxelCounts = new int[3];
    public float[][][] voxelData;
    public final float[] volumetricVectorLengths = new float[3];
    public final Vector3f[] unitVolumetricVectors = new Vector3f[3];
    private final Matrix3f volumetricMatrix = new Matrix3f();
    Point4f thePlane;
    private float thePlaneNormalMag;
    private final Point3f ptXyzTemp = new Point3f();
    private final Vector3f pointVector = new Vector3f();

    public VolumeData() {
        this.volumetricVectors[0] = new Vector3f();
        this.volumetricVectors[1] = new Vector3f();
        this.volumetricVectors[2] = new Vector3f();
        this.unitVolumetricVectors[0] = new Vector3f();
        this.unitVolumetricVectors[1] = new Vector3f();
        this.unitVolumetricVectors[2] = new Vector3f();
    }

    public void setVoxelData(float[][][] fArray) {
        this.voxelData = fArray;
    }

    public void setVolumetricVector(int n, float f, float f2, float f3) {
        this.volumetricVectors[n].x = f;
        this.volumetricVectors[n].y = f2;
        this.volumetricVectors[n].z = f3;
    }

    public void setMatrix() {
        for (int i = 0; i < 3; ++i) {
            this.volumetricMatrix.setColumn(i, this.volumetricVectors[i]);
        }
    }

    public void transform(Vector3f vector3f, Vector3f vector3f2) {
        this.volumetricMatrix.transform(vector3f, vector3f2);
    }

    public void setPlaneParameters(Point4f point4f) {
        this.thePlane = point4f;
        this.thePlaneNormalMag = new Vector3f(point4f.x, point4f.y, point4f.z).length();
    }

    public float calcVoxelPlaneDistance(int n, int n2, int n3) {
        this.voxelPtToXYZ(n, n2, n3, this.ptXyzTemp);
        return (this.thePlane.x * this.ptXyzTemp.x + this.thePlane.y * this.ptXyzTemp.y + this.thePlane.z * this.ptXyzTemp.z + this.thePlane.w) / this.thePlaneNormalMag;
    }

    public float distancePointToPlane(Point3f point3f) {
        return (this.thePlane.x * point3f.x + this.thePlane.y * point3f.y + this.thePlane.z * point3f.z + this.thePlane.w) / this.thePlaneNormalMag;
    }

    public void voxelPtToXYZ(int n, int n2, int n3, Point3f point3f) {
        point3f.scaleAdd(n, this.volumetricVectors[0], this.volumetricOrigin);
        point3f.scaleAdd(n2, this.volumetricVectors[1], point3f);
        point3f.scaleAdd(n3, this.volumetricVectors[2], point3f);
    }

    public void setUnitVectors() {
        for (int i = 0; i < 3; ++i) {
            this.volumetricVectorLengths[i] = this.volumetricVectors[i].length();
            this.unitVolumetricVectors[i].normalize(this.volumetricVectors[i]);
        }
        this.origin[0] = this.volumetricOrigin.x;
        this.origin[1] = this.volumetricOrigin.y;
        this.origin[2] = this.volumetricOrigin.z;
    }

    private float scaleByVoxelVector(Vector3f vector3f, int n) {
        return vector3f.dot(this.unitVolumetricVectors[n]) / this.volumetricVectorLengths[n];
    }

    public void xyzToVoxelPt(float f, float f2, float f3, Point3i point3i) {
        this.pointVector.set(f, f2, f3);
        this.setVoxelPoint();
        point3i.set((int)this.ptXyzTemp.x, (int)this.ptXyzTemp.y, (int)this.ptXyzTemp.z);
    }

    private void setVoxelPoint() {
        this.pointVector.sub(this.volumetricOrigin);
        this.ptXyzTemp.x = this.scaleByVoxelVector(this.pointVector, 0);
        this.ptXyzTemp.y = this.scaleByVoxelVector(this.pointVector, 1);
        this.ptXyzTemp.z = this.scaleByVoxelVector(this.pointVector, 2);
    }

    public float lookupInterpolatedVoxelValue(Point3f point3f) {
        this.pointVector.set(point3f);
        this.setVoxelPoint();
        return this.getInterpolatedVoxelValue(this.ptXyzTemp);
    }

    private float getInterpolatedVoxelValue(Point3f point3f) {
        int n = this.voxelCounts[0] - 1;
        int n2 = VolumeData.indexDown(point3f.x, n);
        int n3 = n2 + (point3f.x < 0.0f || n2 == n ? 0 : 1);
        n = this.voxelCounts[1] - 1;
        int n4 = VolumeData.indexDown(point3f.y, n);
        int n5 = n4 + (point3f.y < 0.0f || n4 == n ? 0 : 1);
        n = this.voxelCounts[2] - 1;
        int n6 = VolumeData.indexDown(point3f.z, n);
        int n7 = n6 + (point3f.z < 0.0f || n6 == n ? 0 : 1);
        float f = VolumeData.getFractional2DValue(point3f.x - (float)n2, point3f.y - (float)n4, this.voxelData[n2][n4][n6], this.voxelData[n3][n4][n6], this.voxelData[n2][n5][n6], this.voxelData[n3][n5][n6]);
        float f2 = VolumeData.getFractional2DValue(point3f.x - (float)n2, point3f.y - (float)n4, this.voxelData[n2][n4][n7], this.voxelData[n3][n4][n7], this.voxelData[n2][n5][n7], this.voxelData[n3][n5][n7]);
        return f + (point3f.z - (float)n6) * (f2 - f);
    }

    public static float getFractional2DValue(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f3 + f * (f4 - f3);
        float f8 = f5 + f * (f6 - f5);
        return f7 + f2 * (f8 - f7);
    }

    private static int indexDown(float f, int n) {
        if (f < 0.0f) {
            return 0;
        }
        int n2 = (int)f;
        return n2 > n ? n : n2;
    }

    void offsetCenter(Point3f point3f) {
        Point3f point3f2 = new Point3f();
        point3f2.scaleAdd((float)(this.voxelCounts[0] - 1) / 2.0f, this.volumetricVectors[0], point3f2);
        point3f2.scaleAdd((float)(this.voxelCounts[1] - 1) / 2.0f, this.volumetricVectors[1], point3f2);
        point3f2.scaleAdd((float)(this.voxelCounts[2] - 1) / 2.0f, this.volumetricVectors[2], point3f2);
        this.volumetricOrigin.sub(point3f, point3f2);
    }

    public void setDataDistanceToPlane(Point4f point4f) {
        this.setPlaneParameters(point4f);
        int n = this.voxelCounts[0];
        int n2 = this.voxelCounts[1];
        int n3 = this.voxelCounts[2];
        this.voxelData = new float[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    this.voxelData[i][j][k] = this.calcVoxelPlaneDistance(i, j, k);
                }
            }
        }
    }

    public void filterData(boolean bl, float f) {
        int n;
        int n2;
        int n3;
        boolean bl2 = !Float.isNaN(f);
        int n4 = this.voxelCounts[0];
        int n5 = this.voxelCounts[1];
        int n6 = this.voxelCounts[2];
        if (bl) {
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n < n6; ++n) {
                        this.voxelData[n3][n2][n] = this.voxelData[n3][n2][n] * this.voxelData[n3][n2][n];
                    }
                }
            }
        }
        if (bl2) {
            for (n3 = 0; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n < n6; ++n) {
                        this.voxelData[n3][n2][n] = f - this.voxelData[n3][n2][n];
                    }
                }
            }
        }
    }

    public void capData(Point4f point4f, float f) {
        int n = this.voxelCounts[0];
        int n2 = this.voxelCounts[1];
        int n3 = this.voxelCounts[2];
        Vector3f vector3f = new Vector3f(point4f.x, point4f.y, point4f.z);
        vector3f.normalize();
        float f2 = 1.0f;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    float f3 = this.voxelData[i][j][k] - f;
                    this.voxelPtToXYZ(i, j, k, this.ptXyzTemp);
                    float f4 = (this.ptXyzTemp.x * vector3f.x + this.ptXyzTemp.y * vector3f.y + this.ptXyzTemp.z * vector3f.z + point4f.w - f) / f2;
                    if (!(f4 >= 0.0f) && !(f4 > f3)) continue;
                    this.voxelData[i][j][k] = f4;
                }
            }
        }
    }
}

