/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jcamp;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;

public class GraphCharacteristics {
    private static final String INTEGRATION_VALUES_DELIM = ":";
    private static final String INTEGRATION_DELIM = ",";
    private static final int MAX_DECIMALS = 2;
    private boolean _zoomIn;
    private boolean _integrate;
    private boolean _grid;
    private boolean _reverse;
    private String _allIntegrationValues = null;
    private Hashtable _integrationValues = null;
    private ArrayList _unsortedIntegrationValues = null;
    private String _textColor = null;
    private String _axisColor = null;
    private String _axisTextColor = null;
    private String _integrateCurveColor = null;
    private String _integrateTextColor = null;
    private String _graphCurveColor = null;
    private DecimalFormat _decForm = null;
    private String _lastPoint = null;

    public GraphCharacteristics() {
        this._zoomIn = false;
        this._integrate = false;
        this._grid = false;
        this._reverse = false;
        this._allIntegrationValues = new String();
        this._integrationValues = new Hashtable();
        this._unsortedIntegrationValues = new ArrayList();
        this._decForm = null;
    }

    public GraphCharacteristics(boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this._zoomIn = bl;
        this._integrate = bl2;
        this._grid = bl3;
        this._reverse = bl4;
        this._allIntegrationValues = string;
        this.setIntegrationValues(this._unsortedIntegrationValues);
        this._axisColor = string2;
        this._axisTextColor = string3;
        this._integrateCurveColor = string4;
        this._integrateTextColor = string7;
        this._graphCurveColor = string5;
        this._textColor = string6;
        this._decForm = null;
    }

    public void setIntegrationValues(ArrayList arrayList) {
        String[] stringArray = null;
        String string = new String();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            string = (String)arrayList.get(i);
            stringArray = string.split(INTEGRATION_VALUES_DELIM);
            hashtable.put(stringArray[0], stringArray[1]);
        }
        this._integrationValues = hashtable;
    }

    public void setUnsortedIntegrationValues(String string) {
        String[] stringArray = string.split(INTEGRATION_DELIM);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        this._unsortedIntegrationValues = arrayList;
        this.setIntegrationValues(arrayList);
    }

    private String isIntegrationCurvePoint(Double d) {
        String[] stringArray = new String[]{"####.00", "####.0", "####"};
        for (int i = 0; i <= 2; ++i) {
            this._decForm = new DecimalFormat(stringArray[i]);
            if (!this._integrationValues.containsKey(this._decForm.format(d))) continue;
            if (this._lastPoint == null || !this._lastPoint.equalsIgnoreCase(this._decForm.format(d))) {
                this._lastPoint = this._decForm.format(d);
                return this._decForm.format(d);
            }
            return null;
        }
        return null;
    }

    public String getIntegrationCurveAreaValue(Double d) {
        String string = this.isIntegrationCurvePoint(d);
        if (string != null) {
            return (String)this._integrationValues.get(string);
        }
        return null;
    }

    public void setZoomIn(boolean bl) {
        this._zoomIn = bl;
    }

    public boolean getZoomIn() {
        return this._zoomIn;
    }

    public void setGrid(boolean bl) {
        this._grid = bl;
    }

    public boolean getGrid() {
        return this._grid;
    }

    public void setIntegrate(boolean bl) {
        this._integrate = bl;
    }

    public boolean getIntegrate() {
        return this._integrate;
    }

    public void setReverse(boolean bl) {
        this._reverse = bl;
    }

    public boolean getReverse() {
        return this._reverse;
    }

    public void setIntegrationValues() {
    }

    public void setAxisColor(String string) {
        this._axisColor = string;
    }

    public String getAxisColor() {
        return this._axisColor;
    }

    public void setAxisTextColor(String string) {
        this._axisTextColor = string;
    }

    public String getAxisTextColor() {
        return this._axisTextColor;
    }

    public void setIntegrateCurveColor(String string) {
        this._integrateCurveColor = string;
    }

    public String getIntegrateCurveColor() {
        return this._integrateCurveColor;
    }

    public void setGraphCurveColor(String string) {
        this._graphCurveColor = string;
    }

    public String getGraphCurveColor() {
        return this._graphCurveColor;
    }

    public void setTextColor(String string) {
        this._textColor = string;
    }

    public String getTextColor() {
        return this._textColor;
    }

    public void setIntegrateTextColor(String string) {
        this._integrateTextColor = string;
    }

    public String getIntegrateTextColor() {
        return this._integrateTextColor;
    }
}

