/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import org.jmol.g3d.Awt3D;
import org.jmol.g3d.Swing3D;

abstract class Platform3D {
    int windowWidth;
    int windowHeight;
    int windowSize;
    int bufferWidth;
    int bufferHeight;
    int bufferSize;
    int bufferSizeT;
    Image imagePixelBuffer;
    int[] pBuffer;
    int[] pBufferT;
    int[] zBuffer;
    int[] zBufferT;
    int argbBackground;
    int widthOffscreen;
    int heightOffscreen;
    Image imageOffscreen;
    Graphics gOffscreen;
    static final boolean forcePlatformAWT = false;
    static final boolean desireClearingThread = false;
    boolean useClearingThread = true;
    ClearingThread clearingThread;

    Platform3D() {
    }

    static Platform3D createInstance(Component component) {
        boolean bl = System.getProperty("java.version").compareTo("1.2") >= 0;
        boolean bl2 = bl;
        Platform3D platform3D = bl2 ? Platform3D.allocateSwing3D() : new Awt3D(component);
        platform3D.initialize(false);
        return platform3D;
    }

    private static Platform3D allocateSwing3D() {
        return new Swing3D();
    }

    final void initialize(boolean bl) {
        this.useClearingThread = bl;
        if (bl) {
            this.clearingThread = new ClearingThread();
            this.clearingThread.start();
        }
    }

    abstract Image allocateImage();

    void allocateTBuffers(boolean bl) {
        this.bufferSizeT = bl ? this.bufferSize : this.windowSize;
        this.zBufferT = new int[this.bufferSizeT];
        this.pBufferT = new int[this.bufferSizeT];
    }

    void allocateBuffers(int n, int n2, boolean bl) {
        this.windowWidth = n;
        this.windowHeight = n2;
        this.windowSize = n * n2;
        if (bl) {
            this.bufferWidth = n * 2;
            this.bufferHeight = n2 * 2;
        } else {
            this.bufferWidth = n;
            this.bufferHeight = n2;
        }
        this.bufferSize = this.bufferWidth * this.bufferHeight;
        this.zBuffer = new int[this.bufferSize];
        this.pBuffer = new int[this.bufferSize];
        this.imagePixelBuffer = this.allocateImage();
    }

    void releaseBuffers() {
        this.bufferSize = -1;
        this.bufferHeight = -1;
        this.bufferWidth = -1;
        this.windowHeight = -1;
        this.windowWidth = -1;
        if (this.imagePixelBuffer != null) {
            this.imagePixelBuffer.flush();
            this.imagePixelBuffer = null;
        }
        this.pBuffer = null;
        this.zBuffer = null;
        this.pBufferT = null;
        this.zBufferT = null;
    }

    void setBackground(int n) {
        if (this.argbBackground != n) {
            this.argbBackground = n;
            if (this.useClearingThread) {
                this.clearingThread.notifyBackgroundChange(n);
            }
        }
    }

    boolean hasContent() {
        int n = this.bufferSize;
        while (--n >= 0) {
            if (this.zBuffer[n] == Integer.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    void clearScreenBuffer(int n) {
        int n2 = this.bufferSize;
        while (--n2 >= 0) {
            this.zBuffer[n2] = Integer.MAX_VALUE;
            this.pBuffer[n2] = n;
        }
    }

    void clearTBuffer() {
        int n = this.bufferSizeT;
        while (--n >= 0) {
            this.zBufferT[n] = Integer.MAX_VALUE;
            this.pBufferT[n] = 0;
        }
    }

    final void obtainScreenBuffer() {
        if (this.useClearingThread) {
            this.clearingThread.obtainBufferForClient();
        } else {
            this.clearScreenBuffer(this.argbBackground);
        }
    }

    final void clearScreenBufferThreaded() {
        if (this.useClearingThread) {
            this.clearingThread.releaseBufferForClearing();
        }
    }

    void notifyEndOfRendering() {
    }

    abstract Image allocateOffscreenImage(int var1, int var2);

    abstract Graphics getGraphics(Image var1);

    void checkOffscreenSize(int n, int n2) {
        if (n <= this.widthOffscreen && n2 <= this.heightOffscreen) {
            return;
        }
        if (this.imageOffscreen != null) {
            this.gOffscreen.dispose();
            this.imageOffscreen.flush();
        }
        if (n > this.widthOffscreen) {
            this.widthOffscreen = n + 63 & 0xFFFFFFC0;
        }
        if (n2 > this.heightOffscreen) {
            this.heightOffscreen = n2 + 15 & 0xFFFFFFF0;
        }
        this.imageOffscreen = this.allocateOffscreenImage(this.widthOffscreen, this.heightOffscreen);
        this.gOffscreen = this.getGraphics(this.imageOffscreen);
    }

    class ClearingThread
    extends Thread
    implements Runnable {
        boolean bufferHasBeenCleared = false;
        boolean clientHasBuffer = false;

        ClearingThread() {
        }

        synchronized void notifyBackgroundChange(int n) {
            this.bufferHasBeenCleared = false;
            this.notify();
        }

        synchronized void obtainBufferForClient() {
            while (!this.bufferHasBeenCleared) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.clientHasBuffer = true;
        }

        synchronized void releaseBufferForClearing() {
            this.clientHasBuffer = false;
            this.bufferHasBeenCleared = false;
            this.notify();
        }

        synchronized void waitForClientRelease() {
            while (this.clientHasBuffer || this.bufferHasBeenCleared) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        synchronized void notifyBufferReady() {
            this.bufferHasBeenCleared = true;
            this.notify();
        }

        public void run() {
            while (true) {
                int n;
                this.waitForClientRelease();
                do {
                    n = Platform3D.this.argbBackground;
                    Platform3D.this.clearScreenBuffer(n);
                } while (n != Platform3D.this.argbBackground);
                this.notifyBufferReady();
            }
        }
    }
}

