/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Component;
import java.awt.Image;
import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolExportInterface;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Circle3D;
import org.jmol.g3d.Colix3D;
import org.jmol.g3d.Cylinder3D;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Hermite3D;
import org.jmol.g3d.Line3D;
import org.jmol.g3d.Normix3D;
import org.jmol.g3d.Platform3D;
import org.jmol.g3d.Rgb16;
import org.jmol.g3d.Shade3D;
import org.jmol.g3d.Sphere3D;
import org.jmol.g3d.Text3D;
import org.jmol.g3d.Triangle3D;
import org.jmol.shape.ShapeRenderer;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public final class Graphics3D
implements JmolRendererInterface {
    Platform3D platform;
    Line3D line3d;
    Circle3D circle3d;
    Sphere3D sphere3d;
    Triangle3D triangle3d;
    Cylinder3D cylinder3d;
    Hermite3D hermite3d;
    Normix3D normix3d;
    boolean isFullSceneAntialiasingEnabled;
    private boolean antialiasThisFrame;
    private boolean antialias2;
    private boolean antialiasEnabled;
    boolean inGreyscaleMode;
    byte[] anaglyphChannelBytes;
    boolean twoPass = false;
    boolean isPass2;
    boolean addAllPixels;
    boolean haveTranslucentObjects;
    int windowWidth;
    int windowHeight;
    int width;
    int height;
    int displayMinX;
    int displayMaxX;
    int displayMinY;
    int displayMaxY;
    int slab;
    int depth;
    boolean zShade;
    int xLast;
    int yLast;
    private int[] pbuf;
    private int[] pbufT;
    int[] zbuf;
    private int[] zbufT;
    int bufferSize;
    short colixCurrent;
    int[] shadesCurrent;
    int argbCurrent;
    boolean isTranslucent;
    boolean isScreened;
    int translucencyMask;
    int argbNoisyUp;
    int argbNoisyDn;
    Font3D font3dCurrent;
    public static final byte ENDCAPS_NONE = 0;
    public static final byte ENDCAPS_OPEN = 1;
    public static final byte ENDCAPS_FLAT = 2;
    public static final byte ENDCAPS_SPHERICAL = 3;
    public static final byte shadeMax = 64;
    public static final byte shadeLast = 63;
    public static final byte shadeNormal = Shade3D.shadeNormal;
    public static final byte intensitySpecularSurfaceLimit = Shade3D.intensitySpecularSurfaceLimit;
    public static final short INHERIT_ALL = 0;
    public static final short USE_PALETTE = 2;
    public static final short BLACK = 4;
    public static final short ORANGE = 5;
    public static final short PINK = 6;
    public static final short BLUE = 7;
    public static final short WHITE = 8;
    public static final short CYAN = 9;
    public static final short RED = 10;
    public static final short GREEN = 11;
    public static final short GRAY = 12;
    public static final short SILVER = 13;
    public static final short LIME = 14;
    public static final short MAROON = 15;
    public static final short NAVY = 16;
    public static final short OLIVE = 17;
    public static final short PURPLE = 18;
    public static final short TEAL = 19;
    public static final short MAGENTA = 20;
    public static final short YELLOW = 21;
    public static final short HOTPINK = 22;
    public static final short GOLD = 23;
    int newWindowWidth;
    int newWindowHeight;
    boolean newAntialiasing;
    int anaglyphLength;
    private int backgroundArgb;
    private int currentIntensity;
    int zMargin;
    boolean currentlyRendering;
    private static final short CHANGEABLE_MASK = Short.MIN_VALUE;
    private static final short UNMASK_CHANGEABLE_TRANSLUCENT = 2047;
    private static final int TRANSLUCENT_SHIFT = 11;
    private static final int ALPHA_SHIFT = 13;
    private static final int TRANSLUCENT_MASK = 30720;
    private static final int TRANSLUCENT_SCREENED = 30720;
    private static final int TRANSPARENT = 16384;
    static final int TRANSLUCENT_50 = 8192;
    public static final short OPAQUE_MASK = -30721;
    private static final short INHERIT_COLOR = 1;
    static final short UNUSED_OPTION3 = 3;
    static final short SPECIAL_COLIX_MAX = 4;
    private short[] changeableColixMap = new short[16];
    static final float[] lighting = Shade3D.lighting;
    private final Vector3f vectorAB = new Vector3f();
    private final Vector3f vectorAC = new Vector3f();
    private final Vector3f vectorNormal = new Vector3f();
    private static final String[] colorNames = new String[]{"black", "pewhite", "pecyan", "pepurple", "pegreen", "peblue", "peviolet", "pebrown", "pepink", "peyellow", "pedarkgreen", "peorange", "pelightblue", "pedarkcyan", "pedarkgray", "aliceblue", "antiquewhite", "aqua", "aquamarine", "azure", "beige", "bisque", "blanchedalmond", "blue", "blueviolet", "brown", "burlywood", "cadetblue", "chartreuse", "chocolate", "coral", "cornflowerblue", "cornsilk", "crimson", "cyan", "darkblue", "darkcyan", "darkgoldenrod", "darkgray", "darkgreen", "darkkhaki", "darkmagenta", "darkolivegreen", "darkorange", "darkorchid", "darkred", "darksalmon", "darkseagreen", "darkslateblue", "darkslategray", "darkturquoise", "darkviolet", "deeppink", "deepskyblue", "dimgray", "dodgerblue", "firebrick", "floralwhite", "forestgreen", "fuchsia", "gainsboro", "ghostwhite", "gold", "goldenrod", "gray", "green", "greenyellow", "honeydew", "hotpink", "indianred", "indigo", "ivory", "khaki", "lavender", "lavenderblush", "lawngreen", "lemonchiffon", "lightblue", "lightcoral", "lightcyan", "lightgoldenrodyellow", "lightgreen", "lightgrey", "lightpink", "lightsalmon", "lightseagreen", "lightskyblue", "lightslategray", "lightsteelblue", "lightyellow", "lime", "limegreen", "linen", "magenta", "maroon", "mediumaquamarine", "mediumblue", "mediumorchid", "mediumpurple", "mediumseagreen", "mediumslateblue", "mediumspringgreen", "mediumturquoise", "mediumvioletred", "midnightblue", "mintcream", "mistyrose", "moccasin", "navajowhite", "navy", "oldlace", "olive", "olivedrab", "orange", "orangered", "orchid", "palegoldenrod", "palegreen", "paleturquoise", "palevioletred", "papayawhip", "peachpuff", "peru", "pink", "plum", "powderblue", "purple", "red", "rosybrown", "royalblue", "saddlebrown", "salmon", "sandybrown", "seagreen", "seashell", "sienna", "silver", "skyblue", "slateblue", "slategray", "snow", "springgreen", "steelblue", "tan", "teal", "thistle", "tomato", "turquoise", "violet", "wheat", "white", "whitesmoke", "yellow", "yellowgreen", "bluetint", "greenblue", "greentint", "grey", "pinktint", "redorange", "yellowtint"};
    private static final int[] colorArgbs = new int[]{-16777216, -1, -16711681, -3137281, -16711936, -10460929, -32576, -6021080, -10024, -256, -16728064, -20480, -5197569, -16736096, -10461088, -984833, -332841, -16711681, -8388652, -983041, -657956, -6972, -5171, -16776961, -7722014, -5952982, -2180985, -10510688, -8388864, -2987746, -32944, -10185235, -1828, -2354116, -16711681, -16777077, -16741493, -4684277, -5658199, -16751616, -4343957, -7667573, -11179217, -29696, -6737204, -7667712, -1468806, -7357297, -12042869, -13676721, -16724271, -7077677, -60269, -16728065, -9868951, -14774017, -5103070, -1296, -14513374, -65281, -2302756, -460545, -10496, -2448096, -8355712, -16744448, -5374161, -983056, -38476, -3318692, -11861886, -16, -989556, -1644806, -3851, -8586240, -1331, -5383962, -1015680, -2031617, -329006, -7278960, -2894893, -18751, -24454, -14634326, -7876870, -8943463, -5192482, -32, -16711936, -13447886, -331546, -65281, -8388608, -10039894, -16777011, -4565549, -7114533, -12799119, -8689426, -16713062, -12004916, -3730043, -15132304, -655366, -6943, -6987, -8531, -16777088, -133658, -8355840, -9728477, -23296, -47872, -2461482, -1120086, -6751336, -5247250, -2396013, -4139, -9543, -3308225, -16181, -2252579, -5185306, -8388480, -65536, -4419697, -12490271, -7650029, -360334, -744352, -13726889, -2578, -6270419, -4144960, -7876885, -9807155, -9404272, -1286, -16711809, -12156236, -2968436, -16744320, -2572328, -40121, -12525360, -1146130, -663885, -1, -657931, -256, -6632142, -5253121, -13726889, -6750285, -8355712, -21573, -47872, -592267};
    private static final Hashtable mapJavaScriptColors = new Hashtable();

    public void destroy() {
        this.releaseBuffers();
        this.platform = null;
    }

    public boolean isDisplayAntialiased() {
        return this.antialiasEnabled;
    }

    public boolean isAntialiased() {
        return this.antialiasThisFrame;
    }

    public Graphics3D(Component component) {
        this.platform = Platform3D.createInstance(component);
        this.line3d = new Line3D(this);
        this.circle3d = new Circle3D(this);
        this.sphere3d = new Sphere3D(this);
        this.triangle3d = new Triangle3D(this);
        this.cylinder3d = new Cylinder3D(this);
        this.hermite3d = new Hermite3D(this);
        this.normix3d = new Normix3D();
    }

    public void setg3dExporter(Graphics3D graphics3D, JmolExportInterface jmolExportInterface) {
    }

    public JmolExportInterface getExporter() {
        return null;
    }

    public void setRenderer(ShapeRenderer shapeRenderer) {
    }

    public boolean currentlyRendering() {
        return this.currentlyRendering;
    }

    public void setWindowParameters(int n, int n2, boolean bl) {
        this.newWindowWidth = n;
        this.newWindowHeight = n2;
        this.newAntialiasing = bl;
        if (this.currentlyRendering) {
            this.endRendering();
        }
    }

    private void setWidthHeight(boolean bl) {
        this.width = this.windowWidth;
        this.height = this.windowHeight;
        if (bl) {
            this.width <<= 1;
            this.height <<= 1;
        }
        this.xLast = this.width - 1;
        this.yLast = this.height - 1;
        this.displayMinX = -(this.width >> 1);
        this.displayMaxX = this.width - this.displayMinX;
        this.displayMinY = -(this.height >> 1);
        this.displayMaxY = this.height - this.displayMinY;
        this.bufferSize = this.width * this.height;
    }

    public boolean checkTranslucent(boolean bl) {
        if (bl) {
            this.haveTranslucentObjects = true;
        }
        return !this.twoPass || this.twoPass && this.isPass2 == bl;
    }

    public void beginRendering(Matrix3f matrix3f) {
        if (this.currentlyRendering) {
            this.endRendering();
        }
        if (this.windowWidth != this.newWindowWidth || this.windowHeight != this.newWindowHeight || this.newAntialiasing != this.isFullSceneAntialiasingEnabled) {
            this.windowWidth = this.newWindowWidth;
            this.windowHeight = this.newWindowHeight;
            this.isFullSceneAntialiasingEnabled = this.newAntialiasing;
            this.releaseBuffers();
        }
        this.normix3d.setRotationMatrix(matrix3f);
        this.antialiasEnabled = this.antialiasThisFrame = this.newAntialiasing;
        this.currentlyRendering = true;
        this.twoPass = true;
        this.isPass2 = false;
        this.colixCurrent = 0;
        this.haveTranslucentObjects = false;
        this.addAllPixels = true;
        if (this.pbuf == null) {
            this.platform.allocateBuffers(this.windowWidth, this.windowHeight, this.antialiasThisFrame);
            this.pbuf = this.platform.pBuffer;
            this.zbuf = this.platform.zBuffer;
        }
        this.setWidthHeight(this.antialiasThisFrame);
        this.platform.obtainScreenBuffer();
    }

    private void releaseBuffers() {
        this.pbuf = null;
        this.zbuf = null;
        this.pbufT = null;
        this.zbufT = null;
        this.platform.releaseBuffers();
    }

    public boolean setPass2(boolean bl) {
        if (!this.haveTranslucentObjects || !this.currentlyRendering) {
            return false;
        }
        this.isPass2 = true;
        this.colixCurrent = 0;
        this.addAllPixels = true;
        if (this.pbufT == null || this.antialias2 != bl) {
            this.platform.allocateTBuffers(bl);
            this.pbufT = this.platform.pBufferT;
            this.zbufT = this.platform.zBufferT;
        }
        this.antialias2 = bl;
        if (this.antialiasThisFrame && !this.antialias2) {
            this.downsampleFullSceneAntialiasing(true);
        }
        this.platform.clearTBuffer();
        return true;
    }

    public void endRendering() {
        if (!this.currentlyRendering) {
            return;
        }
        if (this.pbuf != null) {
            if (this.isPass2) {
                this.mergeOpaqueAndTranslucentBuffers();
            }
            if (this.antialiasThisFrame) {
                this.downsampleFullSceneAntialiasing(false);
            }
        }
        this.platform.notifyEndOfRendering();
        this.currentlyRendering = false;
    }

    public void snapshotAnaglyphChannelBytes() {
        if (this.currentlyRendering) {
            throw new NullPointerException();
        }
        this.anaglyphLength = this.windowWidth * this.windowHeight;
        if (this.anaglyphChannelBytes == null || this.anaglyphChannelBytes.length != this.anaglyphLength) {
            this.anaglyphChannelBytes = new byte[this.anaglyphLength];
        }
        int n = this.anaglyphLength;
        while (--n >= 0) {
            this.anaglyphChannelBytes[n] = (byte)this.pbuf[n];
        }
    }

    public void applyCustomAnaglyph(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1] & 0xFFFFFF;
        int n3 = this.anaglyphLength;
        while (--n3 >= 0) {
            int n4 = this.anaglyphChannelBytes[n3] & 0xFF;
            n4 = (n4 | (n4 | n4 << 8) << 8) & n2;
            this.pbuf[n3] = this.pbuf[n3] & n | n4;
        }
    }

    public void applyGreenAnaglyph() {
        int n = this.anaglyphLength;
        while (--n >= 0) {
            int n2 = (this.anaglyphChannelBytes[n] & 0xFF) << 8;
            this.pbuf[n] = this.pbuf[n] & 0xFFFF0000 | n2;
        }
    }

    public void applyBlueAnaglyph() {
        int n = this.anaglyphLength;
        while (--n >= 0) {
            int n2 = this.anaglyphChannelBytes[n] & 0xFF;
            this.pbuf[n] = this.pbuf[n] & 0xFFFF0000 | n2;
        }
    }

    public void applyCyanAnaglyph() {
        int n = this.anaglyphLength;
        while (--n >= 0) {
            int n2 = this.anaglyphChannelBytes[n] & 0xFF;
            int n3 = n2 << 8 | n2;
            this.pbuf[n] = this.pbuf[n] & 0xFFFF0000 | n3;
        }
    }

    public Image getScreenImage() {
        return this.platform.imagePixelBuffer;
    }

    public void releaseScreenImage() {
        this.platform.clearScreenBufferThreaded();
    }

    public boolean haveTranslucentObjects() {
        return this.haveTranslucentObjects;
    }

    public int getRenderWidth() {
        return this.width;
    }

    public int getRenderHeight() {
        return this.height;
    }

    public int getSlab() {
        return this.slab;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setBackgroundArgb(int n) {
        this.backgroundArgb = n + ((n & 0xFF) == 255 ? -1 : 1);
        this.platform.setBackground(this.backgroundArgb);
    }

    public void setGreyscaleMode(boolean bl) {
        this.inGreyscaleMode = bl;
    }

    public void setSlabAndDepthValues(int n, int n2, boolean bl) {
        this.slab = n < 0 ? 0 : n;
        this.depth = n2 < 0 ? 0 : n2;
        this.zShade = bl;
    }

    public void setSlab(int n) {
        this.slab = n;
    }

    int getZShift(int n) {
        return this.zShade ? (n - this.slab) * 5 / (this.depth - this.slab) : 0;
    }

    private void downsampleFullSceneAntialiasing(boolean bl) {
        int n;
        int n2;
        int n3 = this.width;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.windowHeight;
        while (--n6 >= 0) {
            n2 = this.windowWidth;
            while (--n2 >= 0) {
                n = this.pbuf[n5] >> 2 & 0x3F3F3F3F;
                n += this.pbuf[n5++ + n3] >> 2 & 0x3F3F3F3F;
                n += this.pbuf[n5] >> 2 & 0x3F3F3F3F;
                n += this.pbuf[n5++ + n3] >> 2 & 0x3F3F3F3F;
                n += (n & 0xC0C0C0C0) >> 6;
                this.pbuf[n4] = n & 0xFFFFFF;
                ++n4;
            }
            n5 += n3;
        }
        if (bl) {
            n5 = 0;
            n4 = 0;
            n6 = this.windowHeight;
            while (--n6 >= 0) {
                n2 = this.windowWidth;
                while (--n2 >= 0) {
                    n = Math.min(this.zbuf[n5], this.zbuf[n5 + n3]);
                    n = Math.min(n, this.zbuf[++n5]);
                    if ((n = Math.min(n, this.zbuf[n5 + n3])) != Integer.MAX_VALUE) {
                        n >>= 1;
                    }
                    this.zbuf[n4] = this.pbuf[n4] == this.backgroundArgb ? Integer.MAX_VALUE : n;
                    ++n4;
                    ++n5;
                }
                n5 += n3;
            }
            this.antialiasThisFrame = false;
            this.setWidthHeight(false);
        }
    }

    void mergeOpaqueAndTranslucentBuffers() {
        for (int i = 0; i < this.bufferSize; ++i) {
            Graphics3D.mergeBufferPixel(this.pbuf, this.pbufT[i], i);
        }
    }

    static void averageBufferPixel(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = nArray[n - n2];
        int n4 = nArray[n + n2];
        if (n3 == 0 || n4 == 0) {
            return;
        }
        nArray2[n] = ((n3 & 0xFF000000) >> 1) + ((n4 & 0xFF000000) >> 1) << 1 | (n3 & 0xFF00FF) + (n4 & 0xFF00FF) >> 1 & 0xFF00FF | (n3 & 0xFF00) + (n4 & 0xFF00) >> 1 & 0xFF00;
    }

    static void mergeBufferPixel(int[] nArray, int n, int n2) {
        if (n == 0) {
            return;
        }
        int n3 = nArray[n2];
        if (n3 == n) {
            return;
        }
        int n4 = n3 & 0xFF00FF;
        int n5 = n3 & 0xFF00;
        int n6 = n & 0xFF00FF;
        int n7 = n & 0xFF00;
        int n8 = n >> 24 & 7;
        switch (n8) {
            case 1: {
                n4 = (n6 << 2) + (n6 << 1) + n6 + n4 >> 3 & 0xFF00FF;
                n5 = (n7 << 2) + (n7 << 1) + n7 + n5 >> 3 & 0xFF00;
                break;
            }
            case 2: {
                n4 = (n6 << 1) + n6 + n4 >> 2 & 0xFF00FF;
                n5 = (n7 << 1) + n7 + n5 >> 2 & 0xFF00;
                break;
            }
            case 3: {
                n4 = (n6 << 2) + n6 + (n4 << 1) + n4 >> 3 & 0xFF00FF;
                n5 = (n7 << 2) + n7 + (n5 << 1) + n5 >> 3 & 0xFF00;
                break;
            }
            case 4: {
                n4 = n4 + n6 >> 1 & 0xFF00FF;
                n5 = n5 + n7 >> 1 & 0xFF00;
                break;
            }
            case 5: {
                n4 = (n6 << 1) + n6 + (n4 << 2) + n4 >> 3 & 0xFF00FF;
                n5 = (n7 << 1) + n7 + (n5 << 2) + n5 >> 3 & 0xFF00;
                break;
            }
            case 6: {
                n4 = (n4 << 1) + n4 + n6 >> 2 & 0xFF00FF;
                n5 = (n5 << 1) + n5 + n7 >> 2 & 0xFF00;
                break;
            }
            case 7: {
                n4 = (n4 << 2) + (n4 << 1) + n4 + n6 >> 3 & 0xFF00FF;
                n5 = (n5 << 2) + (n5 << 1) + n5 + n7 >> 3 & 0xFF00;
            }
        }
        nArray[n2] = 0xFF000000 | n4 | n5;
    }

    public boolean hasContent() {
        return this.platform.hasContent();
    }

    private void setColixAndIntensity(short s, int n) {
        if (s == this.colixCurrent && this.currentIntensity == n) {
            return;
        }
        this.currentIntensity = -1;
        this.setColix(s);
        this.setColorNoisy(n);
    }

    public boolean setColix(short s) {
        if (s == this.colixCurrent && this.currentIntensity == -1) {
            return true;
        }
        int n = s & 0x7800;
        if (n == 16384) {
            return false;
        }
        this.isTranslucent = n != 0;
        this.isScreened = this.isTranslucent && n == 30720;
        if (!this.checkTranslucent(this.isTranslucent && !this.isScreened)) {
            return false;
        }
        boolean bl = this.addAllPixels = this.isPass2 || !this.isTranslucent;
        if (this.isPass2) {
            this.translucencyMask = n << 13 | 0xFFFFFF;
        }
        this.colixCurrent = s;
        this.shadesCurrent = this.getShades(s);
        this.currentIntensity = -1;
        this.argbNoisyUp = this.argbNoisyDn = this.getColixArgb(s);
        this.argbCurrent = this.argbNoisyDn;
        return true;
    }

    void setColorNoisy(int n) {
        this.currentIntensity = n;
        this.argbCurrent = this.shadesCurrent[n];
        this.argbNoisyUp = this.shadesCurrent[n < 63 ? n + 1 : 63];
        this.argbNoisyDn = this.shadesCurrent[n > 0 ? n - 1 : 0];
    }

    void setZMargin(int n) {
        this.zMargin = n;
    }

    void addPixel(int n, int n2, int n3) {
        Graphics3D.addPixelT(n, n2, n3, this.zbuf, this.pbuf, this.zbufT, this.pbufT, this.translucencyMask, this.isPass2, this.zMargin);
    }

    static final void addPixelT(int n, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n4, boolean bl, int n5) {
        if (!bl) {
            nArray[n] = n2;
            nArray2[n] = n3;
            return;
        }
        int n6 = nArray3[n];
        if (n2 < n6) {
            int n7 = nArray4[n];
            if (n7 != 0 && n6 - n2 > n5) {
                Graphics3D.mergeBufferPixel(nArray2, n7, n);
            }
            nArray3[n] = n2;
            nArray4[n] = n3 & n4;
        } else if (n2 != n6 && n2 - n6 > n5) {
            Graphics3D.mergeBufferPixel(nArray2, n3 & n4, n);
        }
    }

    public void drawCircleCentered(short s, int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        if (this.isClippedZ(n4)) {
            return;
        }
        int n5 = (n + 1) / 2;
        boolean bl3 = bl2 = n2 < n5 || n2 + n5 >= this.width || n3 < n5 || n3 + n5 >= this.height;
        if (!bl2) {
            this.circle3d.plotCircleCenteredUnclipped(n2, n3, n4, n);
        } else if (!this.isClippedXY(n, n2, n3)) {
            this.circle3d.plotCircleCenteredClipped(n2, n3, n4, n);
        }
        if (!bl) {
            return;
        }
        if (!bl2) {
            this.circle3d.plotFilledCircleCenteredUnclipped(n2, n3, n4, n);
        } else if (!this.isClippedXY(n, n2, n3)) {
            this.circle3d.plotFilledCircleCenteredClipped(n2, n3, n4, n);
        }
    }

    public void fillScreenedCircleCentered(short s, int n, int n2, int n3, int n4) {
        boolean bl;
        if (this.isClippedZ(n4)) {
            return;
        }
        int n5 = (n + 1) / 2;
        boolean bl2 = bl = n2 < n5 || n2 + n5 >= this.width || n3 < n5 || n3 + n5 >= this.height;
        if (this.setColix(Graphics3D.getColixTranslucent(s, false, 0.0f))) {
            if (!bl) {
                this.circle3d.plotCircleCenteredUnclipped(n2, n3, n4, n);
            } else if (!this.isClippedXY(n, n2, n3)) {
                this.circle3d.plotCircleCenteredClipped(n2, n3, n4, n);
            }
        }
        if (!this.setColix(Graphics3D.getColixTranslucent(s, true, 0.5f))) {
            return;
        }
        if (!bl) {
            this.circle3d.plotFilledCircleCenteredUnclipped(n2, n3, n4, n);
        } else if (!this.isClippedXY(n, n2, n3)) {
            this.circle3d.plotFilledCircleCenteredClipped(n2, n3, n4, n);
        }
    }

    public void fillSphereCentered(int n, int n2, int n3, int n4) {
        switch (n) {
            case 1: {
                this.plotPixelClipped(this.argbCurrent, n2, n3, n4);
            }
            case 0: {
                return;
            }
        }
        if (n <= (this.antialiasThisFrame ? 2000 : 1000)) {
            this.sphere3d.render(this.shadesCurrent, !this.addAllPixels, n, n2, n3, n4, null, null, null, -1, null);
        }
    }

    public void fillSphereCentered(int n, Point3i point3i) {
        this.fillSphereCentered(n, point3i.x, point3i.y, point3i.z);
    }

    public void fillSphereCentered(int n, Point3f point3f) {
        this.fillSphereCentered(n, (int)point3f.x, (int)point3f.y, (int)point3f.z);
    }

    public void renderEllipsoid(int n, int n2, int n3, int n4, Matrix3f matrix3f, double[] dArray, Matrix4f matrix4f, int n5, Point3i[] point3iArray) {
        switch (n4) {
            case 1: {
                this.plotPixelClipped(this.argbCurrent, n, n2, n3);
            }
            case 0: {
                return;
            }
        }
        if (n4 <= (this.antialiasThisFrame ? 2000 : 1000)) {
            this.sphere3d.render(this.shadesCurrent, !this.addAllPixels, n4, n, n2, n3, matrix3f, dArray, matrix4f, n5, point3iArray);
        }
    }

    public void drawRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n4 != 0 && this.isClippedZ(n4)) {
            return;
        }
        int n7 = n5 - 1;
        int n8 = n6 - 1;
        int n9 = n + n7;
        int n10 = n2 + n8;
        if (n2 >= 0 && n2 < this.height) {
            this.drawHLine(n, n2, n3, n7);
        }
        if (n10 >= 0 && n10 < this.height) {
            this.drawHLine(n, n10, n3, n7);
        }
        if (n >= 0 && n < this.width) {
            this.drawVLine(n, n2, n3, n8);
        }
        if (n9 >= 0 && n9 < this.width) {
            this.drawVLine(n9, n2, n3, n8);
        }
    }

    private void drawHLine(int n, int n2, int n3, int n4) {
        if (n4 < 0) {
            n += n4;
            n4 = -n4;
        }
        if (n < 0) {
            n4 += n;
            n = 0;
        }
        if (n + n4 >= this.width) {
            n4 = this.width - 1 - n;
        }
        int n5 = n + this.width * n2;
        if (this.addAllPixels) {
            for (int i = 0; i <= n4; ++i) {
                if (n3 < this.zbuf[n5]) {
                    this.addPixel(n5, n3, this.argbCurrent);
                }
                ++n5;
            }
            return;
        }
        boolean bl = ((n ^ n2) & 1) != 0;
        for (int i = 0; i <= n4; ++i) {
            if ((bl = !bl) && n3 < this.zbuf[n5]) {
                this.addPixel(n5, n3, this.argbCurrent);
            }
            ++n5;
        }
    }

    private void drawVLine(int n, int n2, int n3, int n4) {
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (n2 + n4 >= this.height) {
            n4 = this.height - 1 - n2;
        }
        int n5 = n + this.width * n2;
        if (this.addAllPixels) {
            for (int i = 0; i <= n4; ++i) {
                if (n3 < this.zbuf[n5]) {
                    this.addPixel(n5, n3, this.argbCurrent);
                }
                n5 += this.width;
            }
            return;
        }
        boolean bl = ((n ^ n2) & 1) != 0;
        for (int i = 0; i <= n4; ++i) {
            if ((bl = !bl) && n3 < this.zbuf[n5]) {
                this.addPixel(n5, n3, this.argbCurrent);
            }
            n5 += this.width;
        }
    }

    public void fillRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isClippedZ(n4)) {
            return;
        }
        if (n < 0) {
            if ((n5 += n) <= 0) {
                return;
            }
            n = 0;
        }
        if (n + n5 > this.width && (n5 = this.width - n) <= 0) {
            return;
        }
        if (n2 < 0) {
            if ((n6 += n2) <= 0) {
                return;
            }
            n2 = 0;
        }
        if (n2 + n6 > this.height) {
            n6 = this.height - n2;
        }
        while (--n6 >= 0) {
            this.plotPixelsUnclipped(n5, n, n2++, n3);
        }
    }

    public void drawString(String string, Font3D font3D, int n, int n2, int n3, int n4) {
        if (string == null) {
            return;
        }
        if (this.isClippedZ(n4)) {
            return;
        }
        this.drawStringNoSlab(string, font3D, n, n2, n3);
    }

    public void drawStringNoSlab(String string, Font3D font3D, int n, int n2, int n3) {
        if (string == null) {
            return;
        }
        if (font3D != null) {
            this.font3dCurrent = font3D;
        }
        this.plotText(n, n2, n3, this.argbCurrent, string, this.font3dCurrent, null);
    }

    public void plotText(int n, int n2, int n3, int n4, String string, Font3D font3D, JmolRendererInterface jmolRendererInterface) {
        Text3D.plot(n, n2, n3, n4, string, font3D, this, jmolRendererInterface, this.antialiasThisFrame);
    }

    public void setFont(byte by) {
        this.font3dCurrent = Font3D.getFont3D(by);
    }

    public void setFont(Font3D font3D) {
        this.font3dCurrent = font3D;
    }

    public Font3D getFont3DCurrent() {
        return this.font3dCurrent;
    }

    public void drawPixel(int n, int n2, int n3) {
        this.plotPixelClipped(n, n2, n3);
    }

    public void drawPoints(int n, int[] nArray) {
        this.plotPoints(n, nArray);
    }

    public void drawDashedLine(int n, int n2, Point3i point3i, Point3i point3i2) {
        this.line3d.plotDashedLine(this.argbCurrent, !this.addAllPixels, n, n2, point3i.x, point3i.y, point3i.z, point3i2.x, point3i2.y, point3i2.z, false);
    }

    public void drawDottedLine(Point3i point3i, Point3i point3i2) {
        this.line3d.plotDashedLine(this.argbCurrent, !this.addAllPixels, 2, 1, point3i.x, point3i.y, point3i.z, point3i2.x, point3i2.y, point3i2.z, false);
    }

    public void drawLine(int n, int n2, int n3, int n4, int n5, int n6) {
        this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, n, n2, n3, n4, n5, n6, false);
    }

    public void drawLine(short s, short s2, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.setColix(s)) {
            s = 0;
        }
        boolean bl = !this.addAllPixels;
        int n7 = this.argbCurrent;
        if (!this.setColix(s2)) {
            s2 = 0;
        }
        if (s == 0 && s2 == 0) {
            return;
        }
        this.line3d.plotLine(n7, bl, this.argbCurrent, !this.addAllPixels, n, n2, n3, n4, n5, n6, false);
    }

    public void drawLine(Point3i point3i, Point3i point3i2) {
        this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, point3i.x, point3i.y, point3i.z, point3i2.x, point3i2.y, point3i2.z, false);
    }

    public void fillCylinder(short s, short s2, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl;
        if (!this.setColix(s)) {
            s = 0;
        }
        boolean bl2 = bl = !this.addAllPixels;
        if (!this.setColix(s2)) {
            s2 = 0;
        }
        if (s == 0 && s2 == 0) {
            return;
        }
        this.cylinder3d.render(s, s2, bl, !this.addAllPixels, by, n, n2, n3, n4, n5, n6, n7);
    }

    public void fillCylinder(byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.cylinder3d.render(this.colixCurrent, this.colixCurrent, !this.addAllPixels, !this.addAllPixels, by, n, n2, n3, n4, n5, n6, n7);
    }

    public void fillCylinder(byte by, int n, Point3i point3i, Point3i point3i2) {
        this.cylinder3d.render(this.colixCurrent, this.colixCurrent, !this.addAllPixels, !this.addAllPixels, by, n, point3i.x, point3i.y, point3i.z, point3i2.x, point3i2.y, point3i2.z);
    }

    public void fillCylinderBits(byte by, int n, Point3f point3f, Point3f point3f2) {
        this.cylinder3d.renderBits(this.colixCurrent, this.colixCurrent, !this.addAllPixels, !this.addAllPixels, by, n, point3f.x, point3f.y, point3f.z, point3f2.x, point3f2.y, point3f2.z);
    }

    public void fillCone(byte by, int n, Point3i point3i, Point3i point3i2) {
        this.cylinder3d.renderCone(this.colixCurrent, !this.addAllPixels, by, n, point3i.x, point3i.y, point3i.z, point3i2.x, point3i2.y, point3i2.z, false);
    }

    public void fillCone(byte by, int n, Point3f point3f, Point3f point3f2) {
        this.cylinder3d.renderCone(this.colixCurrent, !this.addAllPixels, by, n, point3f.x, point3f.y, point3f.z, point3f2.x, point3f2.y, point3f2.z, true);
    }

    public void drawHermite(int n, Point3i point3i, Point3i point3i2, Point3i point3i3, Point3i point3i4) {
        this.hermite3d.render(false, n, 0, 0, 0, point3i, point3i2, point3i3, point3i4);
    }

    public void drawHermite(boolean bl, boolean bl2, int n, Point3i point3i, Point3i point3i2, Point3i point3i3, Point3i point3i4, Point3i point3i5, Point3i point3i6, Point3i point3i7, Point3i point3i8, int n2) {
        this.hermite3d.render2(bl, bl2, n, point3i, point3i2, point3i3, point3i4, point3i5, point3i6, point3i7, point3i8, n2);
    }

    public void fillHermite(int n, int n2, int n3, int n4, Point3i point3i, Point3i point3i2, Point3i point3i3, Point3i point3i4) {
        this.hermite3d.render(true, n, n2, n3, n4, point3i, point3i2, point3i3, point3i4);
    }

    public static void getHermiteList(int n, Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3, Tuple3f tuple3f4, Tuple3f tuple3f5, Tuple3f[] tuple3fArray, int n2, int n3) {
        Hermite3D.getHermiteList(n, tuple3f, tuple3f2, tuple3f3, tuple3f4, tuple3f5, tuple3fArray, n2, n3);
    }

    public void drawTriangle(Point3i point3i, short s, Point3i point3i2, short s2, Point3i point3i3, short s3, int n) {
        int n2 = point3i.x;
        int n3 = point3i.y;
        int n4 = point3i.z;
        int n5 = point3i2.x;
        int n6 = point3i2.y;
        int n7 = point3i2.z;
        int n8 = point3i3.x;
        int n9 = point3i3.y;
        int n10 = point3i3.z;
        if ((n & 1) == 1) {
            this.drawLine(s, s2, n2, n3, n4, n5, n6, n7);
        }
        if ((n & 2) == 2) {
            this.drawLine(s2, s3, n5, n6, n7, n8, n9, n10);
        }
        if ((n & 4) == 4) {
            this.drawLine(s, s3, n2, n3, n4, n8, n9, n10);
        }
    }

    public void drawTriangle(Point3i point3i, Point3i point3i2, Point3i point3i3, int n) {
        int n2 = point3i.x;
        int n3 = point3i.y;
        int n4 = point3i.z;
        int n5 = point3i2.x;
        int n6 = point3i2.y;
        int n7 = point3i2.z;
        int n8 = point3i3.x;
        int n9 = point3i3.y;
        int n10 = point3i3.z;
        if ((n & 1) == 1) {
            this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, n2, n3, n4, n5, n6, n7, false);
        }
        if ((n & 2) == 2) {
            this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, n5, n6, n7, n8, n9, n10, false);
        }
        if ((n & 4) == 4) {
            this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, n2, n3, n4, n8, n9, n10, false);
        }
    }

    public void drawCylinderTriangle(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.fillCylinder((byte)3, n10, n, n2, n3, n4, n5, n6);
        this.fillCylinder((byte)3, n10, n, n2, n3, n7, n8, n9);
        this.fillCylinder((byte)3, n10, n4, n5, n6, n7, n8, n9);
    }

    public void drawfillTriangle(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, n, n2, n3, n4, n5, n6, false);
        this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, n, n2, n3, n7, n8, n9, false);
        this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, n4, n5, n6, n7, n8, n9, false);
        this.triangle3d.fillTriangle(n, n2, n3, n4, n5, n6, n7, n8, n9, false);
    }

    public void fillTriangle(Point3i point3i, int n, Point3i point3i2, int n2, Point3i point3i3, int n3) {
        this.triangle3d.setGouraud(n, n2, n3);
        this.triangle3d.fillTriangle(point3i, point3i2, point3i3, true);
    }

    public void fillTriangle(Point3i point3i, short s, short s2, Point3i point3i2, short s3, short s4, Point3i point3i3, short s5, short s6) {
        boolean bl;
        if (s2 == s4 && s2 == s6 && s == s3 && s == s5) {
            this.setColixAndIntensity(s, this.normix3d.getIntensity(s2));
            bl = false;
        } else {
            this.triangle3d.setGouraud(this.getShades(s)[this.normix3d.getIntensity(s2)], this.getShades(s3)[this.normix3d.getIntensity(s4)], this.getShades(s5)[this.normix3d.getIntensity(s6)]);
            int n = 0;
            if (Graphics3D.isColixTranslucent(s)) {
                ++n;
            }
            if (Graphics3D.isColixTranslucent(s3)) {
                ++n;
            }
            if (Graphics3D.isColixTranslucent(s5)) {
                ++n;
            }
            this.isTranslucent = n >= 2;
            bl = true;
        }
        this.triangle3d.fillTriangle(point3i, point3i2, point3i3, bl);
    }

    public void fillTriangle(short s, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setColorNoisy(this.normix3d.getIntensity(s));
        this.triangle3d.fillTriangle(n, n2, n3, n4, n5, n6, n7, n8, n9, false);
    }

    public void fillTriangle(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        this.setColorNoisy(this.calcIntensityScreen(point3f, point3f2, point3f3));
        this.triangle3d.fillTriangle(point3f, point3f2, point3f3, false);
    }

    public void fillTriangle(Point3i point3i, Point3i point3i2, Point3i point3i3) {
        this.triangle3d.fillTriangle(point3i, point3i2, point3i3, false);
    }

    public void fillTriangle(Point3i point3i, short s, short s2, Point3i point3i2, short s3, short s4, Point3i point3i3, short s5, short s6, float f) {
        boolean bl;
        if (s2 == s4 && s2 == s6 && s == s3 && s == s5) {
            this.setColixAndIntensity(s, this.normix3d.getIntensity(s2));
            bl = false;
        } else {
            this.triangle3d.setGouraud(this.getShades(s)[this.normix3d.getIntensity(s2)], this.getShades(s3)[this.normix3d.getIntensity(s4)], this.getShades(s5)[this.normix3d.getIntensity(s6)]);
            int n = 0;
            if (Graphics3D.isColixTranslucent(s)) {
                ++n;
            }
            if (Graphics3D.isColixTranslucent(s3)) {
                ++n;
            }
            if (Graphics3D.isColixTranslucent(s5)) {
                ++n;
            }
            this.isTranslucent = n >= 2;
            bl = true;
        }
        this.triangle3d.fillTriangle(point3i, point3i2, point3i3, f, bl);
    }

    public void drawQuadrilateral(short s, Point3i point3i, Point3i point3i2, Point3i point3i3, Point3i point3i4) {
        this.setColix(s);
        this.drawLine(point3i, point3i2);
        this.drawLine(point3i2, point3i3);
        this.drawLine(point3i3, point3i4);
        this.drawLine(point3i4, point3i);
    }

    public void fillQuadrilateral(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
        this.setColorNoisy(this.calcIntensityScreen(point3f, point3f2, point3f3));
        this.triangle3d.fillTriangle(point3f, point3f2, point3f3, false);
        this.triangle3d.fillTriangle(point3f, point3f3, point3f4, false);
    }

    public void fillQuadrilateral(Point3i point3i, short s, short s2, Point3i point3i2, short s3, short s4, Point3i point3i3, short s5, short s6, Point3i point3i4, short s7, short s8) {
        this.fillTriangle(point3i, s, s2, point3i2, s3, s4, point3i3, s5, s6);
        this.fillTriangle(point3i, s, s2, point3i3, s5, s6, point3i4, s7, s8);
    }

    public void renderIsosurface(Point3f[] point3fArray, short s, short[] sArray, Vector3f[] vector3fArray, int[][] nArray, BitSet bitSet, int n, int n2) {
    }

    public boolean isClipped(int n, int n2, int n3) {
        return n < 0 || n >= this.width || n2 < 0 || n2 >= this.height || n3 < this.slab || n3 > this.depth;
    }

    private boolean isClipped(int n, int n2) {
        return n < 0 || n >= this.width || n2 < 0 || n2 >= this.height;
    }

    public boolean isInDisplayRange(int n, int n2) {
        return n >= this.displayMinX && n < this.displayMaxX && n2 >= this.displayMinY && n2 < this.displayMaxY;
    }

    public boolean isClippedXY(int n, int n2, int n3) {
        int n4 = n + 1 >> 1;
        return n2 < -n4 || n2 >= this.width + n4 || n3 < -n4 || n3 >= this.height + n4;
    }

    public boolean isClippedZ(int n) {
        return n != Integer.MIN_VALUE && (n < this.slab || n > this.depth);
    }

    void plotPixelClipped(int n, int n2, int n3) {
        if (this.isClipped(n, n2, n3)) {
            return;
        }
        int n4 = n2 * this.width + n;
        if (n3 < this.zbuf[n4]) {
            this.addPixel(n4, n3, this.argbCurrent);
        }
    }

    public void plotPixelClipped(Point3i point3i) {
        this.plotPixelClipped(point3i.x, point3i.y, point3i.z);
    }

    void plotPixelClipped(int n, int n2, int n3, int n4) {
        if (this.isClipped(n2, n3, n4)) {
            return;
        }
        int n5 = n3 * this.width + n2;
        if (n4 < this.zbuf[n5]) {
            this.addPixel(n5, n4, n);
        }
    }

    public void plotPixelClippedNoSlab(int n, int n2, int n3, int n4) {
        if (this.isClipped(n2, n3)) {
            return;
        }
        int n5 = n3 * this.width + n2;
        if (n4 < this.zbuf[n5]) {
            this.addPixel(n5, n4, n);
        }
    }

    void plotPixelClipped(int n, boolean bl, int n2, int n3, int n4) {
        if (this.isClipped(n2, n3, n4)) {
            return;
        }
        if (bl && ((n2 ^ n3) & 1) != 0) {
            return;
        }
        int n5 = n3 * this.width + n2;
        if (n4 < this.zbuf[n5]) {
            this.addPixel(n5, n4, n);
        }
    }

    void plotPixelUnclipped(int n, int n2, int n3) {
        int n4 = n2 * this.width + n;
        if (n3 < this.zbuf[n4]) {
            this.addPixel(n4, n3, this.argbCurrent);
        }
    }

    void plotPixelUnclipped(int n, int n2, int n3, int n4) {
        int n5 = n3 * this.width + n2;
        if (n4 < this.zbuf[n5]) {
            this.addPixel(n5, n4, n);
        }
    }

    void plotPixelsClipped(int n, int n2, int n3, int n4) {
        if (n3 < 0 || n3 >= this.height || n2 >= this.width) {
            return;
        }
        if (n2 < 0) {
            n += n2;
            n2 = 0;
        }
        if (n + n2 > this.width) {
            n = this.width - n2;
        }
        if (n <= 0) {
            return;
        }
        int n5 = n3 * this.width + n2;
        int n6 = n5 + n;
        int n7 = 1;
        if (!this.addAllPixels) {
            n7 = 2;
            if (((n2 ^ n3) & 1) != 0) {
                ++n5;
            }
        }
        while (n5 < n6) {
            if (n4 < this.zbuf[n5]) {
                this.addPixel(n5, n4, this.argbCurrent);
            }
            n5 += n7;
        }
    }

    void plotPixelsClipped(int n, int n2, int n3, int n4, int n5, Rgb16 rgb16, Rgb16 rgb162) {
        if (n <= 0 || n3 < 0 || n3 >= this.height || n2 >= this.width || n4 < this.slab && n5 < this.slab || n4 > this.depth && n5 > this.depth) {
            return;
        }
        int n6 = (n2 << 16) + (n3 << 1) ^ 0x33333333;
        int n7 = (n4 << 10) + 512;
        int n8 = n5 - n4;
        int n9 = n / 2;
        int n10 = ((n8 << 10) + (n8 >= 0 ? n9 : -n9)) / n;
        if (n2 < 0) {
            n2 = -n2;
            n7 += n10 * n2;
            if ((n -= n2) <= 0) {
                return;
            }
            n2 = 0;
        }
        if (n + n2 > this.width) {
            n = this.width - n2;
        }
        boolean bl = ((n2 ^ n3) & 1) != 0;
        int n11 = n3 * this.width + n2;
        if (rgb16 == null) {
            while (--n >= 0) {
                int n12;
                if ((this.addAllPixels || (bl = !bl)) && (n12 = n7 >> 10) >= this.slab && n12 <= this.depth && n12 < this.zbuf[n11]) {
                    int n13 = (n6 = (n6 << 16) + (n6 << 1) + n6 & Integer.MAX_VALUE) >> 16 & 7;
                    this.addPixel(n11, n12, n13 == 0 ? this.argbNoisyDn : (n13 == 1 ? this.argbNoisyUp : this.argbCurrent));
                }
                ++n11;
                n7 += n10;
            }
        } else {
            int n14 = rgb16.rScaled << 8;
            int n15 = (rgb162.rScaled - rgb16.rScaled << 8) / n;
            int n16 = rgb16.gScaled;
            int n17 = (rgb162.gScaled - n16) / n;
            int n18 = rgb16.bScaled;
            int n19 = (rgb162.bScaled - n18) / n;
            while (--n >= 0) {
                int n20;
                if ((this.addAllPixels || (bl = !bl)) && (n20 = n7 >> 10) >= this.slab && n20 <= this.depth && n20 < this.zbuf[n11]) {
                    this.addPixel(n11, n20, 0xFF000000 | n14 & 0xFF0000 | n16 & 0xFF00 | n18 >> 8 & 0xFF);
                }
                ++n11;
                n7 += n10;
                n14 += n15;
                n16 += n17;
                n18 += n19;
            }
        }
    }

    void plotPixelsUnclipped(int n, int n2, int n3, int n4, int n5, Rgb16 rgb16, Rgb16 rgb162) {
        if (n <= 0) {
            return;
        }
        int n6 = (n2 << 16) + (n3 << 1) ^ 0x33333333;
        boolean bl = ((n2 ^ n3) & 1) != 0;
        int n7 = (n4 << 10) + 512;
        int n8 = n5 - n4;
        int n9 = n / 2;
        int n10 = ((n8 << 10) + (n8 >= 0 ? n9 : -n9)) / n;
        int n11 = n3 * this.width + n2;
        if (rgb16 == null) {
            while (--n >= 0) {
                int n12;
                if ((this.addAllPixels || (bl = !bl)) && (n12 = n7 >> 10) < this.zbuf[n11]) {
                    int n13 = (n6 = (n6 << 16) + (n6 << 1) + n6 & Integer.MAX_VALUE) >> 16 & 7;
                    this.addPixel(n11, n12, n13 == 0 ? this.argbNoisyDn : (n13 == 1 ? this.argbNoisyUp : this.argbCurrent));
                }
                ++n11;
                n7 += n10;
            }
        } else {
            int n14 = rgb16.rScaled << 8;
            int n15 = (rgb162.rScaled - rgb16.rScaled << 8) / n;
            int n16 = rgb16.gScaled;
            int n17 = (rgb162.gScaled - n16) / n;
            int n18 = rgb16.bScaled;
            int n19 = (rgb162.bScaled - n18) / n;
            while (--n >= 0) {
                int n20;
                if ((this.addAllPixels || (bl = !bl)) && (n20 = n7 >> 10) < this.zbuf[n11]) {
                    this.addPixel(n11, n20, 0xFF000000 | n14 & 0xFF0000 | n16 & 0xFF00 | n18 >> 8 & 0xFF);
                }
                ++n11;
                n7 += n10;
                n14 += n15;
                n16 += n17;
                n18 += n19;
            }
        }
    }

    void plotPixelsUnclipped(int n, int n2, int n3, int n4) {
        int n5 = n3 * this.width + n2;
        if (this.addAllPixels) {
            while (--n >= 0) {
                if (n4 < this.zbuf[n5]) {
                    this.addPixel(n5, n4, this.argbCurrent);
                }
                ++n5;
            }
        } else {
            int n6 = n5 + n;
            if (((n2 ^ n3) & 1) != 0 && ++n5 == n6) {
                return;
            }
            do {
                if (n4 >= this.zbuf[n5]) continue;
                this.addPixel(n5, n4, this.argbCurrent);
            } while ((n5 += 2) < n6);
        }
    }

    private void plotPoints(int n, int[] nArray) {
        int n2 = n * 3;
        while (n2 > 0) {
            int n3;
            int n4;
            int n5;
            int n6 = nArray[--n2];
            --n2;
            if (this.isClipped(n5 = nArray[--n2], n4 = nArray[n2], n6)) continue;
            if (n6 < this.zbuf[n3 = n4 * this.width + n5++]) {
                this.addPixel(n3, n6, this.argbCurrent);
            }
            if (!this.antialiasThisFrame) continue;
            n3 = n4 * this.width + n5;
            if (!this.isClipped(n5, n4, n6) && n6 < this.zbuf[n3]) {
                this.addPixel(n3, n6, this.argbCurrent);
            }
            n3 = ++n4 * this.width + n5;
            if (!this.isClipped(n5, n4, n6) && n6 < this.zbuf[n3]) {
                this.addPixel(n3, n6, this.argbCurrent);
            }
            n3 = n4 * this.width + --n5;
            if (this.isClipped(n5, n4, n6) || n6 >= this.zbuf[n3]) continue;
            this.addPixel(n3, n6, this.argbCurrent);
        }
    }

    public static int calcGreyscaleRgbFromRgb(int n) {
        int n2 = (2989 * (n >> 16 & 0xFF) + 5870 * (n >> 8 & 0xFF) + 1140 * (n & 0xFF) + 5000) / 10000;
        int n3 = n2 << 16 | n2 << 8 | n2 | 0xFF000000;
        return n3;
    }

    public static short getColix(int n) {
        return Colix3D.getColix(n);
    }

    public static final Point3f colorPointFromInt(int n, Point3f point3f) {
        point3f.z = n & 0xFF;
        point3f.y = n >> 8 & 0xFF;
        point3f.x = n >> 16 & 0xFF;
        return point3f;
    }

    public static final Point3f colorPointFromString(String string, Point3f point3f) {
        return Graphics3D.colorPointFromInt(Graphics3D.getArgbFromString(string), point3f);
    }

    public static short getColix(String string) {
        int n = Graphics3D.getArgbFromString(string);
        if (n != 0) {
            return Colix3D.getColix(n);
        }
        if ("none".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("opaque".equalsIgnoreCase(string)) {
            return 1;
        }
        return 2;
    }

    private static final short applyColorTranslucencyLevel(short s, float f) {
        if (f == 0.0f) {
            return (short)(s & 0xFFFF87FF);
        }
        if (f < 0.0f) {
            return (short)(s | 0x7800);
        }
        if (f >= 255.0f || (double)f == 1.0) {
            return (short)(s | 0x4000);
        }
        int n = (int)(f < 1.0f ? f * 256.0f : (f <= 9.0f ? (float)((int)(f - 1.0f) << 5) : (f < 15.0f ? 256.0f : f)));
        n = (n >> 5) % 16;
        return (short)(s & 0xFFFF87FF | n << 11);
    }

    public static final int getColixTranslucencyLevel(short s) {
        int n = s >> 11 & 0xF;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return n << 5;
            }
            case 15: {
                return -1;
            }
        }
        return 255;
    }

    public static short getColix(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Byte) {
            return (Byte)object == 0 ? (short)0 : 2;
        }
        if (object instanceof Integer) {
            return Colix3D.getColix((Integer)object);
        }
        if (object instanceof String) {
            return Graphics3D.getColix((String)object);
        }
        if (Logger.debugging) {
            Logger.debug("?? getColix(" + object + ")");
        }
        return 22;
    }

    public static final short getColixTranslucent(short s, boolean bl, float f) {
        if (s == 0) {
            s = 1;
        }
        s = (short)(s & 0xFFFF87FF);
        if (!bl) {
            return s;
        }
        return Graphics3D.applyColorTranslucencyLevel(s, f);
    }

    public int getColixArgb(short s) {
        if (s < 0) {
            s = this.changeableColixMap[s & 0x7FF];
        }
        if (!this.inGreyscaleMode) {
            return Colix3D.getArgb(s);
        }
        return Colix3D.getArgbGreyscale(s);
    }

    int[] getShades(short s) {
        if (s < 0) {
            s = this.changeableColixMap[s & 0x7FF];
        }
        if (!this.inGreyscaleMode) {
            return Colix3D.getShades(s);
        }
        return Colix3D.getShadesGreyscale(s);
    }

    public static final short getChangeableColixIndex(short s) {
        if (s >= 0) {
            return -1;
        }
        return (short)(s & 0x7FF);
    }

    public static final boolean isColixTranslucent(short s) {
        return (s & 0x7800) != 0;
    }

    public static final short getColixInherited(short s, short s2) {
        switch (s) {
            case 0: {
                return s2;
            }
            case 1: {
                return (short)(s2 & 0xFFFF87FF);
            }
        }
        return (s & 0xFFFF87FF) == 1 ? (short)(s2 & 0xFFFF87FF | s & 0x7800) : s;
    }

    public static final boolean isColixColorInherited(short s) {
        switch (s) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return (s & 0xFFFF87FF) == 1;
    }

    public String getHexColorFromIndex(short s) {
        int n = this.getColixArgb(s);
        return Graphics3D.getHexColorFromRGB(n);
    }

    public static String getHexColorFromRGB(int n) {
        if (n == 0) {
            return null;
        }
        String string = "00" + Integer.toHexString(n >> 16 & 0xFF);
        string = string.substring(string.length() - 2);
        String string2 = "00" + Integer.toHexString(n >> 8 & 0xFF);
        string2 = string2.substring(string2.length() - 2);
        String string3 = "00" + Integer.toHexString(n & 0xFF);
        string3 = string3.substring(string3.length() - 2);
        return string + string2 + string3;
    }

    public short getChangeableColix(short s, int n) {
        if (s >= this.changeableColixMap.length) {
            short[] sArray = new short[s + 16];
            System.arraycopy(this.changeableColixMap, 0, sArray, 0, this.changeableColixMap.length);
            this.changeableColixMap = sArray;
        }
        if (this.changeableColixMap[s] == 0) {
            this.changeableColixMap[s] = Colix3D.getColix(n);
        }
        return (short)(s | Short.MIN_VALUE);
    }

    public void changeColixArgb(short s, int n) {
        if (s < this.changeableColixMap.length && this.changeableColixMap[s] != 0) {
            this.changeableColixMap[s] = Colix3D.getColix(n);
        }
    }

    public static void flushShadesAndSphereCaches() {
        Colix3D.flushShades();
        Sphere3D.flushSphereCache();
    }

    public static synchronized void setSpecular(boolean bl) {
        Graphics3D.lighting[Shade3D.SPECULAR_ON] = bl ? 1.0f : 0.0f;
    }

    public static boolean getSpecular() {
        return lighting[Shade3D.SPECULAR_ON] != 0.0f;
    }

    public static synchronized void setSpecularPower(int n) {
        Graphics3D.lighting[Shade3D.SPECULAR_POWER] = n;
        Graphics3D.lighting[Shade3D.INTENSE_FRACTION] = (float)n / 100.0f;
    }

    public static int getSpecularPower() {
        return (int)lighting[Shade3D.SPECULAR_POWER];
    }

    public static synchronized void setSpecularPercent(int n) {
        Graphics3D.lighting[Shade3D.SPECULAR_PERCENT] = n;
        Graphics3D.lighting[Shade3D.INTENSITY_SPECULAR] = (float)n / 100.0f;
    }

    public static int getSpecularPercent() {
        return (int)lighting[Shade3D.SPECULAR_PERCENT];
    }

    public static synchronized void setSpecularExponent(int n) {
        Graphics3D.lighting[Shade3D.SPECULAR_EXPONENT] = n;
    }

    public static int getSpecularExponent() {
        return (int)lighting[Shade3D.SPECULAR_EXPONENT];
    }

    public static synchronized void setDiffusePercent(int n) {
        Graphics3D.lighting[Shade3D.DIFFUSE_PERCENT] = n;
        Graphics3D.lighting[Shade3D.INTENSITY_DIFFUSE] = (float)n / 100.0f;
    }

    public static int getDiffusePercent() {
        return (int)lighting[Shade3D.DIFFUSE_PERCENT];
    }

    public static synchronized void setAmbientPercent(int n) {
        Graphics3D.lighting[Shade3D.AMBIENT_PERCENT] = n;
        Graphics3D.lighting[Shade3D.AMBIENT_FRACTION] = (float)n / 100.0f;
    }

    public static int getAmbientPercent() {
        return (int)lighting[Shade3D.AMBIENT_PERCENT];
    }

    public static Point3f getLightSource() {
        return new Point3f(Shade3D.xLight, Shade3D.yLight, Shade3D.zLight);
    }

    public int calcSurfaceShade(Point3i point3i, Point3i point3i2, Point3i point3i3) {
        byte by;
        this.vectorAB.set(point3i2.x - point3i.x, point3i2.y - point3i.y, point3i2.z - point3i.z);
        if (point3i3 == null) {
            by = Shade3D.calcIntensity(-this.vectorAB.x, -this.vectorAB.y, this.vectorAB.z);
        } else {
            this.vectorAC.set(point3i3.x - point3i.x, point3i3.y - point3i.y, point3i3.z - point3i.z);
            this.vectorAB.cross(this.vectorAB, this.vectorAC);
            byte by2 = by = this.vectorAB.z >= 0.0f ? Shade3D.calcIntensity(-this.vectorAB.x, -this.vectorAB.y, this.vectorAB.z) : Shade3D.calcIntensity(this.vectorAB.x, this.vectorAB.y, -this.vectorAB.z);
        }
        if (by > intensitySpecularSurfaceLimit) {
            by = intensitySpecularSurfaceLimit;
        }
        this.setColorNoisy(by);
        return this.argbCurrent;
    }

    private int calcIntensityScreen(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        this.vectorAB.sub(point3f2, point3f);
        this.vectorAC.sub(point3f3, point3f);
        this.vectorNormal.cross(this.vectorAB, this.vectorAC);
        return this.vectorNormal.z >= 0.0f ? Shade3D.calcIntensity(-this.vectorNormal.x, -this.vectorNormal.y, this.vectorNormal.z) : Shade3D.calcIntensity(this.vectorNormal.x, this.vectorNormal.y, -this.vectorNormal.z);
    }

    public Font3D getFont3D(float f) {
        return Font3D.getFont3D(0, 0, f, f, this.platform);
    }

    public Font3D getFont3D(String string, float f) {
        return Font3D.getFont3D(Font3D.getFontFaceID(string), 0, f, f, this.platform);
    }

    public Font3D getFont3D(String string, String string2, float f) {
        return Font3D.getFont3D(Font3D.getFontFaceID(string), Font3D.getFontStyleID(string2), f, f, this.platform);
    }

    public Font3D getFont3DScaled(Font3D font3D, float f) {
        float f2 = font3D.fontSizeNominal * f;
        return f2 == font3D.fontSize ? font3D : Font3D.getFont3D(font3D.idFontFace, font3D.idFontStyle, f2, font3D.fontSizeNominal, this.platform);
    }

    public byte getFontFid(float f) {
        return this.getFont3D((float)f).fid;
    }

    public byte getFontFid(String string, float f) {
        return this.getFont3D((String)string, (float)f).fid;
    }

    public static int getColorArgb(int n) {
        return colorArgbs[n % colorArgbs.length];
    }

    public static int getArgbFromString(String string) {
        Object object;
        int n = 0;
        if (string == null || (n = string.length()) == 0) {
            return 0;
        }
        if (string.charAt(0) == '[' && string.charAt(n - 1) == ']') {
            if (string.indexOf(",") >= 0) {
                String[] stringArray = TextFormat.split(string.substring(1, string.length() - 1), ",");
                if (stringArray.length != 3) {
                    return 0;
                }
                try {
                    int n2 = Integer.parseInt(stringArray[0]);
                    int n3 = Integer.parseInt(stringArray[1]);
                    int n4 = Integer.parseInt(stringArray[2]);
                    return 0xFF000000 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF;
                }
                catch (NumberFormatException numberFormatException) {
                    return 0;
                }
            }
            switch (n) {
                case 9: {
                    object = "x";
                    break;
                }
                case 10: {
                    object = "0x";
                    break;
                }
                default: {
                    return 0;
                }
            }
            if (string.indexOf((String)object) != 1) {
                return 0;
            }
            string = "#" + string.substring(n - 7, n - 1);
            n = 7;
        }
        if (n == 7 && string.charAt(0) == '#') {
            try {
                int n5 = Integer.parseInt(string.substring(1, 3), 16);
                int n6 = Integer.parseInt(string.substring(3, 5), 16);
                int n7 = Integer.parseInt(string.substring(5, 7), 16);
                return 0xFF000000 | (n5 & 0xFF) << 16 | (n6 & 0xFF) << 8 | n7 & 0xFF;
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        object = (Integer)mapJavaScriptColors.get(string.toLowerCase());
        return object == null ? 0 : (Integer)object;
    }

    public static float distanceToPlane(Point4f point4f, Point3f point3f) {
        return point4f == null ? Float.NaN : (point4f.x * point3f.x + point4f.y * point3f.y + point4f.z * point3f.z + point4f.w) / (float)Math.sqrt(point4f.x * point4f.x + point4f.y * point4f.y + point4f.z * point4f.z);
    }

    public static float distanceToPlane(Point4f point4f, float f, Point3f point3f) {
        return point4f == null ? Float.NaN : (point4f.x * point3f.x + point4f.y * point3f.y + point4f.z * point3f.z + point4f.w) / f;
    }

    public static float distanceToPlane(Vector3f vector3f, float f, Point3f point3f) {
        return vector3f == null ? Float.NaN : (vector3f.x * point3f.x + vector3f.y * point3f.y + vector3f.z * point3f.z + f) / (float)Math.sqrt(vector3f.x * vector3f.x + vector3f.y * vector3f.y + vector3f.z * vector3f.z);
    }

    public static void calcNormalizedNormal(Point3f point3f, Point3f point3f2, Point3f point3f3, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        vector3f2.sub(point3f2, point3f);
        vector3f3.sub(point3f3, point3f);
        vector3f.cross(vector3f2, vector3f3);
        vector3f.normalize();
    }

    public static float getDirectedNormalThroughPoints(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        float f = Graphics3D.getNormalThroughPoints(point3f, point3f2, point3f3, vector3f, vector3f2, vector3f3);
        if (point3f4 != null) {
            Point3f point3f5 = new Point3f(point3f);
            point3f5.add(vector3f);
            float f2 = point3f5.distance(point3f4);
            point3f5.set(point3f);
            point3f5.sub(vector3f);
            if (f2 > point3f5.distance(point3f4)) {
                vector3f.scale(-1.0f);
                f = -f;
            }
        }
        return f;
    }

    public static float getNormalThroughPoints(Point3f point3f, Point3f point3f2, Point3f point3f3, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        Graphics3D.calcNormalizedNormal(point3f, point3f2, point3f3, vector3f, vector3f2, vector3f3);
        vector3f2.set(point3f);
        float f = -vector3f2.dot(vector3f);
        return f;
    }

    public static void getNormalFromCenter(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, boolean bl, Vector3f vector3f) {
        boolean bl2;
        Point3f point3f5 = new Point3f();
        Point3f point3f6 = new Point3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Graphics3D.calcNormalizedNormal(point3f2, point3f3, point3f4, vector3f, vector3f2, vector3f3);
        point3f5.set(point3f2);
        point3f5.add(point3f3);
        point3f5.add(point3f4);
        point3f5.scale(0.33333334f);
        point3f6.set(vector3f);
        point3f6.scale(0.1f);
        point3f6.add(point3f5);
        boolean bl3 = bl2 = bl && point3f.distance(point3f6) < point3f.distance(point3f5) || !bl && point3f.distance(point3f5) < point3f.distance(point3f6);
        if (bl2) {
            vector3f.scale(-1.0f);
        }
    }

    public void calcXYNormalToLine(Point3f point3f, Point3f point3f2, Vector3f vector3f) {
        Vector3f vector3f2 = new Vector3f(point3f);
        vector3f2.sub(point3f2);
        float f = vector3f2.angle(new Vector3f(0.0f, 1.0f, 0.0f));
        if (f == 0.0f) {
            vector3f.set(1.0f, 0.0f, 0.0f);
        } else {
            vector3f.cross(vector3f2, new Vector3f(0.0f, 1.0f, 0.0f));
            vector3f.normalize();
        }
    }

    public static void projectOntoAxis(Point3f point3f, Point3f point3f2, Vector3f vector3f, Vector3f vector3f2) {
        vector3f2.sub(point3f, point3f2);
        float f = vector3f2.dot(vector3f);
        point3f.set(vector3f);
        point3f.scaleAdd(f, point3f2);
        vector3f2.sub(point3f, point3f2);
    }

    public static void calcBestAxisThroughPoints(Point3f[] point3fArray, Point3f point3f, Vector3f vector3f, Vector3f vector3f2, int n) {
        int n2 = point3fArray.length;
        point3f.set(point3fArray[0]);
        vector3f.sub(point3fArray[n2 - 1], point3f);
        vector3f.normalize();
        Graphics3D.calcAveragePointN(point3fArray, n2, point3f);
        int n3 = 0;
        while (n3++ < n && (double)Graphics3D.findAxis(point3fArray, n2, point3f, vector3f, vector3f2) > 0.001) {
        }
        Point3f point3f2 = new Point3f(point3fArray[0]);
        Graphics3D.projectOntoAxis(point3f2, point3f, vector3f, vector3f2);
        point3f.set(point3f2);
    }

    static float findAxis(Point3f[] point3fArray, int n, Point3f point3f, Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        Point3f point3f2 = new Point3f();
        Point3f point3f3 = new Point3f();
        Vector3f vector3f5 = new Vector3f(vector3f);
        float f = 0.0f;
        float f2 = 0.0f;
        int n2 = n;
        while (--n2 >= 0) {
            point3f2.set(point3fArray[n2]);
            point3f3.set(point3f2);
            Graphics3D.projectOntoAxis(point3f3, point3f, vector3f, vector3f2);
            vector3f4.sub(point3f2, point3f3);
            f2 += vector3f4.lengthSquared();
            vector3f4.cross(vector3f2, vector3f4);
            vector3f3.add(vector3f4);
            f += vector3f2.lengthSquared();
        }
        Vector3f vector3f6 = new Vector3f(vector3f3);
        vector3f6.scale(1.0f / f);
        vector3f4.cross(vector3f6, vector3f);
        vector3f.add(vector3f4);
        vector3f.normalize();
        vector3f4.set(vector3f);
        vector3f4.sub(vector3f5);
        return vector3f4.length();
    }

    public static void calcAveragePoint(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        point3f3.set((point3f.x + point3f2.x) / 2.0f, (point3f.y + point3f2.y) / 2.0f, (point3f.z + point3f2.z) / 2.0f);
    }

    public static void calcAveragePointN(Point3f[] point3fArray, int n, Point3f point3f) {
        point3f.set(point3fArray[0]);
        for (int i = 1; i < n; ++i) {
            point3f.add(point3fArray[i]);
        }
        point3f.scale(1.0f / (float)n);
    }

    public short getNormix(Vector3f vector3f) {
        return this.normix3d.getNormix(vector3f.x, vector3f.y, vector3f.z, 3);
    }

    public short getInverseNormix(short s) {
        if (this.normix3d.inverseNormixes == null) {
            this.normix3d.calculateInverseNormixes();
        }
        return this.normix3d.inverseNormixes[s];
    }

    public short get2SidedNormix(Vector3f vector3f) {
        return ~this.normix3d.getNormix(vector3f.x, vector3f.y, vector3f.z, 3);
    }

    public boolean isDirectedTowardsCamera(short s) {
        return this.normix3d.isDirectedTowardsCamera(s);
    }

    public Vector3f[] getTransformedVertexVectors() {
        return this.normix3d.getTransformedVectors();
    }

    public Vector3f getNormixVector(short s) {
        return this.normix3d.getVector(s);
    }

    static {
        int n = colorNames.length;
        while (--n >= 0) {
            mapJavaScriptColors.put(colorNames[n], new Integer(colorArgbs[n]));
        }
    }
}

