/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import netscape.javascript.JSObject;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAppletInterface;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.applet.JmolAppletRegistry;
import org.jmol.applet.Jvm12;
import org.jmol.appletwrapper.AppletWrapper;
import org.jmol.appletwrapper.WrappedApplet;
import org.jmol.i18n.GT;
import org.jmol.popup.JmolPopup;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public class Jmol
implements WrappedApplet {
    JmolViewer viewer;
    boolean jvm12orGreater;
    Jvm12 jvm12;
    JmolPopup jmolpopup;
    String htmlName;
    String fullName;
    String syncId;
    MyStatusListener myStatusListener;
    AppletWrapper appletWrapper;
    boolean mayScript;
    boolean haveDocumentAccess;
    boolean doTranslate = true;
    String[] callbacks = new String[12];
    String statusForm;
    String statusText;
    String statusTextarea;
    static final boolean REQUIRE_PROGRESSBAR = true;
    boolean hasProgressBar;
    int paintCounter;
    String language;
    String menuStructure;
    boolean haveNotifiedError;
    boolean haveWindow;
    boolean needPopupMenu;
    boolean loading;
    public boolean showPaintTime = false;
    private boolean isUpdating;
    static final String[] progressbarMsgs = new String[]{"Jmol developer alert!", "", "Please use jmol.js. You are missing the require 'progressbar' parameter.", "  <param name='progressbar' value='true' />"};
    int timeLast;
    int timeCount;
    int timeTotal;
    long timeBegin;
    int lastMotionEventNumber;
    Object[] buttonCallbackBefore;
    Object[] buttonCallbackAfter;
    boolean buttonCallbackNotificationPending;
    String buttonCallback;
    String buttonName;
    JSObject buttonWindow;
    static final int SCRIPT_CHECK = 0;
    static final int SCRIPT_WAIT = 1;
    static final int SCRIPT_NOWAIT = 2;

    public void setAppletWrapper(AppletWrapper appletWrapper) {
        this.appletWrapper = appletWrapper;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public void init() {
        String string;
        this.htmlName = this.getParameter("name");
        this.syncId = this.getParameter("syncId");
        this.fullName = this.htmlName + "__" + this.syncId + "__";
        System.out.println("Jmol applet " + this.fullName + " initializing");
        this.setLogging();
        this.language = this.getParameter("language");
        if (this.language != null) {
            System.out.print("requested language=" + this.language + "; ");
            new GT(this.language);
        }
        this.language = GT.getLanguage();
        System.out.println("language=" + this.language);
        this.doTranslate = this.getBooleanValue("doTranslate", true);
        if ("none".equals(this.language)) {
            this.doTranslate = false;
        }
        if (!this.doTranslate) {
            GT.setDoTranslate(false);
            Logger.warn("Note -- language translation disabled");
        }
        this.mayScript = (string = this.getParameter("mayscript")) != null && !string.equalsIgnoreCase("false");
        JmolAppletRegistry.checkIn(this.fullName, this.appletWrapper);
        this.initWindows();
        this.initApplication();
    }

    public void destroy() {
        JmolAppletRegistry.checkOut(this.fullName);
        this.viewer.setModeMouse(-1);
        this.viewer = null;
        if (this.jvm12 != null) {
            this.jvm12.console = null;
            this.jvm12 = null;
        }
        System.out.println("Jmol applet " + this.fullName + " destroyed");
    }

    String getParameter(String string) {
        return this.appletWrapper.getParameter(string);
    }

    public void initWindows() {
        String string;
        this.viewer = JmolViewer.allocateViewer(this.appletWrapper, new SmarterJmolAdapter());
        String string2 = "";
        boolean bl = this.appletWrapper.isSigned();
        if (bl) {
            string2 = string2 + "-signed";
        }
        if (this.getBooleanValue("useCommandThread", bl)) {
            string2 = string2 + "-threaded";
        }
        if ((string = this.getValue("JmolAppletProxy", null)) != null) {
            string2 = string2 + "-appletProxy " + string;
        }
        this.viewer.setAppletContext(this.fullName, this.appletWrapper.getDocumentBase(), this.appletWrapper.getCodeBase(), string2);
        this.myStatusListener = new MyStatusListener();
        this.viewer.setJmolStatusListener(this.myStatusListener);
        String string3 = this.getParameter("menuFile");
        if (string3 != null) {
            this.menuStructure = this.viewer.getFileAsString(string3);
        }
        this.jvm12orGreater = this.viewer.isJvm12orGreater();
        if (this.jvm12orGreater) {
            this.jvm12 = new Jvm12(this.appletWrapper, this.viewer);
        }
        if (Logger.debugging) {
            Logger.debug("checking for jsoWindow mayScript=" + this.mayScript);
        }
        if (this.mayScript) {
            this.haveDocumentAccess = false;
            this.mayScript = false;
            JSObject jSObject = null;
            JSObject jSObject2 = null;
            try {
                jSObject = JSObject.getWindow((Applet)this.appletWrapper);
                if (Logger.debugging) {
                    Logger.debug("jsoWindow=" + jSObject);
                }
                if (jSObject == null) {
                    Logger.error("jsoWindow returned null ... no JavaScript callbacks :-(");
                } else {
                    this.mayScript = true;
                    this.haveWindow = true;
                }
                jSObject2 = (JSObject)jSObject.getMember("document");
                if (jSObject2 == null) {
                    Logger.error("jsoDocument returned null ... no DOM manipulations :-(");
                } else {
                    this.haveDocumentAccess = true;
                }
            }
            catch (Exception exception) {
                Logger.error("Microsoft MSIE bug -- http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5012558 " + exception);
            }
            if (Logger.debugging) {
                Logger.debug("jsoWindow:" + jSObject + " jsoDocument:" + jSObject2 + " mayScript:" + this.mayScript + " haveDocumentAccess:" + this.haveDocumentAccess);
            }
        }
    }

    void setLogging() {
        int n = this.getValue("logLevel", this.getBooleanValue("debug", false) ? "5" : "4").charAt(0) - 48;
        if (n != 4) {
            System.out.println("setting logLevel=" + n + " -- To change, use script \"set logLevel [0-5]\"");
        }
        Logger.setLogLevel(n);
    }

    boolean getBooleanValue(String string, boolean bl) {
        String string2 = this.getValue(string, bl ? "true" : "");
        return string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("on") || string2.equalsIgnoreCase("yes");
    }

    String getValue(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    String getValueLowerCase(String string, String string2) {
        String string3 = this.getValue(string, string2);
        if (string3 != null && (string3 = string3.trim().toLowerCase()).length() == 0) {
            string3 = null;
        }
        return string3;
    }

    public void initApplication() {
        int n;
        String string;
        this.viewer.pushHoldRepaint();
        this.hasProgressBar = this.getBooleanValue("progressbar", false);
        this.needPopupMenu = this.getBooleanValue("popupMenu", true);
        if (this.needPopupMenu) {
            this.jmolpopup = JmolPopup.newJmolPopup(this.viewer, this.doTranslate, this.menuStructure);
        }
        this.setStringProperty("defaults", (string = this.getValueLowerCase("emulate", "jmol")).equals("chime") ? "RasMol" : "Jmol");
        this.setStringProperty("backgroundColor", this.getValue("bgcolor", this.getValue("boxbgcolor", "black")));
        this.loadNodeId(this.getValue("loadNodeId", null));
        this.viewer.setBooleanProperty("frank", true);
        this.loading = true;
        for (n = 0; n < 12; ++n) {
            String string2 = JmolConstants.getCallbackName(n);
            this.setValue(string2, null);
        }
        this.loading = false;
        n = 0;
        for (int i = 0; i < 12 && n == 0; ++i) {
            n = this.callbacks[i] != null ? 1 : 0;
        }
        if (!(n == 0 && this.statusForm == null && this.statusText == null || this.mayScript)) {
            Logger.warn("MAYSCRIPT missing -- all applet JavaScript calls disabled");
        }
        if (this.callbacks[6] != null || this.statusForm != null || this.statusText != null) {
            if (this.getValue("doTranslate", null) == null) {
                this.doTranslate = false;
                Logger.warn("Note -- Presence of message callback will disable translation; to enable message translation use jmolSetTranslation(true) prior to jmolApplet()");
            }
            if (this.doTranslate) {
                Logger.warn("Note -- Automatic language translation may affect parsing of callback messages; to disable language translation of callback messages, use jmolSetTranslation(false) prior to jmolApplet()");
            }
        }
        this.statusForm = this.getValue("StatusForm", null);
        this.statusText = this.getValue("StatusText", null);
        this.statusTextarea = this.getValue("StatusTextarea", null);
        if (this.statusForm != null && this.statusText != null) {
            Logger.info("applet text status will be reported to document." + this.statusForm + "." + this.statusText);
        }
        if (this.statusForm != null && this.statusTextarea != null) {
            Logger.info("applet textarea status will be reported to document." + this.statusForm + "." + this.statusTextarea);
        }
        String string3 = this.getValue("script", "");
        System.out.println(string3);
        String string4 = this.getValue("loadInline", null);
        if (string4 != null) {
            this.loadInlineSeparated(string4, string3.length() > 0 ? string3 : null);
        } else {
            string4 = this.getValue("load", null);
            if (string4 != null) {
                string3 = "load \"" + string4 + "\";" + string3;
            }
            if (string3.length() > 0) {
                this.scriptProcessor(string3, null, 2);
            }
        }
        this.viewer.popHoldRepaint();
    }

    private void setValue(String string, String string2) {
        this.setStringProperty(string, this.getValue(string, string2));
    }

    private void setStringProperty(String string, String string2) {
        if (string2 == null) {
            return;
        }
        Logger.info(string + " = \"" + string2 + "\"");
        this.viewer.setStringProperty(string, string2);
    }

    void showStatusAndConsole(String string, boolean bl) {
        try {
            this.appletWrapper.showStatus(string);
            this.sendJsTextStatus(string);
            if (bl) {
                this.consoleMessage(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void sendJsTextStatus(String string) {
        if (!this.haveDocumentAccess || this.statusForm == null || this.statusText == null) {
            return;
        }
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this.appletWrapper);
            JSObject jSObject2 = (JSObject)jSObject.getMember("document");
            JSObject jSObject3 = (JSObject)jSObject2.getMember(this.statusForm);
            if (this.statusText != null) {
                JSObject jSObject4 = (JSObject)jSObject3.getMember(this.statusText);
                jSObject4.setMember("value", string);
            }
        }
        catch (Exception exception) {
            Logger.error("error indicating status at document." + this.statusForm + "." + this.statusText + ":" + exception.toString());
        }
    }

    void sendJsTextareaStatus(String string) {
        if (!this.haveDocumentAccess || this.statusForm == null || this.statusTextarea == null) {
            return;
        }
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this.appletWrapper);
            JSObject jSObject2 = (JSObject)jSObject.getMember("document");
            JSObject jSObject3 = (JSObject)jSObject2.getMember(this.statusForm);
            if (this.statusTextarea != null) {
                JSObject jSObject4 = (JSObject)jSObject3.getMember(this.statusTextarea);
                String string2 = (String)jSObject4.getMember("value");
                jSObject4.setMember("value", string2 + "\n" + string);
            }
        }
        catch (Exception exception) {
            Logger.error("error indicating status at document." + this.statusForm + "." + this.statusTextarea + ":" + exception.toString());
        }
    }

    void consoleMessage(String string) {
        if (this.jvm12 != null) {
            this.jvm12.consoleMessage(string);
        }
        this.sendJsTextareaStatus(string);
    }

    public void paint(Graphics graphics) {
        this.update(graphics, "paint ");
    }

    public void update(Graphics graphics) {
        this.update(graphics, "update");
    }

    private void update(Graphics graphics, String string) {
        if (this.viewer == null) {
            return;
        }
        if (this.isUpdating) {
            return;
        }
        this.isUpdating = true;
        if (this.showPaintTime) {
            this.startPaintClock();
        }
        Dimension dimension = this.jvm12orGreater ? this.jvm12.getSize() : this.appletWrapper.size();
        this.viewer.setScreenDimension(dimension);
        ++this.paintCounter;
        if (!this.hasProgressBar && this.paintCounter < 30 && (this.paintCounter & 1) == 0) {
            this.printProgressbarMessage(graphics);
            this.viewer.repaintView();
        } else {
            this.viewer.renderScreenImage(graphics, dimension, null);
        }
        if (this.showPaintTime) {
            this.stopPaintClock();
            this.showTimes(10, 10, graphics);
        }
        this.isUpdating = false;
    }

    void printProgressbarMessage(Graphics graphics) {
        graphics.setColor(Color.yellow);
        graphics.fillRect(0, 0, 10000, 10000);
        graphics.setColor(Color.black);
        int n = 0;
        int n2 = 13;
        while (n < progressbarMsgs.length) {
            graphics.drawString(progressbarMsgs[n], 10, n2);
            ++n;
            n2 += 13;
        }
    }

    public boolean handleEvent(Event event) {
        if (this.viewer == null) {
            return false;
        }
        return this.viewer.handleOldJvm10Event(event);
    }

    void resetTimes() {
        this.timeTotal = 0;
        this.timeCount = 0;
        this.timeLast = -1;
    }

    void recordTime(int n) {
        if (this.timeLast != -1) {
            this.timeTotal += this.timeLast;
            ++this.timeCount;
        }
        this.timeLast = n;
    }

    void startPaintClock() {
        this.timeBegin = System.currentTimeMillis();
        int n = this.viewer.getMotionEventNumber();
        if (this.lastMotionEventNumber != n) {
            this.lastMotionEventNumber = n;
            this.resetTimes();
        }
    }

    void stopPaintClock() {
        int n = (int)(System.currentTimeMillis() - this.timeBegin);
        this.recordTime(n);
    }

    String fmt(int n) {
        if (n < 0) {
            return "---";
        }
        if (n < 10) {
            return "  " + n;
        }
        if (n < 100) {
            return " " + n;
        }
        return "" + n;
    }

    void showTimes(int n, int n2, Graphics graphics) {
        int n3 = this.timeCount == 0 ? -1 : (this.timeTotal + this.timeCount / 2) / this.timeCount;
        graphics.setColor(Color.green);
        graphics.drawString(this.fmt(this.timeLast) + "ms : " + this.fmt(n3) + "ms", n, n2);
    }

    public void scriptButton(JSObject jSObject, String string, String string2, String string3) {
        if (!this.mayScript || jSObject == null || string3 == null) {
            this.buttonCallbackNotificationPending = false;
            return;
        }
        Logger.info(this.htmlName + " JmolApplet.scriptButton(" + jSObject + "," + string + "," + string2 + "," + string3);
        if (Logger.debugging) {
            Logger.debug("!!!! calling back " + string3);
        }
        if (this.buttonCallbackBefore == null) {
            this.buttonCallbackBefore = new Object[]{null, Boolean.FALSE};
        }
        this.buttonCallbackBefore[0] = string;
        Logger.debug("trying...");
        jSObject.call(string3, this.buttonCallbackBefore);
        Logger.debug("made it");
        this.buttonCallbackNotificationPending = true;
        this.buttonCallback = string3;
        this.buttonWindow = jSObject;
        this.buttonName = string;
        this.scriptProcessor(string2, null, 2);
    }

    private String scriptProcessor(String string, String string2, int n) {
        if (string == null || string.length() == 0) {
            return "";
        }
        switch (n) {
            case 0: {
                String string3 = this.viewer.scriptCheck(string);
                return string3 == null ? "" : string3;
            }
            case 1: {
                if (string2 != null) {
                    return this.viewer.scriptWaitStatus(string, string2).toString();
                }
                return this.viewer.scriptWait(string);
            }
        }
        return this.viewer.script(string);
    }

    public void script(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.scriptProcessor(string, null, 2);
    }

    public String scriptCheck(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return this.scriptProcessor(string, null, 0);
    }

    public String scriptNoWait(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return this.scriptProcessor(string, null, 2);
    }

    public String scriptWait(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return this.scriptProcessor(string, null, 1);
    }

    public String scriptWait(String string, String string2) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return this.scriptProcessor(string, string2, 1);
    }

    public synchronized void syncScript(String string) {
        this.viewer.syncScript(string, "~");
    }

    public String getAppletInfo() {
        return GT._("Jmol Applet version {0} {1}.\n\nAn OpenScience project.\n\nSee http://www.jmol.org for more information", new Object[]{JmolConstants.version, JmolConstants.date}) + "\nhtmlName = " + Escape.escape(this.htmlName) + "\nsyncId = " + Escape.escape(this.syncId) + "\ndocumentBase = " + Escape.escape("" + this.appletWrapper.getDocumentBase()) + "\ncodeBase = " + Escape.escape("" + this.appletWrapper.getCodeBase());
    }

    public Object getProperty(String string) {
        return this.viewer.getProperty(null, string, "");
    }

    public Object getProperty(String string, String string2) {
        return this.viewer.getProperty(null, string, string2);
    }

    public String getPropertyAsString(String string) {
        return this.viewer.getProperty("readable", string, "").toString();
    }

    public String getPropertyAsString(String string, String string2) {
        return this.viewer.getProperty("readable", string, string2).toString();
    }

    public String getPropertyAsJSON(String string) {
        return this.viewer.getProperty("JSON", string, "").toString();
    }

    public String getPropertyAsJSON(String string, String string2) {
        return this.viewer.getProperty("JSON", string, string2).toString();
    }

    public void loadInlineString(String string, String string2, boolean bl) {
        this.viewer.loadInline(string, bl);
        this.script(string2);
    }

    public void loadInlineArray(String[] stringArray, String string, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        this.viewer.loadInline(stringArray, bl);
        this.script(string);
    }

    public void loadInline(String string) {
        this.loadInlineString(string, "", false);
    }

    public void loadInline(String string, String string2) {
        this.loadInlineString(string, string2, false);
    }

    public void loadInline(String[] stringArray) {
        this.loadInlineArray(stringArray, "", false);
    }

    public void loadInline(String[] stringArray, String string) {
        this.loadInlineArray(stringArray, string, false);
    }

    private void loadInlineSeparated(String string, String string2) {
        if (string == null) {
            return;
        }
        this.viewer.loadInline(string);
        this.script(string2);
    }

    public void loadDOMNode(JSObject jSObject) {
        this.viewer.openDOM(jSObject);
    }

    public void loadNodeId(String string) {
        if (!this.haveDocumentAccess) {
            return;
        }
        if (string != null) {
            Object[] objectArray = new Object[]{string};
            JSObject jSObject = null;
            try {
                Object[] objectArray2;
                JSObject jSObject2;
                JSObject jSObject3 = JSObject.getWindow((Applet)this.appletWrapper);
                JSObject jSObject4 = (JSObject)jSObject3.getMember("document");
                jSObject = (JSObject)jSObject4.call("getElementById", objectArray);
                if (jSObject == null && (jSObject2 = (JSObject)jSObject4.call("getElementsByTagNameNS", objectArray2 = new Object[]{"http://www.xml-cml.org/schema/cml2/core", "cml"})) != null) {
                    Object[] objectArray3;
                    String string2;
                    for (int i = 0; i < ((Number)jSObject2.getMember("length")).intValue() && !string.equals(string2 = (String)(jSObject = (JSObject)jSObject2.getSlot(i)).call("getAttribute", objectArray3 = new Object[]{"id"})); ++i) {
                        jSObject = null;
                    }
                }
            }
            catch (Exception exception) {
                jSObject = null;
            }
            if (jSObject != null) {
                this.loadDOMNode(jSObject);
            }
        }
    }

    void loadPopupMenuAsBackgroundTask() {
        if (this.viewer.getOperatingSystemName().equals("Mac OS") && this.viewer.getJavaVersion().equals("1.1.5")) {
            return;
        }
        new Thread(new LoadPopupThread()).start();
    }

    class MyStatusListener
    implements JmolStatusListener {
        MyStatusListener() {
        }

        public boolean notifyEnabled(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    return true;
                }
            }
            return Jmol.this.callbacks[n] != null;
        }

        public void notifyCallback(int n, Object[] objectArray) {
            Object object;
            boolean bl;
            String string = Jmol.this.callbacks[n];
            boolean bl2 = bl = string != null;
            if (objectArray != null) {
                objectArray[0] = Jmol.this.htmlName;
            }
            String string2 = objectArray == null || objectArray[1] == null ? null : objectArray[1].toString();
            switch (n) {
                case 0: {
                    int n2;
                    object = (int[])objectArray[1];
                    int n3 = object[0];
                    int n4 = object[1];
                    int n5 = object[2];
                    int n6 = object[3];
                    Object object2 = object[4];
                    boolean bl3 = n3 <= -2;
                    int n7 = n6 < 0 ? -1 : 1;
                    int n8 = n2 = object2 < 0 ? -1 : 1;
                    if (bl) {
                        objectArray = new Object[]{Jmol.this.htmlName, new Integer(Math.max(n3, -2 - n3)), new Integer(n4), new Integer(n5), new Integer(Math.abs(n6)), new Integer(Math.abs((int)object2)), new Integer(bl3 ? 1 : 0), new Integer(n7), new Integer(n2)};
                    }
                    if (Jmol.this.jmolpopup == null || bl3) break;
                    Jmol.this.jmolpopup.updateComputedMenus();
                    break;
                }
                case 1: {
                    boolean bl4;
                    boolean bl5 = bl4 = (Integer)objectArray[2] == 1;
                    if (bl4 && !bl) {
                        Jmol.this.consoleMessage(string2);
                    }
                    if (!bl) {
                        n = 6;
                        string = Jmol.this.callbacks[6];
                        bl = string != null;
                    }
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    String string3 = (String)objectArray[4];
                    if (string3 == null) break;
                    Jmol.this.showStatusAndConsole((string3.indexOf("NOTE:") >= 0 ? "" : GT._("File Error:")) + string3, true);
                    return;
                }
                case 5: {
                    if (!bl) {
                        n = 6;
                        string = Jmol.this.callbacks[6];
                        boolean bl6 = bl = string != null;
                    }
                    if (objectArray.length == 3) {
                        Jmol.this.showStatusAndConsole(string2, true);
                        break;
                    }
                    Jmol.this.consoleMessage((String)objectArray[3] + ": " + string2);
                    break;
                }
                case 6: {
                    if (!bl) {
                        Jmol.this.consoleMessage(string2);
                    }
                    if (string2 != null) break;
                    return;
                }
                case 7: {
                    break;
                }
                case 8: {
                    Jmol.this.showStatusAndConsole(string2, true);
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    boolean bl7;
                    int n9 = (Integer)objectArray[3];
                    boolean bl8 = bl7 = n9 == 0;
                    if (n9 > 0) {
                        this.notifyScriptTermination();
                    } else if (!bl) {
                        n = 6;
                        string = Jmol.this.callbacks[6];
                        bl = string != null;
                    }
                    Jmol.this.showStatusAndConsole(string2, bl7);
                    break;
                }
                case 11: {
                    this.sendSyncScript(bl, string2, (String)objectArray[2]);
                    return;
                }
            }
            if (!bl || !Jmol.this.mayScript) {
                return;
            }
            try {
                object = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                if (string.equals("alert")) {
                    ((JSObject)object).call(string, string2);
                } else if (string.length() > 0) {
                    ((JSObject)object).call(string, objectArray);
                }
            }
            catch (Exception exception) {
                if (!Jmol.this.haveNotifiedError && Logger.debugging) {
                    Logger.debug(JmolConstants.getCallbackName(n) + " call error to " + string + ": " + exception);
                }
                Jmol.this.haveNotifiedError = true;
            }
        }

        private void notifyScriptTermination() {
            if (Jmol.this.buttonCallbackNotificationPending) {
                if (Logger.debugging) {
                    Logger.debug("!!!! calling back " + Jmol.this.buttonCallback);
                }
                if (Jmol.this.buttonCallbackAfter == null) {
                    Jmol.this.buttonCallbackAfter = new Object[]{null, Boolean.TRUE};
                }
                Jmol.this.buttonCallbackAfter[0] = Jmol.this.buttonName;
                Jmol.this.buttonWindow.call(Jmol.this.buttonCallback, Jmol.this.buttonCallbackAfter);
            }
        }

        private String notifySync(String string) {
            String string2 = Jmol.this.callbacks[11];
            if (!Jmol.this.mayScript || string2 == null) {
                return string;
            }
            try {
                JSObject jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                if (string2.length() > 0) {
                    return (String)jSObject.call(string2, Jmol.this.htmlName, string);
                }
            }
            catch (Exception exception) {
                if (!Jmol.this.haveNotifiedError && Logger.debugging) {
                    Logger.debug("syncCallback call error to " + string2 + ": " + exception);
                }
                Jmol.this.haveNotifiedError = true;
            }
            return string;
        }

        public void setCallbackFunction(String string, String string2) {
            if (string.equalsIgnoreCase("menu")) {
                Jmol.this.menuStructure = string2;
                if (Jmol.this.needPopupMenu) {
                    Jmol.this.jmolpopup = JmolPopup.newJmolPopup(Jmol.this.viewer, Jmol.this.doTranslate, Jmol.this.menuStructure);
                }
                return;
            }
            if (string.equalsIgnoreCase("language")) {
                new GT(string2);
                Jmol.this.language = GT.getLanguage();
                if (Jmol.this.needPopupMenu) {
                    Jmol.this.jmolpopup = JmolPopup.newJmolPopup(Jmol.this.viewer, Jmol.this.doTranslate, Jmol.this.menuStructure);
                }
                return;
            }
            for (int i = 0; i < 12; ++i) {
                if (!JmolConstants.getCallbackName(i).equalsIgnoreCase(string)) continue;
                if (Jmol.this.loading || i != 2) {
                    Jmol.this.callbacks[i] = string2;
                }
                return;
            }
            String string3 = "";
            for (int i = 0; i < 12; ++i) {
                string3 = string3 + " " + JmolConstants.getCallbackName(i);
            }
            Jmol.this.consoleMessage("Available callbacks include: " + string3);
        }

        protected void finalize() throws Throwable {
            Logger.debug("MyStatusListener finalize " + this);
            super.finalize();
        }

        public String eval(String string) {
            if (string.startsWith("_GET_MENU")) {
                return Jmol.this.jmolpopup == null ? "" : Jmol.this.jmolpopup.getMenu("Jmol version " + Viewer.getJmolVersion() + "|" + string);
            }
            if (!Jmol.this.haveDocumentAccess) {
                return "NO EVAL ALLOWED";
            }
            JSObject jSObject = null;
            JSObject jSObject2 = null;
            try {
                jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                jSObject2 = (JSObject)jSObject.getMember("document");
            }
            catch (Exception exception) {
                if (Logger.debugging) {
                    Logger.debug(" error setting jsoWindow or jsoDocument:" + jSObject + ", " + jSObject2);
                }
                return "NO EVAL ALLOWED";
            }
            if (Jmol.this.callbacks[2] != null) {
                this.notifyCallback(2, new Object[]{"", string});
                return "";
            }
            try {
                if (!Jmol.this.haveDocumentAccess || ((Boolean)jSObject2.eval("!!_jmol.noEval")).booleanValue()) {
                    return "NO EVAL ALLOWED";
                }
            }
            catch (Exception exception) {
                Logger.error("# no _jmol in evaluating " + string + ":" + exception.toString());
                return "";
            }
            try {
                return "" + jSObject2.eval(string);
            }
            catch (Exception exception) {
                Logger.error("# error evaluating " + string + ":" + exception.toString());
                return "";
            }
        }

        public void createImage(String string, Object object, int n) {
            String string2;
            String string3 = string2 = object instanceof String ? (String)object : new String((byte[])object);
            if (n == Integer.MAX_VALUE) {
                Jmol.this.consoleMessage(string2);
            }
        }

        public float[][] functionXY(String string, int n, int n2) {
            int n3;
            float[][] fArray = new float[Math.abs(n)][Math.abs(n2)];
            if (!Jmol.this.mayScript || n == 0 || n2 == 0) {
                return fArray;
            }
            try {
                JSObject jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                if (n > 0 && n2 > 0) {
                    for (n3 = 0; n3 < n; ++n3) {
                        for (int i = 0; i < n2; ++i) {
                            fArray[n3][i] = ((Double)jSObject.call(string, Jmol.this.htmlName, new Integer(n3), new Integer(i))).floatValue();
                        }
                    }
                } else if (n2 > 0) {
                    String string2 = (String)jSObject.call(string, Jmol.this.htmlName, new Integer(n), new Integer(n2));
                    n = Math.abs(n);
                    float[] fArray2 = new float[n * n2];
                    Parser.parseFloatArray(string2, null, fArray2);
                    int n4 = 0;
                    for (int i = 0; i < n; ++i) {
                        int n5 = 0;
                        while (n5 < n2) {
                            fArray[i][n5] = fArray2[n4];
                            ++n5;
                            ++n4;
                        }
                    }
                } else {
                    jSObject.call(string, new Object[]{Jmol.this.htmlName, new Integer(n), new Integer(n2), fArray});
                }
            }
            catch (Exception exception) {
                Logger.error("Exception " + exception.getMessage() + " with nX, nY: " + n + " " + n2);
            }
            for (int i = 0; i < n; ++i) {
                for (n3 = 0; n3 < n2; ++n3) {
                    System.out.println("i j fxy " + i + " " + n3 + " " + fArray[i][n3]);
                }
            }
            return fArray;
        }

        public void handlePopupMenu(int n, int n2) {
            if (Jmol.this.jmolpopup == null) {
                return;
            }
            if (!Jmol.this.language.equals(GT.getLanguage())) {
                Jmol.this.jmolpopup = JmolPopup.newJmolPopup(Jmol.this.viewer, Jmol.this.doTranslate, Jmol.this.menuStructure);
                Jmol.this.language = GT.getLanguage();
            }
            Jmol.this.jmolpopup.show(n, n2);
        }

        public void showUrl(String string) {
            if (Logger.debugging) {
                Logger.debug("showUrl(" + string + ")");
            }
            if (string != null && string.length() > 0) {
                try {
                    URL uRL = new URL(string);
                    Jmol.this.appletWrapper.getAppletContext().showDocument(uRL, "_blank");
                }
                catch (MalformedURLException malformedURLException) {
                    Jmol.this.showStatusAndConsole("Malformed URL:" + string, true);
                }
            }
        }

        public void showConsole(boolean bl) {
            if (Jmol.this.jvm12 != null) {
                Jmol.this.jvm12.showConsole(bl);
            }
        }

        private void sendSyncScript(boolean bl, String string, String string2) {
            Vector vector = JmolAppletRegistry.findApplets(string2, Jmol.this.syncId, Jmol.this.fullName);
            if (bl) {
                string = this.notifySync(string);
            }
            if (vector == null || vector.size() == 0) {
                if (!bl) {
                    Logger.error(Jmol.this.fullName + " couldn't find applet " + string2);
                }
                return;
            }
            if (string == null || string.length() == 0) {
                return;
            }
            for (int i = 0; i < vector.size(); ++i) {
                String string3 = (String)vector.elementAt(i);
                JmolAppletInterface jmolAppletInterface = (JmolAppletInterface)JmolAppletRegistry.htRegistry.get(string3);
                if (Logger.debugging) {
                    Logger.debug(Jmol.this.fullName + " sending to " + string3 + ": " + string);
                }
                try {
                    jmolAppletInterface.syncScript(string);
                    continue;
                }
                catch (Exception exception) {
                    Logger.error(Jmol.this.htmlName + " couldn't send to " + string3 + ": " + string + ": " + exception);
                }
            }
        }

        public Hashtable getRegistryInfo() {
            JmolAppletRegistry.checkIn(null, null);
            return JmolAppletRegistry.htRegistry;
        }
    }

    class LoadPopupThread
    implements Runnable {
        LoadPopupThread() {
        }

        protected void finalize() throws Throwable {
            Logger.debug("LoadPopupThead finalize " + this);
            super.finalize();
        }

        public void run() {
            Thread.currentThread().setPriority(1);
            Jmol.this.jmolpopup = JmolPopup.newJmolPopup(Jmol.this.viewer, Jmol.this.doTranslate, Jmol.this.menuStructure);
        }
    }
}

